/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.modules;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.LinkedHashMap;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.resolve.jvm.KotlinCliJavaFileManager;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModule;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModuleFinder;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModuleInfo;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000bJ\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001e\u001a\u00020\u0018H\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00142\u0006\u0010 \u001a\u00020\u0003H\u0002R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0011\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\rR*\u0010\u0016\u001a\u001e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000b0\u0017j\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000b`\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/modules/CliJavaModuleFinder;", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleFinder;", "jrtFileSystemRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "javaFileManager", "Lorg/jetbrains/kotlin/resolve/jvm/KotlinCliJavaFileManager;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/resolve/jvm/KotlinCliJavaFileManager;Lcom/intellij/openapi/project/Project;)V", "allObservableModules", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule;", "getAllObservableModules", "()Lkotlin/sequences/Sequence;", "allScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "Lorg/jetbrains/annotations/NotNull;", "modulesRoot", "Lorg/jetbrains/annotations/Nullable;", "systemModules", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule$Explicit;", "getSystemModules", "userModules", "Ljava/util/LinkedHashMap;", "", "Lkotlin/collections/LinkedHashMap;", "addUserModule", "", "module", "findModule", "name", "findSystemModule", "moduleRoot", "cli"})
public final class CliJavaModuleFinder
implements JavaModuleFinder {
    private final VirtualFile modulesRoot;
    private final LinkedHashMap<String, JavaModule> userModules;
    private final GlobalSearchScope allScope;
    private final KotlinCliJavaFileManager javaFileManager;

    public final void addUserModule(@NotNull JavaModule module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        this.userModules.putIfAbsent(module2.getName(), module2);
    }

    @NotNull
    public final Sequence<JavaModule> getAllObservableModules() {
        Sequence<JavaModule.Explicit> sequence2 = this.getSystemModules();
        Collection<JavaModule> collection = this.userModules.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"userModules.values");
        return SequencesKt.plus(sequence2, (Iterable)collection);
    }

    @NotNull
    public final Sequence<JavaModule.Explicit> getSystemModules() {
        Object[] objectArray;
        VirtualFile virtualFile = this.modulesRoot;
        Object[] $this$orEmpty$iv = virtualFile != null ? virtualFile.getChildren() : null;
        boolean $i$f$orEmpty = false;
        Object[] objectArray2 = $this$orEmpty$iv;
        if (objectArray2 == null) {
            boolean $i$f$emptyArray = false;
            objectArray = new VirtualFile[]{};
        } else {
            objectArray = objectArray2;
        }
        return SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)((Function1)new Function1<VirtualFile, JavaModule.Explicit>(this){

            @Nullable
            public final JavaModule.Explicit invoke(@NotNull VirtualFile p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return CliJavaModuleFinder.access$findSystemModule((CliJavaModuleFinder)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(CliJavaModuleFinder.class);
            }

            public final String getName() {
                return "findSystemModule";
            }

            public final String getSignature() {
                return "findSystemModule(Lcom/intellij/openapi/vfs/VirtualFile;)Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule$Explicit;";
            }
        }));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Nullable
    public JavaModule findModule(@NotNull String name2) {
        JavaModule javaModule;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Object object = this.modulesRoot;
        if (object != null && (object = object.findChild(name2)) != null) {
            VirtualFile virtualFile = object;
            CliJavaModuleFinder cliJavaModuleFinder = this;
            VirtualFile p1 = virtualFile;
            boolean bl = false;
            object = cliJavaModuleFinder.findSystemModule(p1);
            if (object != null) {
                javaModule = (JavaModule)object;
                return javaModule;
            }
        }
        javaModule = this.userModules.get(name2);
        return javaModule;
    }

    private final JavaModule.Explicit findSystemModule(VirtualFile moduleRoot) {
        VirtualFile virtualFile = moduleRoot.findChild("module-info.class");
        if (virtualFile == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"moduleRoot.findChild(Psi\u2026_CLS_FILE) ?: return null");
        VirtualFile file2 = virtualFile;
        JavaModuleInfo javaModuleInfo = JavaModuleInfo.Companion.read(file2, this.javaFileManager, this.allScope);
        if (javaModuleInfo == null) {
            return null;
        }
        JavaModuleInfo moduleInfo2 = javaModuleInfo;
        return new JavaModule.Explicit(moduleInfo2, CollectionsKt.listOf((Object)new JavaModule.Root(moduleRoot, true)), file2);
    }

    public CliJavaModuleFinder(@Nullable VirtualFile jrtFileSystemRoot, @NotNull KotlinCliJavaFileManager javaFileManager, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)javaFileManager, (String)"javaFileManager");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.javaFileManager = javaFileManager;
        VirtualFile virtualFile = jrtFileSystemRoot;
        this.modulesRoot = virtualFile != null ? virtualFile.findChild("modules") : null;
        this.userModules = new LinkedHashMap();
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.allScope(project)");
        this.allScope = globalSearchScope;
    }

    public static final /* synthetic */ JavaModule.Explicit access$findSystemModule(CliJavaModuleFinder $this, VirtualFile moduleRoot) {
        return $this.findSystemModule(moduleRoot);
    }
}

