/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.fir;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.fir.FirLightSourceElement;
import org.jetbrains.kotlin.fir.FirPsiSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDefaultErrorMessages;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticRenderer;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\t\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\f\u001a\u00020\r2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0002J\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u0006H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/cli/common/fir/FirDiagnosticsCompilerResultsReporter;", "", "()V", "reportDiagnostic", "", "diagnostic", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnostic;", "reporter", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "reportDiagnostics", "diagnostics", "", "reportSpecialErrors", "", "location", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSourceLocation;", "Lorg/jetbrains/kotlin/fir/FirLightSourceElement;", "Lorg/jetbrains/kotlin/fir/FirPsiSourceElement;", "DiagnosticComparator", "cli"})
public final class FirDiagnosticsCompilerResultsReporter {
    @NotNull
    public static final FirDiagnosticsCompilerResultsReporter INSTANCE;

    public final boolean reportDiagnostics(@NotNull Collection<? extends FirDiagnostic> diagnostics2, @NotNull MessageCollector reporter2) {
        Intrinsics.checkNotNullParameter(diagnostics2, (String)"diagnostics");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        boolean hasErrors = false;
        for (FirDiagnostic diagnostic : CollectionsKt.sortedWith((Iterable)diagnostics2, (Comparator)DiagnosticComparator.INSTANCE)) {
            hasErrors = this.reportDiagnostic(diagnostic, reporter2) || hasErrors;
        }
        this.reportSpecialErrors(diagnostics2);
        return hasErrors;
    }

    private final void reportSpecialErrors(Collection<? extends FirDiagnostic> diagnostics2) {
    }

    private final boolean reportDiagnostic(FirDiagnostic diagnostic, MessageCollector reporter2) {
        block1: {
            CompilerMessageSourceLocation compilerMessageSourceLocation;
            if (!diagnostic.isValid()) {
                return false;
            }
            CompilerMessageSourceLocation compilerMessageSourceLocation2 = this.location(diagnostic);
            if (compilerMessageSourceLocation2 == null) break block1;
            CompilerMessageSourceLocation location2 = compilerMessageSourceLocation = compilerMessageSourceLocation2;
            boolean bl = false;
            CompilerMessageSeverity severity = AnalyzerWithCompilerReport.Companion.convertSeverity(diagnostic.getSeverity());
            FirDiagnosticRenderer renderer = FirDefaultErrorMessages.Companion.getRendererForDiagnostic(diagnostic);
            reporter2.report(severity, renderer.render(diagnostic), location2);
        }
        return diagnostic.getSeverity() == Severity.ERROR;
    }

    private final CompilerMessageSourceLocation location(FirDiagnostic $this$location) {
        CompilerMessageSourceLocation compilerMessageSourceLocation;
        FirSourceElement element = $this$location.getElement();
        if (element instanceof FirPsiSourceElement) {
            compilerMessageSourceLocation = this.location((FirPsiSourceElement)element, $this$location);
        } else if (element instanceof FirLightSourceElement) {
            compilerMessageSourceLocation = this.location((FirLightSourceElement)element, $this$location);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return compilerMessageSourceLocation;
    }

    private final CompilerMessageSourceLocation location(FirPsiSourceElement $this$location, FirDiagnostic diagnostic) {
        PsiFile file2;
        PsiFile psiFile = file2 = $this$location.getPsi().getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"file");
        return MessageUtil.psiFileToMessageLocation(file2, psiFile.getName(), DiagnosticUtils.getLineAndColumnRange(file2, diagnostic.getTextRanges()));
    }

    private final CompilerMessageSourceLocation location(FirLightSourceElement $this$location, FirDiagnostic diagnostic) {
        return null;
    }

    private FirDiagnosticsCompilerResultsReporter() {
    }

    static {
        FirDiagnosticsCompilerResultsReporter firDiagnosticsCompilerResultsReporter;
        INSTANCE = firDiagnosticsCompilerResultsReporter = new FirDiagnosticsCompilerResultsReporter();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/cli/common/fir/FirDiagnosticsCompilerResultsReporter$DiagnosticComparator;", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnostic;", "Lkotlin/Comparator;", "()V", "compare", "", "o1", "o2", "cli"})
    private static final class DiagnosticComparator
    implements Comparator<FirDiagnostic> {
        @NotNull
        public static final DiagnosticComparator INSTANCE;

        @Override
        public int compare(@NotNull FirDiagnostic o1, @NotNull FirDiagnostic o2) {
            Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
            FirSourceElement element1 = o1.getElement();
            FirSourceElement element2 = o1.getElement();
            if (!(element1 instanceof FirPsiSourceElement) || !(element2 instanceof FirPsiSourceElement)) {
                return 0;
            }
            PsiFile file1 = ((FirPsiSourceElement)element1).getPsi().getContainingFile();
            PsiFile file2 = ((FirPsiSourceElement)element2).getPsi().getContainingFile();
            PsiFile psiFile = file1;
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"file1");
            FileViewProvider fileViewProvider = psiFile.getViewProvider();
            Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"file1.viewProvider");
            VirtualFile virtualFile = fileViewProvider.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"file1.viewProvider.virtualFile");
            String string2 = virtualFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file1.viewProvider.virtualFile.path");
            String path1 = string2;
            PsiFile psiFile2 = file2;
            Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"file2");
            FileViewProvider fileViewProvider2 = psiFile2.getViewProvider();
            Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider2, (String)"file2.viewProvider");
            VirtualFile virtualFile2 = fileViewProvider2.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"file2.viewProvider.virtualFile");
            String string3 = virtualFile2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"file2.viewProvider.virtualFile.path");
            String path2 = string3;
            if (Intrinsics.areEqual((Object)path1, (Object)path2) ^ true) {
                return path1.compareTo(path2);
            }
            TextRange textRange = DiagnosticUtils.firstRange(o1.getTextRanges());
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"DiagnosticUtils.firstRange(o1.textRanges)");
            TextRange range1 = textRange;
            TextRange textRange2 = DiagnosticUtils.firstRange(o2.getTextRanges());
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"DiagnosticUtils.firstRange(o2.textRanges)");
            TextRange range2 = textRange2;
            return Intrinsics.areEqual((Object)range1, (Object)range2) ^ true ? DiagnosticUtils.TEXT_RANGE_COMPARATOR.compare(range1, range2) : o1.getFactory().getName().compareTo(o2.getFactory().getName());
        }

        private DiagnosticComparator() {
        }

        static {
            DiagnosticComparator diagnosticComparator;
            INSTANCE = diagnosticComparator = new DiagnosticComparator();
        }
    }
}

