/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.module.impl;

import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.module.JpsDependenciesRootsEnumerator;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsLibraryDependency;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleDependency;
import org.jetbrains.jps.model.module.JpsModuleSourceDependency;
import org.jetbrains.jps.model.module.JpsSdkDependency;
import org.jetbrains.jps.model.module.impl.JpsDependenciesEnumeratorBase;
import org.jetbrains.jps.util.JpsPathUtil;

public abstract class JpsDependenciesRootsEnumeratorBase<E extends JpsDependenciesEnumeratorBase<?>>
implements JpsDependenciesRootsEnumerator {
    protected final JpsOrderRootType myRootType;
    protected final E myDependenciesEnumerator;

    public JpsDependenciesRootsEnumeratorBase(E dependenciesEnumerator, JpsOrderRootType rootType) {
        this.myDependenciesEnumerator = dependenciesEnumerator;
        this.myRootType = rootType;
    }

    @Override
    public Collection<String> getUrls() {
        LinkedHashSet<String> urls = new LinkedHashSet<String>();
        this.processUrls(new CollectConsumer(urls));
        return urls;
    }

    @Override
    public Collection<File> getRoots() {
        LinkedHashSet<File> files = new LinkedHashSet<File>();
        this.processUrls(url -> {
            if (!JpsPathUtil.isJrtUrl(url)) {
                files.add(JpsPathUtil.urlToFile(url));
            }
        });
        return files;
    }

    private void processUrls(Consumer<? super String> urlConsumer) {
        ((JpsDependenciesEnumeratorBase)this.myDependenciesEnumerator).processDependencies(dependencyElement -> {
            JpsLibrary lib;
            if (dependencyElement instanceof JpsModuleSourceDependency) {
                this.processModuleRootUrls(dependencyElement.getContainingModule(), (JpsDependencyElement)dependencyElement, urlConsumer);
            } else if (dependencyElement instanceof JpsModuleDependency) {
                JpsModule dep = ((JpsModuleDependency)dependencyElement).getModule();
                if (dep != null) {
                    this.processModuleRootUrls(dep, (JpsDependencyElement)dependencyElement, urlConsumer);
                }
            } else if (dependencyElement instanceof JpsLibraryDependency) {
                JpsLibrary lib2 = ((JpsLibraryDependency)dependencyElement).getLibrary();
                if (lib2 != null) {
                    this.processLibraryRootUrls(lib2, urlConsumer);
                }
            } else if (dependencyElement instanceof JpsSdkDependency && (lib = ((JpsSdkDependency)dependencyElement).resolveSdk()) != null) {
                this.processLibraryRootUrls(lib, urlConsumer);
            }
            return true;
        });
    }

    private boolean processLibraryRootUrls(JpsLibrary library, Consumer<? super String> urlConsumer) {
        for (String url : library.getRootUrls(this.myRootType)) {
            urlConsumer.consume(url);
        }
        return true;
    }

    protected abstract boolean processModuleRootUrls(JpsModule var1, JpsDependencyElement var2, Consumer<? super String> var3);
}

