/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl.compiler;

import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.jps.model.java.compiler.JpsCompilerExcludes;
import org.jetbrains.jps.util.JpsPathUtil;

public class JpsCompilerExcludesImpl
implements JpsCompilerExcludes {
    private final Set<File> myFiles = new LinkedHashSet<File>();
    private final Set<File> myDirectories = new LinkedHashSet<File>();
    private final Set<File> myRecursivelyExcludedDirectories = new LinkedHashSet<File>();

    @Override
    public void addExcludedFile(String url) {
        this.addExcludedFile(JpsPathUtil.urlToFile(url));
    }

    @Override
    public void addExcludedDirectory(String url, boolean recursively) {
        this.addExcludedDirectory(JpsPathUtil.urlToFile(url), recursively);
    }

    protected void addExcludedFile(File file) {
        this.myFiles.add(file);
    }

    protected void addExcludedDirectory(File dir, boolean recursively) {
        (recursively ? this.myRecursivelyExcludedDirectories : this.myDirectories).add(dir);
    }

    @Override
    public boolean isExcluded(File file) {
        if (this.myFiles.contains(file)) {
            return true;
        }
        if (!this.myDirectories.isEmpty() || !this.myRecursivelyExcludedDirectories.isEmpty()) {
            File parent = FileUtilRt.getParentFile(file);
            if (this.myDirectories.contains(parent)) {
                return true;
            }
            while (parent != null) {
                if (this.myRecursivelyExcludedDirectories.contains(parent)) {
                    return true;
                }
                parent = FileUtilRt.getParentFile(parent);
            }
        }
        return false;
    }

    @Override
    public Set<File> getExcludedFiles() {
        return this.myFiles;
    }

    @Override
    public Set<File> getExcludedDirectories() {
        return this.myDirectories;
    }

    @Override
    public Set<File> getRecursivelyExcludedDirectories() {
        return this.myRecursivelyExcludedDirectories;
    }
}

