/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.forward;

import com.intellij.openapi.util.ThreadLocalCachedByteArray;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.util.indexing.impl.InputData;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractForwardIndexAccessor<Key, Value, DataType>
implements ForwardIndexAccessor<Key, Value> {
    @NotNull
    private final DataExternalizer<DataType> myDataTypeExternalizer;
    private static final ThreadLocalCachedByteArray ourSpareByteArray = new ThreadLocalCachedByteArray();

    public AbstractForwardIndexAccessor(@NotNull DataExternalizer<DataType> externalizer) {
        if (externalizer == null) {
            AbstractForwardIndexAccessor.$$$reportNull$$$0(0);
        }
        this.myDataTypeExternalizer = externalizer;
    }

    protected abstract InputDataDiffBuilder<Key, Value> createDiffBuilder(int var1, @Nullable DataType var2) throws IOException;

    @Nullable
    public DataType deserializeData(@Nullable ByteArraySequence sequence) throws IOException {
        if (sequence == null) {
            return null;
        }
        return AbstractForwardIndexAccessor.deserializeFromByteSeq(sequence, this.myDataTypeExternalizer);
    }

    @Override
    @NotNull
    public InputDataDiffBuilder<Key, Value> getDiffBuilder(int inputId, @Nullable ByteArraySequence sequence) throws IOException {
        InputDataDiffBuilder<Key, Value> inputDataDiffBuilder = this.createDiffBuilder(inputId, this.deserializeData(sequence));
        if (inputDataDiffBuilder == null) {
            AbstractForwardIndexAccessor.$$$reportNull$$$0(1);
        }
        return inputDataDiffBuilder;
    }

    @Nullable
    public abstract DataType convertToDataType(@NotNull InputData<Key, Value> var1);

    @Override
    @Nullable
    public ByteArraySequence serializeIndexedData(@NotNull InputData<Key, Value> data) throws IOException {
        if (data == null) {
            AbstractForwardIndexAccessor.$$$reportNull$$$0(2);
        }
        return this.serializeIndexedData(this.convertToDataType(data));
    }

    @Nullable
    public ByteArraySequence serializeIndexedData(@Nullable DataType data) throws IOException {
        if (data == null) {
            return null;
        }
        return AbstractForwardIndexAccessor.serializeToByteSeq(data, this.myDataTypeExternalizer, this.getBufferInitialSize(data));
    }

    protected int getBufferInitialSize(@NotNull DataType dataType) {
        if (dataType == null) {
            AbstractForwardIndexAccessor.$$$reportNull$$$0(3);
        }
        return 4;
    }

    public static <Data> ByteArraySequence serializeToByteSeq(Data data, @NotNull DataExternalizer<Data> externalizer, int bufferInitialSize) throws IOException {
        if (externalizer == null) {
            AbstractForwardIndexAccessor.$$$reportNull$$$0(4);
        }
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream(ourSpareByteArray.getBuffer(bufferInitialSize));
        DataOutputStream stream = new DataOutputStream(out);
        externalizer.save(stream, data);
        return out.size() == 0 ? null : out.toByteArraySequence();
    }

    public static <Data> Data deserializeFromByteSeq(@NotNull ByteArraySequence bytes, @NotNull DataExternalizer<Data> externalizer) throws IOException {
        if (bytes == null) {
            AbstractForwardIndexAccessor.$$$reportNull$$$0(5);
        }
        if (externalizer == null) {
            AbstractForwardIndexAccessor.$$$reportNull$$$0(6);
        }
        return externalizer.read(bytes.toInputStream());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalizer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/impl/forward/AbstractForwardIndexAccessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/impl/forward/AbstractForwardIndexAccessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "serializeIndexedData";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBufferInitialSize";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serializeToByteSeq";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deserializeFromByteSeq";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

