/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.FastUtilHashingStrategies;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileCollectionFactory {
    private static final Hash.Strategy<File> FILE_HASH_STRATEGY = new FastUtilHashingStrategies.SerializableHashStrategy<File>(){

        @Override
        public int hashCode(@Nullable File o) {
            return FileUtilRt.pathHashCode(o == null ? null : o.getPath());
        }

        @Override
        public boolean equals(@Nullable File a, @Nullable File b) {
            return FileUtilRt.pathsEqual(a == null ? null : a.getPath(), b == null ? null : b.getPath());
        }
    };
    private static final Hash.Strategy<String> FILE_PATH_HASH_STRATEGY = new FastUtilHashingStrategies.SerializableHashStrategy<String>(){

        @Override
        public int hashCode(@Nullable String value) {
            return FileUtilRt.pathHashCode(value);
        }

        @Override
        public boolean equals(@Nullable String val1, @Nullable String val2) {
            return FileUtilRt.pathsEqual(val1, val2);
        }
    };

    @NotNull
    public static <V> Map<String, V> createCanonicalFilePathMap() {
        return new Object2ObjectOpenCustomHashMap(FILE_PATH_HASH_STRATEGY);
    }

    @NotNull
    public static <V> Map<String, V> createCanonicalFilePathLinkedMap() {
        return new Object2ObjectLinkedOpenCustomHashMap(FILE_PATH_HASH_STRATEGY);
    }

    @NotNull
    public static <V> Map<File, V> createCanonicalFileMap() {
        return new Object2ObjectOpenCustomHashMap(FILE_HASH_STRATEGY);
    }

    @NotNull
    public static <V> Map<File, V> createCanonicalFileMap(int expected) {
        return new Object2ObjectOpenCustomHashMap(expected, FILE_HASH_STRATEGY);
    }

    @NotNull
    public static <V> Map<File, V> createCanonicalFileMap(@NotNull Map<File, V> map) {
        Object2ObjectOpenCustomHashMap m;
        if (map == null) {
            FileCollectionFactory.$$$reportNull$$$0(0);
        }
        if (map instanceof Object2ObjectOpenCustomHashMap && (m = (Object2ObjectOpenCustomHashMap)map).strategy() == FILE_HASH_STRATEGY) {
            Object object = m.clone();
            if (object == null) {
                FileCollectionFactory.$$$reportNull$$$0(1);
            }
            return object;
        }
        return new Object2ObjectOpenCustomHashMap<File, V>(map, FILE_HASH_STRATEGY);
    }

    @NotNull
    public static Set<File> createCanonicalFileSet() {
        return new ObjectOpenCustomHashSet<File>(FILE_HASH_STRATEGY);
    }

    @NotNull
    public static Set<File> createCanonicalFileSet(@NotNull Collection<? extends File> files) {
        if (files == null) {
            FileCollectionFactory.$$$reportNull$$$0(2);
        }
        return new ObjectOpenCustomHashSet<File>(files, FILE_HASH_STRATEGY);
    }

    @NotNull
    public static Set<Path> createCanonicalPathSet() {
        return new ObjectOpenCustomHashSet<Path>(new PathSerializableHashStrategy());
    }

    @NotNull
    public static Set<Path> createCanonicalPathSet(@NotNull Collection<? extends Path> files) {
        if (files == null) {
            FileCollectionFactory.$$$reportNull$$$0(3);
        }
        return new ObjectOpenCustomHashSet<Path>(files, new PathSerializableHashStrategy());
    }

    @NotNull
    public static Set<File> createCanonicalFileLinkedSet() {
        return new ObjectLinkedOpenCustomHashSet<File>(FILE_HASH_STRATEGY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/FileCollectionFactory";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/FileCollectionFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCanonicalFileMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCanonicalFileMap";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createCanonicalFileSet";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createCanonicalPathSet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class PathSerializableHashStrategy
    implements FastUtilHashingStrategies.SerializableHashStrategy<Path> {
        private PathSerializableHashStrategy() {
        }

        @Override
        public int hashCode(@Nullable Path o) {
            return FileUtilRt.pathHashCode(o == null ? null : o.toString());
        }

        @Override
        public boolean equals(@Nullable Path a, @Nullable Path b) {
            return FileUtilRt.pathsEqual(a == null ? null : a.toString(), b == null ? null : b.toString());
        }
    }
}

