/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.LowMemoryWatcherManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.AppDelayQueue;
import com.intellij.util.concurrency.CountingThreadFactory;
import com.intellij.util.concurrency.SchedulingWrapper;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class AppScheduledExecutorService
extends SchedulingWrapper {
    static final String POOLED_THREAD_PREFIX = "ApplicationImpl pooled thread ";
    @NotNull
    private final String myName;
    private final LowMemoryWatcherManager myLowMemoryWatcherManager;
    private final MyThreadFactory myCountingThreadFactory;

    @NotNull
    static ScheduledExecutorService getInstance() {
        AppScheduledExecutorService appScheduledExecutorService = Holder.INSTANCE;
        if (appScheduledExecutorService == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(0);
        }
        return appScheduledExecutorService;
    }

    /*
     * WARNING - void declaration
     */
    AppScheduledExecutorService(@NotNull String name, long keepAliveTime, @NotNull TimeUnit timeUnit) {
        void unit;
        if (name == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(1);
        }
        if (timeUnit == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(2);
        }
        super(new BackendThreadPoolExecutor(new MyThreadFactory(), keepAliveTime, (TimeUnit)unit), new AppDelayQueue());
        this.myName = name;
        this.myCountingThreadFactory = (MyThreadFactory)((BackendThreadPoolExecutor)this.backendExecutorService).getThreadFactory();
        this.myLowMemoryWatcherManager = new LowMemoryWatcherManager(this);
    }

    public void setNewThreadListener(@NotNull BiConsumer<? super Thread, ? super Runnable> threadListener) {
        if (threadListener == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(3);
        }
        this.myCountingThreadFactory.setNewThreadListener(threadListener);
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        List<Runnable> list = AppScheduledExecutorService.error();
        if (list == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    public void shutdown() {
        AppScheduledExecutorService.error();
    }

    static List<Runnable> error() {
        throw new IncorrectOperationException("You must not call this method on the global app pool");
    }

    @Override
    void doShutdown() {
        super.doShutdown();
        ((BackendThreadPoolExecutor)this.backendExecutorService).superShutdown();
    }

    @Override
    @NotNull
    List<Runnable> doShutdownNow() {
        List<Runnable> list = ContainerUtil.concat(super.doShutdownNow(), ((BackendThreadPoolExecutor)this.backendExecutorService).superShutdownNow());
        if (list == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(5);
        }
        return list;
    }

    void shutdownAppScheduledExecutorService() {
        Disposer.dispose(this.myLowMemoryWatcherManager);
        this.delayQueue.shutdown();
        this.doShutdown();
    }

    @NotNull
    @TestOnly
    public String statistics() {
        String string = this.myName + " threads created counter = " + this.myCountingThreadFactory.counter;
        if (string == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(6);
        }
        return string;
    }

    @TestOnly
    public String dumpQueue() {
        return this.delayQueue.toString();
    }

    public int getBackendPoolExecutorSize() {
        return ((BackendThreadPoolExecutor)this.backendExecutorService).getPoolSize();
    }

    @TestOnly
    void setBackendPoolCorePoolSize(int size) {
        ((BackendThreadPoolExecutor)this.backendExecutorService).superSetCorePoolSize(size);
    }

    @NotNull
    public static Thread getPeriodicTasksThread() {
        Thread thread = Holder.INSTANCE.delayQueue.getThread();
        if (thread == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(7);
        }
        return thread;
    }

    @TestOnly
    void waitForLowMemoryWatcherManagerInit(int timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (unit == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(8);
        }
        this.myLowMemoryWatcherManager.waitForInitComplete(timeout, unit);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/concurrency/AppScheduledExecutorService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/concurrency/AppScheduledExecutorService";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "shutdownNow";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doShutdownNow";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "statistics";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPeriodicTasksThread";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setNewThreadListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "waitForLowMemoryWatcherManagerInit";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class BackendThreadPoolExecutor
    extends ThreadPoolExecutor {
        /*
         * WARNING - void declaration
         */
        BackendThreadPoolExecutor(@NotNull ThreadFactory factory, long keepAliveTime, @NotNull TimeUnit timeUnit) {
            void unit;
            if (factory == null) {
                BackendThreadPoolExecutor.$$$reportNull$$$0(0);
            }
            if (timeUnit == null) {
                BackendThreadPoolExecutor.$$$reportNull$$$0(1);
            }
            super(1, Integer.MAX_VALUE, keepAliveTime, (TimeUnit)unit, new SynchronousQueue<Runnable>(), factory);
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            if (t != null && !(t instanceof ProcessCanceledException)) {
                Logger.getInstance(SchedulingWrapper.class).error("Worker exited due to exception", t);
            }
        }

        private void superShutdown() {
            super.shutdown();
        }

        @NotNull
        private List<Runnable> superShutdownNow() {
            List<Runnable> list = super.shutdownNow();
            if (list == null) {
                BackendThreadPoolExecutor.$$$reportNull$$$0(2);
            }
            return list;
        }

        @Override
        public void shutdown() {
            AppScheduledExecutorService.error();
        }

        @Override
        @NotNull
        public List<Runnable> shutdownNow() {
            List<Runnable> list = AppScheduledExecutorService.error();
            if (list == null) {
                BackendThreadPoolExecutor.$$$reportNull$$$0(3);
            }
            return list;
        }

        @Override
        public void setCorePoolSize(int corePoolSize) {
            AppScheduledExecutorService.error();
        }

        private void superSetCorePoolSize(int corePoolSize) {
            super.setCorePoolSize(corePoolSize);
        }

        @Override
        public void allowCoreThreadTimeOut(boolean value) {
            AppScheduledExecutorService.error();
        }

        @Override
        public void setMaximumPoolSize(int maximumPoolSize) {
            AppScheduledExecutorService.error();
        }

        @Override
        public void setKeepAliveTime(long time, TimeUnit unit) {
            AppScheduledExecutorService.error();
        }

        void superSetKeepAliveTime(long time, TimeUnit unit) {
            super.setKeepAliveTime(time, unit);
        }

        @Override
        public void setThreadFactory(ThreadFactory threadFactory) {
            AppScheduledExecutorService.error();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unit";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/concurrency/AppScheduledExecutorService$BackendThreadPoolExecutor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/concurrency/AppScheduledExecutorService$BackendThreadPoolExecutor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "superShutdownNow";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "shutdownNow";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class MyThreadFactory
    extends CountingThreadFactory {
        private BiConsumer<? super Thread, ? super Runnable> newThreadListener;
        private final ThreadFactory myThreadFactory = Executors.privilegedThreadFactory();

        private MyThreadFactory() {
        }

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            if (r == null) {
                MyThreadFactory.$$$reportNull$$$0(0);
            }
            Thread thread = this.myThreadFactory.newThread(r);
            thread.setName(AppScheduledExecutorService.POOLED_THREAD_PREFIX + this.counter.incrementAndGet());
            thread.setPriority(4);
            BiConsumer<? super Thread, ? super Runnable> listener = this.newThreadListener;
            if (listener != null) {
                listener.accept(thread, r);
            }
            Thread thread2 = thread;
            if (thread2 == null) {
                MyThreadFactory.$$$reportNull$$$0(1);
            }
            return thread2;
        }

        void setNewThreadListener(@NotNull BiConsumer<? super Thread, ? super Runnable> threadListener) {
            if (threadListener == null) {
                MyThreadFactory.$$$reportNull$$$0(2);
            }
            if (this.newThreadListener != null) {
                throw new IllegalStateException("Listener was already set: " + this.newThreadListener);
            }
            this.newThreadListener = threadListener;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/concurrency/AppScheduledExecutorService$MyThreadFactory";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "threadListener";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/concurrency/AppScheduledExecutorService$MyThreadFactory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "newThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "newThread";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setNewThreadListener";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class Holder {
        private static final AppScheduledExecutorService INSTANCE = new AppScheduledExecutorService("Global instance", 1L, TimeUnit.MINUTES);

        private Holder() {
        }
    }
}

