/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConditionalLoopStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiGuardedPattern;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiParenthesizedPattern;
import com.intellij.psi.PsiPattern;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimaryPattern;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeTestPattern;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaPsiPatternUtil {
    @Contract(pure=true)
    @NotNull
    public static List<PsiPatternVariable> getExposedPatternVariables(@NotNull PsiExpression expression) {
        PsiElement parent;
        boolean parentMayAccept;
        if (expression == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(0);
        }
        boolean bl = parentMayAccept = (parent = PsiUtil.skipParenthesizedExprUp(expression.getParent())) instanceof PsiPrefixExpression && ((PsiPrefixExpression)parent).getOperationTokenType().equals(JavaTokenType.EXCL) || parent instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)parent).getOperationTokenType().equals(JavaTokenType.ANDAND) || parent instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)parent).getOperationTokenType().equals(JavaTokenType.OROR) || parent instanceof PsiConditionalExpression || parent instanceof PsiIfStatement || parent instanceof PsiConditionalLoopStatement;
        if (!parentMayAccept) {
            List<PsiPatternVariable> list = Collections.emptyList();
            if (list == null) {
                JavaPsiPatternUtil.$$$reportNull$$$0(1);
            }
            return list;
        }
        ArrayList<PsiPatternVariable> list = new ArrayList<PsiPatternVariable>();
        JavaPsiPatternUtil.collectPatternVariableCandidates(expression, expression, list, false);
        ArrayList<PsiPatternVariable> arrayList = list;
        if (arrayList == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Contract(pure=true)
    @NotNull
    public static List<PsiPatternVariable> getExposedPatternVariablesIgnoreParent(@NotNull PsiExpression expression) {
        if (expression == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(3);
        }
        ArrayList<PsiPatternVariable> list = new ArrayList<PsiPatternVariable>();
        JavaPsiPatternUtil.collectPatternVariableCandidates(expression, expression, list, true);
        ArrayList<PsiPatternVariable> arrayList = list;
        if (arrayList == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    public static String getEffectiveInitializerText(@NotNull PsiPatternVariable variable) {
        PsiPattern pattern;
        PsiInstanceOfExpression instanceOf;
        if (variable == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(5);
        }
        if ((instanceOf = ObjectUtils.tryCast((pattern = variable.getPattern()).getParent(), PsiInstanceOfExpression.class)) == null) {
            return null;
        }
        if (pattern instanceof PsiTypeTestPattern) {
            PsiExpression operand = instanceOf.getOperand();
            PsiTypeElement checkType = ((PsiTypeTestPattern)pattern).getCheckType();
            if (checkType == null) {
                return null;
            }
            if (checkType.getType().equals(operand.getType())) {
                return operand.getText();
            }
            return "(" + checkType.getText() + ")" + operand.getText();
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiPattern skipParenthesizedPatternDown(PsiPattern pattern) {
        while (pattern instanceof PsiParenthesizedPattern) {
            pattern = ((PsiParenthesizedPattern)pattern).getPattern();
        }
        return pattern;
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static PsiPatternVariable getPatternVariable(@Nullable PsiPattern pattern) {
        if (pattern instanceof PsiGuardedPattern) {
            return JavaPsiPatternUtil.getPatternVariable(((PsiGuardedPattern)pattern).getPrimaryPattern());
        }
        if (pattern instanceof PsiParenthesizedPattern) {
            return JavaPsiPatternUtil.getPatternVariable(((PsiParenthesizedPattern)pattern).getPattern());
        }
        if (pattern instanceof PsiTypeTestPattern) {
            return ((PsiTypeTestPattern)pattern).getPatternVariable();
        }
        return null;
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static PsiType getPatternType(@Nullable PsiPattern pattern) {
        PsiTypeElement checkType;
        if (pattern == null) {
            return null;
        }
        if (pattern instanceof PsiGuardedPattern) {
            return JavaPsiPatternUtil.getPatternType(((PsiGuardedPattern)pattern).getPrimaryPattern());
        }
        if (pattern instanceof PsiParenthesizedPattern) {
            return JavaPsiPatternUtil.getPatternType(((PsiParenthesizedPattern)pattern).getPattern());
        }
        if (pattern instanceof PsiTypeTestPattern && (checkType = ((PsiTypeTestPattern)pattern).getCheckType()) != null) {
            return checkType.getType();
        }
        return null;
    }

    @Contract(value="null, _ -> false", pure=true)
    public static boolean isTotalForType(@Nullable PsiPattern pattern, @NotNull PsiType type) {
        if (type == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(6);
        }
        if (pattern == null) {
            return false;
        }
        if (pattern instanceof PsiGuardedPattern) {
            PsiGuardedPattern guarded = (PsiGuardedPattern)pattern;
            Object constVal = JavaPsiPatternUtil.evaluateConstant(guarded.getGuardingExpression());
            return JavaPsiPatternUtil.isTotalForType(guarded.getPrimaryPattern(), type) && Boolean.TRUE.equals(constVal);
        }
        if (pattern instanceof PsiParenthesizedPattern) {
            return JavaPsiPatternUtil.isTotalForType(((PsiParenthesizedPattern)pattern).getPattern(), type);
        }
        if (pattern instanceof PsiTypeTestPattern) {
            type = TypeConversionUtil.erasure(type);
            PsiType baseType = TypeConversionUtil.erasure(JavaPsiPatternUtil.getPatternType(pattern));
            if (type instanceof PsiArrayType || baseType instanceof PsiArrayType) {
                return baseType != null && TypeConversionUtil.isAssignable(baseType, type);
            }
            PsiClass typeClass = PsiTypesUtil.getPsiClass(type);
            PsiClass baseTypeClass = PsiTypesUtil.getPsiClass(baseType);
            return typeClass != null && baseTypeClass != null && InheritanceUtil.isInheritorOrSelf(typeClass, baseTypeClass, true);
        }
        return false;
    }

    @Contract(value="null, _ -> false", pure=true)
    public static boolean dominates(@Nullable PsiPattern who, @NotNull PsiPattern overWhom) {
        if (overWhom == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(7);
        }
        if (who == null) {
            return false;
        }
        if (overWhom instanceof PsiGuardedPattern) {
            if (who instanceof PsiTypeTestPattern) {
                PsiType whoType = JavaPsiPatternUtil.getPatternType(who);
                PsiType overWhomType = JavaPsiPatternUtil.getPatternType(overWhom);
                if (whoType != null && overWhomType != null && whoType.equalsToText(overWhomType.getCanonicalText())) {
                    return true;
                }
            } else {
                if (who instanceof PsiParenthesizedPattern) {
                    return JavaPsiPatternUtil.dominates(((PsiParenthesizedPattern)who).getPattern(), overWhom);
                }
                if (who instanceof PsiGuardedPattern) {
                    boolean dominates = JavaPsiPatternUtil.dominates((PsiPattern)((PsiGuardedPattern)who).getPrimaryPattern(), overWhom);
                    if (!dominates) {
                        return false;
                    }
                    Object constVal = JavaPsiPatternUtil.evaluateConstant(((PsiGuardedPattern)who).getGuardingExpression());
                    return Boolean.TRUE.equals(constVal);
                }
                return false;
            }
            return JavaPsiPatternUtil.dominates(who, ((PsiGuardedPattern)overWhom).getPrimaryPattern());
        }
        if (overWhom instanceof PsiParenthesizedPattern) {
            PsiPattern pattern = ((PsiParenthesizedPattern)overWhom).getPattern();
            if (pattern == null) {
                return false;
            }
            return JavaPsiPatternUtil.dominates(who, pattern);
        }
        if (overWhom instanceof PsiTypeTestPattern) {
            PsiType overWhomType = JavaPsiPatternUtil.getPatternType(overWhom);
            return overWhomType != null && JavaPsiPatternUtil.isTotalForType(who, overWhomType);
        }
        return false;
    }

    @Contract(value="_,null -> false", pure=true)
    public static boolean dominates(@NotNull PsiPattern who, @Nullable PsiType overWhom) {
        if (who == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(8);
        }
        if (overWhom == null) {
            return false;
        }
        PsiType whoType = TypeConversionUtil.erasure(JavaPsiPatternUtil.getPatternType(who));
        if (whoType == null) {
            return false;
        }
        PsiType overWhomType = null;
        if (overWhom instanceof PsiPrimitiveType) {
            overWhomType = ((PsiPrimitiveType)overWhom).getBoxedType(who);
        } else if (overWhom instanceof PsiClassType) {
            overWhomType = overWhom;
        }
        return overWhomType != null && TypeConversionUtil.areTypesConvertible(overWhomType, whoType);
    }

    private static void collectPatternVariableCandidates(@NotNull PsiExpression scope, @NotNull PsiExpression expression, Collection<PsiPatternVariable> candidates, boolean strict) {
        PsiPolyadicExpression polyadicExpression;
        IElementType tokenType;
        PsiPatternVariable variable;
        PsiPrimaryPattern pattern;
        if (scope == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(9);
        }
        if (expression == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(10);
        }
        while (true) {
            if (expression instanceof PsiParenthesizedExpression) {
                expression = ((PsiParenthesizedExpression)expression).getExpression();
                continue;
            }
            if (!(expression instanceof PsiPrefixExpression) || !((PsiPrefixExpression)expression).getOperationTokenType().equals(JavaTokenType.EXCL)) break;
            expression = ((PsiPrefixExpression)expression).getOperand();
        }
        if (expression instanceof PsiInstanceOfExpression && (pattern = ((PsiInstanceOfExpression)expression).getPattern()) instanceof PsiTypeTestPattern && (variable = ((PsiTypeTestPattern)pattern).getPatternVariable()) != null && !PsiTreeUtil.isAncestor(scope, variable.getDeclarationScope(), strict)) {
            candidates.add(variable);
        }
        if (expression instanceof PsiPolyadicExpression && ((tokenType = (polyadicExpression = (PsiPolyadicExpression)expression).getOperationTokenType()).equals(JavaTokenType.ANDAND) || tokenType.equals(JavaTokenType.OROR))) {
            for (PsiExpression operand : polyadicExpression.getOperands()) {
                JavaPsiPatternUtil.collectPatternVariableCandidates(scope, operand, candidates, strict);
            }
        }
    }

    @Nullable
    private static Object evaluateConstant(@Nullable PsiExpression expression) {
        if (expression == null) {
            return null;
        }
        return JavaPsiFacade.getInstance(expression.getProject()).getConstantEvaluationHelper().computeConstantExpression(expression, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/JavaPsiPatternUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overWhom";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "who";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/JavaPsiPatternUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExposedPatternVariables";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExposedPatternVariablesIgnoreParent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getExposedPatternVariables";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getExposedPatternVariablesIgnoreParent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveInitializerText";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isTotalForType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "dominates";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectPatternVariableCandidates";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

