/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.util.containers.UnsignedShortArrayList;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.function.IntUnaryOperator;

final class MostlyUShortIntList
implements IntUnaryOperator {
    private static final int IN_MAP = 65535;
    private final UnsignedShortArrayList myList;
    private Int2IntMap myMap;

    MostlyUShortIntList(int initialCapacity) {
        this.myList = new UnsignedShortArrayList(initialCapacity);
    }

    void add(int value) {
        if (value < 0 || value >= 65535) {
            this.initMap().put(this.myList.size(), value);
            value = 65535;
        }
        this.myList.add(value);
    }

    void set(int index, int value) {
        if (value < 0 || value >= 65535) {
            this.initMap().put(index, value);
            value = 65535;
        }
        this.myList.setQuick(index, value);
    }

    private Int2IntMap initMap() {
        if (this.myMap == null) {
            this.myMap = new Int2IntOpenHashMap();
        }
        return this.myMap;
    }

    @Override
    public int applyAsInt(int index) {
        return this.get(index);
    }

    public int get(int index) {
        int value = this.myList.getQuick(index);
        return value == 65535 ? this.myMap.get(index) : value;
    }

    int size() {
        return this.myList.size();
    }

    void trimToSize() {
        this.myList.trimToSize();
        if (this.myMap != null) {
            ((Int2IntOpenHashMap)this.myMap).trim();
        }
    }
}

