/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class IndexingStampInfo {
    final long indexingFileStamp;
    final long indexingByteLength;
    final int indexingCharLength;
    final boolean isBinary;

    IndexingStampInfo(long indexingFileStamp, long indexingByteLength, int indexingCharLength, boolean isBinary) {
        this.indexingFileStamp = indexingFileStamp;
        this.indexingByteLength = indexingByteLength;
        this.indexingCharLength = indexingCharLength;
        this.isBinary = isBinary;
    }

    public String toString() {
        return "indexing timestamp = " + this.indexingFileStamp + ", binary = " + this.isBinary + ", byte size = " + this.indexingByteLength + ", char size = " + this.indexingCharLength;
    }

    public boolean isUpToDate(@Nullable Document document, @NotNull VirtualFile file, @NotNull PsiFile psi) {
        if (file == null) {
            IndexingStampInfo.$$$reportNull$$$0(0);
        }
        if (psi == null) {
            IndexingStampInfo.$$$reportNull$$$0(1);
        }
        if (document == null || FileDocumentManager.getInstance().isDocumentUnsaved(document) || !PsiDocumentManager.getInstance(psi.getProject()).isCommitted(document)) {
            return false;
        }
        boolean isFileBinary = file.getFileType().isBinary();
        return this.indexingFileStamp == file.getTimeStamp() && this.isBinary == isFileBinary && this.contentLengthMatches(file.getLength(), document.getTextLength());
    }

    public boolean contentLengthMatches(long byteContentLength, int charContentLength) {
        if (this.indexingCharLength >= 0 && charContentLength >= 0) {
            return this.indexingCharLength == charContentLength;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "psi";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/stubs/IndexingStampInfo";
        objectArray[2] = "isUpToDate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

