/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.lang.LanguageMatcher;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalSearchScope
extends SearchScope {
    private static final Logger LOG = Logger.getInstance(LocalSearchScope.class);
    public static final LocalSearchScope EMPTY = new LocalSearchScope(PsiElement.EMPTY_ARRAY);
    @Nls
    private final String myDisplayName;
    private final PsiElement[] myScope;
    private final VirtualFile[] myVirtualFiles;
    private final boolean myIgnoreInjectedPsi;

    public LocalSearchScope(@NotNull PsiElement scope) {
        if (scope == null) {
            LocalSearchScope.$$$reportNull$$$0(0);
        }
        this(scope, null);
    }

    public LocalSearchScope(@NotNull PsiElement scope, @Nullable @Nls String displayName) {
        if (scope == null) {
            LocalSearchScope.$$$reportNull$$$0(1);
        }
        this(new PsiElement[]{scope}, displayName);
    }

    public LocalSearchScope(PsiElement @NotNull [] scope) {
        if (scope == null) {
            LocalSearchScope.$$$reportNull$$$0(2);
        }
        this(scope, null);
    }

    public LocalSearchScope(PsiElement @NotNull [] scope, @Nullable @Nls String displayName) {
        if (scope == null) {
            LocalSearchScope.$$$reportNull$$$0(3);
        }
        this(scope, displayName, false);
    }

    public LocalSearchScope(PsiElement @NotNull [] scope, @Nullable @Nls String displayName, boolean ignoreInjectedPsi) {
        if (scope == null) {
            LocalSearchScope.$$$reportNull$$$0(4);
        }
        this.myIgnoreInjectedPsi = ignoreInjectedPsi;
        this.myDisplayName = displayName;
        LinkedHashSet<PsiElement> localScope = new LinkedHashSet<PsiElement>(scope.length);
        HashSet<VirtualFile> virtualFiles = new HashSet<VirtualFile>(scope.length);
        for (PsiElement element : scope) {
            VirtualFile virtualFile;
            LOG.assertTrue(element != null, "null element");
            PsiFile containingFile = element.getContainingFile();
            LOG.assertTrue(containingFile != null, element.getClass().getName());
            if (element instanceof PsiFile) {
                for (PsiFile file : ((PsiFile)element).getViewProvider().getAllFiles()) {
                    if (file == null) {
                        throw new IllegalArgumentException("file " + element + " returned null in its getAllFiles()");
                    }
                    localScope.add(file);
                }
            } else if (element instanceof StubBasedPsiElement || element.getTextRange() != null) {
                localScope.add(element);
            }
            if ((virtualFile = PsiUtilCore.getVirtualFile(containingFile)) == null) continue;
            virtualFiles.add(virtualFile);
        }
        this.myScope = PsiUtilCore.toPsiElementArray(localScope);
        this.myVirtualFiles = VfsUtilCore.toVirtualFileArray(virtualFiles);
    }

    public boolean isIgnoreInjectedPsi() {
        return this.myIgnoreInjectedPsi;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName == null ? super.getDisplayName() : this.myDisplayName;
        if (string == null) {
            LocalSearchScope.$$$reportNull$$$0(5);
        }
        return string;
    }

    public PsiElement @NotNull [] getScope() {
        if (this.myScope == null) {
            LocalSearchScope.$$$reportNull$$$0(6);
        }
        return this.myScope;
    }

    public VirtualFile @NotNull [] getVirtualFiles() {
        if (this.myVirtualFiles == null) {
            LocalSearchScope.$$$reportNull$$$0(7);
        }
        return this.myVirtualFiles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocalSearchScope)) {
            return false;
        }
        LocalSearchScope other = (LocalSearchScope)o;
        if (other.myIgnoreInjectedPsi != this.myIgnoreInjectedPsi) {
            return false;
        }
        if (other.myScope.length != this.myScope.length) {
            return false;
        }
        if (!Comparing.strEqual(this.myDisplayName, other.myDisplayName)) {
            return false;
        }
        for (PsiElement scopeElement : this.myScope) {
            for (PsiElement thatScopeElement : other.myScope) {
                if (Comparing.equal(scopeElement, thatScopeElement)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected int calcHashCode() {
        int result = 0;
        result += this.myIgnoreInjectedPsi ? 1 : 0;
        for (PsiElement element : this.myScope) {
            result += element.hashCode();
        }
        return result;
    }

    @NotNull
    public LocalSearchScope intersectWith(@NotNull LocalSearchScope scope2) {
        if (scope2 == null) {
            LocalSearchScope.$$$reportNull$$$0(8);
        }
        if (this.equals(scope2)) {
            LocalSearchScope localSearchScope = this;
            if (localSearchScope == null) {
                LocalSearchScope.$$$reportNull$$$0(9);
            }
            return localSearchScope;
        }
        return LocalSearchScope.intersection(this, scope2);
    }

    @NotNull
    private static LocalSearchScope intersection(@NotNull LocalSearchScope scope1, @NotNull LocalSearchScope scope2) {
        if (scope1 == null) {
            LocalSearchScope.$$$reportNull$$$0(10);
        }
        if (scope2 == null) {
            LocalSearchScope.$$$reportNull$$$0(11);
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (PsiElement element1 : scope1.myScope) {
            for (PsiElement element2 : scope2.myScope) {
                PsiElement element = LocalSearchScope.intersectScopeElements(element1, element2);
                if (element == null) continue;
                result.add(element);
            }
        }
        return new LocalSearchScope(PsiUtilCore.toPsiElementArray(result), null, scope1.myIgnoreInjectedPsi || scope2.myIgnoreInjectedPsi);
    }

    @Override
    @NotNull
    public SearchScope intersectWith(@NotNull SearchScope scope2) {
        if (scope2 == null) {
            LocalSearchScope.$$$reportNull$$$0(12);
        }
        if (scope2 instanceof LocalSearchScope) {
            LocalSearchScope localSearchScope = this.intersectWith((LocalSearchScope)scope2);
            if (localSearchScope == null) {
                LocalSearchScope.$$$reportNull$$$0(13);
            }
            return localSearchScope;
        }
        LocalSearchScope nonPhysicalScope = this.tryIntersectNonPhysicalWith((GlobalSearchScope)scope2);
        if (nonPhysicalScope != null) {
            LocalSearchScope localSearchScope = nonPhysicalScope;
            if (localSearchScope == null) {
                LocalSearchScope.$$$reportNull$$$0(14);
            }
            return localSearchScope;
        }
        SearchScope searchScope = ((GlobalSearchScope)scope2).intersectWith(this);
        if (searchScope == null) {
            LocalSearchScope.$$$reportNull$$$0(15);
        }
        return searchScope;
    }

    @Nullable
    private LocalSearchScope tryIntersectNonPhysicalWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            LocalSearchScope.$$$reportNull$$$0(16);
        }
        Project project = scope.getProject();
        for (PsiElement element : this.myScope) {
            PsiFile containingFile = element.getContainingFile();
            if (containingFile == null) continue;
            if (containingFile.getViewProvider().isPhysical()) {
                return null;
            }
            if (project == null || project == containingFile.getProject()) continue;
            return EMPTY;
        }
        return this;
    }

    @Nullable
    private static PsiElement intersectScopeElements(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        if (element1 == null) {
            LocalSearchScope.$$$reportNull$$$0(17);
        }
        if (element2 == null) {
            LocalSearchScope.$$$reportNull$$$0(18);
        }
        if (PsiTreeUtil.isContextAncestor(element1, element2, false)) {
            return element2;
        }
        if (PsiTreeUtil.isContextAncestor(element2, element1, false)) {
            return element1;
        }
        if (PsiTreeUtil.isAncestor(element1, element2, false)) {
            return element2;
        }
        if (PsiTreeUtil.isAncestor(element2, element1, false)) {
            return element1;
        }
        return null;
    }

    public String toString() {
        return Arrays.stream(this.myScope).map(String::valueOf).collect(Collectors.joining(",", "LocalSearchScope:", ""));
    }

    @Override
    @NotNull
    public SearchScope union(@NotNull SearchScope scope) {
        if (scope == null) {
            LocalSearchScope.$$$reportNull$$$0(19);
        }
        if (scope instanceof LocalSearchScope) {
            SearchScope searchScope = this.union((LocalSearchScope)scope);
            if (searchScope == null) {
                LocalSearchScope.$$$reportNull$$$0(20);
            }
            return searchScope;
        }
        GlobalSearchScope globalSearchScope = ((GlobalSearchScope)scope).union(this);
        if (globalSearchScope == null) {
            LocalSearchScope.$$$reportNull$$$0(21);
        }
        return globalSearchScope;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            LocalSearchScope.$$$reportNull$$$0(22);
        }
        return this.isInScope(file);
    }

    @NotNull
    public SearchScope union(@NotNull LocalSearchScope scope2) {
        if (scope2 == null) {
            LocalSearchScope.$$$reportNull$$$0(23);
        }
        if (this.equals(scope2)) {
            LocalSearchScope localSearchScope = this;
            if (localSearchScope == null) {
                LocalSearchScope.$$$reportNull$$$0(24);
            }
            return localSearchScope;
        }
        PsiElement[] elements1 = this.getScope();
        PsiElement[] elements2 = scope2.getScope();
        boolean[] united = new boolean[elements2.length];
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        block0: for (PsiElement element1 : elements1) {
            for (int j = 0; j < elements2.length; ++j) {
                PsiElement element2 = elements2[j];
                PsiElement unionElement = LocalSearchScope.scopeElementsUnion(element1, element2);
                if (unionElement == null || unionElement.getContainingFile() == null) continue;
                result.add(unionElement);
                united[j] = true;
                break block0;
            }
            result.add(element1);
        }
        for (int i = 0; i < united.length; ++i) {
            boolean b = united[i];
            if (b) continue;
            result.add(elements2[i]);
        }
        return new LocalSearchScope(PsiUtilCore.toPsiElementArray(result));
    }

    private static PsiElement scopeElementsUnion(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        if (element1 == null) {
            LocalSearchScope.$$$reportNull$$$0(25);
        }
        if (element2 == null) {
            LocalSearchScope.$$$reportNull$$$0(26);
        }
        if (PsiTreeUtil.isAncestor(element1, element2, false)) {
            return element1;
        }
        if (PsiTreeUtil.isAncestor(element2, element1, false)) {
            return element2;
        }
        PsiElement commonParent = PsiTreeUtil.findCommonParent(element1, element2);
        if (commonParent == null) {
            return null;
        }
        return commonParent;
    }

    public boolean isInScope(@NotNull VirtualFile file) {
        if (file == null) {
            LocalSearchScope.$$$reportNull$$$0(27);
        }
        return ArrayUtil.indexOf(this.myVirtualFiles, file) != -1;
    }

    public boolean containsRange(@NotNull PsiFile file, @NotNull TextRange range) {
        if (file == null) {
            LocalSearchScope.$$$reportNull$$$0(28);
        }
        if (range == null) {
            LocalSearchScope.$$$reportNull$$$0(29);
        }
        for (PsiElement element : this.getScope()) {
            if (file != element.getContainingFile() || !element.getTextRange().contains(range)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    @Contract(pure=true)
    public static LocalSearchScope getScopeRestrictedByFileTypes(@NotNull LocalSearchScope scope, FileType ... fileTypes) {
        if (scope == null) {
            LocalSearchScope.$$$reportNull$$$0(30);
        }
        if (fileTypes == null) {
            LocalSearchScope.$$$reportNull$$$0(31);
        }
        if (fileTypes.length == 0) {
            throw new IllegalArgumentException("empty fileTypes");
        }
        if (scope == EMPTY) {
            LocalSearchScope localSearchScope = EMPTY;
            if (localSearchScope == null) {
                LocalSearchScope.$$$reportNull$$$0(32);
            }
            return localSearchScope;
        }
        LocalSearchScope localSearchScope = ReadAction.compute(() -> {
            PsiElement[] elements = scope.getScope();
            ArrayList<PsiElement> result = new ArrayList<PsiElement>(elements.length);
            for (PsiElement element : elements) {
                PsiFile containingFile = element.getContainingFile();
                FileType fileType = containingFile.getFileType();
                if (!ArrayUtil.contains(fileType, fileTypes)) continue;
                result.add(element);
            }
            return result.isEmpty() ? EMPTY : new LocalSearchScope(PsiUtilCore.toPsiElementArray(result), scope.getDisplayName(), scope.isIgnoreInjectedPsi());
        });
        if (localSearchScope == null) {
            LocalSearchScope.$$$reportNull$$$0(33);
        }
        return localSearchScope;
    }

    @Contract(pure=true)
    @NotNull
    static LocalSearchScope getScopeRestrictedByFileLanguage(@NotNull LocalSearchScope scope, @NotNull LanguageMatcher matcher) {
        if (scope == null) {
            LocalSearchScope.$$$reportNull$$$0(34);
        }
        if (matcher == null) {
            LocalSearchScope.$$$reportNull$$$0(35);
        }
        if (scope == EMPTY) {
            LocalSearchScope localSearchScope = EMPTY;
            if (localSearchScope == null) {
                LocalSearchScope.$$$reportNull$$$0(36);
            }
            return localSearchScope;
        }
        LocalSearchScope localSearchScope = ReadAction.compute(() -> {
            List<PsiElement> result = ContainerUtil.filter(scope.getScope(), element -> matcher.matchesLanguage(element.getContainingFile().getLanguage()));
            return result.isEmpty() ? EMPTY : new LocalSearchScope(PsiUtilCore.toPsiElementArray(result), scope.getDisplayName(), scope.isIgnoreInjectedPsi());
        });
        if (localSearchScope == null) {
            LocalSearchScope.$$$reportNull$$$0(37);
        }
        return localSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 24: 
            case 32: 
            case 33: 
            case 36: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 24: 
            case 32: 
            case 33: 
            case 36: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 24: 
            case 32: 
            case 33: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/LocalSearchScope";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope2";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope1";
                break;
            }
            case 17: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element1";
                break;
            }
            case 18: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2";
                break;
            }
            case 22: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypes";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/LocalSearchScope";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFiles";
                break;
            }
            case 9: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectWith";
                break;
            }
            case 20: 
            case 21: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "union";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeRestrictedByFileTypes";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeRestrictedByFileLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 24: 
            case 32: 
            case 33: 
            case 36: 
            case 37: {
                break;
            }
            case 8: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "intersectWith";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "intersection";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "tryIntersectNonPhysicalWith";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "intersectScopeElements";
                break;
            }
            case 19: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "scopeElementsUnion";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isInScope";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "containsRange";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getScopeRestrictedByFileTypes";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getScopeRestrictedByFileLanguage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 24: 
            case 32: 
            case 33: 
            case 36: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

