/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmTypeDeclaration;
import com.intellij.lang.jvm.facade.JvmFacade;
import com.intellij.lang.jvm.facade.JvmFacadeImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JvmPsiConversionHelper;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.impl.IsConstantExpressionVisitor;
import com.intellij.psi.impl.JavaPsiFacadeEx;
import com.intellij.psi.impl.PsiConstantEvaluationHelperImpl;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyHolder;
import com.intellij.psi.impl.source.JavaDummyHolderFactory;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public class JavaPsiFacadeImpl
extends JavaPsiFacadeEx {
    private static final Logger LOG = Logger.getInstance(JavaPsiFacadeImpl.class);
    private final PsiConstantEvaluationHelper myConstantEvaluationHelper;
    private final ConcurrentMap<String, PsiPackage> myPackageCache;
    private final ConcurrentMap<GlobalSearchScope, Map<String, PsiClass>> myClassCache;
    private final Map<GlobalSearchScope, Map<String, Collection<PsiJavaModule>>> myModuleCache;
    private final Project myProject;
    private final JavaFileManager myFileManager;
    private final NotNullLazyValue<JvmFacadeImpl> myJvmFacade;
    private final JvmPsiConversionHelper myConversionHelper;

    public JavaPsiFacadeImpl(@NotNull Project project) {
        if (project == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(0);
        }
        this.myPackageCache = ContainerUtil.createConcurrentSoftValueMap();
        this.myClassCache = ContainerUtil.createConcurrentSoftKeySoftValueMap();
        this.myModuleCache = ContainerUtil.createConcurrentSoftKeySoftValueMap();
        this.myProject = project;
        this.myFileManager = JavaFileManager.getInstance(this.myProject);
        this.myConstantEvaluationHelper = new PsiConstantEvaluationHelperImpl();
        this.myJvmFacade = NotNullLazyValue.atomicLazy(() -> (JvmFacadeImpl)JvmFacade.getInstance(project));
        this.myConversionHelper = JvmPsiConversionHelper.getInstance(this.myProject);
        project.getMessageBus().connect().subscribe(PsiModificationTracker.TOPIC, () -> {
            this.myClassCache.clear();
            this.myPackageCache.clear();
            this.myModuleCache.clear();
        });
        DummyHolderFactory.setFactory(new JavaDummyHolderFactory());
    }

    @Override
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(2);
        }
        ProgressIndicatorProvider.checkCanceled();
        Map map = this.myClassCache.computeIfAbsent(scope, scope1 -> ContainerUtil.createConcurrentWeakValueMap());
        PsiClass result = (PsiClass)map.get(qualifiedName);
        if (result == null) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            result = this.doFindClass(qualifiedName, scope);
            if (result != null && stamp.mayCacheNow()) {
                map.put(qualifiedName, result);
            }
        }
        return result;
    }

    @Nullable
    private PsiClass doFindClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(4);
        }
        if (this.shouldUseSlowResolve()) {
            PsiClass[] classes = this.findClassesInDumbMode(qualifiedName, scope);
            if (classes.length != 0) {
                return classes[0];
            }
            return null;
        }
        List<PsiElementFinder> finders = this.filteredFinders();
        Predicate<PsiClass> classesFilter = JavaPsiFacadeImpl.getFilterFromFinders(scope, finders);
        for (PsiElementFinder finder : finders) {
            PsiClass aClass = finder.findClass(qualifiedName, scope);
            if (aClass == null || classesFilter != null && !classesFilter.test(aClass)) continue;
            return aClass;
        }
        return null;
    }

    private PsiClass @NotNull [] findClassesInDumbMode(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(6);
        }
        String packageName = StringUtil.getPackageName(qualifiedName);
        PsiPackage pkg = this.findPackage(packageName);
        String className = StringUtil.getShortName(qualifiedName);
        if (pkg == null && packageName.length() < qualifiedName.length()) {
            PsiClass[] containingClasses = this.findClassesInDumbMode(packageName, scope);
            if (containingClasses.length == 1) {
                PsiClass[] psiClassArray = PsiElementFinder.filterByName(className, containingClasses[0].getInnerClasses());
                if (psiClassArray == null) {
                    JavaPsiFacadeImpl.$$$reportNull$$$0(7);
                }
                return psiClassArray;
            }
            if (PsiClass.EMPTY_ARRAY == null) {
                JavaPsiFacadeImpl.$$$reportNull$$$0(8);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        if (pkg == null) {
            if (PsiClass.EMPTY_ARRAY == null) {
                JavaPsiFacadeImpl.$$$reportNull$$$0(9);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        PsiClass[] psiClassArray = pkg.findClassByShortName(className, scope);
        if (psiClassArray == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(10);
        }
        return psiClassArray;
    }

    @Override
    public PsiClass @NotNull [] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        List<PsiClass> allClasses;
        if (qualifiedName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(11);
        }
        if (scope == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(12);
        }
        PsiClass[] psiClassArray = (allClasses = this.findClassesWithJvmFacade(qualifiedName, scope)).isEmpty() ? PsiClass.EMPTY_ARRAY : allClasses.toArray(PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(13);
        }
        return psiClassArray;
    }

    @NotNull
    private List<PsiClass> findClassesWithJvmFacade(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        List<JvmClass> jvmClasses;
        if (qualifiedName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(14);
        }
        if (scope == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(15);
        }
        ArrayList<PsiClass> result = null;
        List<PsiClass> ownClasses = this.findClassesWithoutJvmFacade(qualifiedName, scope);
        if (!ownClasses.isEmpty()) {
            result = new ArrayList<PsiClass>(ownClasses);
        }
        if (!(jvmClasses = this.myJvmFacade.getValue().findClassesWithoutJavaFacade(qualifiedName, scope)).isEmpty()) {
            List<PsiClass> jvmPsiClasses = ContainerUtil.map(jvmClasses, it -> this.myConversionHelper.convertTypeDeclaration((JvmTypeDeclaration)it));
            if (result == null) {
                result = new ArrayList<PsiClass>(jvmPsiClasses);
            } else {
                result.addAll(jvmPsiClasses);
            }
        }
        List<PsiClass> list = result == null ? Collections.emptyList() : result;
        if (list == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    public List<PsiClass> findClassesWithoutJvmFacade(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(17);
        }
        if (scope == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(18);
        }
        if (this.shouldUseSlowResolve()) {
            List<PsiClass> list = Arrays.asList(this.findClassesInDumbMode(qualifiedName, scope));
            if (list == null) {
                JavaPsiFacadeImpl.$$$reportNull$$$0(19);
            }
            return list;
        }
        List<PsiElementFinder> finders = this.filteredFinders();
        Predicate<PsiClass> classesFilter = JavaPsiFacadeImpl.getFilterFromFinders(scope, finders);
        ArrayList result = null;
        for (PsiElementFinder finder : finders) {
            PsiClass[] finderClasses = finder.findClasses(qualifiedName, scope);
            if (finderClasses.length == 0) continue;
            if (result == null) {
                result = new ArrayList(finderClasses.length);
            }
            JavaPsiFacadeImpl.filterClassesAndAppend(finder, classesFilter, finderClasses, result);
        }
        List<PsiClass> list = result == null ? Collections.emptyList() : result;
        if (list == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(20);
        }
        return list;
    }

    private static Predicate<PsiClass> getFilterFromFinders(@NotNull GlobalSearchScope scope, @NotNull List<? extends PsiElementFinder> finders) {
        if (scope == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(21);
        }
        if (finders == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(22);
        }
        Predicate<PsiClass> filter = null;
        for (PsiElementFinder psiElementFinder : finders) {
            Predicate<PsiClass> finderFilter = psiElementFinder.getClassesFilter(scope);
            if (finderFilter == null) continue;
            filter = filter == null ? finderFilter : filter.and(finderFilter);
        }
        return filter;
    }

    private boolean shouldUseSlowResolve() {
        DumbService dumbService = DumbService.getInstance(this.getProject());
        return dumbService.isDumb() && dumbService.isAlternativeResolveEnabled();
    }

    @Override
    @NotNull
    public PsiConstantEvaluationHelper getConstantEvaluationHelper() {
        PsiConstantEvaluationHelper psiConstantEvaluationHelper = this.myConstantEvaluationHelper;
        if (psiConstantEvaluationHelper == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(23);
        }
        return psiConstantEvaluationHelper;
    }

    @Override
    public PsiPackage findPackage(@NotNull String qualifiedName) {
        PsiPackage aPackage;
        if (qualifiedName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(24);
        }
        if ((aPackage = (PsiPackage)this.myPackageCache.get(qualifiedName)) != null) {
            return aPackage;
        }
        for (PsiElementFinder finder : this.filteredFinders()) {
            aPackage = finder.findPackage(qualifiedName);
            if (aPackage == null) continue;
            return ConcurrencyUtil.cacheOrGet(this.myPackageCache, qualifiedName, aPackage);
        }
        return null;
    }

    @Override
    public PsiJavaModule findModule(@NotNull String moduleName, @NotNull GlobalSearchScope scope) {
        Collection<PsiJavaModule> modules;
        if (moduleName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(25);
        }
        if (scope == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(26);
        }
        return (modules = this.findModules(moduleName, scope)).size() == 1 ? modules.iterator().next() : null;
    }

    @Override
    @NotNull
    public Collection<PsiJavaModule> findModules(@NotNull String moduleName, @NotNull GlobalSearchScope scope) {
        if (moduleName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(27);
        }
        if (scope == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(28);
        }
        Collection collection = this.myModuleCache.computeIfAbsent(scope, k -> ContainerUtil.createConcurrentWeakValueMap()).computeIfAbsent(moduleName, k -> JavaFileManager.getInstance(this.myProject).findModules((String)k, scope));
        if (collection == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(29);
        }
        return collection;
    }

    @NotNull
    private List<PsiElementFinder> filteredFinders() {
        List<PsiElementFinder> list = DumbService.getInstance(this.getProject()).filterByDumbAwareness(PsiElementFinder.EP.getPoint(this.myProject).getExtensionList());
        if (list == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(30);
        }
        return list;
    }

    @Override
    @NotNull
    public PsiJavaParserFacade getParserFacade() {
        PsiElementFactory psiElementFactory = this.getElementFactory();
        if (psiElementFactory == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(31);
        }
        return psiElementFactory;
    }

    @Override
    @NotNull
    public PsiResolveHelper getResolveHelper() {
        PsiResolveHelper psiResolveHelper = PsiResolveHelper.SERVICE.getInstance(this.myProject);
        if (psiResolveHelper == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(32);
        }
        return psiResolveHelper;
    }

    @Override
    @NotNull
    public PsiNameHelper getNameHelper() {
        PsiNameHelper psiNameHelper = PsiNameHelper.getInstance(this.myProject);
        if (psiNameHelper == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(33);
        }
        return psiNameHelper;
    }

    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(34);
        }
        if (scope == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(35);
        }
        HashSet<String> result = new HashSet<String>();
        for (PsiElementFinder finder : this.filteredFinders()) {
            result.addAll(finder.getClassNames(psiPackage, scope));
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(36);
        }
        return hashSet;
    }

    public PsiClass @NotNull [] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(37);
        }
        if (scope == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(38);
        }
        List<PsiElementFinder> finders = this.filteredFinders();
        Predicate<PsiClass> classesFilter = JavaPsiFacadeImpl.getFilterFromFinders(scope, finders);
        ArrayList result = null;
        for (PsiElementFinder finder : finders) {
            PsiClass[] classes = finder.getClasses(psiPackage, scope);
            if (classes.length == 0) continue;
            if (result == null) {
                result = new ArrayList(classes.length);
            }
            JavaPsiFacadeImpl.filterClassesAndAppend(finder, classesFilter, classes, result);
        }
        PsiClass[] psiClassArray = result == null ? PsiClass.EMPTY_ARRAY : result.toArray(PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(39);
        }
        return psiClassArray;
    }

    private static void filterClassesAndAppend(PsiElementFinder finder, @Nullable Predicate<? super PsiClass> classesFilter, PsiClass @NotNull [] classes, @NotNull List<? super PsiClass> result) {
        if (result == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(40);
        }
        if (classes == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(41);
        }
        for (PsiClass psiClass : classes) {
            if (psiClass == null) {
                LOG.error("Finder " + finder + " returned null PsiClass");
                continue;
            }
            if (classesFilter != null && !classesFilter.test(psiClass)) continue;
            result.add(psiClass);
        }
    }

    public PsiFile @NotNull [] getPackageFiles(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(42);
        }
        if (scope == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(43);
        }
        Condition<PsiFile> filter = null;
        for (PsiElementFinder finder : this.filteredFinders()) {
            Condition<PsiFile> finderFilter = finder.getPackageFilesFilter(psiPackage, scope);
            if (finderFilter == null) continue;
            if (filter == null) {
                filter = finderFilter;
                continue;
            }
            filter = Conditions.and(filter, finderFilter);
        }
        LinkedHashSet<PsiFile> result = new LinkedHashSet<PsiFile>();
        PsiDirectory[] directories = psiPackage.getDirectories(scope);
        for (PsiDirectory directory : directories) {
            for (PsiFile file : directory.getFiles()) {
                if (filter != null && !filter.value(file)) continue;
                result.add(file);
            }
        }
        for (PsiElementFinder finder : this.filteredFinders()) {
            Collections.addAll(result, finder.getPackageFiles(psiPackage, scope));
        }
        PsiFile[] psiFileArray = result.toArray(PsiFile.EMPTY_ARRAY);
        if (psiFileArray == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(44);
        }
        return psiFileArray;
    }

    public boolean processPackageDirectories(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiDirectory> consumer, boolean includeLibrarySources) {
        if (psiPackage == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(45);
        }
        if (scope == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(46);
        }
        if (consumer == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(47);
        }
        for (PsiElementFinder finder : this.filteredFinders()) {
            if (finder.processPackageDirectories(psiPackage, scope, consumer, includeLibrarySources)) continue;
            return false;
        }
        return true;
    }

    public PsiPackage @NotNull [] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(48);
        }
        if (scope == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(49);
        }
        LinkedHashMap<String, PsiPackage> result = new LinkedHashMap<String, PsiPackage>();
        for (PsiElementFinder finder : this.filteredFinders()) {
            PsiPackage[] packages;
            for (PsiPackage aPackage : packages = finder.getSubPackages(psiPackage, scope)) {
                result.putIfAbsent(aPackage.getName(), aPackage);
            }
        }
        PsiPackage[] psiPackageArray = result.values().toArray(PsiPackage.EMPTY_ARRAY);
        if (psiPackageArray == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(50);
        }
        return psiPackageArray;
    }

    @Override
    public boolean isPartOfPackagePrefix(@NotNull String packageName) {
        if (packageName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(51);
        }
        Collection<String> packagePrefixes = this.myFileManager.getNonTrivialPackagePrefixes();
        for (String subpackageName : packagePrefixes) {
            if (!PsiNameHelper.isSubpackageOf(subpackageName, packageName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInPackage(@NotNull PsiElement element, @NotNull PsiPackage aPackage) {
        PsiFile file;
        if (element == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(52);
        }
        if (aPackage == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(53);
        }
        if ((file = FileContextUtil.getContextFile(element)) instanceof JavaDummyHolder) {
            return ((JavaDummyHolder)file).isInPackage(aPackage);
        }
        if (file instanceof PsiJavaFile) {
            String packageName = ((PsiJavaFile)file).getPackageName();
            return packageName.equals(aPackage.getQualifiedName());
        }
        return false;
    }

    @Override
    public boolean arePackagesTheSame(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        PsiFile file2;
        PsiFile file1;
        if (element1 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(54);
        }
        if (element2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(55);
        }
        if (Comparing.equal(file1 = FileContextUtil.getContextFile(element1), file2 = FileContextUtil.getContextFile(element2))) {
            return true;
        }
        if (file1 instanceof JavaDummyHolder && file2 instanceof JavaDummyHolder) {
            return true;
        }
        if (file1 instanceof JavaDummyHolder || file2 instanceof JavaDummyHolder) {
            JavaDummyHolder dummyHolder = (JavaDummyHolder)(file1 instanceof JavaDummyHolder ? file1 : file2);
            PsiFile other = file1 instanceof JavaDummyHolder ? file2 : file1;
            return dummyHolder.isSamePackage(other);
        }
        if (!(file1 instanceof PsiClassOwner)) {
            return false;
        }
        if (!(file2 instanceof PsiClassOwner)) {
            return false;
        }
        String package1 = ((PsiClassOwner)file1).getPackageName();
        String package2 = ((PsiClassOwner)file2).getPackageName();
        return Objects.equals(package1, package2);
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(56);
        }
        return project;
    }

    @Override
    public boolean isConstantExpression(@NotNull PsiExpression expression) {
        if (expression == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(57);
        }
        IsConstantExpressionVisitor visitor = new IsConstantExpressionVisitor();
        expression.accept(visitor);
        return visitor.isConstant();
    }

    @Override
    @NotNull
    public PsiElementFactory getElementFactory() {
        PsiElementFactory psiElementFactory = PsiElementFactory.getInstance(this.myProject);
        if (psiElementFactory == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(58);
        }
        return psiElementFactory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 23: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 39: 
            case 44: 
            case 50: 
            case 56: 
            case 58: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 23: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 39: 
            case 44: 
            case 50: 
            case 56: 
            case 58: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 11: 
            case 14: 
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 12: 
            case 15: 
            case 18: 
            case 21: 
            case 26: 
            case 28: 
            case 35: 
            case 38: 
            case 43: 
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 23: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 39: 
            case 44: 
            case 50: 
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/JavaPsiFacadeImpl";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finders";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 34: 
            case 37: 
            case 42: 
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiPackage";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element1";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/JavaPsiFacadeImpl";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesInDumbMode";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesWithJvmFacade";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesWithoutJvmFacade";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstantEvaluationHelper";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "findModules";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "filteredFinders";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getParserFacade";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveHelper";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameHelper";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassNames";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageFiles";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubPackages";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doFindClass";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findClassesInDumbMode";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 23: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 39: 
            case 44: 
            case 50: 
            case 56: 
            case 58: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findClassesWithJvmFacade";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findClassesWithoutJvmFacade";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getFilterFromFinders";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findPackage";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findModule";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findModules";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getClassNames";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getClasses";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "filterClassesAndAppend";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getPackageFiles";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "processPackageDirectories";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getSubPackages";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "isPartOfPackagePrefix";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isInPackage";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "arePackagesTheSame";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isConstantExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 23: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 39: 
            case 44: 
            case 50: 
            case 56: 
            case 58: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

