/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.core.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.model.ModelBranch;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomModel;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.PomTransaction;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.event.PomModelListener;
import com.intellij.pom.impl.PomTransactionBase;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.wrappers.PsiEventWrapperAspect;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.ChangedPsiRangeUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.DiffLog;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiToDocumentSynchronizer;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.text.BlockSupport;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.lang.CompoundRuntimeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PomModelImpl
extends UserDataHolderBase
implements PomModel {
    private final Project myProject;
    private final TreeAspect myTreeAspect;
    private final PsiEventWrapperAspect myPsiAspect;
    private final Collection<PomModelListener> myListeners;
    private final ThreadLocal<Stack<PomTransaction>> myTransactionStack;
    private static volatile boolean allowPsiModification = true;

    public PomModelImpl(@NotNull Project project) {
        if (project == null) {
            PomModelImpl.$$$reportNull$$$0(0);
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myTransactionStack = ThreadLocal.withInitial(Stack::new);
        this.myProject = project;
        this.myTreeAspect = TreeAspect.getInstance(project);
        this.myPsiAspect = new PsiEventWrapperAspect(this.myTreeAspect);
    }

    @Override
    public <T extends PomModelAspect> T getModelAspect(@NotNull Class<T> aClass) {
        if (aClass == null) {
            PomModelImpl.$$$reportNull$$$0(1);
        }
        return (T)(this.myTreeAspect.getClass().equals(aClass) ? this.myTreeAspect : (this.myPsiAspect.getClass().equals(aClass) ? this.myPsiAspect : null));
    }

    @Override
    public void addModelListener(@NotNull PomModelListener listener) {
        if (listener == null) {
            PomModelImpl.$$$reportNull$$$0(2);
        }
        this.myListeners.add(listener);
    }

    @Override
    public void addModelListener(@NotNull PomModelListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            PomModelImpl.$$$reportNull$$$0(3);
        }
        if (parentDisposable == null) {
            PomModelImpl.$$$reportNull$$$0(4);
        }
        this.addModelListener(listener);
        Disposer.register(parentDisposable, () -> this.removeModelListener(listener));
    }

    @Override
    public void removeModelListener(@NotNull PomModelListener listener) {
        if (listener == null) {
            PomModelImpl.$$$reportNull$$$0(5);
        }
        this.myListeners.remove(listener);
    }

    @Override
    public void runTransaction(@NotNull PomTransaction transaction) throws IncorrectOperationException {
        if (transaction == null) {
            PomModelImpl.$$$reportNull$$$0(6);
        }
        if (!PomModelImpl.isAllowPsiModification()) {
            throw new IncorrectOperationException("Must not modify PSI inside save listener");
        }
        ProgressManager.getInstance().executeNonCancelableSection(() -> {
            PsiElement changeScope = transaction.getChangeScope();
            PsiFile containingFileByTree = PomModelImpl.getContainingFileByTree(changeScope);
            Document document = this.startTransaction(transaction, containingFileByTree);
            PomTransaction block = this.getBlockingTransaction(changeScope);
            if (block != null) {
                block.getAccumulatedEvent().beforeNestedTransaction();
            }
            ArrayList throwables = new ArrayList(0);
            DebugUtil.performPsiModification(null, () -> {
                PomModelEvent event;
                try {
                    Stack<PomTransaction> blockedAspects = this.myTransactionStack.get();
                    blockedAspects.push(transaction);
                    try {
                        transaction.run();
                        event = transaction.getAccumulatedEvent();
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throwables.add(e);
                        try {
                            if (containingFileByTree != null) {
                                this.commitTransaction(containingFileByTree, document);
                            }
                        }
                        catch (ProcessCanceledException e2) {
                            throw e2;
                        }
                        catch (Throwable t) {
                            throwables.add(t);
                        }
                        if (throwables.isEmpty()) return;
                        CompoundRuntimeException.throwIfNotEmpty(throwables);
                        return;
                    }
                    finally {
                        blockedAspects.pop();
                    }
                    if (block == null) {
                        if (event.getChangedAspects().contains(this.myTreeAspect)) {
                            this.updateDependentAspects(event);
                        }
                        Iterator<PomModelListener> iterator = this.myListeners.iterator();
                        block29: while (iterator.hasNext()) {
                            PomModelAspect modelAspect;
                            PomModelListener listener = iterator.next();
                            Set<PomModelAspect> changedAspects = event.getChangedAspects();
                            Iterator<PomModelAspect> iterator2 = changedAspects.iterator();
                            do {
                                if (!iterator2.hasNext()) continue block29;
                            } while (!listener.isAspectChangeInteresting(modelAspect = iterator2.next()));
                            listener.modelChanged(event);
                        }
                        return;
                    }
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throwables.add(t);
                    return;
                }
                block.getAccumulatedEvent().merge(event);
                return;
                finally {
                    try {
                        if (containingFileByTree != null) {
                            this.commitTransaction(containingFileByTree, document);
                        }
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        throwables.add(t);
                    }
                    if (!throwables.isEmpty()) {
                        CompoundRuntimeException.throwIfNotEmpty(throwables);
                    }
                }
            });
        });
    }

    protected void updateDependentAspects(PomModelEvent event) {
        this.myPsiAspect.update(event);
    }

    @Nullable
    private PomTransaction getBlockingTransaction(PsiElement changeScope) {
        Stack<PomTransaction> blockedAspects = this.myTransactionStack.get();
        ListIterator iterator = blockedAspects.listIterator(blockedAspects.size());
        while (iterator.hasPrevious()) {
            PomTransaction transaction = (PomTransaction)iterator.previous();
            if (!PsiTreeUtil.isAncestor(PomModelImpl.getContainingFileByTree(transaction.getChangeScope()), changeScope, false)) continue;
            return transaction;
        }
        return null;
    }

    private void commitTransaction(@NotNull PsiFile containingFileByTree, @Nullable Document document) {
        boolean isPhysicalPsiChange;
        if (containingFileByTree == null) {
            PomModelImpl.$$$reportNull$$$0(7);
        }
        PsiDocumentManagerBase manager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(this.myProject);
        PsiToDocumentSynchronizer synchronizer = manager.getSynchronizer();
        boolean isFromCommit = manager.isCommitInProgress();
        boolean bl = isPhysicalPsiChange = !isFromCommit && !synchronizer.isIgnorePsiEvents();
        if (isPhysicalPsiChange) {
            this.reparseParallelTrees(containingFileByTree, synchronizer);
        }
        boolean docSynced = false;
        if (document != null) {
            int oldLength = containingFileByTree.getTextLength();
            docSynced = synchronizer.commitTransaction(document);
            if (docSynced) {
                this.sendAfterChildrenChangedEvent(containingFileByTree, oldLength);
            }
        }
        if (isPhysicalPsiChange && docSynced) {
            containingFileByTree.getViewProvider().contentsSynchronized();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reparseParallelTrees(PsiFile changedFile, PsiToDocumentSynchronizer synchronizer) {
        List<PsiFile> allFiles = changedFile.getViewProvider().getAllFiles();
        if (allFiles.size() <= 1) {
            return;
        }
        CharSequence newText = changedFile.getNode().getChars();
        for (PsiFile file : allFiles) {
            Runnable changeAction;
            FileElement fileElement = file == changedFile ? null : ((PsiFileImpl)file).getTreeElement();
            Runnable runnable = changeAction = fileElement == null ? null : this.reparseFile(file, fileElement, newText);
            if (changeAction == null) continue;
            synchronizer.setIgnorePsiEvents(true);
            try {
                CodeStyleManager.getInstance(file.getProject()).performActionWithFormatterDisabled(changeAction);
            }
            finally {
                synchronizer.setIgnorePsiEvents(false);
            }
        }
    }

    @Nullable
    @ApiStatus.Internal
    public Runnable reparseFile(final @NotNull PsiFile file, @NotNull FileElement treeElement, @NotNull CharSequence newText) {
        TextRange changedPsiRange;
        if (file == null) {
            PomModelImpl.$$$reportNull$$$0(8);
        }
        if (treeElement == null) {
            PomModelImpl.$$$reportNull$$$0(9);
        }
        if (newText == null) {
            PomModelImpl.$$$reportNull$$$0(10);
        }
        if ((changedPsiRange = ChangedPsiRangeUtil.getChangedPsiRange(file, treeElement, newText)) == null) {
            return null;
        }
        ProgressIndicator indicator = EmptyProgressIndicator.notNullize(ProgressIndicatorProvider.getGlobalProgressIndicator());
        final DiffLog log = BlockSupport.getInstance(this.myProject).reparseRange(file, treeElement, changedPsiRange, newText, indicator, treeElement.getText());
        return () -> this.runTransaction(new PomTransactionBase(file){

            @Override
            @NotNull
            public PomModelEvent runInner() throws IncorrectOperationException {
                return new PomModelEvent(PomModelImpl.this, log.performActualPsiChange(file));
            }
        });
    }

    @Nullable
    @Contract(value="_,null -> null")
    private Document startTransaction(@NotNull PomTransaction transaction, @Nullable PsiFile psiFile) {
        Document document;
        VirtualFile vFile;
        if (transaction == null) {
            PomModelImpl.$$$reportNull$$$0(11);
        }
        PsiDocumentManagerBase manager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(this.myProject);
        PsiToDocumentSynchronizer synchronizer = manager.getSynchronizer();
        PsiElement changeScope = transaction.getChangeScope();
        if (psiFile != null && !(psiFile instanceof DummyHolder) && !manager.isCommitInProgress()) {
            PsiUtilCore.ensureValid(psiFile);
        }
        boolean physical = changeScope.isPhysical();
        if (synchronizer.toProcessPsiEvent()) {
            if (this.isDocumentUncommitted(psiFile)) {
                throw new IllegalStateException("Attempt to modify PSI for non-committed Document!");
            }
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            if (physical && !commandProcessor.isUndoTransparentActionInProgress() && commandProcessor.getCurrentCommand() == null) {
                throw new IncorrectOperationException("Must not change PSI outside command or undo-transparent action. See com.intellij.openapi.command.WriteCommandAction or com.intellij.openapi.command.CommandProcessor");
            }
        }
        VirtualFile virtualFile = vFile = psiFile == null ? null : psiFile.getViewProvider().getVirtualFile();
        if (psiFile != null) {
            ((SmartPointerManagerImpl)SmartPointerManager.getInstance(this.myProject)).fastenBelts(vFile);
            if (psiFile instanceof PsiFileImpl) {
                ((PsiFileImpl)psiFile).beforeAstChange();
            }
        }
        this.sendBeforeChildrenChangeEvent(changeScope);
        Document document2 = psiFile == null || psiFile instanceof DummyHolder ? null : (document = physical || ModelBranch.getPsiBranch(psiFile) != null ? FileDocumentManager.getInstance().getDocument(vFile) : FileDocumentManager.getInstance().getCachedDocument(vFile));
        if (document != null) {
            synchronizer.startTransaction(this.myProject, document, psiFile);
        }
        return document;
    }

    private boolean isDocumentUncommitted(@Nullable PsiFile file) {
        if (file == null) {
            return false;
        }
        PsiDocumentManager manager = PsiDocumentManager.getInstance(this.myProject);
        Document cachedDocument = manager.getCachedDocument(file);
        return cachedDocument != null && manager.isUncommited(cachedDocument);
    }

    @Nullable
    private static PsiFile getContainingFileByTree(@NotNull PsiElement changeScope) {
        PsiFile psiFile;
        ASTNode node;
        if (changeScope == null) {
            PomModelImpl.$$$reportNull$$$0(12);
        }
        if ((node = changeScope.getNode()) == null) {
            psiFile = changeScope.getContainingFile();
        } else {
            FileASTNode fileElement = TreeUtil.getFileElement(node);
            if (fileElement == null) {
                return null;
            }
            psiFile = (PsiFile)fileElement.getPsi();
        }
        return psiFile.getNode() != null ? psiFile : null;
    }

    public static <T extends Throwable> void guardPsiModificationsIn(@NotNull ThrowableRunnable<T> runnable) throws T {
        if (runnable == null) {
            PomModelImpl.$$$reportNull$$$0(13);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        boolean old = allowPsiModification;
        try {
            allowPsiModification = false;
            runnable.run();
        }
        finally {
            allowPsiModification = old;
        }
    }

    public static boolean isAllowPsiModification() {
        return allowPsiModification;
    }

    private void sendBeforeChildrenChangeEvent(@NotNull PsiElement scope) {
        if (scope == null) {
            PomModelImpl.$$$reportNull$$$0(14);
        }
        if (!PomModelImpl.shouldFirePhysicalPsiEvents(scope)) {
            this.getPsiManager().beforeChange(false);
            return;
        }
        PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(this.getPsiManager());
        event.setParent(scope);
        event.setFile(scope.getContainingFile());
        TextRange range = scope.getTextRange();
        event.setOffset(range == null ? 0 : range.getStartOffset());
        event.setOldLength(scope.getTextLength());
        event.setGenericChange(true);
        this.getPsiManager().beforeChildrenChange(event);
    }

    @ApiStatus.Internal
    public static boolean shouldFirePhysicalPsiEvents(@NotNull PsiElement scope) {
        if (scope == null) {
            PomModelImpl.$$$reportNull$$$0(15);
        }
        return scope.isPhysical() && ModelBranch.getPsiBranch(scope) == null;
    }

    private void sendAfterChildrenChangedEvent(@NotNull PsiFile scope, int oldLength) {
        if (scope == null) {
            PomModelImpl.$$$reportNull$$$0(16);
        }
        if (!PomModelImpl.shouldFirePhysicalPsiEvents(scope)) {
            this.getPsiManager().afterChange(false);
            return;
        }
        PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(this.getPsiManager());
        event.setParent(scope);
        event.setFile(scope);
        event.setOffset(0);
        event.setOldLength(oldLength);
        event.setGenericChange(true);
        this.getPsiManager().childrenChanged(event);
    }

    @NotNull
    private PsiManagerImpl getPsiManager() {
        PsiManagerImpl psiManagerImpl = (PsiManagerImpl)PsiManager.getInstance(this.myProject);
        if (psiManagerImpl == null) {
            PomModelImpl.$$$reportNull$$$0(17);
        }
        return psiManagerImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transaction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFileByTree";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newText";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeScope";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/pom/core/impl/PomModelImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/pom/core/impl/PomModelImpl";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getModelAspect";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addModelListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeModelListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runTransaction";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "commitTransaction";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reparseFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "startTransaction";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFileByTree";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "guardPsiModificationsIn";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "sendBeforeChildrenChangeEvent";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "shouldFirePhysicalPsiEvents";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "sendAfterChildrenChangedEvent";
                break;
            }
            case 17: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

