/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.util.plugins;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.platform.util.plugins.DataLoader;
import com.intellij.platform.util.plugins.PathResolver;
import com.intellij.platform.util.plugins.XIncludeResolvingContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000T\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0001H\u0002\u001a\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u00012\b\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rH\u0002\u001a<\u0010\u0016\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\rH\u0002\u001a2\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0007\u001aV\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\"2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u001a\u0010$\u001a\u0016\u0012\u0004\u0012\u00020\r\u0018\u00010%j\n\u0012\u0004\u0012\u00020\r\u0018\u0001`&H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\b\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"BASE", "", "HREF", "INCLUDE", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG$annotations", "()V", "PARSE", "XML", "XPOINTER", "extractNeededChildren", "Lorg/jdom/Element;", "remoteElement", "xpointer", "getChildBase", "base", "relativePath", "isIncludeElement", "", "element", "loadXIncludeReference", "context", "Lcom/intellij/platform/util/plugins/XIncludeResolvingContext;", "pathResolver", "Lcom/intellij/platform/util/plugins/PathResolver;", "dataLoader", "Lcom/intellij/platform/util/plugins/DataLoader;", "referrerElement", "resolveNonXIncludeElement", "", "original", "resolveXIncludeElement", "", "linkElement", "result", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "intellij.platform.util"})
@JvmName(name="PathBasedJdomXIncluder")
public final class PathBasedJdomXIncluder {
    private static final String INCLUDE = "include";
    private static final String HREF = "href";
    private static final String BASE = "base";
    private static final String PARSE = "parse";
    private static final String XML = "xml";
    private static final String XPOINTER = "xpointer";
    private static final Logger LOG;

    private static /* synthetic */ void getLOG$annotations() {
    }

    private static final List<Element> resolveXIncludeElement(XIncludeResolvingContext context2, PathResolver pathResolver, DataLoader dataLoader2, Element linkElement, String base, ArrayList<Element> result) throws JDOMException {
        String xpointer;
        String string = linkElement.getAttributeValue(HREF);
        if (string == null) {
            throw (Throwable)new RuntimeException("Missing href attribute");
        }
        String relativePath = string;
        String string2 = linkElement.getAttributeValue(PARSE);
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            LOG.assertTrue(Intrinsics.areEqual((Object)it, (Object)XML), it + " is not a legal value for the parse attribute");
        }
        Element remoteParsed = PathBasedJdomXIncluder.loadXIncludeReference(context2, pathResolver, dataLoader2, base, relativePath, linkElement);
        if (remoteParsed != null && (xpointer = linkElement.getAttributeValue(XPOINTER)) != null) {
            remoteParsed = PathBasedJdomXIncluder.extractNeededChildren(remoteParsed, xpointer);
        }
        if (remoteParsed == null) {
            ArrayList<Element> arrayList = result;
            return arrayList != null ? (List)arrayList : CollectionsKt.emptyList();
        }
        ArrayList<Element> newResult = result;
        if (newResult == null) {
            newResult = new ArrayList(remoteParsed.getContentSize());
        } else {
            newResult.ensureCapacity(newResult.size() + remoteParsed.getContentSize());
        }
        String childBase = PathBasedJdomXIncluder.getChildBase(base, relativePath);
        Iterator<Content> iterator = remoteParsed.getContent().iterator();
        while (iterator.hasNext()) {
            Element content;
            Content content2 = iterator.next();
            if (!(content2 instanceof Element)) {
                content2 = null;
            }
            if ((Element)content2 == null) {
                continue;
            }
            iterator.remove();
            if (PathBasedJdomXIncluder.isIncludeElement(content)) {
                PathBasedJdomXIncluder.resolveXIncludeElement(context2, pathResolver, dataLoader2, content, childBase, newResult);
                continue;
            }
            PathBasedJdomXIncluder.resolveNonXIncludeElement(context2, pathResolver, dataLoader2, content, childBase);
            newResult.add(content);
        }
        return newResult;
    }

    private static final Element loadXIncludeReference(XIncludeResolvingContext context2, PathResolver pathResolver, DataLoader dataLoader2, String base, String relativePath, Element referrerElement) throws JDOMException {
        Object it;
        boolean bl;
        boolean bl2;
        Object object;
        Element root = null;
        IOException readError = null;
        try {
            String string = referrerElement.getAttributeValue(BASE, Namespace.XML_NAMESPACE);
            if (string != null) {
                object = string;
                bl2 = false;
                bl = false;
                it = object;
                boolean bl3 = false;
                LOG.error("Do not use xml:base attribute: " + (String)it);
            }
            root = pathResolver.loadXIncludeReference(dataLoader2, base, relativePath, context2.getXmlFactory());
        }
        catch (IOException e) {
            readError = e;
            root = null;
        }
        if (root == null) {
            Element element = referrerElement.getChild("fallback", referrerElement.getNamespace());
            if (element != null) {
                object = element;
                bl2 = false;
                bl = false;
                it = object;
                boolean bl4 = false;
                return null;
            }
            if (context2.getIgnoreMissingInclude()) {
                LOG.info(relativePath + " include ignored (dataLoader=" + dataLoader2 + ')', readError);
                return null;
            }
            throw (Throwable)new RuntimeException("Cannot resolve " + relativePath + " (dataLoader=" + dataLoader2 + ')', readError);
        }
        if (PathBasedJdomXIncluder.isIncludeElement(root)) {
            throw (Throwable)new UnsupportedOperationException("root tag of remote cannot be include");
        }
        PathBasedJdomXIncluder.resolveNonXIncludeElement(context2, pathResolver, dataLoader2, root, PathBasedJdomXIncluder.getChildBase(base, relativePath));
        return root;
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    public static final void resolveNonXIncludeElement(@NotNull XIncludeResolvingContext context2, @NotNull PathResolver pathResolver, @NotNull DataLoader dataLoader2, @NotNull Element original, @Nullable String base) throws JDOMException {
        List<Content> contentList;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pathResolver, (String)"pathResolver");
        Intrinsics.checkNotNullParameter((Object)dataLoader2, (String)"dataLoader");
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        List<Content> list = contentList = original.getContent();
        Intrinsics.checkNotNullExpressionValue(list, (String)"contentList");
        int n = ((Collection)list).size();
        --n;
        boolean bl = false;
        while (n >= 0) {
            Element content;
            void i;
            Content content2 = contentList.get((int)i);
            if (!(content2 instanceof Element)) {
                content2 = null;
            }
            if ((Element)content2 == null) {
            } else if (PathBasedJdomXIncluder.isIncludeElement(content)) {
                original.setContent((int)i, (Collection<? extends Content>)PathBasedJdomXIncluder.resolveXIncludeElement(context2, pathResolver, dataLoader2, content, base, null));
            } else {
                PathBasedJdomXIncluder.resolveNonXIncludeElement(context2, pathResolver, dataLoader2, content, base);
            }
            --i;
        }
    }

    private static final boolean isIncludeElement(Element element) {
        return Intrinsics.areEqual((Object)element.getName(), (Object)INCLUDE) && Intrinsics.areEqual((Object)element.getNamespace(), (Object)JDOMUtil.XINCLUDE_NAMESPACE);
    }

    private static final String getChildBase(String base, String relativePath) {
        int end = StringsKt.lastIndexOf$default((CharSequence)relativePath, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (end <= 0 || StringsKt.startsWith$default((String)relativePath, (String)"/META-INF/", (boolean)false, (int)2, null)) {
            return base;
        }
        String string = relativePath;
        int n = 0;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, end);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String childBase = string3;
        return base == null ? childBase : base + '/' + childBase;
    }

    private static final Element extractNeededChildren(Element remoteElement, String xpointer) {
        String subTagName;
        Matcher matcher = JDOMUtil.XPOINTER_PATTERN.matcher(xpointer);
        if (!matcher.matches()) {
            throw (Throwable)new RuntimeException("Unsupported XPointer: " + xpointer);
        }
        String pointer = matcher.group(1);
        if (!(matcher = JDOMUtil.CHILDREN_PATTERN.matcher(pointer)).matches()) {
            throw (Throwable)new RuntimeException("Unsupported pointer: " + pointer);
        }
        if (Intrinsics.areEqual((Object)remoteElement.getName(), (Object)matcher.group(1)) ^ true) {
            return null;
        }
        String string = matcher.group(2);
        if (string == null) {
            return remoteElement;
        }
        String string2 = subTagName = string;
        int n = 1;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        Element element = remoteElement.getChild(string4);
        Intrinsics.checkNotNull((Object)element);
        return element;
    }

    static {
        Logger logger = Logger.getInstance("#com.intellij.ide.plugins.PluginManager");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"#com\u2026e.plugins.PluginManager\")");
        LOG = logger;
    }
}

