/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.TreeElementPattern;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class VirtualFilePattern
extends TreeElementPattern<VirtualFile, VirtualFile, VirtualFilePattern> {
    public VirtualFilePattern() {
        super(VirtualFile.class);
    }

    public VirtualFilePattern ofType(FileType type) {
        final String fileTypeName = type.getName();
        return (VirtualFilePattern)this.with(new PatternCondition<VirtualFile>("ofType"){

            @Override
            public boolean accepts(@NotNull VirtualFile virtualFile, ProcessingContext context2) {
                if (virtualFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                return virtualFile.getFileType().getName().equals(fileTypeName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/patterns/VirtualFilePattern$1", "accepts"));
            }
        });
    }

    public VirtualFilePattern withName(String name) {
        return this.withName((ElementPattern<String>)StandardPatterns.string().equalTo(name));
    }

    public VirtualFilePattern withExtension(final String ... alternatives) {
        if (alternatives == null) {
            VirtualFilePattern.$$$reportNull$$$0(0);
        }
        return (VirtualFilePattern)this.with(new PatternCondition<VirtualFile>("withExtension"){

            @Override
            public boolean accepts(@NotNull VirtualFile virtualFile, ProcessingContext context2) {
                if (virtualFile == null) {
                    2.$$$reportNull$$$0(0);
                }
                String extension = virtualFile.getExtension();
                for (String alternative : alternatives) {
                    if (!alternative.equals(extension)) continue;
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/patterns/VirtualFilePattern$2", "accepts"));
            }
        });
    }

    public VirtualFilePattern withExtension(final @NonNls @NotNull String extension) {
        if (extension == null) {
            VirtualFilePattern.$$$reportNull$$$0(1);
        }
        return (VirtualFilePattern)this.with(new PatternCondition<VirtualFile>("withExtension"){

            @Override
            public boolean accepts(@NotNull VirtualFile virtualFile, ProcessingContext context2) {
                if (virtualFile == null) {
                    3.$$$reportNull$$$0(0);
                }
                return extension.equals(virtualFile.getExtension());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/patterns/VirtualFilePattern$3", "accepts"));
            }
        });
    }

    public VirtualFilePattern withName(final ElementPattern<String> namePattern) {
        return (VirtualFilePattern)this.with(new PatternCondition<VirtualFile>("withName"){

            @Override
            public boolean accepts(@NotNull VirtualFile virtualFile, ProcessingContext context2) {
                if (virtualFile == null) {
                    4.$$$reportNull$$$0(0);
                }
                return namePattern.accepts(virtualFile.getName(), context2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/patterns/VirtualFilePattern$4", "accepts"));
            }
        });
    }

    public VirtualFilePattern withPath(final ElementPattern<String> pathPattern) {
        return (VirtualFilePattern)this.with(new PatternCondition<VirtualFile>("withName"){

            @Override
            public boolean accepts(@NotNull VirtualFile virtualFile, ProcessingContext context2) {
                if (virtualFile == null) {
                    5.$$$reportNull$$$0(0);
                }
                return pathPattern.accepts(virtualFile.getPath(), context2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/patterns/VirtualFilePattern$5", "accepts"));
            }
        });
    }

    @Override
    protected VirtualFile getParent(@NotNull VirtualFile t) {
        if (t == null) {
            VirtualFilePattern.$$$reportNull$$$0(2);
        }
        return t.getParent();
    }

    protected VirtualFile[] getChildren(@NotNull VirtualFile file) {
        if (file == null) {
            VirtualFilePattern.$$$reportNull$$$0(3);
        }
        return file.getChildren();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alternatives";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/patterns/VirtualFilePattern";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "withExtension";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getParent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildren";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

