/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StringPattern;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class PsiFilePattern<T extends PsiFile, Self extends PsiFilePattern<T, Self>>
extends PsiElementPattern<T, Self> {
    protected PsiFilePattern(@NotNull InitialPatternCondition<T> condition) {
        if (condition == null) {
            PsiFilePattern.$$$reportNull$$$0(0);
        }
        super(condition);
    }

    protected PsiFilePattern(Class<T> aClass) {
        super(aClass);
    }

    public Self withParentDirectoryName(final StringPattern namePattern) {
        return (Self)((PsiFilePattern)this.with(new PatternCondition<T>("withParentDirectoryName"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context2) {
                PsiDirectory directory;
                if (t == null) {
                    1.$$$reportNull$$$0(0);
                }
                return (directory = t.getContainingDirectory()) != null && namePattern.accepts(directory.getName(), context2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiFilePattern$1", "accepts"));
            }
        }));
    }

    public Self withOriginalFile(final ElementPattern<? extends T> filePattern) {
        return (Self)((PsiFilePattern)this.with(new PatternCondition<T>("withOriginalFile"){

            @Override
            public boolean accepts(@NotNull T file, ProcessingContext context2) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                return filePattern.accepts(file.getOriginalFile());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/patterns/PsiFilePattern$2", "accepts"));
            }
        }));
    }

    public Self withVirtualFile(final ElementPattern<? extends VirtualFile> vFilePattern) {
        return (Self)((PsiFilePattern)this.with(new PatternCondition<T>("withVirtualFile"){

            @Override
            public boolean accepts(@NotNull T file, ProcessingContext context2) {
                if (file == null) {
                    3.$$$reportNull$$$0(0);
                }
                return vFilePattern.accepts(file.getVirtualFile(), context2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/patterns/PsiFilePattern$3", "accepts"));
            }
        }));
    }

    public Self withFileType(final ElementPattern<? extends FileType> fileTypePattern) {
        return (Self)((PsiFilePattern)this.with(new PatternCondition<T>("withFileType"){

            @Override
            public boolean accepts(@NotNull T file, ProcessingContext context2) {
                if (file == null) {
                    4.$$$reportNull$$$0(0);
                }
                return fileTypePattern.accepts(file.getFileType(), context2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/patterns/PsiFilePattern$4", "accepts"));
            }
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/patterns/PsiFilePattern", "<init>"));
    }

    public static class Capture<T extends PsiFile>
    extends PsiFilePattern<T, Capture<T>> {
        protected Capture(Class<T> aClass) {
            super(aClass);
        }

        public Capture(@NotNull InitialPatternCondition<T> condition) {
            if (condition == null) {
                Capture.$$$reportNull$$$0(0);
            }
            super(condition);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/patterns/PsiFilePattern$Capture", "<init>"));
        }
    }
}

