/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.impl.ZipEntryMap;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.ResourceHandle;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class ZipHandlerBase
extends ArchiveHandler {
    private static final Logger LOG = Logger.getInstance(ZipHandlerBase.class);
    @ApiStatus.Internal
    public static volatile boolean USE_CRC_INSTEAD_OF_TIMESTAMP = ZipHandlerBase.getUseCrcInsteadOfTimestampPropertyValue();

    private static boolean getUseCrcInsteadOfTimestampPropertyValue() {
        return SystemProperties.is("zip.handler.uses.crc.instead.of.timestamp");
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public static void forceUseCrcInsteadOfTimestamp() {
        USE_CRC_INSTEAD_OF_TIMESTAMP = true;
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public static void resetUseCrcInsteadOfTimestamp() {
        USE_CRC_INSTEAD_OF_TIMESTAMP = ZipHandlerBase.getUseCrcInsteadOfTimestampPropertyValue();
    }

    public ZipHandlerBase(@NotNull String path) {
        if (path == null) {
            ZipHandlerBase.$$$reportNull$$$0(0);
        }
        super(path);
    }

    @Override
    @NotNull
    protected Map<String, ArchiveHandler.EntryInfo> createEntriesMap() throws IOException {
        ResourceHandle<ZipFile> zipRef = this.acquireZipHandle();
        Map<String, ArchiveHandler.EntryInfo> map = this.buildEntryMapForZipFile(zipRef.get());
        Map<String, ArchiveHandler.EntryInfo> map2 = map;
        if (map2 == null) {
            ZipHandlerBase.$$$reportNull$$$0(1);
        }
        return map2;
        finally {
            if (zipRef != null) {
                zipRef.close();
            }
        }
    }

    @NotNull
    protected Map<String, ArchiveHandler.EntryInfo> buildEntryMapForZipFile(@NotNull ZipFile zip) {
        if (zip == null) {
            ZipHandlerBase.$$$reportNull$$$0(2);
        }
        ZipEntryMap map = new ZipEntryMap(zip.size());
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry ze = entries.nextElement();
            this.processEntry(map, LOG, ze.getName(), ze.isDirectory() ? null : (parent, name) -> {
                long fileStamp = USE_CRC_INSTEAD_OF_TIMESTAMP ? ze.getCrc() : this.getEntryFileStamp();
                return new ArchiveHandler.EntryInfo((CharSequence)name, false, ze.getSize(), fileStamp, (ArchiveHandler.EntryInfo)parent);
            });
        }
        ZipEntryMap zipEntryMap = map;
        if (zipEntryMap == null) {
            ZipHandlerBase.$$$reportNull$$$0(3);
        }
        return zipEntryMap;
    }

    public long getEntryCrc(@NotNull String relativePath) throws IOException {
        if (relativePath == null) {
            ZipHandlerBase.$$$reportNull$$$0(4);
        }
        try (ResourceHandle<ZipFile> zipRef = this.acquireZipHandle();){
            ZipFile zip = zipRef.get();
            ZipEntry entry = zip.getEntry(relativePath);
            if (entry != null) {
                long l = entry.getCrc();
                return l;
            }
        }
        throw new FileNotFoundException(this.getFile() + "!/" + relativePath);
    }

    @Override
    public byte @NotNull [] contentsToByteArray(@NotNull String relativePath) throws IOException {
        block15: {
            byte[] byArray;
            InputStream stream;
            ResourceHandle<ZipFile> zipRef;
            block16: {
                if (relativePath == null) {
                    ZipHandlerBase.$$$reportNull$$$0(5);
                }
                zipRef = this.acquireZipHandle();
                ZipFile zip = zipRef.get();
                ZipEntry entry = zip.getEntry(relativePath);
                if (entry == null) break block15;
                long length = entry.getSize();
                if (FileUtilRt.isTooLarge(length)) {
                    throw new FileTooBigException(this.getFile() + "!/" + relativePath);
                }
                stream = zip.getInputStream(entry);
                if (stream == null) break block15;
                byArray = FileUtil.loadBytes(stream, (int)length);
                if (byArray != null) break block16;
                ZipHandlerBase.$$$reportNull$$$0(6);
            }
            return byArray;
            {
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            finally {
                if (zipRef != null) {
                    zipRef.close();
                }
            }
        }
        throw new FileNotFoundException(this.getFile() + "!/" + relativePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public InputStream getInputStream(@NotNull String relativePath) throws IOException {
        block12: {
            InputStream stream;
            if (relativePath == null) {
                ZipHandlerBase.$$$reportNull$$$0(7);
            }
            boolean release = true;
            ResourceHandle<ZipFile> zipRef = this.acquireZipHandle();
            ZipFile zip = zipRef.get();
            ZipEntry entry = zip.getEntry(relativePath);
            if (entry == null || (stream = zip.getInputStream(entry)) == null) break block12;
            long length = entry.getSize();
            if (!FileUtilRt.isTooLarge(length)) {
                BufferExposingByteArrayInputStream bufferExposingByteArrayInputStream = new BufferExposingByteArrayInputStream(FileUtil.loadBytes(stream, (int)length));
                BufferExposingByteArrayInputStream bufferExposingByteArrayInputStream2 = bufferExposingByteArrayInputStream;
                if (bufferExposingByteArrayInputStream2 == null) {
                    ZipHandlerBase.$$$reportNull$$$0(8);
                }
                return bufferExposingByteArrayInputStream2;
                finally {
                    stream.close();
                }
            }
            release = false;
            InputStreamWrapper inputStreamWrapper = new InputStreamWrapper(stream, zipRef);
            InputStreamWrapper inputStreamWrapper2 = inputStreamWrapper;
            if (inputStreamWrapper2 == null) {
                ZipHandlerBase.$$$reportNull$$$0(9);
            }
            return inputStreamWrapper2;
            finally {
                if (release) {
                    zipRef.close();
                }
            }
        }
        throw new FileNotFoundException(this.getFile() + "!/" + relativePath);
    }

    protected abstract long getEntryFileStamp();

    @NotNull
    protected abstract ResourceHandle<ZipFile> acquireZipHandle() throws IOException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/ZipHandlerBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zip";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/ZipHandlerBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createEntriesMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildEntryMapForZipFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildEntryMapForZipFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getEntryCrc";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "contentsToByteArray";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InputStreamWrapper
    extends InputStream {
        private final InputStream myStream;
        private final ResourceHandle<ZipFile> myZipRef;
        private final AtomicBoolean closed = new AtomicBoolean(false);

        InputStreamWrapper(InputStream stream, ResourceHandle<ZipFile> zipRef) {
            this.myStream = stream;
            this.myZipRef = zipRef;
        }

        @Override
        public int read() throws IOException {
            return this.myStream.read();
        }

        @Override
        public int read(byte @NotNull [] b, int off, int len) throws IOException {
            if (b == null) {
                InputStreamWrapper.$$$reportNull$$$0(0);
            }
            return this.myStream.read(b, off, len);
        }

        @Override
        public int available() throws IOException {
            return this.myStream.available();
        }

        @Override
        public void close() throws IOException {
            if (!this.closed.getAndSet(true)) {
                try {
                    this.myStream.close();
                }
                finally {
                    this.myZipRef.close();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/openapi/vfs/impl/ZipHandlerBase$InputStreamWrapper", "read"));
        }
    }
}

