/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.openapi.util.text.Pluralizer;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.text.CharArrayCharSequence;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Strings {
    private static final List<String> REPLACES_REFS = Arrays.asList("&lt;", "&gt;", "&amp;", "&#39;", "&quot;");
    private static final List<String> REPLACES_DISP = Arrays.asList("<", ">", "&", "'", "\"");
    public static final CharSequence EMPTY_CHAR_SEQUENCE = new CharArrayCharSequence(ArrayUtilRt.EMPTY_CHAR_ARRAY);

    public static boolean isAscii(char ch) {
        return ch < '\u0080';
    }

    @Contract(pure=true)
    public static int compare(char c1, char c2, boolean ignoreCase) {
        char u2;
        int d = c1 - c2;
        if (d == 0 || !ignoreCase) {
            return d;
        }
        char u1 = StringUtilRt.toUpperCase(c1);
        d = u1 - (u2 = StringUtilRt.toUpperCase(c2));
        if (d != 0) {
            d = StringUtilRt.toLowerCase(u1) - StringUtilRt.toLowerCase(u2);
        }
        return d;
    }

    @Contract(pure=true)
    public static boolean charsMatch(char c1, char c2, boolean ignoreCase) {
        return Strings.compare(c1, c2, ignoreCase) == 0;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String toLowerCase(@Nullable String str) {
        return str == null ? null : str.toLowerCase(Locale.ENGLISH);
    }

    @Contract(pure=true)
    public static char toLowerCase(char a) {
        return StringUtilRt.toLowerCase(a);
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String toUpperCase(String s) {
        return s == null ? null : s.toUpperCase(Locale.ENGLISH);
    }

    @Contract(pure=true)
    public static char toUpperCase(char a) {
        return StringUtilRt.toUpperCase(a);
    }

    @Contract(pure=true)
    public static boolean contains(@NotNull CharSequence sequence, @NotNull CharSequence infix) {
        if (sequence == null) {
            Strings.$$$reportNull$$$0(0);
        }
        if (infix == null) {
            Strings.$$$reportNull$$$0(1);
        }
        return Strings.indexOf(sequence, infix) >= 0;
    }

    @Contract(pure=true)
    public static boolean contains(@NotNull CharSequence s, int start, int end, char c) {
        if (s == null) {
            Strings.$$$reportNull$$$0(2);
        }
        return Strings.indexOf(s, c, start, end) >= 0;
    }

    @Contract(pure=true)
    public static boolean containsChar(@NotNull String value, char ch) {
        if (value == null) {
            Strings.$$$reportNull$$$0(3);
        }
        return value.indexOf(ch) >= 0;
    }

    @Contract(pure=true)
    public static boolean containsAnyChar(@NotNull String value, @NotNull String chars) {
        if (value == null) {
            Strings.$$$reportNull$$$0(4);
        }
        if (chars == null) {
            Strings.$$$reportNull$$$0(5);
        }
        return chars.length() > value.length() ? Strings.containsAnyChar(value, chars, 0, value.length()) : Strings.containsAnyChar(chars, value, 0, chars.length());
    }

    @Contract(pure=true)
    public static boolean containsAnyChar(@NotNull String value, @NotNull String chars, int start, int end) {
        if (value == null) {
            Strings.$$$reportNull$$$0(6);
        }
        if (chars == null) {
            Strings.$$$reportNull$$$0(7);
        }
        for (int i = start; i < end; ++i) {
            if (chars.indexOf(value.charAt(i)) < 0) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c) {
        if (s == null) {
            Strings.$$$reportNull$$$0(8);
        }
        return Strings.indexOf(s, c, 0, s.length());
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start) {
        if (s == null) {
            Strings.$$$reportNull$$$0(9);
        }
        return Strings.indexOf(s, c, start, s.length());
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start, int end) {
        if (s == null) {
            Strings.$$$reportNull$$$0(10);
        }
        end = Math.min(end, s.length());
        for (int i = Math.max(start, 0); i < end; ++i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence, @NotNull CharSequence infix) {
        if (sequence == null) {
            Strings.$$$reportNull$$$0(11);
        }
        if (infix == null) {
            Strings.$$$reportNull$$$0(12);
        }
        return Strings.indexOf(sequence, infix, 0);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence, @NotNull CharSequence infix, int start) {
        if (sequence == null) {
            Strings.$$$reportNull$$$0(13);
        }
        if (infix == null) {
            Strings.$$$reportNull$$$0(14);
        }
        return Strings.indexOf(sequence, infix, start, sequence.length());
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence, @NotNull CharSequence infix, int start, int end) {
        if (sequence == null) {
            Strings.$$$reportNull$$$0(15);
        }
        if (infix == null) {
            Strings.$$$reportNull$$$0(16);
        }
        for (int i = start; i <= end - infix.length(); ++i) {
            if (!Strings.startsWith(sequence, i, infix)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start, int end, boolean caseSensitive) {
        if (s == null) {
            Strings.$$$reportNull$$$0(17);
        }
        end = Math.min(end, s.length());
        for (int i = Math.max(start, 0); i < end; ++i) {
            if (!Strings.charsMatch(s.charAt(i), c, !caseSensitive)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(char @NotNull [] s, char c, int start, int end, boolean caseSensitive) {
        if (s == null) {
            Strings.$$$reportNull$$$0(18);
        }
        end = Math.min(end, s.length);
        for (int i = Math.max(start, 0); i < end; ++i) {
            boolean ignoreCase;
            boolean bl = ignoreCase = !caseSensitive;
            if (!Strings.charsMatch(s[i], c, ignoreCase)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull String s, @NotNull String chars) {
        if (s == null) {
            Strings.$$$reportNull$$$0(19);
        }
        if (chars == null) {
            Strings.$$$reportNull$$$0(20);
        }
        return Strings.indexOfAny(s, chars, 0, s.length());
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull CharSequence s, @NotNull String chars) {
        if (s == null) {
            Strings.$$$reportNull$$$0(21);
        }
        if (chars == null) {
            Strings.$$$reportNull$$$0(22);
        }
        return Strings.indexOfAny(s, chars, 0, s.length());
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull String s, @NotNull String chars, int start, int end) {
        if (s == null) {
            Strings.$$$reportNull$$$0(23);
        }
        if (chars == null) {
            Strings.$$$reportNull$$$0(24);
        }
        return Strings.indexOfAny((CharSequence)s, chars, start, end);
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull CharSequence s, @NotNull String chars, int start, int end) {
        if (s == null) {
            Strings.$$$reportNull$$$0(25);
        }
        if (chars == null) {
            Strings.$$$reportNull$$$0(26);
        }
        if (chars.isEmpty()) {
            return -1;
        }
        end = Math.min(end, s.length());
        for (int i = Math.max(start, 0); i < end; ++i) {
            if (!Strings.containsChar(chars, s.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull String where, @NotNull String what, int fromIndex) {
        if (where == null) {
            Strings.$$$reportNull$$$0(27);
        }
        if (what == null) {
            Strings.$$$reportNull$$$0(28);
        }
        return Strings.indexOfIgnoreCase((CharSequence)where, (CharSequence)what, fromIndex);
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull CharSequence where, @NotNull CharSequence what, int fromIndex) {
        if (where == null) {
            Strings.$$$reportNull$$$0(29);
        }
        if (what == null) {
            Strings.$$$reportNull$$$0(30);
        }
        int targetCount = what.length();
        int sourceCount = where.length();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = what.charAt(0);
        int max = sourceCount - targetCount;
        for (int i = fromIndex; i <= max; ++i) {
            if (!Strings.charsEqualIgnoreCase(where.charAt(i), first)) {
                while (++i <= max && !Strings.charsEqualIgnoreCase(where.charAt(i), first)) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = 1;
            while (j < end && Strings.charsEqualIgnoreCase(where.charAt(j), what.charAt(k))) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull String where, char what, int fromIndex) {
        if (where == null) {
            Strings.$$$reportNull$$$0(31);
        }
        int sourceCount = where.length();
        for (int i = Math.max(fromIndex, 0); i < sourceCount; ++i) {
            if (!Strings.charsEqualIgnoreCase(where.charAt(i), what)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static boolean charsEqualIgnoreCase(char a, char b) {
        return Strings.charsMatch(a, b, true);
    }

    @Contract(pure=true)
    @NotNull
    public static String capitalize(@NotNull String s) {
        if (s == null) {
            Strings.$$$reportNull$$$0(32);
        }
        if (s.isEmpty()) {
            String string = s;
            if (string == null) {
                Strings.$$$reportNull$$$0(33);
            }
            return string;
        }
        if (s.length() == 1) {
            String string = Strings.toUpperCase(s);
            if (string == null) {
                Strings.$$$reportNull$$$0(34);
            }
            return string;
        }
        if (Character.isUpperCase(s.charAt(0))) {
            String string = s;
            if (string == null) {
                Strings.$$$reportNull$$$0(35);
            }
            return string;
        }
        String string = Strings.toUpperCase(s.charAt(0)) + s.substring(1);
        if (string == null) {
            Strings.$$$reportNull$$$0(36);
        }
        return string;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isCapitalized(@Nullable String s) {
        return s != null && !s.isEmpty() && Character.isUpperCase(s.charAt(0));
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull CharSequence text, int startIndex, @NotNull CharSequence prefix) {
        if (text == null) {
            Strings.$$$reportNull$$$0(37);
        }
        if (prefix == null) {
            Strings.$$$reportNull$$$0(38);
        }
        int tl = text.length();
        if (startIndex < 0 || startIndex > tl) {
            throw new IllegalArgumentException("Index is out of bounds: " + startIndex + ", length: " + tl);
        }
        int l1 = tl - startIndex;
        int l2 = prefix.length();
        if (l1 < l2) {
            return false;
        }
        for (int i = 0; i < l2; ++i) {
            if (text.charAt(i + startIndex) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean endsWith(@NotNull CharSequence text, @NotNull CharSequence suffix) {
        if (text == null) {
            Strings.$$$reportNull$$$0(39);
        }
        if (suffix == null) {
            Strings.$$$reportNull$$$0(40);
        }
        return StringUtilRt.endsWith(text, suffix);
    }

    @Contract(pure=true)
    public static boolean endsWithChar(@Nullable CharSequence s, char suffix) {
        return StringUtilRt.endsWithChar(s, suffix);
    }

    @Contract(pure=true)
    public static boolean endsWithIgnoreCase(@NotNull CharSequence str, @NotNull String suffix) {
        if (str == null) {
            Strings.$$$reportNull$$$0(41);
        }
        if (suffix == null) {
            Strings.$$$reportNull$$$0(42);
        }
        return StringUtilRt.endsWithIgnoreCase(str, suffix);
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isNotEmpty(@Nullable String s) {
        return !Strings.isEmpty(s);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable String s) {
        return s == null || s.isEmpty();
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable CharSequence cs) {
        return StringUtilRt.isEmpty(cs);
    }

    @Contract(pure=true)
    @NotNull
    public static String pluralize(@NotNull String word) {
        String plural;
        if (word == null) {
            Strings.$$$reportNull$$$0(43);
        }
        if ((plural = Pluralizer.PLURALIZER.plural(word)) != null) {
            String string = plural;
            if (string == null) {
                Strings.$$$reportNull$$$0(44);
            }
            return string;
        }
        if (word.endsWith("s")) {
            String string = Pluralizer.restoreCase(word, word + "es");
            if (string == null) {
                Strings.$$$reportNull$$$0(45);
            }
            return string;
        }
        String string = Pluralizer.restoreCase(word, word + "s");
        if (string == null) {
            Strings.$$$reportNull$$$0(46);
        }
        return string;
    }

    @Contract(pure=true)
    @Nullable
    public static String unpluralize(@NotNull String word) {
        String singular;
        if (word == null) {
            Strings.$$$reportNull$$$0(47);
        }
        if ((singular = Pluralizer.PLURALIZER.singular(word)) != null) {
            return singular;
        }
        if (word.endsWith("es")) {
            return Strings.nullize(Strings.trimEnd(word, "es", true));
        }
        if (word.endsWith("s")) {
            return Strings.nullize(Strings.trimEnd(word, "s", true));
        }
        return null;
    }

    @Contract(pure=true)
    @NotNull
    public static String notNullize(@Nullable String s) {
        String string = StringUtilRt.notNullize(s);
        if (string == null) {
            Strings.$$$reportNull$$$0(48);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String notNullize(@Nullable String s, @NotNull String defaultValue) {
        if (defaultValue == null) {
            Strings.$$$reportNull$$$0(49);
        }
        String string = StringUtilRt.notNullize(s, defaultValue);
        if (string == null) {
            Strings.$$$reportNull$$$0(50);
        }
        return string;
    }

    @Contract(pure=true)
    @Nullable
    public static String nullize(@Nullable String s) {
        return Strings.nullize(s, false);
    }

    @Contract(pure=true)
    @Nullable
    public static String nullize(@Nullable String s, @Nullable String defaultValue) {
        boolean empty = Strings.isEmpty(s) || Objects.equals(s, defaultValue);
        return empty ? null : s;
    }

    @Contract(pure=true)
    @Nullable
    public static String nullize(@Nullable String s, boolean nullizeSpaces) {
        boolean empty = nullizeSpaces ? Strings.isEmptyOrSpaces(s) : Strings.isEmpty(s);
        return empty ? null : s;
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable CharSequence s) {
        return StringUtilRt.isEmptyOrSpaces(s);
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String trim(@Nullable String s) {
        return s == null ? null : s.trim();
    }

    @Contract(pure=true)
    @NotNull
    public static String trimEnd(@NotNull String s, @NotNull String suffix) {
        if (s == null) {
            Strings.$$$reportNull$$$0(51);
        }
        if (suffix == null) {
            Strings.$$$reportNull$$$0(52);
        }
        return Strings.trimEnd(s, suffix, false);
    }

    @Contract(pure=true)
    @NotNull
    public static String trimEnd(@NotNull String s, @NotNull String suffix, boolean ignoreCase) {
        boolean endsWith;
        if (s == null) {
            Strings.$$$reportNull$$$0(53);
        }
        if (suffix == null) {
            Strings.$$$reportNull$$$0(54);
        }
        boolean bl = endsWith = ignoreCase ? Strings.endsWithIgnoreCase(s, suffix) : s.endsWith(suffix);
        if (endsWith) {
            String string = s.substring(0, s.length() - suffix.length());
            if (string == null) {
                Strings.$$$reportNull$$$0(55);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            Strings.$$$reportNull$$$0(56);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String trimEnd(@NotNull String s, char suffix) {
        if (s == null) {
            Strings.$$$reportNull$$$0(57);
        }
        if (Strings.endsWithChar(s, suffix)) {
            String string = s.substring(0, s.length() - 1);
            if (string == null) {
                Strings.$$$reportNull$$$0(58);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            Strings.$$$reportNull$$$0(59);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String trimStart(@NotNull String s, @NotNull String prefix) {
        if (s == null) {
            Strings.$$$reportNull$$$0(60);
        }
        if (prefix == null) {
            Strings.$$$reportNull$$$0(61);
        }
        if (s.startsWith(prefix)) {
            String string = s.substring(prefix.length());
            if (string == null) {
                Strings.$$$reportNull$$$0(62);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            Strings.$$$reportNull$$$0(63);
        }
        return string;
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars) {
        if (chars == null) {
            Strings.$$$reportNull$$$0(64);
        }
        if (chars instanceof String || chars instanceof CharSequenceWithStringHash) {
            return chars.hashCode();
        }
        return Strings.stringHashCode(chars, 0, chars.length());
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars, int from, int to) {
        if (chars == null) {
            Strings.$$$reportNull$$$0(65);
        }
        return Strings.stringHashCode(chars, from, to, 0);
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars, int from, int to, int prefixHash) {
        if (chars == null) {
            Strings.$$$reportNull$$$0(66);
        }
        int h = prefixHash;
        for (int off = from; off < to; ++off) {
            h = 31 * h + chars.charAt(off);
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCode(char @NotNull [] chars, int from, int to) {
        if (chars == null) {
            Strings.$$$reportNull$$$0(67);
        }
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + chars[off];
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(char @NotNull [] chars, int from, int to) {
        if (chars == null) {
            Strings.$$$reportNull$$$0(68);
        }
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + Strings.toLowerCase(chars[off]);
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars, int from, int to) {
        if (chars == null) {
            Strings.$$$reportNull$$$0(69);
        }
        return StringUtilRt.stringHashCodeInsensitive(chars, from, to);
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars, int from, int to, int prefixHash) {
        if (chars == null) {
            Strings.$$$reportNull$$$0(70);
        }
        return StringUtilRt.stringHashCodeInsensitive(chars, from, to, prefixHash);
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars) {
        if (chars == null) {
            Strings.$$$reportNull$$$0(71);
        }
        return StringUtilRt.stringHashCodeInsensitive(chars);
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text, char c) {
        if (text == null) {
            Strings.$$$reportNull$$$0(72);
        }
        return Strings.countChars(text, c, 0, false);
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text, char c, int offset, boolean stopAtOtherChar) {
        if (text == null) {
            Strings.$$$reportNull$$$0(73);
        }
        return Strings.countChars(text, c, offset, text.length(), stopAtOtherChar);
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text, char c, int start, int end, boolean stopAtOtherChar) {
        if (text == null) {
            Strings.$$$reportNull$$$0(74);
        }
        boolean forward = start <= end;
        start = forward ? Math.max(0, start) : Math.min(text.length(), start);
        end = forward ? Math.min(text.length(), end) : Math.max(0, end);
        int count = 0;
        int i = forward ? start : start - 1;
        while (forward == i < end) {
            if (text.charAt(i) == c) {
                ++count;
            } else if (stopAtOtherChar) break;
            i += forward ? 1 : -1;
        }
        return count;
    }

    @NotNull
    public static StringBuilder escapeToRegexp(@NotNull CharSequence text, @NotNull StringBuilder builder) {
        if (text == null) {
            Strings.$$$reportNull$$$0(75);
        }
        if (builder == null) {
            Strings.$$$reportNull$$$0(76);
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == ' ' || Character.isLetter(c) || Character.isDigit(c) || c == '_') {
                builder.append(c);
                continue;
            }
            if (c == '\n') {
                builder.append("\\n");
                continue;
            }
            if (c == '\r') {
                builder.append("\\r");
                continue;
            }
            Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
            if (block == Character.UnicodeBlock.HIGH_SURROGATES || block == Character.UnicodeBlock.LOW_SURROGATES) {
                builder.append(c);
                continue;
            }
            builder.append('\\').append(c);
        }
        StringBuilder stringBuilder = builder;
        if (stringBuilder == null) {
            Strings.$$$reportNull$$$0(77);
        }
        return stringBuilder;
    }

    @Contract(pure=true)
    @NotNull
    public static String unescapeXmlEntities(@NotNull String text) {
        if (text == null) {
            Strings.$$$reportNull$$$0(78);
        }
        return Strings.replace(text, REPLACES_REFS, REPLACES_DISP);
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeXmlEntities(@NotNull String text) {
        if (text == null) {
            Strings.$$$reportNull$$$0(79);
        }
        return Strings.replace(text, REPLACES_DISP, REPLACES_REFS);
    }

    @Contract(pure=true)
    @NotNull
    public static String replace(@NotNull String text, @NotNull List<String> from, @NotNull List<String> to) {
        if (text == null) {
            Strings.$$$reportNull$$$0(80);
        }
        if (from == null) {
            Strings.$$$reportNull$$$0(81);
        }
        if (to == null) {
            Strings.$$$reportNull$$$0(82);
        }
        assert (from.size() == to.size());
        StringBuilder result = null;
        block0: for (int i = 0; i < text.length(); ++i) {
            for (int j = 0; j < from.size(); ++j) {
                String toReplace = from.get(j);
                String replaceWith = to.get(j);
                int len = toReplace.length();
                if (len == 0 || !text.regionMatches(i, toReplace, 0, len)) continue;
                if (result == null) {
                    result = new StringBuilder(text.length());
                    result.append(text, 0, i);
                }
                result.append(replaceWith);
                i += len - 1;
                continue block0;
            }
            if (result == null) continue;
            result.append(text.charAt(i));
        }
        String string = result == null ? text : result.toString();
        if (string == null) {
            Strings.$$$reportNull$$$0(83);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> String join(T @NotNull [] items, @NotNull Function<? super T, String> f, @NotNull String separator) {
        if (f == null) {
            Strings.$$$reportNull$$$0(84);
        }
        if (separator == null) {
            Strings.$$$reportNull$$$0(85);
        }
        if (items == null) {
            Strings.$$$reportNull$$$0(86);
        }
        return Strings.join(Arrays.asList(items), f, separator);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> String join(@NotNull Collection<? extends T> items, @NotNull Function<? super T, String> f, @NotNull String separator) {
        if (items == null) {
            Strings.$$$reportNull$$$0(87);
        }
        if (f == null) {
            Strings.$$$reportNull$$$0(88);
        }
        if (separator == null) {
            Strings.$$$reportNull$$$0(89);
        }
        if (items.isEmpty()) {
            return "";
        }
        if (items.size() == 1) {
            return Strings.notNullize(f.fun(items.iterator().next()));
        }
        return Strings.join(items, f, separator);
    }

    @Contract(pure=true)
    @NotNull
    public static String join(@NotNull Iterable<?> items, @NotNull String separator) {
        if (items == null) {
            Strings.$$$reportNull$$$0(90);
        }
        if (separator == null) {
            Strings.$$$reportNull$$$0(91);
        }
        StringBuilder result = new StringBuilder();
        for (Object item : items) {
            result.append(item).append(separator);
        }
        if (result.length() > 0) {
            result.setLength(result.length() - separator.length());
        }
        String string = result.toString();
        if (string == null) {
            Strings.$$$reportNull$$$0(92);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> String join(@NotNull Iterable<? extends T> items, @NotNull Function<? super T, ? extends CharSequence> f, @NotNull String separator) {
        if (items == null) {
            Strings.$$$reportNull$$$0(93);
        }
        if (f == null) {
            Strings.$$$reportNull$$$0(94);
        }
        if (separator == null) {
            Strings.$$$reportNull$$$0(95);
        }
        StringBuilder result = new StringBuilder();
        Strings.join(items, f, separator, result);
        String string = result.toString();
        if (string == null) {
            Strings.$$$reportNull$$$0(96);
        }
        return string;
    }

    public static <T> void join(@NotNull Iterable<? extends T> items, @NotNull Function<? super T, ? extends CharSequence> f, @NotNull String separator, @NotNull StringBuilder result) {
        if (items == null) {
            Strings.$$$reportNull$$$0(97);
        }
        if (f == null) {
            Strings.$$$reportNull$$$0(98);
        }
        if (separator == null) {
            Strings.$$$reportNull$$$0(99);
        }
        if (result == null) {
            Strings.$$$reportNull$$$0(100);
        }
        boolean isFirst = true;
        for (T item : items) {
            CharSequence string = f.fun(item);
            if (Strings.isEmpty(string)) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                result.append(separator);
            }
            result.append(string);
        }
    }

    @Contract(pure=true)
    @NotNull
    public static String join(@NotNull Collection<String> strings, @NotNull String separator) {
        if (strings == null) {
            Strings.$$$reportNull$$$0(101);
        }
        if (separator == null) {
            Strings.$$$reportNull$$$0(102);
        }
        if (strings.size() <= 1) {
            return Strings.notNullize(strings.isEmpty() ? null : strings.iterator().next());
        }
        StringBuilder result = new StringBuilder();
        Strings.join(strings, separator, result);
        String string = result.toString();
        if (string == null) {
            Strings.$$$reportNull$$$0(103);
        }
        return string;
    }

    public static void join(@NotNull Collection<String> strings, @NotNull String separator, @NotNull StringBuilder result) {
        if (strings == null) {
            Strings.$$$reportNull$$$0(104);
        }
        if (separator == null) {
            Strings.$$$reportNull$$$0(105);
        }
        if (result == null) {
            Strings.$$$reportNull$$$0(106);
        }
        boolean isFirst = true;
        for (String string : strings) {
            if (string == null) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                result.append(separator);
            }
            result.append(string);
        }
    }

    @Contract(pure=true)
    @NotNull
    public static String join(int @NotNull [] strings, @NotNull String separator) {
        if (separator == null) {
            Strings.$$$reportNull$$$0(107);
        }
        if (strings == null) {
            Strings.$$$reportNull$$$0(108);
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0) {
                result.append(separator);
            }
            result.append(strings[i]);
        }
        String string = result.toString();
        if (string == null) {
            Strings.$$$reportNull$$$0(109);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String join(String ... strings) {
        if (strings == null) {
            Strings.$$$reportNull$$$0(110);
        }
        if (strings.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String string : strings) {
            builder.append(string);
        }
        String string = builder.toString();
        if (string == null) {
            Strings.$$$reportNull$$$0(111);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 77: 
            case 83: 
            case 92: 
            case 96: 
            case 103: 
            case 109: 
            case 111: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 77: 
            case 83: 
            case 92: 
            case 96: 
            case 103: 
            case 109: 
            case 111: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 1: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infix";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 32: 
            case 51: 
            case 53: 
            case 57: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: 
            case 7: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "where";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 77: 
            case 83: 
            case 92: 
            case 96: 
            case 103: 
            case 109: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/text/Strings";
                break;
            }
            case 37: 
            case 39: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 78: 
            case 79: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 38: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 40: 
            case 42: 
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 43: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 84: 
            case 88: 
            case 94: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 85: 
            case 89: 
            case 91: 
            case 95: 
            case 99: 
            case 102: 
            case 105: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 86: 
            case 87: 
            case 90: 
            case 93: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 100: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 101: 
            case 104: 
            case 108: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/text/Strings";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalize";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "pluralize";
                break;
            }
            case 48: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
            case 55: 
            case 56: 
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "trimEnd";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "trimStart";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeToRegexp";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "replace";
                break;
            }
            case 92: 
            case 96: 
            case 103: 
            case 109: 
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "containsChar";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "containsAnyChar";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "indexOfAny";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "indexOfIgnoreCase";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "capitalize";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 77: 
            case 83: 
            case 92: 
            case 96: 
            case 103: 
            case 109: 
            case 111: {
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "endsWith";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "endsWithIgnoreCase";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "pluralize";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "unpluralize";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "notNullize";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "trimEnd";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "trimStart";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCode";
                break;
            }
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCodeInsensitive";
                break;
            }
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "countChars";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "escapeToRegexp";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "unescapeXmlEntities";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "escapeXmlEntities";
                break;
            }
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 77: 
            case 83: 
            case 92: 
            case 96: 
            case 103: 
            case 109: 
            case 111: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

