/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageDirectoryCache {
    private static final Logger LOG = Logger.getInstance(PackageDirectoryCache.class);
    private final MultiMap<String, VirtualFile> myRootsByPackagePrefix;
    private final Map<String, PackageInfo> myDirectoriesByPackageNameCache;
    private final Set<String> myNonExistentPackages;

    public PackageDirectoryCache(@NotNull MultiMap<String, VirtualFile> rootsByPackagePrefix) {
        if (rootsByPackagePrefix == null) {
            PackageDirectoryCache.$$$reportNull$$$0(0);
        }
        this.myRootsByPackagePrefix = MultiMap.create();
        this.myDirectoriesByPackageNameCache = new ConcurrentHashMap<String, PackageInfo>();
        this.myNonExistentPackages = ContainerUtil.newConcurrentSet();
        for (String prefix : rootsByPackagePrefix.keySet()) {
            for (VirtualFile file : rootsByPackagePrefix.get(prefix)) {
                if (!file.isValid()) {
                    LOG.error("Invalid root: " + file);
                    continue;
                }
                this.myRootsByPackagePrefix.putValue(prefix, file);
            }
        }
    }

    void clear() {
        this.myNonExistentPackages.clear();
        this.myDirectoriesByPackageNameCache.clear();
    }

    public void onLowMemory() {
        this.myNonExistentPackages.clear();
    }

    @NotNull
    public List<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName) {
        PackageInfo info;
        if (packageName == null) {
            PackageDirectoryCache.$$$reportNull$$$0(1);
        }
        List<VirtualFile> list = (info = this.getPackageInfo(packageName)) == null ? Collections.emptyList() : Collections.unmodifiableList(info.myPackageDirectories);
        if (list == null) {
            PackageDirectoryCache.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    private PackageInfo getPackageInfo(@NotNull String packageName) {
        PackageInfo info;
        if (packageName == null) {
            PackageDirectoryCache.$$$reportNull$$$0(3);
        }
        if ((info = this.myDirectoriesByPackageNameCache.get(packageName)) == null && !this.myNonExistentPackages.contains(packageName)) {
            if (packageName.length() > Registry.intValue("java.max.package.name.length") || StringUtil.containsAnyChar(packageName, ";[/")) {
                return null;
            }
            SmartList<VirtualFile> result = new SmartList<VirtualFile>();
            if (StringUtil.isNotEmpty(packageName) && !StringUtil.startsWithChar(packageName, '.')) {
                int i = packageName.lastIndexOf(46);
                while (true) {
                    PackageInfo parentInfo;
                    if ((parentInfo = this.getPackageInfo(i > 0 ? packageName.substring(0, i) : "")) != null) {
                        result.addAll(parentInfo.getSubPackageDirectories(packageName.substring(i + 1)));
                    }
                    if (i < 0) break;
                    i = packageName.lastIndexOf(46, i - 1);
                    ProgressManager.checkCanceled();
                }
            }
            for (VirtualFile file : this.myRootsByPackagePrefix.get(packageName)) {
                if (!file.isDirectory() || !file.isValid()) continue;
                result.add(file);
            }
            if (!result.isEmpty()) {
                info = new PackageInfo(packageName, result);
                this.myDirectoriesByPackageNameCache.put(packageName, info);
            } else {
                this.myNonExistentPackages.add(packageName);
            }
        }
        return info;
    }

    @NotNull
    public Set<String> getSubpackageNames(@NotNull String packageName, @NotNull GlobalSearchScope scope) {
        PackageInfo info;
        if (packageName == null) {
            PackageDirectoryCache.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            PackageDirectoryCache.$$$reportNull$$$0(5);
        }
        if ((info = this.getPackageInfo(packageName)) == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                PackageDirectoryCache.$$$reportNull$$$0(6);
            }
            return set;
        }
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<String, Collection<VirtualFile>> entry : info.mySubPackages.getValue().entrySet()) {
            String shortName = entry.getKey();
            Collection<VirtualFile> directories = entry.getValue();
            if (!ContainerUtil.exists(directories, scope::contains)) continue;
            result.add(shortName);
        }
        Set<String> set = Collections.unmodifiableSet(result);
        if (set == null) {
            PackageDirectoryCache.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    public static PackageDirectoryCache createCache(@NotNull List<? extends VirtualFile> roots) {
        if (roots == null) {
            PackageDirectoryCache.$$$reportNull$$$0(8);
        }
        MultiMap<String, VirtualFile> map = MultiMap.create();
        map.putValues("", roots);
        return new PackageDirectoryCache(map);
    }

    protected boolean isPackageDirectory(@NotNull VirtualFile dir, @NotNull String packageName) {
        if (dir == null) {
            PackageDirectoryCache.$$$reportNull$$$0(9);
        }
        if (packageName == null) {
            PackageDirectoryCache.$$$reportNull$$$0(10);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsByPackagePrefix";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/PackageDirectoryCache";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/PackageDirectoryCache";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoriesByPackageName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubpackageNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoriesByPackageName";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPackageInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSubpackageNames";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createCache";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isPackageDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class PackageInfo {
        @NotNull
        final String myQname;
        @NotNull
        final List<? extends VirtualFile> myPackageDirectories;
        final NotNullLazyValue<MultiMap<String, VirtualFile>> mySubPackages;

        PackageInfo(@NotNull String qname, List<? extends VirtualFile> packageDirectories) {
            if (qname == null) {
                PackageInfo.$$$reportNull$$$0(0);
            }
            if (packageDirectories == null) {
                PackageInfo.$$$reportNull$$$0(1);
            }
            this.myQname = qname;
            this.myPackageDirectories = packageDirectories;
            this.mySubPackages = NotNullLazyValue.volatileLazy(() -> {
                MultiMap<String, VirtualFile> result = MultiMap.createLinked();
                for (VirtualFile virtualFile : this.myPackageDirectories) {
                    ProgressManager.checkCanceled();
                    for (VirtualFile child : virtualFile.getChildren()) {
                        String packageName;
                        String childName = child.getName();
                        String string = packageName = this.myQname.isEmpty() ? childName : this.myQname + "." + childName;
                        if (!child.isDirectory() || !PackageDirectoryCache.this.isPackageDirectory(child, packageName)) continue;
                        result.putValue(childName, child);
                    }
                }
                return result;
            });
        }

        @NotNull
        Collection<VirtualFile> getSubPackageDirectories(String shortName) {
            Collection<VirtualFile> collection = this.mySubPackages.getValue().get(shortName);
            if (collection == null) {
                PackageInfo.$$$reportNull$$$0(2);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qname";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageDirectories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/impl/PackageDirectoryCache$PackageInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/impl/PackageDirectoryCache$PackageInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubPackageDirectories";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

