/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.lang.JavaVersion;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum JavaSdkVersion {
    JDK_1_0(LanguageLevel.JDK_1_3),
    JDK_1_1(LanguageLevel.JDK_1_3),
    JDK_1_2(LanguageLevel.JDK_1_3),
    JDK_1_3(LanguageLevel.JDK_1_3),
    JDK_1_4(LanguageLevel.JDK_1_4),
    JDK_1_5(LanguageLevel.JDK_1_5),
    JDK_1_6(LanguageLevel.JDK_1_6),
    JDK_1_7(LanguageLevel.JDK_1_7),
    JDK_1_8(LanguageLevel.JDK_1_8),
    JDK_1_9(LanguageLevel.JDK_1_9),
    JDK_10(LanguageLevel.JDK_10),
    JDK_11(LanguageLevel.JDK_11),
    JDK_12(LanguageLevel.JDK_12),
    JDK_13(LanguageLevel.JDK_13),
    JDK_14(LanguageLevel.JDK_14),
    JDK_15(LanguageLevel.JDK_15),
    JDK_16(LanguageLevel.JDK_16),
    JDK_17(LanguageLevel.JDK_17),
    JDK_18(LanguageLevel.JDK_X);

    private final LanguageLevel myMaxLanguageLevel;

    private JavaSdkVersion(LanguageLevel maxLanguageLevel) {
        if (maxLanguageLevel == null) {
            JavaSdkVersion.$$$reportNull$$$0(0);
        }
        this.myMaxLanguageLevel = maxLanguageLevel;
    }

    @NotNull
    public LanguageLevel getMaxLanguageLevel() {
        LanguageLevel languageLevel = this.myMaxLanguageLevel;
        if (languageLevel == null) {
            JavaSdkVersion.$$$reportNull$$$0(1);
        }
        return languageLevel;
    }

    @NotNull
    @NlsSafe
    public String getDescription() {
        int feature = this.ordinal();
        String string = feature < 5 ? "1." + feature : String.valueOf(feature);
        if (string == null) {
            JavaSdkVersion.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAtLeast(@NotNull JavaSdkVersion version) {
        if (version == null) {
            JavaSdkVersion.$$$reportNull$$$0(3);
        }
        return this.compareTo(version) >= 0;
    }

    @NotNull
    public static JavaSdkVersion fromLanguageLevel(@NotNull LanguageLevel languageLevel) throws IllegalArgumentException {
        if (languageLevel == null) {
            JavaSdkVersion.$$$reportNull$$$0(4);
        }
        JavaSdkVersion[] values = JavaSdkVersion.values();
        if (languageLevel == LanguageLevel.JDK_X) {
            JavaSdkVersion javaSdkVersion = values[values.length - 1];
            if (javaSdkVersion == null) {
                JavaSdkVersion.$$$reportNull$$$0(5);
            }
            return javaSdkVersion;
        }
        int feature = languageLevel.toJavaVersion().feature;
        if (feature < values.length) {
            JavaSdkVersion javaSdkVersion = values[feature];
            if (javaSdkVersion == null) {
                JavaSdkVersion.$$$reportNull$$$0(6);
            }
            return javaSdkVersion;
        }
        throw new IllegalArgumentException("Can't map " + (Object)((Object)languageLevel) + " to any of " + Arrays.toString((Object[])values));
    }

    @Nullable
    public static JavaSdkVersion fromVersionString(@NotNull String versionString) {
        JavaVersion version;
        if (versionString == null) {
            JavaSdkVersion.$$$reportNull$$$0(7);
        }
        return (version = JavaVersion.tryParse(versionString)) != null ? JavaSdkVersion.fromJavaVersion(version) : null;
    }

    @Nullable
    public static JavaSdkVersion fromJavaVersion(@NotNull JavaVersion version) {
        JavaSdkVersion[] values;
        if (version == null) {
            JavaSdkVersion.$$$reportNull$$$0(8);
        }
        return version.feature < (values = JavaSdkVersion.values()).length ? values[version.feature] : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maxLanguageLevel";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/JavaSdkVersion";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/JavaSdkVersion";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMaxLanguageLevel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "fromLanguageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAtLeast";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fromLanguageLevel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fromVersionString";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fromJavaVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

