/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.PatternUtil;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;

public class WildcardFileNameMatcher
implements FileNameMatcher {
    private final String myPattern;
    private final MaskMatcher myMatcher;

    public WildcardFileNameMatcher(@NotNull String pattern) {
        if (pattern == null) {
            WildcardFileNameMatcher.$$$reportNull$$$0(0);
        }
        this.myPattern = pattern;
        this.myMatcher = WildcardFileNameMatcher.createMatcher(pattern);
    }

    @NotNull
    private static MaskMatcher createMatcher(@NotNull String pattern) {
        int len;
        if (pattern == null) {
            WildcardFileNameMatcher.$$$reportNull$$$0(1);
        }
        if ((len = pattern.length()) > 1 && pattern.indexOf(63) < 0) {
            if (pattern.charAt(0) == '*' && pattern.indexOf(42, 1) < 0) {
                return new SuffixMatcher(pattern.substring(1));
            }
            if (pattern.indexOf(42) == len - 1) {
                return new PrefixMatcher(pattern.substring(0, len - 1));
            }
            if (len > 2 && pattern.charAt(0) == '*' && pattern.indexOf(42, 1) == len - 1) {
                return new InfixMatcher(pattern.substring(1, len - 1));
            }
        }
        return new RegexpMatcher(pattern);
    }

    @Override
    public boolean acceptsCharSequence(@NotNull CharSequence fileName) {
        if (fileName == null) {
            WildcardFileNameMatcher.$$$reportNull$$$0(2);
        }
        return this.myMatcher.matches(fileName);
    }

    @Override
    @NotNull
    public String getPresentableString() {
        String string = this.myPattern;
        if (string == null) {
            WildcardFileNameMatcher.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WildcardFileNameMatcher that = (WildcardFileNameMatcher)o;
        return this.myPattern.equals(that.myPattern);
    }

    public int hashCode() {
        return this.myPattern.hashCode();
    }

    @NotNull
    public String getPattern() {
        String string = this.myPattern;
        if (string == null) {
            WildcardFileNameMatcher.$$$reportNull$$$0(4);
        }
        return string;
    }

    public String toString() {
        return this.myPattern;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/WildcardFileNameMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/WildcardFileNameMatcher";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableString";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createMatcher";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "acceptsCharSequence";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class InfixMatcher
    implements MaskMatcher {
        private final String myInfix;

        InfixMatcher(@NotNull String infix) {
            if (infix == null) {
                InfixMatcher.$$$reportNull$$$0(0);
            }
            this.myInfix = infix;
        }

        @Override
        public boolean matches(@NotNull CharSequence filename) {
            if (filename == null) {
                InfixMatcher.$$$reportNull$$$0(1);
            }
            return Strings.contains(filename, this.myInfix);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "infix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filename";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/fileTypes/WildcardFileNameMatcher$InfixMatcher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matches";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class PrefixMatcher
    implements MaskMatcher {
        private final String myPrefix;

        private PrefixMatcher(@NotNull String prefix) {
            if (prefix == null) {
                PrefixMatcher.$$$reportNull$$$0(0);
            }
            this.myPrefix = prefix;
        }

        @Override
        public boolean matches(@NotNull CharSequence filename) {
            if (filename == null) {
                PrefixMatcher.$$$reportNull$$$0(1);
            }
            return Strings.startsWith(filename, 0, this.myPrefix);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filename";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/fileTypes/WildcardFileNameMatcher$PrefixMatcher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matches";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class SuffixMatcher
    implements MaskMatcher {
        private final String mySuffix;

        SuffixMatcher(@NotNull String suffix) {
            if (suffix == null) {
                SuffixMatcher.$$$reportNull$$$0(0);
            }
            this.mySuffix = suffix;
        }

        @Override
        public boolean matches(@NotNull CharSequence filename) {
            if (filename == null) {
                SuffixMatcher.$$$reportNull$$$0(1);
            }
            return Strings.endsWith(filename, this.mySuffix);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suffix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filename";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/fileTypes/WildcardFileNameMatcher$SuffixMatcher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matches";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class RegexpMatcher
    implements MaskMatcher {
        private final Matcher myMatcher;

        RegexpMatcher(@NotNull String pattern) {
            if (pattern == null) {
                RegexpMatcher.$$$reportNull$$$0(0);
            }
            this.myMatcher = PatternUtil.fromMask(pattern).matcher("");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean matches(@NotNull CharSequence filename) {
            if (filename == null) {
                RegexpMatcher.$$$reportNull$$$0(1);
            }
            Matcher matcher = this.myMatcher;
            synchronized (matcher) {
                this.myMatcher.reset(filename);
                return this.myMatcher.matches();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filename";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/fileTypes/WildcardFileNameMatcher$RegexpMatcher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matches";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface MaskMatcher {
        public boolean matches(@NotNull CharSequence var1);
    }
}

