/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.core.CoreBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.SavingRequestor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileDocumentManager
implements SavingRequestor {
    @NotNull
    public static FileDocumentManager getInstance() {
        FileDocumentManager fileDocumentManager = ApplicationManager.getApplication().getService(FileDocumentManager.class);
        if (fileDocumentManager == null) {
            FileDocumentManager.$$$reportNull$$$0(0);
        }
        return fileDocumentManager;
    }

    @Nullable
    public abstract Document getDocument(@NotNull VirtualFile var1);

    @Nullable
    public abstract Document getCachedDocument(@NotNull VirtualFile var1);

    @Nullable
    public abstract VirtualFile getFile(@NotNull Document var1);

    public abstract void saveAllDocuments();

    public abstract void saveDocuments(@NotNull Predicate<? super Document> var1);

    public abstract void saveDocument(@NotNull Document var1);

    public abstract void saveDocumentAsIs(@NotNull Document var1);

    public abstract Document @NotNull [] getUnsavedDocuments();

    public abstract boolean isDocumentUnsaved(@NotNull Document var1);

    public abstract boolean isFileModified(@NotNull VirtualFile var1);

    public abstract boolean isPartialPreviewOfALargeFile(@NotNull Document var1);

    public abstract void reloadFromDisk(@NotNull Document var1);

    @NotNull
    public abstract String getLineSeparator(@Nullable VirtualFile var1, @Nullable Project var2);

    public abstract boolean requestWriting(@NotNull Document var1, @Nullable Project var2);

    @NotNull
    public WriteAccessStatus requestWritingStatus(@NotNull Document document, @Nullable Project project) {
        if (document == null) {
            FileDocumentManager.$$$reportNull$$$0(1);
        }
        WriteAccessStatus writeAccessStatus = this.requestWriting(document, project) ? WriteAccessStatus.WRITABLE : WriteAccessStatus.NON_WRITABLE;
        if (writeAccessStatus == null) {
            FileDocumentManager.$$$reportNull$$$0(2);
        }
        return writeAccessStatus;
    }

    public static boolean fileForDocumentCheckedOutSuccessfully(@NotNull Document document, @NotNull Project project) {
        if (document == null) {
            FileDocumentManager.$$$reportNull$$$0(3);
        }
        if (project == null) {
            FileDocumentManager.$$$reportNull$$$0(4);
        }
        return FileDocumentManager.getInstance().requestWriting(document, project);
    }

    public abstract void reloadFiles(VirtualFile ... var1);

    @ApiStatus.Internal
    public void reloadBinaryFiles() {
    }

    @ApiStatus.Internal
    @Nullable
    public FileViewProvider findCachedPsiInAnyProject(@NotNull VirtualFile file) {
        if (file == null) {
            FileDocumentManager.$$$reportNull$$$0(5);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/FileDocumentManager";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/FileDocumentManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "requestWritingStatus";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "requestWritingStatus";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fileForDocumentCheckedOutSuccessfully";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findCachedPsiInAnyProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class WriteAccessStatus {
        public static final WriteAccessStatus NON_WRITABLE = new WriteAccessStatus(false);
        public static final WriteAccessStatus WRITABLE = new WriteAccessStatus(true);
        private final boolean myWithWriteAccess;
        @NotNull
        private final @NlsContexts.HintText String myReadOnlyMessage;

        private WriteAccessStatus(boolean withWriteAccess) {
            this.myWithWriteAccess = withWriteAccess;
            this.myReadOnlyMessage = withWriteAccess ? "" : CoreBundle.message("editing.read.only.file.hint", new Object[0]);
        }

        public WriteAccessStatus(@NotNull @NlsContexts.HintText String readOnlyMessage) {
            if (readOnlyMessage == null) {
                WriteAccessStatus.$$$reportNull$$$0(0);
            }
            this.myWithWriteAccess = false;
            this.myReadOnlyMessage = readOnlyMessage;
        }

        public boolean hasWriteAccess() {
            return this.myWithWriteAccess;
        }

        @NotNull
        @NlsContexts.HintText
        public String getReadOnlyMessage() {
            String string = this.myReadOnlyMessage;
            if (string == null) {
                WriteAccessStatus.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "readOnlyMessage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/fileEditor/FileDocumentManager$WriteAccessStatus";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/fileEditor/FileDocumentManager$WriteAccessStatus";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReadOnlyMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

