/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.extensions.DefaultPluginDescriptor;
import com.intellij.openapi.extensions.ExtensionDescriptor;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointDescriptor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.BeanExtensionPoint;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.InterfaceExtensionPoint;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ThreeState;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class ExtensionsAreaImpl
implements ExtensionsArea {
    private static final Logger LOG = Logger.getInstance(ExtensionsAreaImpl.class);
    private static final boolean DEBUG_REGISTRATION = false;
    private final ComponentManager componentManager;
    public volatile Map<String, ExtensionPointImpl<?>> extensionPoints;
    private final Map<String, Throwable> epTraces;

    public ExtensionsAreaImpl(@NotNull ComponentManager componentManager) {
        if (componentManager == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(0);
        }
        this.extensionPoints = Collections.emptyMap();
        this.epTraces = null;
        this.componentManager = componentManager;
    }

    @TestOnly
    public void notifyAreaReplaced(@Nullable ExtensionsAreaImpl newArea) {
        HashSet<String> processedEPs = new HashSet<String>(this.extensionPoints.size());
        for (ExtensionPointImpl<?> point : this.extensionPoints.values()) {
            point.notifyAreaReplaced(this);
            processedEPs.add(point.getName());
        }
        if (newArea == null) {
            return;
        }
        for (ExtensionPointImpl<?> point : newArea.extensionPoints.values()) {
            if (processedEPs.contains(point.getName())) continue;
            point.notifyAreaReplaced(this);
        }
    }

    @TestOnly
    public void registerExtensionPoints(@NotNull PluginDescriptor pluginDescriptor, @NotNull List<Element> extensionPointElements) {
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(1);
        }
        if (extensionPointElements == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(2);
        }
        for (Element element : extensionPointElements) {
            String pointName = element.getAttributeValue("qualifiedName");
            if (pointName == null) {
                String name = element.getAttributeValue("name");
                if (name == null) {
                    throw this.componentManager.createError("'name' attribute not specified for extension point in '" + pluginDescriptor + "' plugin", pluginDescriptor.getPluginId());
                }
                assert (pluginDescriptor.getPluginId() != null);
                pointName = pluginDescriptor.getPluginId().getIdString() + '.' + name;
            }
            String beanClassName = element.getAttributeValue("beanClass");
            String interfaceClassName = element.getAttributeValue("interface");
            if (beanClassName == null && interfaceClassName == null) {
                throw this.componentManager.createError("Neither 'beanClass' nor 'interface' attribute is specified for extension point '" + pointName + "' in '" + pluginDescriptor + "' plugin", pluginDescriptor.getPluginId());
            }
            if (beanClassName != null && interfaceClassName != null) {
                throw this.componentManager.createError("Both 'beanClass' and 'interface' attributes are specified for extension point '" + pointName + "' in '" + pluginDescriptor + "' plugin", pluginDescriptor.getPluginId());
            }
            boolean dynamic = Boolean.parseBoolean(element.getAttributeValue("dynamic"));
            String className = interfaceClassName == null ? beanClassName : interfaceClassName;
            this.doRegisterExtensionPoint(pointName, className, pluginDescriptor, interfaceClassName != null, dynamic);
        }
    }

    public boolean unregisterExtensions(@NotNull String extensionPointName, @NotNull PluginDescriptor pluginDescriptor, @NotNull List<ExtensionDescriptor> elements, @NotNull List<Runnable> priorityListenerCallbacks, @NotNull List<Runnable> listenerCallbacks) {
        ExtensionPointImpl<?> point;
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(3);
        }
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(4);
        }
        if (elements == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(5);
        }
        if (priorityListenerCallbacks == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(6);
        }
        if (listenerCallbacks == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(7);
        }
        if ((point = this.extensionPoints.get(extensionPointName)) == null) {
            return false;
        }
        point.unregisterExtensions(this.componentManager, pluginDescriptor, elements, priorityListenerCallbacks, listenerCallbacks);
        return true;
    }

    public void resetExtensionPoints(@NotNull List<ExtensionPointDescriptor> descriptors, @NotNull PluginDescriptor pluginDescriptor) {
        if (descriptors == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(8);
        }
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(9);
        }
        for (ExtensionPointDescriptor descriptor : descriptors) {
            ExtensionPointImpl<?> extensionPoint = this.extensionPoints.get(descriptor.getQualifiedName(pluginDescriptor));
            if (extensionPoint == null) continue;
            extensionPoint.reset();
        }
    }

    public void clearUserCache() {
        this.extensionPoints.values().forEach(ExtensionPointImpl::clearUserCache);
    }

    public void unregisterExtensionPoints(@NotNull List<ExtensionPointDescriptor> descriptors, @NotNull PluginDescriptor pluginDescriptor) {
        if (descriptors == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(10);
        }
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(11);
        }
        if (descriptors.isEmpty()) {
            return;
        }
        HashMap map = new HashMap(this.extensionPoints);
        for (ExtensionPointDescriptor descriptor : descriptors) {
            map.remove(descriptor.getQualifiedName(pluginDescriptor));
        }
        this.extensionPoints = map;
    }

    @TestOnly
    public void registerExtensionPoint(@NotNull BaseExtensionPointName<?> extensionPoint, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind, @NotNull Disposable parentDisposable) {
        if (extensionPoint == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(12);
        }
        if (extensionPointBeanClass == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(13);
        }
        if (kind == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(14);
        }
        if (parentDisposable == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(15);
        }
        String extensionPointName = extensionPoint.getName();
        this.registerExtensionPoint(extensionPointName, extensionPointBeanClass, kind, false);
        Disposer.register(parentDisposable, () -> this.unregisterExtensionPoint(extensionPointName));
    }

    @Override
    @TestOnly
    public void registerExtensionPoint(@NotNull String extensionPointName, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind, boolean dynamic) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(16);
        }
        if (extensionPointBeanClass == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(17);
        }
        if (kind == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(18);
        }
        DefaultPluginDescriptor pluginDescriptor = new DefaultPluginDescriptor(PluginId.getId("fakeIdForTests"));
        this.doRegisterExtensionPoint(extensionPointName, extensionPointBeanClass, pluginDescriptor, kind == ExtensionPoint.Kind.INTERFACE, dynamic);
    }

    @TestOnly
    public <T> ExtensionPointImpl<T> registerPoint(@NotNull String name, @NotNull Class<T> extensionClass, @NotNull PluginDescriptor pluginDescriptor, boolean isDynamic) {
        if (name == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(19);
        }
        if (extensionClass == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(20);
        }
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(21);
        }
        return this.doRegisterExtensionPoint(name, extensionClass.getName(), pluginDescriptor, extensionClass.isInterface() || (extensionClass.getModifiers() & 0x400) != 0, isDynamic);
    }

    @TestOnly
    @NotNull
    private <T> ExtensionPointImpl<T> doRegisterExtensionPoint(@NotNull String name, @NotNull String extensionClass, @NotNull PluginDescriptor pluginDescriptor, boolean isInterface, boolean dynamic) {
        if (name == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(22);
        }
        if (extensionClass == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(23);
        }
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(24);
        }
        ExtensionPointImpl point = isInterface ? new InterfaceExtensionPoint(name, extensionClass, pluginDescriptor, this.componentManager, null, dynamic) : new BeanExtensionPoint(name, extensionClass, pluginDescriptor, this.componentManager, dynamic);
        this.checkThatPointNotDuplicated(name, point.getPluginDescriptor());
        HashMap<String, ExtensionPointImpl> newMap = new HashMap<String, ExtensionPointImpl>(this.extensionPoints.size() + 1);
        newMap.putAll(this.extensionPoints);
        newMap.put(name, point);
        this.extensionPoints = Collections.unmodifiableMap(newMap);
        ExtensionPointImpl extensionPointImpl = point;
        if (extensionPointImpl == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(25);
        }
        return extensionPointImpl;
    }

    @TestOnly
    public <T> ExtensionPointImpl<T> registerFakeBeanPoint(@NotNull String name, @NotNull PluginDescriptor pluginDescriptor) {
        if (name == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(26);
        }
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(27);
        }
        return this.doRegisterExtensionPoint(name, Object.class.getName(), pluginDescriptor, false, false);
    }

    private void checkThatPointNotDuplicated(@NotNull String pointName, @NotNull PluginDescriptor pluginDescriptor) {
        if (pointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(28);
        }
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(29);
        }
        if (!this.hasExtensionPoint(pointName)) {
            return;
        }
        PluginId id1 = ((ExtensionPointImpl)this.getExtensionPoint(pointName)).getPluginDescriptor().getPluginId();
        PluginId id2 = pluginDescriptor.getPluginId();
        @NonNls String message = "Duplicate registration for EP '" + pointName + "': first in " + id1 + ", second in " + id2;
        throw this.componentManager.createError(message, pluginDescriptor.getPluginId());
    }

    public void registerExtensionPoints(@NotNull List<ExtensionPointDescriptor> points, @NotNull PluginDescriptor pluginDescriptor) {
        if (points == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(30);
        }
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(31);
        }
        HashMap map = new HashMap(this.extensionPoints);
        ExtensionsAreaImpl.createExtensionPoints(points, this.componentManager, map, pluginDescriptor);
        this.extensionPoints = map;
    }

    public void setPoints(@NotNull Map<String, ExtensionPointImpl<?>> value) {
        if (value == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(32);
        }
        this.extensionPoints = value;
    }

    @ApiStatus.Internal
    public static void createExtensionPoints(@NotNull List<ExtensionPointDescriptor> points, @NotNull ComponentManager componentManager, @NotNull Map<String, ExtensionPointImpl<?>> result, @NotNull PluginDescriptor pluginDescriptor) {
        if (points == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(33);
        }
        if (componentManager == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(34);
        }
        if (result == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(35);
        }
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(36);
        }
        for (ExtensionPointDescriptor descriptor : points) {
            ExtensionPointImpl point;
            String name = descriptor.getQualifiedName(pluginDescriptor);
            ExtensionPointImpl old = result.put(name, point = descriptor.isBean ? new BeanExtensionPoint(name, descriptor.className, pluginDescriptor, componentManager, descriptor.isDynamic) : new InterfaceExtensionPoint(name, descriptor.className, pluginDescriptor, componentManager, null, descriptor.isDynamic));
            if (old == null) continue;
            result.put(name, old);
            PluginDescriptor oldPluginDescriptor = old.getPluginDescriptor();
            throw componentManager.createError("Duplicate registration for EP " + name + ": first in " + oldPluginDescriptor + ", second in " + pluginDescriptor, pluginDescriptor.getPluginId());
        }
    }

    @NotNull
    public <T> ExtensionPointImpl<T> getExtensionPoint(@NotNull String extensionPointName) {
        ExtensionPointImpl<?> extensionPoint;
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(37);
        }
        if ((extensionPoint = this.extensionPoints.get(extensionPointName)) == null) {
            throw new IllegalArgumentException("Missing extension point: " + extensionPointName + " in container " + this.componentManager);
        }
        ExtensionPointImpl<?> extensionPointImpl = extensionPoint;
        if (extensionPointImpl == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(38);
        }
        return extensionPointImpl;
    }

    @Nullable
    public <T> ExtensionPointImpl<T> getExtensionPointIfRegistered(@NotNull String extensionPointName) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(39);
        }
        return this.extensionPoints.get(extensionPointName);
    }

    @Override
    @NotNull
    public <T> ExtensionPoint<T> getExtensionPoint(@NotNull ExtensionPointName<T> extensionPointName) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(40);
        }
        ExtensionPoint extensionPoint = this.getExtensionPoint(extensionPointName.getName());
        if (extensionPoint == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(41);
        }
        return extensionPoint;
    }

    @TestOnly
    public void processExtensionPoints(@NotNull Consumer<ExtensionPointImpl<?>> consumer) {
        if (consumer == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(42);
        }
        this.extensionPoints.values().forEach(consumer);
    }

    @ApiStatus.Internal
    @Nullable
    public <T> T findExtensionByClass(@NotNull Class<T> aClass) {
        if (aClass == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(43);
        }
        if (aClass.getName().equals("com.intellij.execution.executors.DefaultDebugExecutor")) {
            return this.extensionPoints.get("com.intellij.executor").findExtension(aClass, false, ThreeState.YES);
        }
        for (ExtensionPointImpl<?> point : this.extensionPoints.values()) {
            if (!(point instanceof InterfaceExtensionPoint)) continue;
            try {
                T extension;
                Class<T> extensionClass = point.getExtensionClass();
                if (!extensionClass.isAssignableFrom(aClass) || (extension = point.findExtension(aClass, false, ThreeState.YES)) == null) continue;
                return extension;
            }
            catch (Throwable e) {
                LOG.warn("error during findExtensionPointByClass", e);
            }
        }
        return null;
    }

    @Override
    @TestOnly
    public void unregisterExtensionPoint(@NotNull String extensionPointName) {
        ExtensionPointImpl<?> extensionPoint;
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(44);
        }
        if ((extensionPoint = this.extensionPoints.get(extensionPointName)) != null) {
            extensionPoint.reset();
            HashMap map = new HashMap(this.extensionPoints);
            map.remove(extensionPointName);
            this.extensionPoints = Collections.unmodifiableMap(map);
        }
    }

    @Override
    public boolean hasExtensionPoint(@NotNull String extensionPointName) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(45);
        }
        return this.extensionPoints.containsKey(extensionPointName);
    }

    @Override
    public boolean hasExtensionPoint(@NotNull ExtensionPointName<?> extensionPointName) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(46);
        }
        return this.hasExtensionPoint(extensionPointName.getName());
    }

    public String toString() {
        return this.componentManager.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 25: 
            case 38: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 25: 
            case 38: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentManager";
                break;
            }
            case 1: 
            case 4: 
            case 9: 
            case 11: 
            case 21: 
            case 24: 
            case 27: 
            case 29: 
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointElements";
                break;
            }
            case 3: 
            case 16: 
            case 37: 
            case 39: 
            case 40: 
            case 44: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityListenerCallbacks";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listenerCallbacks";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPoint";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointBeanClass";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 19: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionClass";
                break;
            }
            case 25: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointName";
                break;
            }
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "points";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "doRegisterExtensionPoint";
                break;
            }
            case 38: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionPoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPoints";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtensions";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resetExtensionPoints";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtensionPoints";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPoint";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "registerPoint";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "doRegisterExtensionPoint";
                break;
            }
            case 25: 
            case 38: 
            case 41: {
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "registerFakeBeanPoint";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "checkThatPointNotDuplicated";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setPoints";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createExtensionPoints";
                break;
            }
            case 37: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionPoint";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionPointIfRegistered";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "processExtensionPoints";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "findExtensionByClass";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtensionPoint";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "hasExtensionPoint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 25: 
            case 38: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

