/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.containers.CollectionFactory;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ExtensionProcessingHelper {
    public static <T> void forEachExtensionSafe(@NotNull Iterable<? extends T> iterable, @NotNull Consumer<? super T> extensionConsumer) {
        if (iterable == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(0);
        }
        if (extensionConsumer == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(1);
        }
        for (T t : iterable) {
            if (t == null) break;
            try {
                extensionConsumer.accept(t);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                ExtensionPointImpl.LOG.error(e);
            }
        }
    }

    @Nullable
    public static <T> T findFirstSafe(@NotNull Predicate<? super T> predicate, @NotNull Iterable<? extends T> iterable) {
        if (predicate == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(2);
        }
        if (iterable == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(3);
        }
        return (T)ExtensionProcessingHelper.computeSafeIfAny(o -> predicate.test(o) ? o : null, iterable);
    }

    @Nullable
    public static <T, R> R computeSafeIfAny(@NotNull Function<? super T, ? extends R> processor, @NotNull Iterable<? extends T> iterable) {
        if (processor == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(4);
        }
        if (iterable == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(5);
        }
        for (T t : iterable) {
            if (t == null) {
                return null;
            }
            try {
                R result = processor.apply(t);
                if (result == null) continue;
                return result;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                ExtensionPointImpl.LOG.error(e);
            }
        }
        return null;
    }

    @NotNull
    public static <K, T> List<T> getByGroupingKey(@NotNull ExtensionPointImpl<T> point, @NotNull Class<?> cacheId, @NotNull K key, @NotNull @NotNull Function<? super @NotNull T, ? extends @Nullable K> keyMapper) {
        List result;
        Map<? extends K, List<T>> prev;
        ConcurrentMap keyMapperToCache;
        Map<K, List<T>> cache;
        if (point == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(6);
        }
        if (cacheId == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(7);
        }
        if (key == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(8);
        }
        if (keyMapper == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(9);
        }
        if ((cache = (Map<K, List<T>>)(keyMapperToCache = point.getCacheMap()).get(cacheId)) == null && (prev = keyMapperToCache.putIfAbsent(cacheId, cache = ExtensionProcessingHelper.buildCacheForGroupingKeyMapper(keyMapper, point))) != null) {
            cache = prev;
        }
        List list = (result = (List)cache.get(key)) == null ? Collections.emptyList() : result;
        if (list == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(10);
        }
        return list;
    }

    @ApiStatus.Internal
    @Nullable
    public static <K, T, V> V getByKey(@NotNull ExtensionPointImpl<T> point, @NotNull K key, @NotNull Class<?> cacheId, @NotNull @NotNull Function<? super @NotNull T, ? extends @Nullable K> keyMapper, @NotNull @NotNull Function<? super @NotNull T, ? extends @Nullable V> valueMapper) {
        if (point == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(11);
        }
        if (key == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(12);
        }
        if (cacheId == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(13);
        }
        if (keyMapper == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(14);
        }
        if (valueMapper == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(15);
        }
        return ExtensionProcessingHelper.doGetByKey(point, cacheId, key, keyMapper, valueMapper, point.getCacheMap());
    }

    @ApiStatus.Internal
    @Nullable
    public static <K, T> T getByKey(@NotNull ExtensionPointImpl<T> point, @NotNull K key, @NotNull Class<?> cacheId, @NotNull @NotNull Function<? super @NotNull T, ? extends @Nullable K> keyMapper) {
        if (point == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(16);
        }
        if (key == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(17);
        }
        if (cacheId == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(18);
        }
        if (keyMapper == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(19);
        }
        return ExtensionProcessingHelper.doGetByKey(point, cacheId, key, keyMapper, Function.identity(), point.getCacheMap());
    }

    @ApiStatus.Internal
    @NotNull
    public static <K, T, V> V computeIfAbsent(@NotNull ExtensionPointImpl<T> point, @NotNull K key, @NotNull Class<?> cacheId, @NotNull Function<? super K, ? extends V> valueProducer) {
        if (point == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(20);
        }
        if (key == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(21);
        }
        if (cacheId == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(22);
        }
        if (valueProducer == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(23);
        }
        ConcurrentMap cache = point.getCacheMap();
        Object object = cache.computeIfAbsent(new AbstractMap.SimpleImmutableEntry(key, cacheId), entry -> valueProducer.apply((Object)entry.getKey()));
        if (object == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(24);
        }
        return (V)object;
    }

    @ApiStatus.Internal
    @NotNull
    public static <T, V> V computeIfAbsent(@NotNull ExtensionPointImpl<T> point, @NotNull Class<?> cacheId, @NotNull Supplier<? extends V> valueProducer) {
        if (point == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(25);
        }
        if (cacheId == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(26);
        }
        if (valueProducer == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(27);
        }
        ConcurrentMap cache = point.getCacheMap();
        Object object = cache.computeIfAbsent(cacheId, __ -> valueProducer.get());
        if (object == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(28);
        }
        return (V)object;
    }

    @Nullable
    private static <CACHE_KEY, K, T, V> V doGetByKey(@NotNull ExtensionPoint<T> point, @NotNull CACHE_KEY cacheId, @NotNull K key, @NotNull Function<? super T, ? extends K> keyMapper, @NotNull @NotNull Function<? super @NotNull T, ? extends @Nullable V> valueMapper, @NotNull ConcurrentMap<CACHE_KEY, Map<K, V>> keyMapperToCache) {
        Map<? extends K, ? extends V> prev;
        Map<K, V> cache;
        if (point == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(29);
        }
        if (cacheId == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(30);
        }
        if (key == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(31);
        }
        if (keyMapper == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(32);
        }
        if (valueMapper == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(33);
        }
        if (keyMapperToCache == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(34);
        }
        if ((cache = (Map<K, V>)keyMapperToCache.get(cacheId)) == null && (prev = keyMapperToCache.putIfAbsent(cacheId, cache = ExtensionProcessingHelper.buildCacheForKeyMapper(keyMapper, valueMapper, point))) != null) {
            cache = prev;
        }
        return cache.get(key);
    }

    @NotNull
    private static <K, T> Map<K, List<T>> buildCacheForGroupingKeyMapper(@NotNull Function<? super T, ? extends K> keyMapper, @NotNull ExtensionPoint<T> point) {
        if (keyMapper == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(35);
        }
        if (point == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(36);
        }
        HashMap<Object, List> cache = new HashMap<Object, List>();
        for (T extension : point.getExtensionList()) {
            K key = keyMapper.apply(extension);
            if (key == null) continue;
            cache.computeIfAbsent(key, k -> new ArrayList()).add(extension);
        }
        HashMap<Object, List> hashMap = cache;
        if (hashMap == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(37);
        }
        return hashMap;
    }

    @NotNull
    private static <K, T, V> Map<K, V> buildCacheForKeyMapper(@NotNull Function<? super T, ? extends K> keyMapper, @NotNull @NotNull Function<? super @NotNull T, ? extends @Nullable V> valueMapper, @NotNull ExtensionPoint<T> point) {
        if (keyMapper == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(38);
        }
        if (valueMapper == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(39);
        }
        if (point == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(40);
        }
        List<T> extensions = point.getExtensionList();
        Map<K, V> cache = CollectionFactory.createSmallMemoryFootprintMap(extensions.size());
        for (T extension : extensions) {
            V value;
            K key = keyMapper.apply(extension);
            if (key == null || (value = valueMapper.apply(extension)) == null) continue;
            cache.put(key, value);
        }
        Map<K, V> map = cache;
        if (map == null) {
            ExtensionProcessingHelper.$$$reportNull$$$0(41);
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 24: 
            case 28: 
            case 37: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 24: 
            case 28: 
            case 37: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionConsumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: 
            case 11: 
            case 16: 
            case 20: 
            case 25: 
            case 29: 
            case 36: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 7: 
            case 13: 
            case 18: 
            case 22: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheId";
                break;
            }
            case 8: 
            case 12: 
            case 17: 
            case 21: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 9: 
            case 14: 
            case 19: 
            case 32: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyMapper";
                break;
            }
            case 10: 
            case 24: 
            case 28: 
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/extensions/impl/ExtensionProcessingHelper";
                break;
            }
            case 15: 
            case 33: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueMapper";
                break;
            }
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueProducer";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyMapperToCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/extensions/impl/ExtensionProcessingHelper";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getByGroupingKey";
                break;
            }
            case 24: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "computeIfAbsent";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCacheForGroupingKeyMapper";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCacheForKeyMapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forEachExtensionSafe";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findFirstSafe";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computeSafeIfAny";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getByGroupingKey";
                break;
            }
            case 10: 
            case 24: 
            case 28: 
            case 37: 
            case 41: {
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getByKey";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "computeIfAbsent";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "doGetByKey";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "buildCacheForGroupingKeyMapper";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "buildCacheForKeyMapper";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 24: 
            case 28: 
            case 37: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

