/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.TextChange;
import com.intellij.openapi.editor.impl.TextChangeImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TextChangesStorage {
    private final List<ChangeEntry> myChanges = new ArrayList<ChangeEntry>();

    @NotNull
    public List<TextChangeImpl> getChanges() {
        if (this.myChanges.isEmpty()) {
            List<TextChangeImpl> list = Collections.emptyList();
            if (list == null) {
                TextChangesStorage.$$$reportNull$$$0(0);
            }
            return list;
        }
        ArrayList<TextChangeImpl> result = new ArrayList<TextChangeImpl>(this.myChanges.size());
        for (ChangeEntry changeEntry : this.myChanges) {
            result.add(changeEntry.change);
        }
        ArrayList<TextChangeImpl> arrayList = result;
        if (arrayList == null) {
            TextChangesStorage.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public List<? extends TextChange> getChanges(int start, int end) {
        assert (start <= end);
        int changeStartIndex = this.getChangeIndex(start);
        if (changeStartIndex < 0) {
            changeStartIndex = -changeStartIndex - 1;
        }
        if (changeStartIndex >= this.myChanges.size()) {
            List list = Collections.emptyList();
            if (list == null) {
                TextChangesStorage.$$$reportNull$$$0(2);
            }
            return list;
        }
        int changeEndIndex = this.getChangeIndex(end);
        boolean endInclusive = true;
        if (changeEndIndex < 0) {
            changeEndIndex = -changeEndIndex - 1;
            endInclusive = false;
        }
        ArrayList<TextChangeImpl> result = null;
        for (int i = changeStartIndex; i <= changeEndIndex && (endInclusive || i != changeEndIndex); ++i) {
            if (result == null) {
                result = new ArrayList<TextChangeImpl>();
            }
            result.add(this.myChanges.get((int)i).change);
        }
        List<Object> list = result == null ? Collections.emptyList() : result;
        if (list == null) {
            TextChangesStorage.$$$reportNull$$$0(3);
        }
        return list;
    }

    public boolean isEmpty() {
        return this.myChanges.isEmpty();
    }

    public void clear() {
        this.myChanges.clear();
    }

    public int size() {
        return this.myChanges.size();
    }

    public void store(@NotNull TextChange change) {
        if (change == null) {
            TextChangesStorage.$$$reportNull$$$0(4);
        }
        if (this.myChanges.isEmpty()) {
            this.myChanges.add(new ChangeEntry(new TextChangeImpl(change.getText(), change.getStart(), change.getEnd()), change.getStart()));
            return;
        }
        ChangeEntry last = this.myChanges.get(this.myChanges.size() - 1);
        if (last.clientStartOffset + last.change.getText().length() < change.getStart()) {
            int clientShift = last.clientStartOffset - last.change.getStart() + last.change.getDiff();
            this.myChanges.add(new ChangeEntry(new TextChangeImpl(change.getText(), change.getStart() - clientShift, change.getEnd() - clientShift), change.getStart()));
            return;
        }
        int insertionIndex = this.doStore(change);
        if (insertionIndex < 0) {
            return;
        }
        this.mergeIfNecessary(insertionIndex);
    }

    private int doStore(@NotNull TextChange change) {
        ChangeEntry changeEntry;
        if (change == null) {
            TextChangesStorage.$$$reportNull$$$0(5);
        }
        int newChangeStart = change.getStart();
        int newChangeEnd = change.getEnd();
        int insertionIndex = this.getChangeIndex(change.getStart());
        int clientShift = 0;
        int changeDiff = change.getText().length() - (change.getEnd() - change.getStart());
        if (insertionIndex < 0) {
            if ((insertionIndex = -insertionIndex - 1) >= this.myChanges.size()) {
                if (!this.myChanges.isEmpty()) {
                    ChangeEntry changeEntry2 = this.myChanges.get(this.myChanges.size() - 1);
                    clientShift = changeEntry2.clientStartOffset - changeEntry2.change.getStart() + changeEntry2.change.getDiff();
                }
                this.myChanges.add(new ChangeEntry(new TextChangeImpl(change.getText(), change.getStart() - clientShift, change.getEnd() - clientShift), change.getStart()));
                return insertionIndex;
            }
            if (insertionIndex > 0) {
                changeEntry = this.myChanges.get(insertionIndex - 1);
                clientShift = changeEntry.clientStartOffset - changeEntry.change.getStart() + changeEntry.change.getDiff();
            }
        } else {
            changeEntry = this.myChanges.get(insertionIndex);
            clientShift = changeEntry.clientStartOffset - changeEntry.change.getStart();
        }
        boolean updateClientOffsetOnly = false;
        for (int i = insertionIndex; i < this.myChanges.size(); ++i) {
            CharSequence adjustedText;
            ChangeEntry changeEntry3 = this.myChanges.get(i);
            int storedClientStart = changeEntry3.change.getStart() + clientShift;
            CharSequence storedText = changeEntry3.change.getText();
            int storedClientEnd = storedClientStart + storedText.length();
            if (!updateClientOffsetOnly && storedClientStart > newChangeEnd) {
                if (changeDiff == 0) break;
                updateClientOffsetOnly = true;
            }
            if (updateClientOffsetOnly) {
                changeEntry3.clientStartOffset += changeDiff;
                continue;
            }
            if (storedClientEnd <= newChangeStart) {
                clientShift += changeEntry3.change.getDiff();
                insertionIndex = i + 1;
                continue;
            }
            if (storedClientStart <= newChangeStart && storedClientEnd >= newChangeEnd) {
                adjustedText = new StringBuilder();
                if (storedClientStart < newChangeStart) {
                    ((StringBuilder)adjustedText).append(storedText.subSequence(0, newChangeStart - storedClientStart));
                }
                ((StringBuilder)adjustedText).append(change.getText());
                if (storedClientEnd > newChangeEnd) {
                    ((StringBuilder)adjustedText).append(storedText.subSequence(newChangeEnd - storedClientStart, storedText.length()));
                }
                if (((StringBuilder)adjustedText).length() == 0 && changeEntry3.change.getStart() == changeEntry3.change.getEnd()) {
                    this.myChanges.remove(i);
                    insertionIndex = -1;
                    updateClientOffsetOnly = true;
                    --i;
                    continue;
                }
                changeEntry3.change = new TextChangeImpl(adjustedText, changeEntry3.change.getStart(), changeEntry3.change.getEnd());
                insertionIndex = -1;
                updateClientOffsetOnly = true;
                continue;
            }
            if (newChangeStart <= storedClientStart && newChangeEnd >= storedClientEnd) {
                this.myChanges.remove(i);
                insertionIndex = i--;
                newChangeEnd -= changeEntry3.change.getDiff();
                continue;
            }
            if (newChangeStart <= storedClientStart && newChangeEnd > storedClientStart) {
                int numberOfStoredChangeSymbolsToRemove = newChangeEnd - storedClientStart;
                CharSequence adjustedText2 = storedText.subSequence(numberOfStoredChangeSymbolsToRemove, storedText.length());
                changeEntry3.change = new TextChangeImpl(adjustedText2, changeEntry3.change.getStart(), changeEntry3.change.getEnd());
                changeEntry3.clientStartOffset += changeDiff + numberOfStoredChangeSymbolsToRemove;
                newChangeEnd -= numberOfStoredChangeSymbolsToRemove;
                insertionIndex = i;
                continue;
            }
            if (newChangeEnd >= storedClientEnd) {
                TextChangeImpl adjusted;
                adjustedText = storedText.subSequence(0, newChangeStart - storedClientStart);
                changeEntry3.change = adjusted = new TextChangeImpl(adjustedText, changeEntry3.change.getStart(), changeEntry3.change.getEnd());
                clientShift += adjusted.getDiff();
                newChangeEnd -= storedClientEnd - newChangeStart;
                insertionIndex = i + 1;
                continue;
            }
            changeEntry3.clientStartOffset += changeDiff;
        }
        if (insertionIndex >= 0) {
            this.myChanges.add(insertionIndex, new ChangeEntry(new TextChangeImpl(change.getText(), newChangeStart - clientShift, newChangeEnd - clientShift), change.getStart()));
        }
        return insertionIndex;
    }

    private void mergeIfNecessary(int insertionIndex) {
        String text;
        ChangeEntry left;
        ChangeEntry toMerge = this.myChanges.get(insertionIndex);
        if (insertionIndex > 0 && (left = this.myChanges.get(insertionIndex - 1)).getClientEndOffset() == toMerge.clientStartOffset && left.change.getEnd() == toMerge.change.getStart()) {
            text = left.change.getText().toString() + toMerge.change.getText();
            left.change = new TextChangeImpl(text, left.change.getStart(), toMerge.change.getEnd());
            this.myChanges.remove(insertionIndex);
            --insertionIndex;
        }
        toMerge = this.myChanges.get(insertionIndex);
        if (insertionIndex < this.myChanges.size() - 1) {
            ChangeEntry right = this.myChanges.get(insertionIndex + 1);
            if (toMerge.getClientEndOffset() == right.clientStartOffset && toMerge.change.getEnd() == right.change.getStart()) {
                text = toMerge.change.getText().toString() + right.change.getText();
                toMerge.change = new TextChangeImpl(text, toMerge.change.getStart(), right.change.getEnd());
                this.myChanges.remove(insertionIndex + 1);
            }
        }
    }

    public char charAt(char @NotNull [] originalData, int index) {
        int changeIndex;
        if (originalData == null) {
            TextChangesStorage.$$$reportNull$$$0(6);
        }
        if ((changeIndex = this.getChangeIndex(index)) >= 0) {
            ChangeEntry changeEntry = this.myChanges.get(changeIndex);
            if (changeEntry.change.getText().length() > index - changeEntry.clientStartOffset) {
                return changeEntry.change.getText().charAt(index - changeEntry.clientStartOffset);
            }
            int originalArrayIndex = index - (changeEntry.clientStartOffset - changeEntry.change.getStart() + changeEntry.change.getDiff());
            return originalData[originalArrayIndex];
        }
        changeIndex = -changeIndex - 1;
        int clientShift = 0;
        if (changeIndex > 0 && changeIndex <= this.myChanges.size()) {
            ChangeEntry changeEntry = this.myChanges.get(changeIndex - 1);
            clientShift = changeEntry.clientStartOffset - changeEntry.change.getStart() + changeEntry.change.getDiff();
        }
        return originalData[index - clientShift];
    }

    public CharSequence substring(char @NotNull [] originalData, int start, int end) {
        ChangeEntry changeEntry;
        int endChangeIndex;
        if (originalData == null) {
            TextChangesStorage.$$$reportNull$$$0(7);
        }
        if (this.myChanges.isEmpty()) {
            return new String(originalData, start, end - start);
        }
        if (end == start) {
            return "";
        }
        int startChangeIndex = this.getChangeIndex(start);
        boolean substringAffectedByChanges = startChangeIndex != (endChangeIndex = this.getChangeIndex(end)) || startChangeIndex >= 0;
        int clientShift = 0;
        int originalStart = 0;
        if (startChangeIndex < 0) {
            if ((startChangeIndex = -startChangeIndex - 1) > 0 && startChangeIndex <= this.myChanges.size()) {
                changeEntry = this.myChanges.get(startChangeIndex - 1);
                clientShift = changeEntry.clientStartOffset - changeEntry.change.getStart() + changeEntry.change.getDiff();
                originalStart = changeEntry.change.getEnd();
            }
        } else {
            changeEntry = this.myChanges.get(startChangeIndex);
            clientShift = changeEntry.clientStartOffset - changeEntry.change.getStart();
        }
        if (!substringAffectedByChanges) {
            return new String(originalData, start - clientShift, end - start);
        }
        char[] data = new char[end - start];
        int outputOffset = 0;
        for (int i = startChangeIndex; i < this.myChanges.size() && outputOffset < data.length; ++i) {
            ChangeEntry changeEntry2 = this.myChanges.get(i);
            int clientStart = changeEntry2.clientStartOffset;
            if (clientStart >= end) {
                if (i == startChangeIndex) {
                    return new String(originalData, start - clientShift, end - start);
                }
                System.arraycopy(originalData, originalStart, data, outputOffset, data.length - outputOffset);
                break;
            }
            int clientEnd = clientStart + changeEntry2.change.getText().length();
            if (clientEnd > start) {
                if (clientStart > start) {
                    int length = Math.min(clientStart - start, changeEntry2.change.getStart() - originalStart);
                    length = Math.min(length, data.length - outputOffset);
                    System.arraycopy(originalData, changeEntry2.change.getStart() - length, data, outputOffset, length);
                    if ((outputOffset += length) >= data.length) break;
                }
                if (clientStart < clientEnd) {
                    int changeTextStartOffset = start <= clientStart ? 0 : start - clientStart;
                    int length = Math.min(clientEnd, end) - Math.max(clientStart, start);
                    CharArrayUtil.getChars(changeEntry2.change.getText(), data, changeTextStartOffset, outputOffset, length);
                    outputOffset += length;
                }
            }
            originalStart = changeEntry2.change.getEnd();
        }
        if (outputOffset < data.length) {
            System.arraycopy(originalData, originalStart, data, outputOffset, data.length - outputOffset);
        }
        return new String(data);
    }

    private int getChangeIndex(int clientOffset) {
        return ObjectUtils.binarySearch(0, this.myChanges.size(), i -> {
            ChangeEntry changeEntry = this.myChanges.get(i);
            if (changeEntry.clientStartOffset > clientOffset) {
                return 1;
            }
            if (changeEntry.clientStartOffset + changeEntry.change.getText().length() < clientOffset) {
                return -1;
            }
            return 0;
        });
    }

    public String toString() {
        return this.myChanges.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/TextChangesStorage";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChanges";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/TextChangesStorage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "store";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doStore";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "charAt";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "substring";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ChangeEntry {
        public TextChangeImpl change;
        public int clientStartOffset;

        ChangeEntry(TextChangeImpl change, int clientStartOffset) {
            this.change = change;
            this.clientStartOffset = clientStartOffset;
        }

        public int getClientEndOffset() {
            return this.clientStartOffset + this.change.getText().length();
        }

        @NonNls
        public String toString() {
            return "client start offset: " + this.clientStartOffset + ", change: " + this.change;
        }
    }
}

