/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.openapi.editor.ex.util.DataStorage;
import com.intellij.openapi.editor.ex.util.SegmentArray;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class ShortBasedStorage
implements DataStorage {
    protected short[] myData;

    public ShortBasedStorage() {
        this.myData = new short[64];
    }

    protected ShortBasedStorage(short[] data) {
        this.myData = data;
    }

    @Override
    public void setData(int segmentIndex, int data) {
        if (segmentIndex >= this.myData.length) {
            this.myData = ArrayUtil.realloc(this.myData, SegmentArray.calcCapacity(this.myData.length, segmentIndex));
        }
        this.myData[segmentIndex] = (short)data;
    }

    @Override
    public void remove(int startIndex, int endIndex, int mySegmentCount) {
        if (endIndex < mySegmentCount) {
            System.arraycopy(this.myData, endIndex, this.myData, startIndex, mySegmentCount - endIndex);
        }
    }

    @Override
    public void replace(DataStorage storage, int startOffset, int len) {
        assert (storage instanceof ShortBasedStorage);
        System.arraycopy(((ShortBasedStorage)storage).myData, 0, this.myData, startOffset, len);
    }

    @Override
    public void insert(DataStorage storageToInsert, int startIndex, int segmentCountToInsert, int segmentCount) {
        assert (storageToInsert instanceof ShortBasedStorage);
        this.myData = ShortBasedStorage.insert(this.myData, ((ShortBasedStorage)storageToInsert).myData, startIndex, segmentCountToInsert, segmentCount);
    }

    @Override
    public int getData(int index) {
        return this.myData[index];
    }

    @Override
    public int packData(IElementType tokenType, int state, boolean isRestartableState) {
        short idx = tokenType.getIndex();
        return isRestartableState ? idx : -idx;
    }

    @Override
    public int unpackStateFromData(int data) {
        throw new UnsupportedOperationException("Unable to unpack state, state is not stored in ShortBasedStorage");
    }

    @Override
    public IElementType unpackTokenFromData(int data) {
        return IElementType.find((short)Math.abs(data));
    }

    @Override
    public DataStorage copy() {
        return new ShortBasedStorage(this.myData);
    }

    @Override
    public DataStorage createStorage() {
        return new ShortBasedStorage();
    }

    protected static short @NotNull [] insert(short @NotNull [] array, short @NotNull [] insertArray, int startIndex, int insertLength, int mySegmentCount) {
        if (array == null) {
            ShortBasedStorage.$$$reportNull$$$0(0);
        }
        if (insertArray == null) {
            ShortBasedStorage.$$$reportNull$$$0(1);
        }
        short[] newArray = ShortBasedStorage.reallocateArray(array, mySegmentCount + insertLength);
        if (startIndex < mySegmentCount) {
            System.arraycopy(newArray, startIndex, newArray, startIndex + insertLength, mySegmentCount - startIndex);
        }
        System.arraycopy(insertArray, 0, newArray, startIndex, insertLength);
        if (newArray == null) {
            ShortBasedStorage.$$$reportNull$$$0(2);
        }
        return newArray;
    }

    protected static short @NotNull [] reallocateArray(short @NotNull [] array, int index) {
        if (array == null) {
            ShortBasedStorage.$$$reportNull$$$0(3);
        }
        if (index < array.length) {
            if (array == null) {
                ShortBasedStorage.$$$reportNull$$$0(4);
            }
            return array;
        }
        short[] sArray = ArrayUtil.realloc(array, SegmentArray.calcCapacity(array.length, index));
        if (sArray == null) {
            ShortBasedStorage.$$$reportNull$$$0(5);
        }
        return sArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertArray";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/ex/util/ShortBasedStorage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/ex/util/ShortBasedStorage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "insert";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "reallocateArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "insert";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reallocateArray";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

