/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.IdeUrlTrackingParametersProvider;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.ex.ProgressSlide;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.XmlElement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ApplicationInfoImpl
extends ApplicationInfoEx {
    public static final String DEFAULT_PLUGINS_HOST = "https://plugins.jetbrains.com";
    static final String IDEA_PLUGINS_HOST_PROPERTY = "idea.plugins.host";
    private static volatile ApplicationInfoImpl instance;
    private String myCodeName;
    private String myMajorVersion;
    private String myMinorVersion;
    private String myMicroVersion;
    private String myPatchVersion;
    private String myFullVersionFormat;
    private String myBuildNumber;
    private String myApiVersion;
    private String myVersionSuffix;
    private String myCompanyName;
    private String myCopyrightStart;
    private String myShortCompanyName;
    private String myCompanyUrl;
    private long myProgressColor;
    private long myCopyrightForeground;
    private long myAboutForeground;
    private long myAboutLinkColor;
    private int[] myAboutLogoRect;
    private String myProgressTailIconName;
    private int myProgressHeight;
    private int myProgressY;
    private String mySplashImageUrl;
    private String myAboutImageUrl;
    private String myIconUrl;
    private String mySmallIconUrl;
    private String myBigIconUrl;
    private String mySvgIconUrl;
    private String mySvgEapIconUrl;
    private String mySmallSvgIconUrl;
    private String mySmallSvgEapIconUrl;
    private String myToolWindowIconUrl;
    private String myWelcomeScreenLogoUrl;
    private Calendar myBuildDate;
    private Calendar myMajorReleaseBuildDate;
    private boolean myShowLicensee;
    private String myWelcomeScreenDialog;
    private ApplicationInfoEx.UpdateUrls myUpdateUrls;
    private String myDocumentationUrl;
    private String mySupportUrl;
    private String myYoutrackUrl;
    private String myFeedbackUrl;
    private String myPluginManagerUrl;
    private String myPluginsListUrl;
    private String myChannelsListUrl;
    private String myPluginsDownloadUrl;
    private String myBuiltinPluginsUrl;
    private String myWhatsNewUrl;
    private int myWhatsNewEligibility;
    private String myWinKeymapUrl;
    private String myMacKeymapUrl;
    private boolean myEAP;
    private boolean myHasHelp;
    private boolean myHasContextHelp;
    private String myWebHelpUrl;
    private final List<PluginId> essentialPluginsIds;
    private String myEventLogSettingsUrl;
    private String myJetBrainsTvUrl;
    private String myEvalLicenseUrl;
    private String myKeyConversionUrl;
    private String mySubscriptionFormId;
    private String mySubscriptionNewsKey;
    private String mySubscriptionNewsValue;
    private String mySubscriptionTipsKey;
    private boolean mySubscriptionTipsAvailable;
    private String mySubscriptionAdditionalFormData;
    private List<ProgressSlide> progressSlides;
    private String myDefaultLightLaf;
    private String myDefaultDarkLaf;

    private ApplicationInfoImpl() {
        this(ApplicationNamesInfo.initAndGetRawData());
    }

    @NonInjectable
    ApplicationInfoImpl(@NotNull XmlElement element) {
        if (element == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(0);
        }
        this.myCompanyName = "JetBrains s.r.o.";
        this.myCopyrightStart = "2000";
        this.myCompanyUrl = "https://www.jetbrains.com/";
        this.myProgressColor = -1L;
        this.myCopyrightForeground = -1L;
        this.myAboutForeground = -1L;
        this.myAboutLinkColor = -1L;
        this.myProgressHeight = 2;
        this.myProgressY = 350;
        this.myIconUrl = "/icon.png";
        this.mySmallIconUrl = "/icon_small.png";
        this.myToolWindowIconUrl = "/toolwindows/toolWindowProject.svg";
        this.myShowLicensee = true;
        this.myHasHelp = true;
        this.myHasContextHelp = true;
        this.myWebHelpUrl = "https://www.jetbrains.com/idea/webhelp/";
        this.essentialPluginsIds = new ArrayList<PluginId>();
        this.myEventLogSettingsUrl = "https://resources.jetbrains.com/storage/fus/config/v4/%s/%s.json";
        this.myEvalLicenseUrl = "https://www.jetbrains.com/store/license.html";
        this.myKeyConversionUrl = "https://www.jetbrains.com/shop/eform/keys-exchange";
        this.progressSlides = Collections.emptyList();
        block58: for (XmlElement child : element.children) {
            switch (child.name) {
                case "version": {
                    this.myMajorVersion = child.getAttributeValue("major");
                    this.myMinorVersion = child.getAttributeValue("minor");
                    this.myMicroVersion = child.getAttributeValue("micro");
                    this.myPatchVersion = child.getAttributeValue("patch");
                    this.myFullVersionFormat = child.getAttributeValue("full");
                    this.myCodeName = child.getAttributeValue("codename");
                    this.myEAP = Boolean.parseBoolean(child.getAttributeValue("eap"));
                    this.myVersionSuffix = child.getAttributeValue("suffix");
                    if (this.myVersionSuffix != null || !this.myEAP) break;
                    this.myVersionSuffix = "EAP";
                    break;
                }
                case "company": {
                    this.myCompanyName = child.getAttributeValue("name", this.myCompanyName);
                    this.myShortCompanyName = child.getAttributeValue("shortName", this.myCompanyName == null ? null : ApplicationInfoImpl.shortenCompanyName(this.myCompanyName));
                    this.myCompanyUrl = child.getAttributeValue("url", this.myCompanyUrl);
                    this.myCopyrightStart = child.getAttributeValue("copyrightStart", this.myCopyrightStart);
                    break;
                }
                case "build": {
                    this.readBuildInfo(child);
                    break;
                }
                case "logo": {
                    this.readLogoInfo(child);
                    break;
                }
                case "about": {
                    String c;
                    this.myAboutImageUrl = child.getAttributeValue("url");
                    String v = child.getAttributeValue("foreground");
                    if (v != null) {
                        this.myAboutForeground = ApplicationInfoImpl.parseColor(v);
                    }
                    if ((v = child.getAttributeValue("copyrightForeground")) != null) {
                        this.myCopyrightForeground = ApplicationInfoImpl.parseColor(v);
                    }
                    if ((c = child.getAttributeValue("linkColor")) != null) {
                        this.myAboutLinkColor = ApplicationInfoImpl.parseColor(c);
                    }
                    String logoX = child.getAttributeValue("logoX");
                    String logoY = child.getAttributeValue("logoY");
                    String logoW = child.getAttributeValue("logoW");
                    String logoH = child.getAttributeValue("logoH");
                    if (logoX == null || logoY == null || logoW == null || logoH == null) continue block58;
                    try {
                        this.myAboutLogoRect = new int[]{Integer.parseInt(logoX), Integer.parseInt(logoY), Integer.parseInt(logoW), Integer.parseInt(logoH)};
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                case "icon": {
                    this.myIconUrl = child.getAttributeValue("size32");
                    this.mySmallIconUrl = child.getAttributeValue("size16", this.mySmallIconUrl);
                    this.myBigIconUrl = ApplicationInfoImpl.getAttributeValue(child, "size128");
                    String toolWindowIcon = ApplicationInfoImpl.getAttributeValue(child, "size12");
                    if (toolWindowIcon != null) {
                        this.myToolWindowIconUrl = toolWindowIcon;
                    }
                    this.mySvgIconUrl = child.getAttributeValue("svg");
                    this.mySmallSvgIconUrl = child.getAttributeValue("svg-small");
                    break;
                }
                case "icon-eap": {
                    this.mySvgEapIconUrl = child.getAttributeValue("svg");
                    this.mySmallSvgEapIconUrl = child.getAttributeValue("svg-small");
                    break;
                }
                case "licensee": {
                    this.myShowLicensee = Boolean.parseBoolean(child.getAttributeValue("show"));
                    break;
                }
                case "welcome-screen": {
                    this.myWelcomeScreenLogoUrl = child.getAttributeValue("logo-url");
                    break;
                }
                case "welcome-wizard": {
                    this.myWelcomeScreenDialog = ApplicationInfoImpl.getAttributeValue(child, "dialog");
                    break;
                }
                case "help": {
                    String attValue;
                    String webHelpUrl = ApplicationInfoImpl.getAttributeValue(child, "webhelp-url");
                    if (webHelpUrl != null) {
                        this.myWebHelpUrl = webHelpUrl;
                    }
                    this.myHasHelp = (attValue = child.getAttributeValue("has-help")) == null || Boolean.parseBoolean(attValue);
                    attValue = child.getAttributeValue("has-context-help");
                    this.myHasContextHelp = attValue == null || Boolean.parseBoolean(attValue);
                    break;
                }
                case "update-urls": {
                    this.myUpdateUrls = new UpdateUrlsImpl(child);
                    break;
                }
                case "documentation": {
                    this.myDocumentationUrl = child.getAttributeValue("url");
                    break;
                }
                case "support": {
                    this.mySupportUrl = child.getAttributeValue("url");
                    break;
                }
                case "youtrack": {
                    this.myYoutrackUrl = child.getAttributeValue("url");
                    break;
                }
                case "feedback": {
                    this.myFeedbackUrl = child.getAttributeValue("url");
                    break;
                }
                case "whatsnew": {
                    this.myWhatsNewUrl = child.getAttributeValue("url");
                    String eligibility = child.getAttributeValue("eligibility");
                    if ("embed".equals(eligibility)) {
                        this.myWhatsNewEligibility = 1;
                        break;
                    }
                    if (!"auto".equals(eligibility)) continue block58;
                    this.myWhatsNewEligibility = 2;
                    break;
                }
                case "plugins": {
                    this.readPluginInfo(child);
                    break;
                }
                case "keymap": {
                    this.myWinKeymapUrl = child.getAttributeValue("win");
                    this.myMacKeymapUrl = child.getAttributeValue("mac");
                    break;
                }
                case "essential-plugin": {
                    String id = child.content;
                    if (id == null || id.isEmpty()) continue block58;
                    this.essentialPluginsIds.add(PluginId.getId(id));
                    break;
                }
                case "statistics": {
                    this.myEventLogSettingsUrl = child.getAttributeValue("event-log-settings");
                    break;
                }
                case "jetbrains-tv": {
                    this.myJetBrainsTvUrl = child.getAttributeValue("url");
                    break;
                }
                case "evaluation": {
                    String url = ApplicationInfoImpl.getAttributeValue(child, "license-url");
                    if (url == null) continue block58;
                    this.myEvalLicenseUrl = url.trim();
                    break;
                }
                case "licensing": {
                    String url = ApplicationInfoImpl.getAttributeValue(child, "key-conversion-url");
                    if (url == null) continue block58;
                    this.myKeyConversionUrl = url.trim();
                    break;
                }
                case "subscriptions": {
                    this.mySubscriptionFormId = child.getAttributeValue("formid");
                    this.mySubscriptionNewsKey = child.getAttributeValue("news-key");
                    this.mySubscriptionNewsValue = child.getAttributeValue("news-value", "yes");
                    this.mySubscriptionTipsKey = child.getAttributeValue("tips-key");
                    this.mySubscriptionTipsAvailable = Boolean.parseBoolean(child.getAttributeValue("tips-available"));
                    this.mySubscriptionAdditionalFormData = child.getAttributeValue("additional-form-data");
                    break;
                }
                case "default-laf": {
                    String laf = ApplicationInfoImpl.getAttributeValue(child, "light");
                    if (laf != null) {
                        this.myDefaultLightLaf = laf.trim();
                    }
                    if ((laf = ApplicationInfoImpl.getAttributeValue(child, "dark")) == null) break;
                    this.myDefaultDarkLaf = laf.trim();
                }
            }
        }
        this.essentialPluginsIds.sort(null);
    }

    private void readLogoInfo(@NotNull XmlElement element) {
        if (element == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(1);
        }
        this.mySplashImageUrl = ApplicationInfoImpl.getAttributeValue(element, "url");
        String v = element.getAttributeValue("progressColor");
        if (v != null && !v.isEmpty()) {
            this.myProgressColor = ApplicationInfoImpl.parseColor(v);
        }
        if ((v = element.getAttributeValue("progressTailIcon")) != null && !v.isEmpty()) {
            this.myProgressTailIconName = v;
        }
        if ((v = element.getAttributeValue("progressHeight")) != null && !v.isEmpty()) {
            this.myProgressHeight = Integer.parseInt(v);
        }
        if ((v = element.getAttributeValue("progressY")) != null && !v.isEmpty()) {
            this.myProgressY = Integer.parseInt(v);
        }
        if (!element.children.isEmpty()) {
            this.progressSlides = new ArrayList<ProgressSlide>(element.children.size());
            for (XmlElement child : element.children) {
                if (!child.name.equals("progressSlide")) continue;
                String slideUrl = Objects.requireNonNull(child.getAttributeValue("url"));
                String progressPercent = Objects.requireNonNull(child.getAttributeValue("progressPercent"));
                int progressPercentInt = Integer.parseInt(progressPercent);
                if (progressPercentInt < 0 || progressPercentInt > 100) {
                    throw new IllegalArgumentException("Expected [0, 100], got " + progressPercent);
                }
                float progressPercentFloat = (float)progressPercentInt / 100.0f;
                this.progressSlides.add(new ProgressSlide(slideUrl, progressPercentFloat));
            }
        }
    }

    @NotNull
    public static ApplicationInfoEx getShadowInstance() {
        return ApplicationInfoImpl.getShadowInstanceImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NotNull
    public static ApplicationInfoImpl getShadowInstanceImpl() {
        ApplicationInfoImpl result = instance;
        if (result != null) {
            ApplicationInfoImpl applicationInfoImpl = result;
            if (applicationInfoImpl == null) {
                ApplicationInfoImpl.$$$reportNull$$$0(2);
            }
            return applicationInfoImpl;
        }
        Class<ApplicationInfoImpl> clazz = ApplicationInfoImpl.class;
        synchronized (ApplicationInfoImpl.class) {
            result = instance;
            if (result == null) {
                Activity activity = StartUpMeasurer.startActivity("app info loading", ActivityCategory.DEFAULT);
                try {
                    instance = result = new ApplicationInfoImpl(ApplicationNamesInfo.initAndGetRawData());
                }
                finally {
                    activity.end();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            ApplicationInfoImpl applicationInfoImpl = result;
            if (applicationInfoImpl == null) {
                ApplicationInfoImpl.$$$reportNull$$$0(3);
            }
            return applicationInfoImpl;
        }
    }

    @NotNull
    public static String orFromPluginsCompatibleBuild(@Nullable BuildNumber buildNumber) {
        BuildNumber number = buildNumber != null ? buildNumber : ApplicationInfoImpl.getShadowInstanceImpl().getPluginsCompatibleBuildAsNumber();
        String string = number.asString();
        if (string == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public Calendar getBuildDate() {
        if (this.myBuildDate == null) {
            this.myBuildDate = Calendar.getInstance();
        }
        return this.myBuildDate;
    }

    @Override
    public Calendar getMajorReleaseBuildDate() {
        return this.myMajorReleaseBuildDate != null ? this.myMajorReleaseBuildDate : this.myBuildDate;
    }

    @Override
    @NotNull
    public BuildNumber getBuild() {
        BuildNumber buildNumber = Objects.requireNonNull(BuildNumber.fromString(this.myBuildNumber));
        if (buildNumber == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(5);
        }
        return buildNumber;
    }

    @Override
    @NotNull
    public String getApiVersion() {
        String string = this.getApiVersionAsNumber().asString();
        if (string == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public BuildNumber getApiVersionAsNumber() {
        BuildNumber api;
        BuildNumber build = this.getBuild();
        if (this.myApiVersion != null && (api = ApplicationInfoImpl.fromStringWithProductCode(this.myApiVersion, build)) != null) {
            BuildNumber buildNumber = api;
            if (buildNumber == null) {
                ApplicationInfoImpl.$$$reportNull$$$0(7);
            }
            return buildNumber;
        }
        BuildNumber buildNumber = build;
        if (buildNumber == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(8);
        }
        return buildNumber;
    }

    @Override
    public String getMajorVersion() {
        return this.myMajorVersion;
    }

    @Override
    public String getMinorVersion() {
        return this.myMinorVersion;
    }

    @Override
    public String getMicroVersion() {
        return this.myMicroVersion;
    }

    @Override
    public String getPatchVersion() {
        return this.myPatchVersion;
    }

    @Override
    @NotNull
    public String getFullVersion() {
        String result = this.myFullVersionFormat != null ? MessageFormat.format(this.myFullVersionFormat, this.myMajorVersion, this.myMinorVersion, this.myMicroVersion, this.myPatchVersion) : ApplicationInfoImpl.requireNonNullElse(this.myMajorVersion) + '.' + ApplicationInfoImpl.requireNonNullElse(this.myMinorVersion);
        if (this.myVersionSuffix != null && !this.myVersionSuffix.isEmpty()) {
            result = result + " " + this.myVersionSuffix;
        }
        String string = result;
        if (string == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @NotNull
    public String getStrictVersion() {
        String string = this.myMajorVersion + "." + this.myMinorVersion + "." + ApplicationInfoImpl.requireNonNullElse(this.myMicroVersion) + "." + ApplicationInfoImpl.requireNonNullElse(this.myPatchVersion);
        if (string == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    public String getVersionName() {
        String fullName = ApplicationNamesInfo.getInstance().getFullProductName();
        if (this.myEAP && this.myCodeName != null && !this.myCodeName.isEmpty()) {
            fullName = fullName + " (" + this.myCodeName + ")";
        }
        return fullName;
    }

    @Override
    public String getShortCompanyName() {
        return this.myShortCompanyName;
    }

    @Override
    public String getCompanyName() {
        return this.myCompanyName;
    }

    @Override
    public String getCompanyURL() {
        return IdeUrlTrackingParametersProvider.getInstance().augmentUrl(this.myCompanyUrl);
    }

    @Override
    public String getSplashImageUrl() {
        return this.mySplashImageUrl;
    }

    @Override
    public String getAboutImageUrl() {
        return this.myAboutImageUrl;
    }

    @Override
    public long getProgressColor() {
        return this.myProgressColor;
    }

    @Override
    public long getCopyrightForeground() {
        return this.myCopyrightForeground;
    }

    @Override
    public int getProgressHeight() {
        return this.myProgressHeight;
    }

    @Override
    public int getProgressY() {
        return this.myProgressY;
    }

    @Override
    @Nullable
    public String getProgressTailIcon() {
        return this.myProgressTailIconName;
    }

    @Override
    public String getIconUrl() {
        return this.myIconUrl;
    }

    @Override
    @NotNull
    public String getSmallIconUrl() {
        String string = this.mySmallIconUrl;
        if (string == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    @Nullable
    public String getBigIconUrl() {
        return this.myBigIconUrl;
    }

    @Override
    @Nullable
    public String getApplicationSvgIconUrl() {
        return this.isEAP() && this.mySvgEapIconUrl != null ? this.mySvgEapIconUrl : this.mySvgIconUrl;
    }

    @Override
    @Nullable
    public String getSmallApplicationSvgIconUrl() {
        return this.getSmallApplicationSvgIconUrl(this.isEAP());
    }

    @Nullable
    public String getSmallApplicationSvgIconUrl(boolean isEap) {
        return isEap && this.mySmallSvgEapIconUrl != null ? this.mySmallSvgEapIconUrl : this.mySmallSvgIconUrl;
    }

    @Override
    public String getToolWindowIconUrl() {
        return this.myToolWindowIconUrl;
    }

    @Override
    @Nullable
    public String getWelcomeScreenLogoUrl() {
        return this.myWelcomeScreenLogoUrl;
    }

    @Override
    @Nullable
    public String getWelcomeWizardDialog() {
        return this.myWelcomeScreenDialog;
    }

    @Override
    public String getPackageCode() {
        return null;
    }

    @Override
    public boolean isEAP() {
        return this.myEAP;
    }

    @Override
    public boolean isMajorEAP() {
        return this.myEAP && (this.myMinorVersion == null || this.myMinorVersion.indexOf(46) < 0);
    }

    @Override
    @Nullable
    public ApplicationInfoEx.UpdateUrls getUpdateUrls() {
        return this.myUpdateUrls;
    }

    @Override
    public String getDocumentationUrl() {
        return this.myDocumentationUrl;
    }

    @Override
    public String getSupportUrl() {
        return this.mySupportUrl;
    }

    @Override
    public String getYoutrackUrl() {
        return this.myYoutrackUrl;
    }

    @Override
    public String getFeedbackUrl() {
        return this.myFeedbackUrl;
    }

    @Override
    public String getPluginManagerUrl() {
        return this.myPluginManagerUrl;
    }

    @Override
    public boolean usesJetBrainsPluginRepository() {
        return DEFAULT_PLUGINS_HOST.equalsIgnoreCase(this.myPluginManagerUrl);
    }

    @Override
    public String getPluginsListUrl() {
        return this.myPluginsListUrl;
    }

    @Override
    public String getChannelsListUrl() {
        return this.myChannelsListUrl;
    }

    @Override
    public String getPluginsDownloadUrl() {
        return this.myPluginsDownloadUrl;
    }

    @Override
    public String getBuiltinPluginsUrl() {
        return this.myBuiltinPluginsUrl;
    }

    @Override
    public String getWebHelpUrl() {
        return this.myWebHelpUrl;
    }

    @Override
    public boolean hasHelp() {
        return this.myHasHelp;
    }

    @Override
    public boolean hasContextHelp() {
        return this.myHasContextHelp;
    }

    @Override
    public String getWhatsNewUrl() {
        return this.myWhatsNewUrl;
    }

    @Override
    public boolean isWhatsNewEligibleFor(int role) {
        return this.myWhatsNewEligibility >= role;
    }

    @Override
    public String getWinKeymapUrl() {
        return this.myWinKeymapUrl;
    }

    @Override
    public String getMacKeymapUrl() {
        return this.myMacKeymapUrl;
    }

    @Override
    public long getAboutForeground() {
        return this.myAboutForeground;
    }

    @Override
    public long getAboutLinkColor() {
        return this.myAboutLinkColor;
    }

    @Override
    public String getFullApplicationName() {
        return this.getVersionName() + " " + this.getFullVersion();
    }

    @Override
    public boolean showLicenseeInfo() {
        return this.myShowLicensee;
    }

    @Override
    public String getCopyrightStart() {
        return this.myCopyrightStart;
    }

    public String getEventLogSettingsUrl() {
        return this.myEventLogSettingsUrl;
    }

    @Override
    public String getJetBrainsTvUrl() {
        return this.myJetBrainsTvUrl;
    }

    @Override
    public String getEvalLicenseUrl() {
        return this.myEvalLicenseUrl;
    }

    @Override
    public String getKeyConversionUrl() {
        return this.myKeyConversionUrl;
    }

    @Override
    public int @Nullable [] getAboutLogoRect() {
        return this.myAboutLogoRect;
    }

    @Override
    public String getSubscriptionFormId() {
        return this.mySubscriptionFormId;
    }

    @Override
    public String getSubscriptionNewsKey() {
        return this.mySubscriptionNewsKey;
    }

    @Override
    public String getSubscriptionNewsValue() {
        return this.mySubscriptionNewsValue;
    }

    @Override
    public String getSubscriptionTipsKey() {
        return this.mySubscriptionTipsKey;
    }

    @Override
    public boolean areSubscriptionTipsAvailable() {
        return this.mySubscriptionTipsAvailable;
    }

    @Override
    @Nullable
    public String getSubscriptionAdditionalFormData() {
        return this.mySubscriptionAdditionalFormData;
    }

    @Override
    @NotNull
    public List<ProgressSlide> getProgressSlides() {
        List<ProgressSlide> list = this.progressSlides;
        if (list == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    @NlsSafe
    public String getPluginsCompatibleBuild() {
        String string = this.getPluginsCompatibleBuildAsNumber().asString();
        if (string == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public BuildNumber getPluginsCompatibleBuildAsNumber() {
        @Nullable BuildNumber compatibleBuild = BuildNumber.fromPluginsCompatibleBuild();
        BuildNumber version = compatibleBuild != null ? compatibleBuild : this.getApiVersionAsNumber();
        BuildNumber buildNumber = ApplicationInfoImpl.fromStringWithProductCode(version.asString(), this.getBuild());
        BuildNumber buildNumber2 = Objects.requireNonNull(buildNumber);
        if (buildNumber2 == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(14);
        }
        return buildNumber2;
    }

    @Nullable
    private static BuildNumber fromStringWithProductCode(@NotNull String version, @NotNull BuildNumber buildNumber) {
        if (version == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(15);
        }
        if (buildNumber == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(16);
        }
        return BuildNumber.fromStringWithProductCode(version, buildNumber.getProductCode());
    }

    @Nullable
    private static String getAttributeValue(@NotNull XmlElement element, @NotNull String name) {
        String value;
        if (element == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(17);
        }
        if (name == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(18);
        }
        return (value = element.getAttributeValue(name)) == null || value.isEmpty() ? null : value;
    }

    private void readBuildInfo(@NotNull XmlElement element) {
        String majorReleaseDateString;
        if (element == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(19);
        }
        this.myBuildNumber = ApplicationInfoImpl.getAttributeValue(element, "number");
        this.myApiVersion = ApplicationInfoImpl.getAttributeValue(element, "apiVersion");
        String dateString = element.getAttributeValue("date");
        if (dateString != null && !dateString.equals("__BUILD_DATE__")) {
            this.myBuildDate = ApplicationInfoImpl.parseDate(dateString);
        }
        if ((majorReleaseDateString = element.getAttributeValue("majorReleaseDate")) != null) {
            this.myMajorReleaseBuildDate = ApplicationInfoImpl.parseDate(majorReleaseDateString);
        }
    }

    private void readPluginInfo(@Nullable XmlElement element) {
        String pluginsHost;
        String pluginManagerUrl = DEFAULT_PLUGINS_HOST;
        String pluginsListUrl = null;
        this.myChannelsListUrl = null;
        this.myPluginsDownloadUrl = null;
        if (element != null) {
            String builtinPluginsUrl;
            String downloadUrl;
            String channelListUrl;
            String listUrl;
            String url = element.getAttributeValue("url");
            if (url != null) {
                String string = pluginManagerUrl = url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
            }
            if ((listUrl = element.getAttributeValue("list-url")) != null) {
                pluginsListUrl = listUrl;
            }
            if ((channelListUrl = element.getAttributeValue("channel-list-url")) != null) {
                this.myChannelsListUrl = channelListUrl;
            }
            if ((downloadUrl = element.getAttributeValue("download-url")) != null) {
                this.myPluginsDownloadUrl = downloadUrl;
            }
            if ((builtinPluginsUrl = element.getAttributeValue("builtin-url")) != null && !builtinPluginsUrl.isEmpty()) {
                this.myBuiltinPluginsUrl = builtinPluginsUrl;
            }
        }
        if ((pluginsHost = System.getProperty(IDEA_PLUGINS_HOST_PROPERTY)) != null) {
            pluginManagerUrl = pluginsHost.endsWith("/") ? pluginsHost.substring(0, pluginsHost.length() - 1) : pluginsHost;
            this.myPluginsDownloadUrl = null;
            this.myChannelsListUrl = null;
            pluginsListUrl = null;
        }
        this.myPluginManagerUrl = pluginManagerUrl;
        String string = this.myPluginsListUrl = pluginsListUrl == null ? pluginManagerUrl + "/plugins/list/" : pluginsListUrl;
        if (this.myChannelsListUrl == null) {
            this.myChannelsListUrl = pluginManagerUrl + "/channels/list/";
        }
        if (this.myPluginsDownloadUrl == null) {
            this.myPluginsDownloadUrl = pluginManagerUrl + "/pluginManager/";
        }
    }

    private static String shortenCompanyName(@NotNull String name) {
        if (name == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(20);
        }
        if (name.endsWith(" s.r.o.")) {
            name = name.substring(0, name.length() - " s.r.o.".length());
        }
        if (name.endsWith(" Inc.")) {
            name = name.substring(0, name.length() - " Inc.".length());
        }
        return name;
    }

    @NotNull
    private static GregorianCalendar parseDate(@NotNull String dateString) {
        if (dateString == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(21);
        }
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        try {
            calendar.set(1, Integer.parseInt(dateString.substring(0, 4)));
            calendar.set(2, Integer.parseInt(dateString.substring(4, 6)) - 1);
            calendar.set(5, Integer.parseInt(dateString.substring(6, 8)));
            if (dateString.length() > 8) {
                calendar.set(11, Integer.parseInt(dateString.substring(8, 10)));
                calendar.set(12, Integer.parseInt(dateString.substring(10, 12)));
            } else {
                calendar.set(11, 0);
                calendar.set(12, 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        GregorianCalendar gregorianCalendar = calendar;
        if (gregorianCalendar == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(22);
        }
        return gregorianCalendar;
    }

    private static long parseColor(@NotNull String colorString) {
        if (colorString == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(23);
        }
        return Long.parseLong(colorString, 16);
    }

    private static String requireNonNullElse(String s) {
        return s != null ? s : "0";
    }

    @Override
    public boolean isEssentialPlugin(@NotNull String pluginId) {
        if (pluginId == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(24);
        }
        return "com.intellij".equals(pluginId) || this.isEssentialPlugin(PluginId.getId(pluginId));
    }

    @Override
    public boolean isEssentialPlugin(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(25);
        }
        return PluginManagerCore.CORE_ID.equals(pluginId) || Collections.binarySearch(this.essentialPluginsIds, pluginId) >= 0;
    }

    @Override
    @NotNull
    public List<PluginId> getEssentialPluginsIds() {
        List<PluginId> list = this.essentialPluginsIds;
        if (list == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(26);
        }
        return list;
    }

    @Override
    @Nullable
    public String getDefaultLightLaf() {
        return this.myDefaultLightLaf;
    }

    @Override
    @Nullable
    public String getDefaultDarkLaf() {
        return this.myDefaultDarkLaf;
    }

    @Deprecated
    public static boolean isInStressTest() {
        return ApplicationManagerEx.isInStressTest();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 22: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 22: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/impl/ApplicationInfoImpl";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildNumber";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dateString";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorString";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/impl/ApplicationInfoImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShadowInstanceImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "orFromPluginsCompatibleBuild";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuild";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getApiVersion";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getApiVersionAsNumber";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullVersion";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getStrictVersion";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSmallIconUrl";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgressSlides";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsCompatibleBuild";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsCompatibleBuildAsNumber";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "parseDate";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getEssentialPluginsIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readLogoInfo";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 22: 
            case 26: {
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "fromStringWithProductCode";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeValue";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "readBuildInfo";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "shortenCompanyName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "parseDate";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "parseColor";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isEssentialPlugin";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 22: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class UpdateUrlsImpl
    implements ApplicationInfoEx.UpdateUrls {
        private final String myCheckingUrl;
        private final String myPatchesUrl;

        private UpdateUrlsImpl(@NotNull XmlElement element) {
            if (element == null) {
                UpdateUrlsImpl.$$$reportNull$$$0(0);
            }
            this.myCheckingUrl = element.getAttributeValue("check");
            this.myPatchesUrl = element.getAttributeValue("patches");
        }

        @Override
        public String getCheckingUrl() {
            return this.myCheckingUrl;
        }

        @Override
        public String getPatchesUrl() {
            return this.myPatchesUrl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/application/impl/ApplicationInfoImpl$UpdateUrlsImpl", "<init>"));
        }
    }
}

