/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.util.text.Strings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PathManager {
    public static final String PROPERTIES_FILE = "idea.properties.file";
    public static final String PROPERTIES_FILE_NAME = "idea.properties";
    public static final String PROPERTY_HOME_PATH = "idea.home.path";
    public static final String PROPERTY_CONFIG_PATH = "idea.config.path";
    public static final String PROPERTY_SYSTEM_PATH = "idea.system.path";
    public static final String PROPERTY_SCRATCH_PATH = "idea.scratch.path";
    public static final String PROPERTY_PLUGINS_PATH = "idea.plugins.path";
    public static final String PROPERTY_LOG_PATH = "idea.log.path";
    public static final String PROPERTY_LOG_CONFIG_FILE = "idea.log.config.file";
    public static final String PROPERTY_PATHS_SELECTOR = "idea.paths.selector";
    public static final String OPTIONS_DIRECTORY = "options";
    public static final String DEFAULT_EXT = ".xml";
    private static final String PROPERTY_HOME = "idea.home";
    private static final String PROPERTY_VENDOR_NAME = "idea.vendor.name";
    private static final String JRE_DIRECTORY = "jbr";
    private static final String LIB_DIRECTORY = "lib";
    private static final String PLUGINS_DIRECTORY = "plugins";
    private static final String BIN_DIRECTORY = "bin";
    private static final String LOG_DIRECTORY = "log";
    private static final String CONFIG_DIRECTORY = "config";
    private static final String SYSTEM_DIRECTORY = "system";
    private static final String PATHS_SELECTOR = System.getProperty("idea.paths.selector");
    private static volatile String ourHomePath;
    private static volatile List<Path> ourBinDirectories;
    private static Path ourCommonDataPath;
    private static String ourConfigPath;
    private static String ourSystemPath;
    private static String ourScratchPath;
    private static String ourPluginsPath;
    private static String ourLogPath;

    @NotNull
    public static String getHomePath() {
        String string = PathManager.getHomePath(true);
        if (string == null) {
            PathManager.$$$reportNull$$$0(0);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="true -> !null")
    public static String getHomePath(boolean insideIde) {
        String result = ourHomePath;
        if (result != null) {
            return result;
        }
        Class<PathManager> clazz = PathManager.class;
        synchronized (PathManager.class) {
            result = ourHomePath;
            if (result != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return result;
            }
            String explicit = PathManager.getExplicitPath(PROPERTY_HOME_PATH);
            if (explicit == null) {
                explicit = PathManager.getExplicitPath(PROPERTY_HOME);
            }
            if (explicit != null) {
                result = explicit;
                if (!Files.isDirectory(Paths.get(result, new String[0]), new LinkOption[0])) {
                    ourHomePath = result;
                    throw new RuntimeException("Invalid home path '" + result + "'");
                }
            } else if (insideIde && (result = PathManager.getHomePathFor(PathManager.class)) == null) {
                String advice = SystemInfoRt.isMac ? "reinstall the software." : "make sure bin/idea.properties is present in the installation directory.";
                throw new RuntimeException("Could not find installation home path. Please " + advice);
            }
            if (result != null && SystemInfoRt.isWindows) {
                try {
                    result = Paths.get(result, new String[0]).toRealPath(LinkOption.NOFOLLOW_LINKS).toString();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ourBinDirectories = result == null ? Collections.emptyList() : PathManager.getBinDirectories(Paths.get(result, new String[0]));
            ourHomePath = result;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    private static List<Path> getBinDirectories() {
        List<Path> result = ourBinDirectories;
        if (result == null) {
            PathManager.getHomePath(true);
            result = ourBinDirectories;
        }
        return result;
    }

    public static boolean isUnderHomeDirectory(@NotNull String path) {
        if (path == null) {
            PathManager.$$$reportNull$$$0(1);
        }
        try {
            return PathManager.isUnderHomeDirectory(Paths.get(path, new String[0]));
        }
        catch (InvalidPathException e) {
            return false;
        }
    }

    public static boolean isUnderHomeDirectory(@NotNull Path target) {
        if (target == null) {
            PathManager.$$$reportNull$$$0(2);
        }
        Path home = Paths.get(PathManager.getHomePath(), new String[0]);
        try {
            home = home.toRealPath(new LinkOption[0]);
            target = target.toRealPath(new LinkOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return target.startsWith(home);
    }

    @Nullable
    public static String getHomePathFor(@NotNull Class<?> aClass) {
        String rootPath;
        if (aClass == null) {
            PathManager.$$$reportNull$$$0(3);
        }
        if ((rootPath = PathManager.getResourceRoot(aClass, '/' + aClass.getName().replace('.', '/') + ".class")) == null) {
            return null;
        }
        Path root = Paths.get(rootPath, new String[0]).toAbsolutePath();
        while ((root = root.getParent()) != null && !PathManager.isIdeaHome(root)) {
        }
        return root != null ? root.toString() : null;
    }

    private static boolean isIdeaHome(Path root) {
        for (Path binDir : PathManager.getBinDirectories(root)) {
            if (!Files.isRegularFile(binDir.resolve(PROPERTIES_FILE_NAME), new LinkOption[0])) continue;
            return true;
        }
        return false;
    }

    private static List<Path> getBinDirectories(Path root) {
        ArrayList<Path> binDirs = new ArrayList<Path>();
        Path[] candidates = new Path[]{root.resolve(BIN_DIRECTORY), Paths.get(PathManager.getCommunityHomePath(root.toString()), BIN_DIRECTORY)};
        String osSuffix = SystemInfoRt.isWindows ? "win" : (SystemInfoRt.isMac ? "mac" : "linux");
        for (Path dir : candidates) {
            if (binDirs.contains(dir) || !Files.isDirectory(dir, new LinkOption[0])) continue;
            binDirs.add(dir);
            dir = dir.resolve(osSuffix);
            if (!Files.isDirectory(dir, new LinkOption[0])) continue;
            binDirs.add(dir);
        }
        return binDirs;
    }

    @NotNull
    public static String getBinPath() {
        String string = PathManager.getHomePath() + '/' + BIN_DIRECTORY;
        if (string == null) {
            PathManager.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public static Path findBinFile(@NotNull String fileName) {
        if (fileName == null) {
            PathManager.$$$reportNull$$$0(5);
        }
        for (Path binDir : PathManager.getBinDirectories()) {
            Path candidate = binDir.resolve(fileName);
            if (!Files.isRegularFile(candidate, new LinkOption[0])) continue;
            return candidate;
        }
        return null;
    }

    @NotNull
    public static Path findBinFileWithException(@NotNull String fileName) throws FileNotFoundException {
        Path file;
        if (fileName == null) {
            PathManager.$$$reportNull$$$0(6);
        }
        if ((file = PathManager.findBinFile(fileName)) != null) {
            Path path = file;
            if (path == null) {
                PathManager.$$$reportNull$$$0(7);
            }
            return path;
        }
        StringBuilder message = new StringBuilder();
        message.append('\'').append(fileName).append("' not found in directories:");
        for (Path directory : PathManager.getBinDirectories()) {
            message.append('\n').append(directory);
        }
        throw new FileNotFoundException(message.toString());
    }

    @NotNull
    public static String getLibPath() {
        String string = PathManager.getHomePath() + '/' + LIB_DIRECTORY;
        if (string == null) {
            PathManager.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static String getPreInstalledPluginsPath() {
        String string = PathManager.getHomePath() + '/' + PLUGINS_DIRECTORY;
        if (string == null) {
            PathManager.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static String getBundledRuntimePath() {
        String string = PathManager.getHomePath() + '/' + JRE_DIRECTORY + (SystemInfoRt.isMac ? "/Contents/Home" : "");
        if (string == null) {
            PathManager.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static synchronized Path getCommonDataPath() {
        if (ourCommonDataPath == null) {
            Path path = Paths.get(PathManager.platformPath("", "Application Support", "", "APPDATA", "", "XDG_DATA_HOME", ".local/share", ""), new String[0]);
            if (!Files.exists(path, LinkOption.NOFOLLOW_LINKS)) {
                try {
                    Files.createDirectories(path, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            ourCommonDataPath = path;
        }
        Path path = ourCommonDataPath;
        if (path == null) {
            PathManager.$$$reportNull$$$0(11);
        }
        return path;
    }

    @Nullable
    public static String getPathsSelector() {
        return PATHS_SELECTOR;
    }

    @NotNull
    public static Path getConfigDir() {
        Path path = Paths.get(PathManager.getConfigPath(), new String[0]);
        if (path == null) {
            PathManager.$$$reportNull$$$0(12);
        }
        return path;
    }

    @NotNull
    public static String getConfigPath() {
        if (ourConfigPath != null) {
            String string = ourConfigPath;
            if (string == null) {
                PathManager.$$$reportNull$$$0(13);
            }
            return string;
        }
        String explicit = PathManager.getExplicitPath(PROPERTY_CONFIG_PATH);
        ourConfigPath = explicit != null ? explicit : (PATHS_SELECTOR != null ? PathManager.getDefaultConfigPathFor(PATHS_SELECTOR) : PathManager.getHomePath() + '/' + CONFIG_DIRECTORY);
        String string = ourConfigPath;
        if (string == null) {
            PathManager.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public static String getScratchPath() {
        if (ourScratchPath != null) {
            String string = ourScratchPath;
            if (string == null) {
                PathManager.$$$reportNull$$$0(15);
            }
            return string;
        }
        String explicit = PathManager.getExplicitPath(PROPERTY_SCRATCH_PATH);
        ourScratchPath = explicit != null ? explicit : PathManager.getConfigPath();
        String string = ourScratchPath;
        if (string == null) {
            PathManager.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public static String getDefaultConfigPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(17);
        }
        String string = PathManager.platformPath(selector, "Application Support", "", "APPDATA", "", "XDG_CONFIG_HOME", ".config", "");
        if (string == null) {
            PathManager.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public static String getOptionsPath() {
        String string = PathManager.getConfigPath() + '/' + OPTIONS_DIRECTORY;
        if (string == null) {
            PathManager.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public static File getOptionsFile(@NotNull String fileName) {
        if (fileName == null) {
            PathManager.$$$reportNull$$$0(20);
        }
        File file = Paths.get(PathManager.getOptionsPath(), fileName + DEFAULT_EXT).toFile();
        if (file == null) {
            PathManager.$$$reportNull$$$0(21);
        }
        return file;
    }

    @NotNull
    public static String getPluginsPath() {
        if (ourPluginsPath != null) {
            String string = ourPluginsPath;
            if (string == null) {
                PathManager.$$$reportNull$$$0(22);
            }
            return string;
        }
        String explicit = PathManager.getExplicitPath(PROPERTY_PLUGINS_PATH);
        ourPluginsPath = explicit != null ? explicit : (PATHS_SELECTOR != null && System.getProperty(PROPERTY_CONFIG_PATH) == null ? PathManager.getDefaultPluginPathFor(PATHS_SELECTOR) : PathManager.getConfigPath() + '/' + PLUGINS_DIRECTORY);
        String string = ourPluginsPath;
        if (string == null) {
            PathManager.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    public static String getDefaultPluginPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(24);
        }
        String string = PathManager.platformPath(selector, "Application Support", PLUGINS_DIRECTORY, "APPDATA", PLUGINS_DIRECTORY, "XDG_DATA_HOME", ".local/share", "");
        if (string == null) {
            PathManager.$$$reportNull$$$0(25);
        }
        return string;
    }

    @Nullable
    public static String getCustomOptionsDirectory() {
        return PATHS_SELECTOR != null ? PathManager.getDefaultConfigPathFor(PATHS_SELECTOR) : null;
    }

    @NotNull
    public static String getSystemPath() {
        if (ourSystemPath != null) {
            String string = ourSystemPath;
            if (string == null) {
                PathManager.$$$reportNull$$$0(26);
            }
            return string;
        }
        String explicit = PathManager.getExplicitPath(PROPERTY_SYSTEM_PATH);
        ourSystemPath = explicit != null ? explicit : (PATHS_SELECTOR != null ? PathManager.getDefaultSystemPathFor(PATHS_SELECTOR) : PathManager.getHomePath() + '/' + SYSTEM_DIRECTORY);
        String string = ourSystemPath;
        if (string == null) {
            PathManager.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    public static String getDefaultSystemPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(28);
        }
        String string = PathManager.platformPath(selector, "Caches", "", "LOCALAPPDATA", "", "XDG_CACHE_HOME", ".cache", "");
        if (string == null) {
            PathManager.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    public static String getDefaultUnixSystemPath(@NotNull String userHome, @NotNull String pathsSelector) {
        if (userHome == null) {
            PathManager.$$$reportNull$$$0(30);
        }
        if (pathsSelector == null) {
            PathManager.$$$reportNull$$$0(31);
        }
        String string = PathManager.getUnixPlatformPath(userHome, pathsSelector, null, ".cache", "");
        if (string == null) {
            PathManager.$$$reportNull$$$0(32);
        }
        return string;
    }

    @NotNull
    public static String getTempPath() {
        String string = PathManager.getSystemPath() + "/tmp";
        if (string == null) {
            PathManager.$$$reportNull$$$0(33);
        }
        return string;
    }

    @NotNull
    public static Path getIndexRoot() {
        String indexRootPath = PathManager.getExplicitPath("index_root_path");
        if (indexRootPath == null) {
            indexRootPath = PathManager.getSystemPath() + "/index";
        }
        Path path = Paths.get(indexRootPath, new String[0]);
        if (path == null) {
            PathManager.$$$reportNull$$$0(34);
        }
        return path;
    }

    @NotNull
    public static String getLogPath() {
        if (ourLogPath != null) {
            String string = ourLogPath;
            if (string == null) {
                PathManager.$$$reportNull$$$0(35);
            }
            return string;
        }
        String explicit = PathManager.getExplicitPath(PROPERTY_LOG_PATH);
        ourLogPath = explicit != null ? explicit : (PATHS_SELECTOR != null && System.getProperty(PROPERTY_SYSTEM_PATH) == null ? PathManager.getDefaultLogPathFor(PATHS_SELECTOR) : PathManager.getSystemPath() + '/' + LOG_DIRECTORY);
        String string = ourLogPath;
        if (string == null) {
            PathManager.$$$reportNull$$$0(36);
        }
        return string;
    }

    @NotNull
    public static String getDefaultLogPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(37);
        }
        String string = PathManager.platformPath(selector, "Logs", "", "LOCALAPPDATA", LOG_DIRECTORY, "XDG_CACHE_HOME", ".cache", LOG_DIRECTORY);
        if (string == null) {
            PathManager.$$$reportNull$$$0(38);
        }
        return string;
    }

    @NotNull
    public static String getPluginTempPath() {
        String string = PathManager.getSystemPath() + '/' + PLUGINS_DIRECTORY;
        if (string == null) {
            PathManager.$$$reportNull$$$0(39);
        }
        return string;
    }

    @Nullable
    public static String getResourceRoot(@NotNull Class<?> context2, @NotNull String path) {
        URL url;
        if (context2 == null) {
            PathManager.$$$reportNull$$$0(40);
        }
        if (path == null) {
            PathManager.$$$reportNull$$$0(41);
        }
        if ((url = context2.getResource(path)) == null) {
            url = ClassLoader.getSystemResource(path.substring(1));
        }
        return url != null ? PathManager.extractRoot(url, path) : null;
    }

    @Nullable
    public static String getResourceRoot(@NotNull ClassLoader classLoader, @NotNull String resourcePath) {
        URL url;
        if (classLoader == null) {
            PathManager.$$$reportNull$$$0(42);
        }
        if (resourcePath == null) {
            PathManager.$$$reportNull$$$0(43);
        }
        return (url = classLoader.getResource(resourcePath)) == null ? null : PathManager.extractRoot(url, "/" + resourcePath);
    }

    @Nullable
    private static String extractRoot(URL resourceURL, String resourcePath) {
        if (resourcePath.length() == 0 || resourcePath.charAt(0) != '/' && resourcePath.charAt(0) != '\\') {
            PathManager.log("precondition failed: " + resourcePath);
            return null;
        }
        String resultPath = null;
        String protocol = resourceURL.getProtocol();
        if ("file".equals(protocol)) {
            File result;
            try {
                result = new File(resourceURL.toURI().getSchemeSpecificPart());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("URL='" + resourceURL + "'", e);
            }
            String path = result.getPath();
            String testPath = path.replace('\\', '/');
            String testResourcePath = resourcePath.replace('\\', '/');
            if (StringUtilRt.endsWithIgnoreCase(testPath, testResourcePath)) {
                resultPath = path.substring(0, path.length() - resourcePath.length());
            }
        } else if ("jar".equals(protocol)) {
            String jarPath = PathManager.splitJarUrl(resourceURL.getFile());
            if (jarPath != null) {
                resultPath = jarPath;
            }
        } else if ("jrt".equals(protocol)) {
            return null;
        }
        if (resultPath == null) {
            PathManager.log("cannot extract '" + resourcePath + "' from '" + resourceURL + "'");
            return null;
        }
        return Paths.get(resultPath, new String[0]).normalize().toString();
    }

    @Nullable
    private static String splitJarUrl(@NotNull String url) {
        int pivot;
        if (url == null) {
            PathManager.$$$reportNull$$$0(44);
        }
        if ((pivot = url.indexOf("!/")) < 0) {
            return null;
        }
        String jarPath = url.substring(0, pivot);
        boolean startsWithConcatenation = true;
        int offset = 0;
        for (String prefix : new String[]{"jar", ":"}) {
            int prefixLen = prefix.length();
            if (!jarPath.regionMatches(offset, prefix, 0, prefixLen)) {
                startsWithConcatenation = false;
                break;
            }
            offset += prefixLen;
        }
        if (startsWithConcatenation) {
            jarPath = jarPath.substring("jar".length() + 1);
        }
        if (!jarPath.startsWith("file")) {
            return jarPath;
        }
        try {
            File result;
            URL parsedUrl = new URL(jarPath);
            try {
                result = new File(parsedUrl.toURI().getSchemeSpecificPart());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("URL='" + parsedUrl + "'", e);
            }
            return result.getPath().replace('\\', '/');
        }
        catch (Exception e) {
            jarPath = jarPath.substring("file".length());
            if (jarPath.startsWith("://")) {
                return jarPath.substring("://".length());
            }
            if (!jarPath.isEmpty() && jarPath.charAt(0) == ':') {
                return jarPath.substring(1);
            }
            return jarPath;
        }
    }

    public static void loadProperties() {
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        paths.add(System.getProperty(PROPERTIES_FILE));
        paths.add(PathManager.getCustomPropertiesFile());
        paths.add(System.getProperty("user.home") + '/' + PROPERTIES_FILE_NAME);
        final String homePath = PathManager.getHomePath(true);
        for (Path binDir : PathManager.getBinDirectories()) {
            paths.add(binDir.resolve(PROPERTIES_FILE_NAME).toString());
        }
        final Properties sysProperties = System.getProperties();
        for (final String path : paths) {
            Path file;
            Path path2 = file = path == null ? null : Paths.get(path, new String[0]);
            if (file == null) continue;
            try {
                InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);
                try {
                    new Properties(){

                        @Override
                        public Object put(Object key, Object value) {
                            if (PathManager.PROPERTY_HOME_PATH.equals(key) || PathManager.PROPERTY_HOME.equals(key)) {
                                PathManager.log(path + ": '" + key + "' cannot be redefined");
                            } else if (!sysProperties.containsKey(key)) {
                                sysProperties.put(key, PathManager.substituteVars((String)value, homePath));
                            }
                            return null;
                        }
                    }.load(inputStream);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (AccessDeniedException | NoSuchFileException inputStream) {
            }
            catch (IOException e) {
                PathManager.log("Can't read property file '" + path + "': " + e.getMessage());
            }
        }
    }

    private static String getCustomPropertiesFile() {
        String configPath = PathManager.getCustomOptionsDirectory();
        return configPath != null ? configPath + '/' + PROPERTIES_FILE_NAME : null;
    }

    @Contract(value="null -> null")
    public static String substituteVars(String s) {
        return PathManager.substituteVars(s, PathManager.getHomePath());
    }

    @Contract(value="null, _ -> null")
    public static String substituteVars(String s, @NotNull String ideaHomePath) {
        if (ideaHomePath == null) {
            PathManager.$$$reportNull$$$0(45);
        }
        if (s == null) {
            return null;
        }
        if (s.startsWith("..")) {
            s = ideaHomePath + '/' + BIN_DIRECTORY + '/' + s;
        }
        Matcher m = Lazy.PROPERTY_REF.matcher(s);
        while (m.find()) {
            String key = m.group(1);
            String value = System.getProperty(key);
            if (value == null) {
                switch (key) {
                    case "idea.home.path": 
                    case "idea.home": {
                        value = ideaHomePath;
                        break;
                    }
                    case "idea.config.path": {
                        value = PathManager.getConfigPath();
                        break;
                    }
                    case "idea.system.path": {
                        value = PathManager.getSystemPath();
                    }
                }
            }
            if (value == null) {
                PathManager.log("Unknown property: " + key);
                value = "";
            }
            s = s.replace(m.group(), value);
            m = Lazy.PROPERTY_REF.matcher(s);
        }
        return s;
    }

    @NotNull
    public static File findFileInLibDirectory(@NotNull String relativePath) {
        Path file;
        if (relativePath == null) {
            PathManager.$$$reportNull$$$0(46);
        }
        if (!Files.exists(file = Paths.get(PathManager.getLibPath(), relativePath), new LinkOption[0])) {
            file = Paths.get(PathManager.getHomePath(), "community/lib/" + relativePath);
        }
        File file2 = file.toFile();
        if (file2 == null) {
            PathManager.$$$reportNull$$$0(47);
        }
        return file2;
    }

    @NotNull
    public static String getCommunityHomePath() {
        return PathManager.getCommunityHomePath(PathManager.getHomePath());
    }

    @NotNull
    private static String getCommunityHomePath(@NotNull String homePath) {
        boolean isRunningFromSources;
        if (homePath == null) {
            PathManager.$$$reportNull$$$0(48);
        }
        if (!(isRunningFromSources = Files.isDirectory(Paths.get(homePath, ".idea"), new LinkOption[0]))) {
            String string = homePath;
            if (string == null) {
                PathManager.$$$reportNull$$$0(49);
            }
            return string;
        }
        if (Files.isDirectory(Paths.get(homePath, "community/.idea"), new LinkOption[0])) {
            String string = homePath + "/community";
            if (string == null) {
                PathManager.$$$reportNull$$$0(50);
            }
            return string;
        }
        if (Files.isDirectory(Paths.get(homePath, "ultimate/community/.idea"), new LinkOption[0])) {
            String string = homePath + "/ultimate/community";
            if (string == null) {
                PathManager.$$$reportNull$$$0(51);
            }
            return string;
        }
        if (Files.isRegularFile(Paths.get(homePath, "../../Product.Root"), new LinkOption[0])) {
            String string = homePath + "/../ultimate/community";
            if (string == null) {
                PathManager.$$$reportNull$$$0(52);
            }
            return string;
        }
        String string = homePath;
        if (string == null) {
            PathManager.$$$reportNull$$$0(53);
        }
        return string;
    }

    @Nullable
    public static String getJarPathForClass(@NotNull Class<?> aClass) {
        Path resourceRoot;
        if (aClass == null) {
            PathManager.$$$reportNull$$$0(54);
        }
        return (resourceRoot = PathManager.getJarForClass(aClass)) == null ? null : resourceRoot.toString();
    }

    @Nullable
    public static Path getJarForClass(@NotNull Class<?> aClass) {
        String resourceRoot;
        if (aClass == null) {
            PathManager.$$$reportNull$$$0(55);
        }
        return (resourceRoot = PathManager.getResourceRoot(aClass, '/' + aClass.getName().replace('.', '/') + ".class")) == null ? null : Paths.get(resourceRoot, new String[0]).toAbsolutePath();
    }

    @NotNull
    public static Path getJarArtifactPath(@NotNull String classesRoot, @NotNull String artifactName) {
        if (classesRoot == null) {
            PathManager.$$$reportNull$$$0(56);
        }
        if (artifactName == null) {
            PathManager.$$$reportNull$$$0(57);
        }
        String artifactJarName = Strings.trimEnd(artifactName, ":jar") + ".jar";
        String artifactDirNameInBuildLayout = artifactName.replaceAll("\\W", "_");
        return PathManager.getArtifactPath(classesRoot, artifactJarName, "rt", artifactDirNameInBuildLayout);
    }

    @NotNull
    public static Path getArtifactPath(@NotNull String classesRoot, @NotNull String artifactFileName, @NotNull String artifactDirNameInPluginLayout, @NotNull String artifactDirNameInBuildLayout) {
        Path rootPath;
        if (classesRoot == null) {
            PathManager.$$$reportNull$$$0(58);
        }
        if (artifactFileName == null) {
            PathManager.$$$reportNull$$$0(59);
        }
        if (artifactDirNameInPluginLayout == null) {
            PathManager.$$$reportNull$$$0(60);
        }
        if (artifactDirNameInBuildLayout == null) {
            PathManager.$$$reportNull$$$0(61);
        }
        if (Files.isRegularFile(rootPath = Paths.get(classesRoot, new String[0]), new LinkOption[0])) {
            Path path = rootPath.resolveSibling(artifactDirNameInPluginLayout).resolve(artifactFileName);
            if (path == null) {
                PathManager.$$$reportNull$$$0(62);
            }
            return path;
        }
        Path outClassesDir = rootPath.getParent().getParent();
        Path artifactsDir = outClassesDir.resolveSibling("project-artifacts");
        if (!Files.exists(artifactsDir, new LinkOption[0])) {
            artifactsDir = outClassesDir.resolve("artifacts");
        }
        Path path = artifactsDir.resolve(artifactDirNameInBuildLayout).resolve(artifactFileName);
        if (path == null) {
            PathManager.$$$reportNull$$$0(63);
        }
        return path;
    }

    private static void log(String x) {
        System.err.println(x);
    }

    @NotNull
    public static String getAbsolutePath(@NotNull String path) {
        if (path == null) {
            PathManager.$$$reportNull$$$0(64);
        }
        if (path.startsWith("~/") || path.startsWith("~\\")) {
            path = System.getProperty("user.home") + path.substring(1);
        }
        String string = Paths.get(path, new String[0]).toAbsolutePath().normalize().toString();
        if (string == null) {
            PathManager.$$$reportNull$$$0(65);
        }
        return string;
    }

    @Nullable
    private static String getExplicitPath(@NotNull String property) {
        String path;
        if (property == null) {
            PathManager.$$$reportNull$$$0(66);
        }
        if ((path = System.getProperty(property)) == null) {
            return null;
        }
        boolean quoted = path.length() > 1 && '\"' == path.charAt(0) && '\"' == path.charAt(path.length() - 1);
        return PathManager.getAbsolutePath(quoted ? path.substring(1, path.length() - 1) : path);
    }

    private static String platformPath(String selector, String macDir, String macSub, String winVar, String winSub, String xdgVar, String xdgDfl, String xdgSub) {
        String userHome = System.getProperty("user.home");
        String vendorName = PathManager.vendorName();
        if (SystemInfoRt.isMac) {
            String dir = userHome + "/Library/" + macDir + '/' + vendorName;
            if (!selector.isEmpty()) {
                dir = dir + '/' + selector;
            }
            if (!macSub.isEmpty()) {
                dir = dir + '/' + macSub;
            }
            return dir;
        }
        if (SystemInfoRt.isWindows) {
            String dir = System.getenv(winVar);
            if (dir == null || dir.isEmpty()) {
                dir = userHome + "\\AppData\\" + (winVar.startsWith("LOCAL") ? "Local" : "Roaming");
            }
            dir = dir + '\\' + vendorName;
            if (!selector.isEmpty()) {
                dir = dir + '\\' + selector;
            }
            if (!winSub.isEmpty()) {
                dir = dir + '\\' + winSub;
            }
            return dir;
        }
        if (SystemInfoRt.isUnix) {
            return PathManager.getUnixPlatformPath(userHome, selector, xdgVar, xdgDfl, xdgSub);
        }
        throw new UnsupportedOperationException("Unsupported OS: " + SystemInfoRt.OS_NAME);
    }

    private static String getUnixPlatformPath(String userHome, String selector, @Nullable String xdgVar, String xdgDfl, String xdgSub) {
        String dir;
        String string = dir = xdgVar != null ? System.getenv(xdgVar) : null;
        if (dir == null || dir.isEmpty()) {
            dir = userHome + '/' + xdgDfl;
        }
        dir = dir + '/' + PathManager.vendorName();
        if (!selector.isEmpty()) {
            dir = dir + '/' + selector;
        }
        if (!xdgSub.isEmpty()) {
            dir = dir + '/' + xdgSub;
        }
        return dir;
    }

    private static String vendorName() {
        String property = System.getProperty(PROPERTY_VENDOR_NAME);
        if (property == null) {
            try {
                Class<?> ex = Class.forName("com.intellij.openapi.application.ex.ApplicationInfoEx");
                Class<?> impl = Class.forName("com.intellij.openapi.application.impl.ApplicationInfoImpl");
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                Object instance = lookup.findStatic(impl, "getShadowInstance", MethodType.methodType(ex)).invoke();
                property = lookup.findVirtual(impl, "getShortCompanyName", MethodType.methodType(String.class)).invoke(instance);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.setProperty(PROPERTY_VENDOR_NAME, property != null ? property : "JetBrains");
        }
        return property;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 17: 
            case 20: 
            case 24: 
            case 28: 
            case 30: 
            case 31: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 64: 
            case 66: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 17: 
            case 20: 
            case 24: 
            case 28: 
            case 30: 
            case 31: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 64: 
            case 66: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/PathManager";
                break;
            }
            case 1: 
            case 41: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 3: 
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 5: 
            case 6: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 17: 
            case 24: 
            case 28: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userHome";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathsSelector";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcePath";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaHomePath";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesRoot";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactName";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactFileName";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactDirNameInPluginLayout";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactDirNameInBuildLayout";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomePath";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 17: 
            case 20: 
            case 24: 
            case 28: 
            case 30: 
            case 31: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 64: 
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/PathManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findBinFileWithException";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibPath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreInstalledPluginsPath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundledRuntimePath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonDataPath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigDir";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigPath";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getScratchPath";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConfigPathFor";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPath";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsFile";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsPath";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPluginPathFor";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemPath";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSystemPathFor";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultUnixSystemPath";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempPath";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexRoot";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogPath";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLogPathFor";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginTempPath";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "findFileInLibDirectory";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommunityHomePath";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactPath";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbsolutePath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isUnderHomeDirectory";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getHomePathFor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findBinFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findBinFileWithException";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultConfigPathFor";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getOptionsFile";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPluginPathFor";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultSystemPathFor";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultUnixSystemPath";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultLogPathFor";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getResourceRoot";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "splitJarUrl";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "substituteVars";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "findFileInLibDirectory";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getCommunityHomePath";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getJarPathForClass";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getJarForClass";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getJarArtifactPath";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactPath";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getAbsolutePath";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getExplicitPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 17: 
            case 20: 
            case 24: 
            case 28: 
            case 30: 
            case 31: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 64: 
            case 66: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Lazy {
        private static final Pattern PROPERTY_REF = Pattern.compile("\\$\\{(.+?)}");

        private Lazy() {
        }
    }
}

