/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Calendar;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public abstract class ApplicationInfo {
    public static ApplicationInfo getInstance() {
        return ApplicationManager.getApplication().getService(ApplicationInfo.class);
    }

    public abstract Calendar getBuildDate();

    @NotNull
    public abstract BuildNumber getBuild();

    @NotNull
    public abstract String getApiVersion();

    public abstract String getMajorVersion();

    public abstract String getMinorVersion();

    public abstract String getMicroVersion();

    public abstract String getPatchVersion();

    @NlsSafe
    public abstract String getVersionName();

    @NlsSafe
    public final String getMinorVersionMainPart() {
        String value = StringUtil.substringBefore(this.getMinorVersion(), ".");
        return value == null ? this.getMinorVersion() : value;
    }

    @NlsSafe
    public abstract String getCompanyName();

    @NlsSafe
    public abstract String getShortCompanyName();

    public abstract String getCompanyURL();

    public abstract String getJetBrainsTvUrl();

    public abstract String getEvalLicenseUrl();

    public abstract String getKeyConversionUrl();

    public abstract boolean hasHelp();

    public abstract boolean hasContextHelp();

    @NlsSafe
    @NotNull
    public abstract String getFullVersion();

    @NlsSafe
    public final String getShortVersion() {
        return this.getMajorVersion() + '.' + this.getMinorVersionMainPart();
    }

    @NlsSafe
    @NotNull
    public abstract String getStrictVersion();

    public static boolean helpAvailable() {
        return ApplicationManager.getApplication() != null && ApplicationInfo.getInstance() != null && ApplicationInfo.getInstance().hasHelp();
    }

    public static boolean contextHelpAvailable() {
        return ApplicationManager.getApplication() != null && ApplicationInfo.getInstance() != null && ApplicationInfo.getInstance().hasContextHelp();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public String getBuildNumber() {
        return this.getBuild().asString();
    }

    public abstract String getFullApplicationName();
}

