/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.model.BranchableSyntheticPsiElement;
import com.intellij.model.BranchedVirtualFileImpl;
import com.intellij.model.ModelBranch;
import com.intellij.model.ModelPatch;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.file.PsiFileImplUtil;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
@ApiStatus.Internal
public abstract class ModelBranchImpl
extends UserDataHolderBase
implements ModelBranch {
    private static final Logger LOG = Logger.getInstance(ModelBranchImpl.class);
    private final Map<VirtualFile, BranchedVirtualFileImpl> myVFileCopies;
    private final Set<BranchedVirtualFileImpl> myVfsStructureChanges;
    private final Set<BranchedVirtualFileImpl> myAffectedFiles;
    private final Map<Document, List<DocumentEvent>> myDocumentChanges;
    private final List<Runnable> myAfterMerge;
    private final SimpleModificationTracker myVfsChanges;
    private final Project myProject;
    @NotNull
    private final Throwable myCreationTrace;
    private boolean myMerged;

    ModelBranchImpl(@NotNull Project project) {
        if (project == null) {
            ModelBranchImpl.$$$reportNull$$$0(0);
        }
        this.myVFileCopies = new HashMap<VirtualFile, BranchedVirtualFileImpl>();
        this.myVfsStructureChanges = new LinkedHashSet<BranchedVirtualFileImpl>();
        this.myAffectedFiles = new HashSet<BranchedVirtualFileImpl>();
        this.myDocumentChanges = new HashMap<Document, List<DocumentEvent>>();
        this.myAfterMerge = new ArrayList<Runnable>();
        this.myVfsChanges = new SimpleModificationTracker();
        this.myProject = project;
        this.myCreationTrace = ThrowableInterner.intern(new Throwable());
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (PsiDocumentManager.getInstance(project).hasEventSystemEnabledUncommittedDocuments()) {
            throw new IllegalStateException("Model branches may only be created on committed PSI");
        }
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ModelBranchImpl.$$$reportNull$$$0(1);
        }
        return project;
    }

    void addVfsStructureChange(BranchedVirtualFileImpl file) {
        this.myVfsChanges.incModificationCount();
        PsiManagerImpl psiManager = (PsiManagerImpl)PsiManager.getInstance(this.myProject);
        psiManager.beforeChange(false);
        psiManager.afterChange(false);
        this.myVfsStructureChanges.add(file);
        VfsUtilCore.processFilesRecursively(file, each -> {
            this.myAffectedFiles.add((BranchedVirtualFileImpl)each);
            return true;
        });
    }

    @NotNull
    static ModelPatch performInBranch(@NotNull Consumer<? super ModelBranch> action2, final @NotNull ModelBranchImpl branch) {
        if (action2 == null) {
            ModelBranchImpl.$$$reportNull$$$0(2);
        }
        if (branch == null) {
            ModelBranchImpl.$$$reportNull$$$0(3);
        }
        action2.accept(branch);
        return new ModelPatch(){

            @Override
            public void applyBranchChanges() {
                branch.mergeBack();
            }

            @Override
            @NotNull
            public Map<VirtualFile, CharSequence> getBranchChanges() {
                HashMap<VirtualFile, CharSequence> result = new HashMap<VirtualFile, CharSequence>();
                for (Document document : branch.myDocumentChanges.keySet()) {
                    VirtualFile file = Objects.requireNonNull(FileDocumentManager.getInstance().getFile(document));
                    VirtualFile original = branch.findOriginalFile(file);
                    if (original == null) continue;
                    result.put(original, document.getImmutableCharSequence());
                }
                HashMap<VirtualFile, CharSequence> hashMap = result;
                if (hashMap == null) {
                    1.$$$reportNull$$$0(0);
                }
                return hashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/model/ModelBranchImpl$1", "getBranchChanges"));
            }
        };
    }

    @Override
    public void runAfterMerge(@NotNull Runnable action2) {
        if (action2 == null) {
            ModelBranchImpl.$$$reportNull$$$0(4);
        }
        this.myAfterMerge.add(action2);
    }

    @Override
    @Nullable
    public VirtualFile findFileByUrl(@NotNull String url) {
        if (url == null) {
            ModelBranchImpl.$$$reportNull$$$0(5);
        }
        int prefixEnd = url.length();
        while (prefixEnd > 0) {
            VirtualFile someParent = VirtualFileManager.getInstance().findFileByUrl(url.substring(0, prefixEnd));
            if (someParent != null) {
                return this.findFileByUrl(url, this.findPhysicalFileCopy(someParent));
            }
            prefixEnd = url.lastIndexOf(47, prefixEnd - 1);
        }
        return null;
    }

    @Nullable
    private VirtualFile findFileByUrl(@NotNull String url, @NotNull BranchedVirtualFileImpl someCopyFromSameFS) {
        if (url == null) {
            ModelBranchImpl.$$$reportNull$$$0(6);
        }
        if (someCopyFromSameFS == null) {
            ModelBranchImpl.$$$reportNull$$$0(7);
        }
        BranchedVirtualFileImpl topmostChange = JBIterable.generate(someCopyFromSameFS, BranchedVirtualFileImpl::getParent).filter(this.myVfsStructureChanges::contains).last();
        BranchedVirtualFileImpl stableAncestor = topmostChange != null ? topmostChange.getParent() : someCopyFromSameFS;
        String stableUrl = Objects.requireNonNull(this.findOriginalFile(stableAncestor)).getUrl();
        if (url.equals(stableUrl)) {
            return stableAncestor;
        }
        if (!url.startsWith(stableUrl)) {
            LOG.error("Inconsistent branch copies, please include attachment with paths", new Attachment("urls.txt", "url=" + url + "\nstableUrl=" + stableUrl));
            return null;
        }
        return stableAncestor.findFileByRelativePath(url.substring(stableUrl.length() + 1));
    }

    @Override
    @NotNull
    public VirtualFile findFileCopy(@NotNull VirtualFile original) {
        if (original == null) {
            ModelBranchImpl.$$$reportNull$$$0(8);
        }
        VirtualFile virtualFile = original instanceof VirtualFileWindow ? this.findInjectedFileCopy((VirtualFileWindow)((Object)original)) : this.findPhysicalFileCopy(original);
        if (virtualFile == null) {
            ModelBranchImpl.$$$reportNull$$$0(9);
        }
        return virtualFile;
    }

    @NotNull
    private VirtualFile findInjectedFileCopy(VirtualFileWindow original) {
        BranchedVirtualFileImpl hostCopy = this.findPhysicalFileCopy(original.getDelegate());
        DocumentWindow injectedDoc = original.getDocumentWindow();
        PsiFile hostPsi = PsiManager.getInstance(this.myProject).findFile(hostCopy);
        assert (hostPsi != null);
        PsiElement leaf = InjectedLanguageManager.getInstance(this.myProject).findInjectedElementAt(hostPsi, injectedDoc.getHostRanges()[0].getStartOffset());
        assert (leaf != null);
        PsiFile injectedCopy = leaf.getContainingFile();
        VirtualFile virtualFile = injectedCopy.getViewProvider().getVirtualFile();
        if (virtualFile == null) {
            ModelBranchImpl.$$$reportNull$$$0(10);
        }
        return virtualFile;
    }

    @NotNull
    BranchedVirtualFileImpl findPhysicalFileCopy(@NotNull VirtualFile original) {
        if (original == null) {
            ModelBranchImpl.$$$reportNull$$$0(11);
        }
        assert (ModelBranch.getFileBranch(original) != this);
        BranchedVirtualFileImpl branchedVirtualFileImpl = this.myVFileCopies.computeIfAbsent(original, __ -> {
            assert (original instanceof VirtualFileWithId);
            return new BranchedVirtualFileImpl(this, original, original.getName(), original.isDirectory(), null);
        });
        if (branchedVirtualFileImpl == null) {
            ModelBranchImpl.$$$reportNull$$$0(12);
        }
        return branchedVirtualFileImpl;
    }

    void registerDocumentChange(Document document, DocumentEvent event, BranchedVirtualFileImpl file) {
        this.myDocumentChanges.computeIfAbsent(document, __ -> new ArrayList()).add(event);
        this.myAffectedFiles.add(file);
    }

    @Nullable
    private PsiFile findSameLanguageRoot(@Nullable PsiFile original, @Nullable VirtualFile vFileCopy) {
        if (original == null || vFileCopy == null) {
            return null;
        }
        FileViewProvider viewProvider = PsiManager.getInstance(this.myProject).findViewProvider(vFileCopy);
        return viewProvider == null ? null : viewProvider.getPsi(original.getLanguage());
    }

    @Override
    @NotNull
    public <T extends PsiElement> T obtainPsiCopy(@NotNull T original) {
        if (original == null) {
            ModelBranchImpl.$$$reportNull$$$0(13);
        }
        if (original instanceof PsiDirectory) {
            PsiElement psiElement = Objects.requireNonNull(PsiManager.getInstance(this.myProject).findDirectory(this.findFileCopy(((PsiDirectory)original).getVirtualFile())));
            if (psiElement == null) {
                ModelBranchImpl.$$$reportNull$$$0(14);
            }
            return (T)psiElement;
        }
        if (original instanceof BranchableSyntheticPsiElement) {
            BranchableSyntheticPsiElement branchableSyntheticPsiElement = ((BranchableSyntheticPsiElement)original).obtainBranchCopy(this);
            if (branchableSyntheticPsiElement == null) {
                ModelBranchImpl.$$$reportNull$$$0(15);
            }
            return (T)branchableSyntheticPsiElement;
        }
        PsiFile file = original.getContainingFile();
        assert (file != null) : original;
        VirtualFile vFileCopy = this.findFileCopy(file.getViewProvider().getVirtualFile());
        PsiFile fileCopy = Objects.requireNonNull(this.findSameLanguageRoot(file, vFileCopy));
        T t = Objects.requireNonNull(PsiTreeUtil.findSameElementInCopy(original, fileCopy));
        if (t == null) {
            ModelBranchImpl.$$$reportNull$$$0(16);
        }
        return t;
    }

    @Override
    @NotNull
    public <T extends PsiReference> T obtainReferenceCopy(@NotNull T original) {
        Object[] refs;
        if (original == null) {
            ModelBranchImpl.$$$reportNull$$$0(17);
        }
        PsiElement psiCopy = this.obtainPsiCopy(original.getElement());
        TextRange range = original.getRangeInElement();
        T found = ModelBranchImpl.findSimilarReference(original, range, (PsiReference[])(refs = psiCopy.getReferences()));
        if (found == null) {
            throw new AssertionError((Object)("Cannot find " + original + " of " + original.getClass() + " at " + range + " in the copy, where references are " + Arrays.toString(refs)));
        }
        T t = found;
        if (t == null) {
            ModelBranchImpl.$$$reportNull$$$0(18);
        }
        return t;
    }

    @Nullable
    private static <T> T findSimilarReference(@NotNull T original, TextRange range, PsiReference[] references) {
        if (original == null) {
            ModelBranchImpl.$$$reportNull$$$0(19);
        }
        return (T)ContainerUtil.find(references, r -> r.getClass() == original.getClass() && range.equals(r.getRangeInElement()));
    }

    @Override
    @Nullable
    public <T extends PsiElement> T findOriginalPsi(@NotNull T branched) {
        if (branched == null) {
            ModelBranchImpl.$$$reportNull$$$0(20);
        }
        if (branched instanceof PsiDirectory) {
            VirtualFile originalDir = this.findOriginalFile(((PsiDirectory)branched).getVirtualFile());
            if (originalDir == null) {
                return null;
            }
            return (T)Objects.requireNonNull(PsiManager.getInstance(this.myProject).findDirectory(originalDir));
        }
        PsiFile branchedFile = branched.getContainingFile();
        PsiFile originalFile = this.findSameLanguageRoot(branchedFile, this.findOriginalFile(branchedFile.getViewProvider().getVirtualFile()));
        return originalFile == null ? null : (T)PsiTreeUtil.findSameElementInCopy(branched, originalFile);
    }

    @Override
    @Nullable
    public VirtualFile findOriginalFile(@NotNull VirtualFile file) {
        if (file == null) {
            ModelBranchImpl.$$$reportNull$$$0(21);
        }
        BranchedVirtualFileImpl branched = (BranchedVirtualFileImpl)file;
        assert (branched.getBranch() == this);
        return branched.getOriginal();
    }

    @Override
    public long getBranchedPsiModificationCount() {
        return this.getBranchedVfsStructureModificationCount() + this.myDocumentChanges.keySet().stream().map(PsiDocumentManager.getInstance(this.myProject)::getPsiFile).filter(Objects::nonNull).mapToLong(PsiFile::getModificationStamp).sum();
    }

    @Override
    public long getBranchedVfsStructureModificationCount() {
        return this.myVfsChanges.getModificationCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeBack() {
        this.checkBranchIsAlive();
        try {
            try {
                for (BranchedVirtualFileImpl file : this.myVfsStructureChanges) {
                    VirtualFile original = file.getOrCreateOriginal();
                    String copyName = file.getName();
                    if (!original.getName().equals(copyName)) {
                        PsiFileImplUtil.saveDocumentIfFileWillBecomeBinary(original, copyName);
                        original.rename(this, copyName);
                    }
                    VirtualFile newParent = this.findOriginalFile(file.getParent());
                    if (original.getParent().equals(newParent)) continue;
                    assert (newParent != null);
                    original.move(this, newParent);
                }
            }
            catch (IOException e) {
                throw new IncorrectOperationException(e);
            }
            for (Document document : this.myDocumentChanges.keySet()) {
                VirtualFile file = Objects.requireNonNull(FileDocumentManager.getInstance().getFile(document));
                DocumentImpl original = (DocumentImpl)FileDocumentManager.getInstance().getDocument(Objects.requireNonNull(this.findOriginalFile(file)));
                assert (original != null);
                for (DocumentEvent event : this.myDocumentChanges.get(document)) {
                    original.replaceString(event.getOffset(), event.getOffset() + event.getOldLength(), event.getMoveOffset(), event.getNewFragment(), LocalTimeCounter.currentTime(), false);
                }
            }
            for (Runnable runnable : this.myAfterMerge) {
                runnable.run();
            }
        }
        finally {
            this.myMerged = true;
        }
    }

    @NotNull
    public GlobalSearchScope modifyScope(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            ModelBranchImpl.$$$reportNull$$$0(22);
        }
        return new DelegatingGlobalSearchScope(scope, new Object[]{this, this.getBranchedPsiModificationCount()}){

            @Override
            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                return ModelBranch.getFileBranch(file) == ModelBranchImpl.this && super.contains(file);
            }

            @Override
            @NotNull
            public Collection<ModelBranch> getModelBranchesAffectingScope() {
                if (ModelBranchImpl.this.myMerged) {
                    List<ModelBranch> list = Collections.emptyList();
                    if (list == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return list;
                }
                Set<ModelBranch> set = Collections.singleton(ModelBranchImpl.this);
                if (set == null) {
                    2.$$$reportNull$$$0(2);
                }
                return set;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/model/ModelBranchImpl$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/model/ModelBranchImpl$2";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getModelBranchesAffectingScope";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "contains";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public boolean hasModifications(@NotNull VirtualFile branchFile) {
        if (branchFile == null) {
            ModelBranchImpl.$$$reportNull$$$0(23);
        }
        assert (ModelBranch.getFileBranch(branchFile) == this);
        return this.myAffectedFiles.contains(branchFile);
    }

    public static boolean processModifiedFilesInScope(@NotNull GlobalSearchScope scope, @NotNull Processor<? super VirtualFile> processor) {
        Collection<ModelBranch> branches;
        if (scope == null) {
            ModelBranchImpl.$$$reportNull$$$0(24);
        }
        if (processor == null) {
            ModelBranchImpl.$$$reportNull$$$0(25);
        }
        return (branches = scope.getModelBranchesAffectingScope()).isEmpty() || ModelBranchImpl.processModifiedFilesInScope(scope, processor, branches);
    }

    private static boolean processModifiedFilesInScope(GlobalSearchScope scope, Processor<? super VirtualFile> processor, Collection<? extends ModelBranch> branches) {
        for (ModelBranch modelBranch : branches) {
            for (VirtualFile virtualFile : ((ModelBranchImpl)modelBranch).myAffectedFiles) {
                if (!scope.contains(virtualFile) || processor.process(virtualFile)) continue;
                return false;
            }
        }
        return true;
    }

    protected abstract void assertAllChildrenLoaded(@NotNull VirtualFile var1);

    void checkBranchIsAlive() {
        if (this.myMerged) {
            LOG.error("Attempting to access merged branch [" + this.hashCode() + "]", new Attachment("creation.trace", this.myCreationTrace));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/model/ModelBranchImpl";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "someCopyFromSameFS";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branched";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchFile";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/model/ModelBranchImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findFileCopy";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findInjectedFileCopy";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findPhysicalFileCopy";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "obtainPsiCopy";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "obtainReferenceCopy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "performInBranch";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runAfterMerge";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findFileByUrl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findFileCopy";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findPhysicalFileCopy";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "obtainPsiCopy";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "obtainReferenceCopy";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findSimilarReference";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findOriginalPsi";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findOriginalFile";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "modifyScope";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "hasModifications";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processModifiedFilesInScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

