/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.parser;

import com.intellij.core.JavaPsiBundle;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class PatternParser {
    private static final TokenSet PATTERN_MODIFIERS = TokenSet.create(JavaTokenType.FINAL_KEYWORD);
    private final JavaParser myParser;

    public PatternParser(JavaParser javaParser) {
        this.myParser = javaParser;
    }

    @Contract(pure=true)
    public boolean isPattern(PsiBuilder builder) {
        PsiBuilder.Marker patternStart = builder.mark();
        while (builder.getTokenType() == JavaTokenType.LPARENTH) {
            builder.advanceLexer();
        }
        this.myParser.getDeclarationParser().parseModifierList(builder, PATTERN_MODIFIERS);
        PsiBuilder.Marker type = this.myParser.getReferenceParser().parseType(builder, 5);
        boolean isPattern = type != null && builder.getTokenType() == JavaTokenType.IDENTIFIER;
        patternStart.rollbackTo();
        return isPattern;
    }

    @NotNull PsiBuilder.Marker parsePattern(PsiBuilder builder) {
        PsiBuilder.Marker guardPattern = builder.mark();
        PsiBuilder.Marker primaryPattern = this.parsePrimaryPattern(builder);
        if (builder.getTokenType() != JavaTokenType.ANDAND) {
            guardPattern.drop();
            PsiBuilder.Marker marker = primaryPattern;
            if (marker == null) {
                PatternParser.$$$reportNull$$$0(0);
            }
            return marker;
        }
        builder.advanceLexer();
        PsiBuilder.Marker guardingExpression = this.myParser.getExpressionParser().parseAssignment(builder);
        if (guardingExpression == null) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
        }
        JavaParserUtil.done(guardPattern, JavaElementType.GUARDED_PATTERN);
        PsiBuilder.Marker marker = guardPattern;
        if (marker == null) {
            PatternParser.$$$reportNull$$$0(1);
        }
        return marker;
    }

    @NotNull PsiBuilder.Marker parsePrimaryPattern(PsiBuilder builder) {
        if (builder.getTokenType() == JavaTokenType.LPARENTH) {
            PsiBuilder.Marker parenPattern = builder.mark();
            builder.advanceLexer();
            this.parsePattern(builder);
            if (!PsiBuilderUtil.expect(builder, JavaTokenType.RPARENTH)) {
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.rparen", new Object[0]));
            }
            JavaParserUtil.done(parenPattern, JavaElementType.PARENTHESIZED_PATTERN);
            PsiBuilder.Marker marker = parenPattern;
            if (marker == null) {
                PatternParser.$$$reportNull$$$0(2);
            }
            return marker;
        }
        return this.parseTypePattern(builder);
    }

    private @NotNull PsiBuilder.Marker parseTypePattern(PsiBuilder builder) {
        PsiBuilder.Marker pattern = builder.mark();
        PsiBuilder.Marker patternVariable = builder.mark();
        this.myParser.getDeclarationParser().parseModifierList(builder, PATTERN_MODIFIERS);
        PsiBuilder.Marker type = this.myParser.getReferenceParser().parseType(builder, 5);
        assert (type != null);
        boolean hasIdentifier = PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER);
        assert (hasIdentifier) : "identifier expected";
        JavaParserUtil.done(patternVariable, JavaElementType.PATTERN_VARIABLE);
        JavaParserUtil.done(pattern, JavaElementType.TYPE_TEST_PATTERN);
        PsiBuilder.Marker marker = pattern;
        if (marker == null) {
            PatternParser.$$$reportNull$$$0(3);
        }
        return marker;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/java/parser/PatternParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePattern";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePrimaryPattern";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTypePattern";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

