/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiLambdaNameHelper {
    private static final Key<ParameterizedCachedValue<Map<PsiLambdaExpression, String>, PsiClass>> LAMBDA_NAME = Key.create("ANONYMOUS_CLASS_NAME");

    @Nullable
    public static String getVMName(@NotNull PsiLambdaExpression lambdaExpression) {
        PsiClass upper;
        if (lambdaExpression == null) {
            PsiLambdaNameHelper.$$$reportNull$$$0(0);
        }
        if ((upper = PsiTreeUtil.getParentOfType((PsiElement)lambdaExpression, PsiClass.class)) == null) {
            return null;
        }
        ParameterizedCachedValue<Map<PsiLambdaExpression, String>, PsiClass> value = upper.getUserData(LAMBDA_NAME);
        if (value == null) {
            value = CachedValuesManager.getManager(upper.getProject()).createParameterizedCachedValue(new ParameterizedCachedValueProvider<Map<PsiLambdaExpression, String>, PsiClass>(){

                @Override
                public CachedValueProvider.Result<Map<PsiLambdaExpression, String>> compute(final PsiClass upper) {
                    final HashMap map = new HashMap();
                    upper.accept(new JavaRecursiveElementWalkingVisitor(){
                        int index;

                        @Override
                        public void visitLambdaExpression(PsiLambdaExpression expression) {
                            map.put(expression, "$" + this.index++);
                            super.visitLambdaExpression(expression);
                        }

                        @Override
                        public void visitClass(PsiClass aClass) {
                            if (aClass == upper) {
                                super.visitClass(aClass);
                            }
                        }
                    });
                    return CachedValueProvider.Result.create(map, upper);
                }
            }, false);
            upper.putUserData(LAMBDA_NAME, value);
        }
        return "lambda" + PsiLambdaNameHelper.getLambdaPrefix(lambdaExpression) + value.getValue(upper).get(lambdaExpression);
    }

    public static String getLambdaPrefix(@NotNull PsiLambdaExpression lambdaExpression) {
        PsiMember member;
        if (lambdaExpression == null) {
            PsiLambdaNameHelper.$$$reportNull$$$0(1);
        }
        String methodPrefix = (member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)lambdaExpression, PsiMethod.class, PsiClass.class, PsiField.class)) instanceof PsiMethod ? (member.getContainingClass() instanceof PsiAnonymousClass ? "" : "$" + member.getName()) : (member instanceof PsiField && member.getContainingClass() instanceof PsiAnonymousClass ? "" : "$new");
        return methodPrefix;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "lambdaExpression";
        objectArray2[1] = "com/intellij/ide/util/PsiLambdaNameHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getVMName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getLambdaPrefix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

