/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginUtil;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ReflectionUtil;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginUtilImpl
implements PluginUtil {
    private static final Logger LOG = Logger.getInstance(PluginUtilImpl.class);

    @Override
    @Nullable
    public PluginId getCallerPlugin(int stackFrameCount) {
        Class<?> aClass = ReflectionUtil.getCallerClass(stackFrameCount + 1);
        if (aClass == null) {
            return null;
        }
        ClassLoader classLoader = aClass.getClassLoader();
        return classLoader instanceof PluginAwareClassLoader ? ((PluginAwareClassLoader)((Object)classLoader)).getPluginId() : null;
    }

    @Override
    @Nullable
    public PluginId findPluginId(@NotNull Throwable t) {
        if (t == null) {
            PluginUtilImpl.$$$reportNull$$$0(0);
        }
        return PluginUtilImpl.doFindPluginId(t);
    }

    @Nullable
    public static PluginId doFindPluginId(@NotNull Throwable t) {
        Throwable cause;
        PluginId id;
        String s;
        int pos;
        CharSequence className;
        if (t == null) {
            PluginUtilImpl.$$$reportNull$$$0(1);
        }
        if (t instanceof PluginException) {
            return ((PluginException)t).getPluginId();
        }
        PluginId bundledId = null;
        HashSet<String> visitedClassNames = new HashSet<String>();
        for (StackTraceElement element : t.getStackTrace()) {
            PluginId id2;
            String className2;
            if (element == null || !visitedClassNames.add(className2 = element.getClassName())) continue;
            PluginDescriptor descriptor = PluginManagerCore.getPluginDescriptorOrPlatformByClassName(className2);
            PluginId pluginId = id2 = descriptor == null ? null : descriptor.getPluginId();
            if (id2 == null || PluginManagerCore.CORE_ID.equals(id2)) continue;
            if (descriptor.isBundled()) {
                if (bundledId != null) continue;
                bundledId = id2;
                PluginUtilImpl.logPluginDetection(className2, id2);
                continue;
            }
            PluginUtilImpl.logPluginDetection(className2, id2);
            return id2;
        }
        if (t instanceof NoSuchMethodException) {
            if (t.getMessage() != null) {
                className = new StringBuilder();
                StringTokenizer tok = new StringTokenizer(t.getMessage(), ".");
                while (tok.hasMoreTokens()) {
                    String token = tok.nextToken();
                    if (token.isEmpty() || !Character.isJavaIdentifierStart(token.charAt(0))) continue;
                    ((StringBuilder)className).append(token);
                }
                PluginId pluginId = PluginManagerCore.getPluginByClassName(((StringBuilder)className).toString());
                if (pluginId != null) {
                    return pluginId;
                }
            }
        } else if (t instanceof ClassNotFoundException) {
            PluginId id3;
            if (t.getMessage() != null && (id3 = PluginManagerCore.getPluginByClassName(t.getMessage())) != null) {
                return id3;
            }
        } else if (t instanceof NoClassDefFoundError && t.getMessage() != null) {
            PluginId id4;
            className = StringUtil.substringAfterLast(t.getMessage(), " ");
            if (className == null) {
                className = t.getMessage();
            }
            if (((String)className).indexOf(47) > 0) {
                className = ((String)className).replace('/', '.');
            }
            if ((id4 = PluginManagerCore.getPluginByClassName((String)className)) != null) {
                return PluginManagerCore.getPluginByClassName((String)className);
            }
        } else if (t instanceof AbstractMethodError && t.getMessage() != null && (pos = (s = t.getMessage()).indexOf(40)) >= 0 && (pos = (s = s.substring(0, pos)).lastIndexOf(46)) >= 0 && (id = PluginManagerCore.getPluginByClassName(s = s.substring(0, pos))) != null) {
            return id;
        }
        PluginId causeId = (cause = t.getCause()) == null ? null : PluginUtilImpl.doFindPluginId(cause);
        return causeId != null ? causeId : bundledId;
    }

    private static void logPluginDetection(String className, PluginId id) {
        if (LOG.isDebugEnabled()) {
            String message = "Detected a plugin " + id + " by class " + className;
            IdeaPluginDescriptor descriptor = PluginManagerCore.getPlugin(id);
            if (descriptor != null) {
                ClassLoader loader = descriptor.getPluginClassLoader();
                message = message + "; loader=" + loader + '/' + loader.getClass();
                if (loader instanceof PluginClassLoader) {
                    message = message + "; loaded class: " + ((PluginClassLoader)loader).hasLoadedClass(className);
                }
            }
            LOG.debug(message);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "t";
        objectArray2[1] = "com/intellij/ide/plugins/PluginUtilImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findPluginId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "doFindPluginId";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

