/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class PluginManager {
    public static final String INSTALLED_TXT = "installed.txt";
    public static final Pattern EXPLICIT_BIG_NUMBER_PATTERN = Pattern.compile("(.*)\\.(9{4,}+|10{4,}+)");

    @NotNull
    public static PluginManager getInstance() {
        PluginManager pluginManager = ApplicationManager.getApplication().getService(PluginManager.class);
        if (pluginManager == null) {
            PluginManager.$$$reportNull$$$0(0);
        }
        return pluginManager;
    }

    private PluginManager() {
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.2")
    public void addDisablePluginListener(@NotNull Runnable listener) {
        if (listener == null) {
            PluginManager.$$$reportNull$$$0(1);
        }
        DisabledPluginsState.addDisablePluginListener(listener);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.2")
    public void removeDisablePluginListener(@NotNull Runnable listener) {
        if (listener == null) {
            PluginManager.$$$reportNull$$$0(2);
        }
        DisabledPluginsState.removeDisablePluginListener(listener);
    }

    @Nullable
    public static Path getOnceInstalledIfExists() {
        Path onceInstalledFile = PathManager.getConfigDir().resolve(INSTALLED_TXT);
        return Files.isRegularFile(onceInstalledFile, new LinkOption[0]) ? onceInstalledFile : null;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static void processException(@NotNull Throwable t) {
        if (t == null) {
            PluginManager.$$$reportNull$$$0(3);
        }
        try {
            Class<?> aClass = PluginManager.class.getClassLoader().loadClass("com.intellij.ide.plugins.StartupAbortedException");
            Method method = aClass.getMethod("processException", Throwable.class);
            method.setAccessible(true);
            method.invoke(null, t);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    @Nullable
    public static IdeaPluginDescriptor getPlugin(@Nullable PluginId id) {
        return PluginManagerCore.getPlugin(id);
    }

    public static IdeaPluginDescriptor @NotNull [] getPlugins() {
        IdeaPluginDescriptor[] ideaPluginDescriptorArray = PluginManagerCore.getPlugins();
        if (ideaPluginDescriptorArray == null) {
            PluginManager.$$$reportNull$$$0(4);
        }
        return ideaPluginDescriptorArray;
    }

    public static boolean isPluginInstalled(PluginId id) {
        return PluginManagerCore.isPluginInstalled(id);
    }

    @Nullable
    public static PluginId getPluginByClassName(@NotNull String className) {
        if (className == null) {
            PluginManager.$$$reportNull$$$0(5);
        }
        return PluginManagerCore.getPluginByClassName(className);
    }

    @NotNull
    public static List<? extends IdeaPluginDescriptor> getLoadedPlugins() {
        List<? extends IdeaPluginDescriptor> list = PluginManagerCore.getLoadedPlugins();
        if (list == null) {
            PluginManager.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    public PluginId getPluginOrPlatformByClassName(@NotNull String className) {
        if (className == null) {
            PluginManager.$$$reportNull$$$0(7);
        }
        return PluginManagerCore.getPluginOrPlatformByClassName(className);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    @NotNull
    public static List<String> getDisabledPlugins() {
        final Set<PluginId> list = DisabledPluginsState.disabledPlugins();
        return new AbstractList<String>(){

            @Override
            public boolean contains(Object o) {
                return list.contains(o);
            }

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public String get(int index) {
                if (index < 0 || index >= list.size()) {
                    throw new IndexOutOfBoundsException("index=" + index + " size=" + list.size());
                }
                Iterator iterator = list.iterator();
                for (int i = 0; i < index; ++i) {
                    iterator.next();
                }
                return ((PluginId)iterator.next()).getIdString();
            }
        };
    }

    public static boolean disablePlugin(@NotNull String id) {
        if (id == null) {
            PluginManager.$$$reportNull$$$0(8);
        }
        return PluginManagerCore.disablePlugin(PluginId.getId(id));
    }

    @Deprecated
    public static boolean enablePlugin(@NotNull String id) {
        if (id == null) {
            PluginManager.$$$reportNull$$$0(9);
        }
        return PluginManagerCore.enablePlugin(PluginId.getId(id));
    }

    public boolean enablePlugin(@NotNull PluginId id) {
        if (id == null) {
            PluginManager.$$$reportNull$$$0(10);
        }
        return PluginManagerCore.enablePlugin(id);
    }

    @ApiStatus.Internal
    @NotNull
    public static Logger getLogger() {
        Logger logger = PluginManagerCore.getLogger();
        if (logger == null) {
            PluginManager.$$$reportNull$$$0(11);
        }
        return logger;
    }

    @Nullable
    public IdeaPluginDescriptor findEnabledPlugin(@NotNull PluginId id) {
        if (id == null) {
            PluginManager.$$$reportNull$$$0(12);
        }
        List<IdeaPluginDescriptorImpl> result = PluginManagerCore.getLoadedPlugins(null);
        for (IdeaPluginDescriptor ideaPluginDescriptor : result) {
            if (!id.equals(ideaPluginDescriptor.getPluginId())) continue;
            return ideaPluginDescriptor;
        }
        return null;
    }

    public boolean hideImplementationDetails() {
        return !Registry.is("plugins.show.implementation.details");
    }

    @NotNull
    public Disposable createDisposable(@NotNull Class<?> requestor) {
        ClassLoader classLoader;
        if (requestor == null) {
            PluginManager.$$$reportNull$$$0(13);
        }
        if (!((classLoader = requestor.getClassLoader()) instanceof PluginAwareClassLoader)) {
            Disposable disposable = Disposer.newDisposable();
            if (disposable == null) {
                PluginManager.$$$reportNull$$$0(14);
            }
            return disposable;
        }
        final int classLoaderId = ((PluginAwareClassLoader)((Object)classLoader)).getInstanceId();
        return new PluginAwareDisposable(){

            @Override
            public int getClassLoaderId() {
                return classLoaderId;
            }

            @Override
            public void dispose() {
            }
        };
    }

    @NotNull
    public Disposable createDisposable(@NotNull Class<?> requestor, @NotNull ComponentManager parentDisposable) {
        if (requestor == null) {
            PluginManager.$$$reportNull$$$0(15);
        }
        if (parentDisposable == null) {
            PluginManager.$$$reportNull$$$0(16);
        }
        Disposable disposable = this.createDisposable(requestor);
        Disposer.register(parentDisposable, disposable);
        Disposable disposable2 = disposable;
        if (disposable2 == null) {
            PluginManager.$$$reportNull$$$0(17);
        }
        return disposable2;
    }

    @ApiStatus.Internal
    @Nullable
    public static String convertExplicitBigNumberInUntilBuildToStar(@Nullable String build) {
        if (build == null) {
            return null;
        }
        Matcher matcher = EXPLICIT_BIG_NUMBER_PATTERN.matcher(build);
        return matcher.matches() ? matcher.group(1) + ".*" : build;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginManager";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlugins";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedPlugins";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 14: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addDisablePluginListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeDisablePluginListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processException";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPluginByClassName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPluginOrPlatformByClassName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "disablePlugin";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "enablePlugin";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findEnabledPlugin";
                break;
            }
            case 13: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createDisposable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface PluginAwareDisposable
    extends Disposable {
        public int getClassLoaderId();
    }
}

