/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB-\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\bBA\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\r\u0010\u0019\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0012H\u0016R\u0011\u0010\u000e\u001a\u00020\u00068G\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00068G\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0010R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ide/plugins/PluginLoadingError;", "", "plugin", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "detailedMessageSupplier", "Ljava/util/function/Supplier;", "", "shortMessageSupplier", "(Lcom/intellij/ide/plugins/IdeaPluginDescriptor;Ljava/util/function/Supplier;Ljava/util/function/Supplier;)V", "isNotifyUser", "", "disabledDependency", "Lcom/intellij/openapi/extensions/PluginId;", "(Lcom/intellij/ide/plugins/IdeaPluginDescriptor;Ljava/util/function/Supplier;Ljava/util/function/Supplier;ZLcom/intellij/openapi/extensions/PluginId;)V", "detailedMessage", "getDetailedMessage", "()Ljava/lang/String;", "internalMessage", "Lorg/jetbrains/annotations/NonNls;", "getInternalMessage", "()Z", "getPlugin", "()Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "shortMessage", "getShortMessage", "toString", "Companion", "intellij.platform.core.impl"})
public final class PluginLoadingError {
    @NotNull
    private final IdeaPluginDescriptor plugin;
    private final Supplier<String> detailedMessageSupplier;
    private final Supplier<String> shortMessageSupplier;
    private final boolean isNotifyUser;
    @JvmField
    @Nullable
    public final PluginId disabledDependency;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NlsContexts.DetailedDescription
    @NotNull
    public final String getDetailedMessage() {
        Supplier<String> supplier = this.detailedMessageSupplier;
        Intrinsics.checkNotNull(supplier);
        String string = supplier.get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"detailedMessageSupplier!!.get()");
        return string;
    }

    @NotNull
    public String toString() {
        return this.getInternalMessage();
    }

    @NotNull
    public final String getInternalMessage() {
        Supplier<String> supplier = this.detailedMessageSupplier;
        if (supplier == null) {
            supplier = this.shortMessageSupplier;
        }
        String string = supplier.get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(detailedMessageSupplier\u2026ortMessageSupplier).get()");
        return Companion.formatErrorMessage(this.plugin, string);
    }

    @NlsContexts.Label
    @NotNull
    public final String getShortMessage() {
        String string = this.shortMessageSupplier.get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortMessageSupplier.get()");
        return string;
    }

    @NotNull
    public final IdeaPluginDescriptor getPlugin() {
        return this.plugin;
    }

    public final boolean isNotifyUser() {
        return this.isNotifyUser;
    }

    public PluginLoadingError(@NotNull IdeaPluginDescriptor plugin, @Nullable Supplier<String> detailedMessageSupplier, @NotNull Supplier<String> shortMessageSupplier, boolean isNotifyUser, @Nullable PluginId disabledDependency) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter(shortMessageSupplier, (String)"shortMessageSupplier");
        this.plugin = plugin;
        this.detailedMessageSupplier = detailedMessageSupplier;
        this.shortMessageSupplier = shortMessageSupplier;
        this.isNotifyUser = isNotifyUser;
        this.disabledDependency = disabledDependency;
    }

    public /* synthetic */ PluginLoadingError(IdeaPluginDescriptor ideaPluginDescriptor, Supplier supplier, Supplier supplier2, boolean bl, PluginId pluginId, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            pluginId = null;
        }
        this(ideaPluginDescriptor, supplier, supplier2, bl, pluginId);
    }

    public PluginLoadingError(@NotNull IdeaPluginDescriptor plugin, @Nullable Supplier<String> detailedMessageSupplier, @NotNull Supplier<String> shortMessageSupplier) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter(shortMessageSupplier, (String)"shortMessageSupplier");
        this(plugin, detailedMessageSupplier, shortMessageSupplier, true, null, 16, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004\u00a8\u0006\t"}, d2={"Lcom/intellij/ide/plugins/PluginLoadingError$Companion;", "", "()V", "formatErrorMessage", "", "Lorg/jetbrains/annotations/NonNls;", "descriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "message", "intellij.platform.core.impl"})
    public static final class Companion {
        @NotNull
        public final String formatErrorMessage(@NotNull IdeaPluginDescriptor descriptor, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            String path = ((Object)descriptor.getPluginPath()).toString();
            StringBuilder builder = new StringBuilder();
            builder.append("The ").append(descriptor.getName()).append(" (id=").append(descriptor.getPluginId()).append(", path=");
            builder.append(FileUtil.getLocationRelativeToUserHome(path, false));
            String version = descriptor.getVersion();
            if (version != null && !descriptor.isBundled() && Intrinsics.areEqual((Object)version, (Object)PluginManagerCore.getBuildNumber().asString()) ^ true) {
                builder.append(", version=").append(version);
            }
            builder.append(") plugin ").append(message);
            String string = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

