/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.plugins.ClassPathXmlPathResolver;
import com.intellij.ide.plugins.DescriptorListLoadingContext;
import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.ImmutableZipFileDataLoader;
import com.intellij.ide.plugins.JavaZipFileDataLoader;
import com.intellij.ide.plugins.LoadDescriptorsFromClassPathAction;
import com.intellij.ide.plugins.LoadDescriptorsFromDirAction;
import com.intellij.ide.plugins.PathResolver;
import com.intellij.ide.plugins.PluginLoadingResult;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginXmlPathResolver;
import com.intellij.ide.plugins.RawPluginDescriptor;
import com.intellij.ide.plugins.ReadModuleContext;
import com.intellij.ide.plugins.XmlReader;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.platform.util.plugins.DataLoader;
import com.intellij.platform.util.plugins.LocalFsDataLoader;
import com.intellij.util.PlatformUtils;
import com.intellij.util.io.Decompressor;
import com.intellij.util.lang.ZipFilePool;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Supplier;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLStreamException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000z\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0002\u001a0\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000bH\u0002\u001a\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0000\u001a\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0002\u001a^\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u00172\u001a\u0010\u001a\u001a\u0016\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u001d\u0018\u00010\u001b2\u000e\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u001f2\u000e\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u001f\u001a2\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00172\b\u0010&\u001a\u0004\u0018\u00010\u00172\u0006\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u0013H\u0002\u001a \u0010)\u001a\u0004\u0018\u00010 2\u0006\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020$\u001a.\u0010)\u001a\u0004\u0018\u00010 2\u0006\u0010*\u001a\u00020\u00172\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001d2\u0006\u0010+\u001a\u00020\u00132\u0006\u0010.\u001a\u00020/\u001a\u001a\u00100\u001a\u0004\u0018\u00010 2\u0006\u0010*\u001a\u00020\u00172\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u001aD\u00101\u001a\u0004\u0018\u00010 2\u0006\u0010*\u001a\u00020\u00172\u0006\u00102\u001a\u00020\u000b2\b\u00103\u001a\u0004\u0018\u00010\u00172\u0006\u0010#\u001a\u00020$2\u0006\u0010+\u001a\u00020\u00132\u0006\u00104\u001a\u00020\u00132\u0006\u0010.\u001a\u00020/H\u0002\u001a@\u00105\u001a\u0004\u0018\u00010 2\u0006\u0010*\u001a\u00020\u00172\u0006\u00106\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020$2\u0006\u0010.\u001a\u00020/2\u0006\u0010+\u001a\u00020\u00132\u0006\u00104\u001a\u00020\u00132\u0006\u00107\u001a\u00020\u0013\u001aD\u00108\u001a\u0004\u0018\u00010 2\u0006\u0010*\u001a\u00020\u00172\u0006\u00109\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020/2\u0006\u0010,\u001a\u00020$2\u0006\u0010+\u001a\u00020\u00132\u0006\u00104\u001a\u00020\u00132\b\u00103\u001a\u0004\u0018\u00010\u0017H\u0002\u001a\u0018\u0010:\u001a\u00020$2\u0006\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u0013H\u0000\u001a\u0018\u0010;\u001a\u00020\u00052\u0006\u0010<\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$H\u0002\u001a\u001a\u0010=\u001a\u0004\u0018\u00010 2\u0006\u0010>\u001a\u00020\u00172\u0006\u00109\u001a\u00020\u000bH\u0000\u001aB\u0010?\u001a\u0004\u0018\u00010 2\u0006\u0010*\u001a\u00020\u00172\u0006\u00106\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020$2\u0006\u0010+\u001a\u00020\u00132\u0006\u00104\u001a\u00020\u00132\u0006\u00102\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020/H\u0002\u001a\u001c\u0010@\u001a\b\u0012\u0004\u0012\u00020 0A2\u0006\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u0013\u001a\u001e\u0010B\u001a\u00020\u00052\u0006\u0010C\u001a\u00020\u00172\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00170\u001fH\u0002\u001a\u0016\u0010E\u001a\b\u0012\u0004\u0012\u00020F0A2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006G"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "collectPluginFilesInClassPath", "", "loader", "Ljava/lang/ClassLoader;", "urls", "", "Ljava/net/URL;", "", "computePlatformPluginUrlAndCollectPluginUrls", "platformPrefix", "createPluginLoadingResult", "Lcom/intellij/ide/plugins/PluginLoadingResult;", "buildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "fileNameIsLikeVersionedLibraryName", "", "name", "getDescriptorsToMigrate", "dir", "Ljava/nio/file/Path;", "compatibleBuildNumber", "bundledPluginsPath", "brokenPluginVersions", "", "Lcom/intellij/openapi/extensions/PluginId;", "", "pluginsToMigrate", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "incompatiblePlugins", "loadBundledDescriptorsAndDescriptorsFromDir", "context", "Lcom/intellij/ide/plugins/DescriptorListLoadingContext;", "customPluginDir", "bundledPluginDir", "isUnitTestMode", "isRunningFromSources", "loadDescriptor", "file", "isBundled", "parentContext", "disabledPlugins", "pathResolver", "Lcom/intellij/ide/plugins/PathResolver;", "loadDescriptorFromArtifact", "loadDescriptorFromDir", "descriptorRelativePath", "pluginPath", "isEssential", "loadDescriptorFromFileOrDir", "pathName", "isDirectory", "loadDescriptorFromJar", "fileName", "loadDescriptors", "loadDescriptorsFromProperty", "result", "loadForCoreEnv", "pluginRoot", "loadFromPluginDir", "loadUncachedDescriptors", "", "putMoreLikelyPluginJarsFirst", "pluginDir", "filesInLibUnderPluginDir", "testLoadDescriptorsFromClassPath", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "intellij.platform.core.impl"})
@JvmName(name="PluginDescriptorLoader")
@ApiStatus.Internal
public final class PluginDescriptorLoader {
    private static final Logger getLOG() {
        Logger logger = PluginManagerCore.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"PluginManagerCore.getLogger()");
        return logger;
    }

    @NotNull
    public static final PluginLoadingResult createPluginLoadingResult(@Nullable BuildNumber buildNumber) {
        Map<PluginId, Set<String>> map = PluginManagerCore.getBrokenPluginVersions();
        Intrinsics.checkNotNullExpressionValue(map, (String)"PluginManagerCore.getBrokenPluginVersions()");
        return new PluginLoadingResult(map, new Supplier(buildNumber){
            final /* synthetic */ BuildNumber $buildNumber;

            @NotNull
            public final BuildNumber get() {
                BuildNumber buildNumber = this.$buildNumber;
                if (buildNumber == null) {
                    BuildNumber buildNumber2 = PluginManagerCore.getBuildNumber();
                    buildNumber = buildNumber2;
                    Intrinsics.checkNotNullExpressionValue((Object)buildNumber2, (String)"PluginManagerCore.getBuildNumber()");
                }
                return buildNumber;
            }
            {
                this.$buildNumber = buildNumber;
            }
        }, false, 4, null);
    }

    @Nullable
    public static final IdeaPluginDescriptorImpl loadDescriptor(@NotNull Path file, boolean isBundled, @NotNull DescriptorListLoadingContext parentContext) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)parentContext, (String)"parentContext");
        return PluginDescriptorLoader.loadDescriptorFromFileOrDir(file, "plugin.xml", parentContext, PluginXmlPathResolver.DEFAULT_PATH_RESOLVER, isBundled, false, Files.isDirectory(file, new LinkOption[0]));
    }

    @Nullable
    public static final IdeaPluginDescriptorImpl loadForCoreEnv(@NotNull Path pluginRoot, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)pluginRoot, (String)"pluginRoot");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        PathResolver pathResolver = PluginXmlPathResolver.DEFAULT_PATH_RESOLVER;
        Set<PluginId> set = DisabledPluginsState.disabledPlugins();
        Intrinsics.checkNotNullExpressionValue(set, (String)"DisabledPluginsState.disabledPlugins()");
        DescriptorListLoadingContext parentContext = new DescriptorListLoadingContext(set, null, false, false, false, false, 62, null);
        if (Files.isDirectory(pluginRoot, new LinkOption[0])) {
            return PluginDescriptorLoader.loadDescriptorFromDir(pluginRoot, "META-INF/" + fileName, null, parentContext, true, true, pathResolver);
        }
        return PluginDescriptorLoader.loadDescriptorFromJar(pluginRoot, fileName, pathResolver, parentContext, true, true, null);
    }

    private static final IdeaPluginDescriptorImpl loadDescriptorFromDir(Path file, String descriptorRelativePath, Path pluginPath, DescriptorListLoadingContext context2, boolean isBundled, boolean isEssential, PathResolver pathResolver) {
        try {
            byte[] input = Files.readAllBytes(file.resolve(descriptorRelativePath));
            LocalFsDataLoader dataLoader2 = new LocalFsDataLoader(file);
            Intrinsics.checkNotNullExpressionValue((Object)input, (String)"input");
            RawPluginDescriptor raw = XmlReader.readModuleDescriptor(input, (ReadModuleContext)context2, pathResolver, (DataLoader)dataLoader2, null, null, ((Object)file).toString());
            Path path = pluginPath;
            if (path == null) {
                path = file;
            }
            IdeaPluginDescriptorImpl descriptor = new IdeaPluginDescriptorImpl(raw, path, isBundled, null);
            descriptor.readExternal(raw, pathResolver, context2, false, dataLoader2);
            descriptor.jarFiles = Collections.singletonList(file);
            return descriptor;
        }
        catch (NoSuchFileException e) {
            return null;
        }
        catch (Throwable e) {
            if (isEssential) {
                throw e;
            }
            PluginDescriptorLoader.getLOG().warn("Cannot load " + file.resolve(descriptorRelativePath), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final IdeaPluginDescriptorImpl loadDescriptorFromJar(Path file, String fileName, PathResolver pathResolver, DescriptorListLoadingContext parentContext, boolean isBundled, boolean isEssential, Path pluginPath) {
        Closeable closeable = null;
        try {
            byte[] byArray;
            DataLoader dataLoader2 = null;
            ZipFilePool pool = ZipFilePool.POOL;
            if (pool == null || parentContext.transient) {
                ZipFile zipFile = new ZipFile(file.toFile(), StandardCharsets.UTF_8);
                closeable = zipFile;
                dataLoader2 = new JavaZipFileDataLoader(zipFile);
            } else {
                ZipFilePool.EntryResolver entryResolver = pool.load(file);
                Intrinsics.checkNotNullExpressionValue((Object)entryResolver, (String)"pool.load(file)");
                dataLoader2 = new ImmutableZipFileDataLoader(entryResolver, file, pool);
            }
            if (dataLoader2.load("META-INF/" + fileName) == null) {
                IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = null;
                return ideaPluginDescriptorImpl;
            }
            RawPluginDescriptor raw = XmlReader.readModuleDescriptor(byArray, (ReadModuleContext)parentContext, pathResolver, dataLoader2, null, null, ((Object)file).toString());
            Path path = pluginPath;
            if (path == null) {
                path = file;
            }
            IdeaPluginDescriptorImpl descriptor = new IdeaPluginDescriptorImpl(raw, path, isBundled, null);
            descriptor.readExternal(raw, pathResolver, parentContext, false, dataLoader2);
            descriptor.jarFiles = Collections.singletonList(descriptor.getPluginPath());
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = descriptor;
            return ideaPluginDescriptorImpl;
        }
        catch (Throwable e) {
            if (isEssential) {
                throw e instanceof XMLStreamException ? (Throwable)new RuntimeException("Cannot read " + file, e) : e;
            }
            parentContext.result.reportCannotLoad(file, e);
        }
        finally {
            Closeable closeable2 = closeable;
            if (closeable2 != null) {
                closeable2.close();
            }
        }
        return null;
    }

    @Nullable
    public static final IdeaPluginDescriptorImpl loadDescriptorFromFileOrDir(@NotNull Path file, @NotNull String pathName, @NotNull DescriptorListLoadingContext context2, @NotNull PathResolver pathResolver, boolean isBundled, boolean isEssential, boolean isDirectory) {
        IdeaPluginDescriptorImpl ideaPluginDescriptorImpl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)pathName, (String)"pathName");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pathResolver, (String)"pathResolver");
        if (isDirectory) {
            String descriptorRelativePath = "META-INF/" + pathName;
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl2 = PluginDescriptorLoader.loadDescriptorFromDir(file, descriptorRelativePath, null, context2, isBundled, isEssential, pathResolver);
            if (ideaPluginDescriptorImpl2 != null) {
                IdeaPluginDescriptorImpl ideaPluginDescriptorImpl3 = ideaPluginDescriptorImpl2;
                boolean bl = false;
                boolean bl2 = false;
                IdeaPluginDescriptorImpl it = ideaPluginDescriptorImpl3;
                boolean bl3 = false;
                return it;
            }
            ideaPluginDescriptorImpl = PluginDescriptorLoader.loadFromPluginDir(file, pathName, context2, isBundled, isEssential, descriptorRelativePath, pathResolver);
        } else {
            ideaPluginDescriptorImpl = StringsKt.endsWith((String)((Object)file.getFileName()).toString(), (String)".jar", (boolean)true) ? PluginDescriptorLoader.loadDescriptorFromJar(file, pathName, pathResolver, context2, isBundled, isEssential, null) : null;
        }
        return ideaPluginDescriptorImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final IdeaPluginDescriptorImpl loadFromPluginDir(Path file, String pathName, DescriptorListLoadingContext parentContext, boolean isBundled, boolean isEssential, String descriptorRelativePath, PathResolver pathResolver) {
        Object object;
        boolean bl;
        Object object2;
        ArrayList<Path> pluginJarFiles = new ArrayList<Path>();
        try {
            Closeable closeable = Files.newDirectoryStream(file.resolve("lib"));
            boolean bl2 = false;
            boolean bl3 = false;
            object2 = null;
            try {
                DirectoryStream stream = (DirectoryStream)closeable;
                bl = false;
                for (Path childFile : stream) {
                    String path = ((Object)childFile).toString();
                    if (!StringsKt.endsWith((String)path, (String)".jar", (boolean)true) && !StringsKt.endsWith((String)path, (String)".zip", (boolean)true)) continue;
                    pluginJarFiles.add(childFile);
                }
                object = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
            }
        }
        catch (NoSuchFileException e) {
            return null;
        }
        if (!pluginJarFiles.isEmpty()) {
            PluginDescriptorLoader.putMoreLikelyPluginJarsFirst(file, (List<Path>)pluginJarFiles);
            PluginXmlPathResolver pluginPathResolver = new PluginXmlPathResolver((List<? extends Path>)pluginJarFiles);
            object2 = pluginJarFiles.iterator();
            while (object2.hasNext()) {
                Path jarFile;
                Path path = jarFile = (Path)object2.next();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"jarFile");
                IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = PluginDescriptorLoader.loadDescriptorFromJar(path, pathName, pluginPathResolver, parentContext, isBundled, isEssential, file);
                if (ideaPluginDescriptorImpl == null) continue;
                object = ideaPluginDescriptorImpl;
                bl = false;
                boolean bl4 = false;
                Object it = object;
                boolean bl5 = false;
                it.jarFiles = pluginJarFiles;
                return it;
            }
        }
        if (!isBundled) {
            Path classesDir;
            Path path = classesDir = file.resolve("classes");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"classesDir");
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = PluginDescriptorLoader.loadDescriptorFromDir(path, descriptorRelativePath, file, parentContext, isBundled, isEssential, pathResolver);
            if (ideaPluginDescriptorImpl != null) {
                IdeaPluginDescriptorImpl ideaPluginDescriptorImpl2 = ideaPluginDescriptorImpl;
                boolean bl6 = false;
                boolean bl7 = false;
                IdeaPluginDescriptorImpl it = ideaPluginDescriptorImpl2;
                boolean bl8 = false;
                ArrayList<Path> classPath = new ArrayList<Path>(pluginJarFiles.size() + 1);
                classPath.add(classesDir);
                classPath.addAll((Collection)pluginJarFiles);
                it.jarFiles = classPath;
                return it;
            }
        }
        return null;
    }

    private static final void putMoreLikelyPluginJarsFirst(Path pluginDir, List<Path> filesInLibUnderPluginDir) {
        String pluginDirName = ((Object)pluginDir.getFileName()).toString();
        Collections.sort(filesInLibUnderPluginDir, new Comparator(pluginDirName){
            final /* synthetic */ String $pluginDirName;

            public final int compare(@NotNull Path o1, @NotNull Path o2) {
                boolean o1EndsWithIdea;
                boolean o1StartsWithNeededName;
                boolean o1IsVersioned;
                Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
                String o2Name = ((Object)o2.getFileName()).toString();
                String o1Name = ((Object)o1.getFileName()).toString();
                boolean o2StartsWithResources = StringsKt.startsWith$default((String)o2Name, (String)"resources", (boolean)false, (int)2, null);
                boolean o1StartsWithResources = StringsKt.startsWith$default((String)o1Name, (String)"resources", (boolean)false, (int)2, null);
                if (o2StartsWithResources != o1StartsWithResources) {
                    return o2StartsWithResources ? -1 : 1;
                }
                boolean o2IsVersioned = PluginDescriptorLoader.access$fileNameIsLikeVersionedLibraryName(o2Name);
                if (o2IsVersioned != (o1IsVersioned = PluginDescriptorLoader.access$fileNameIsLikeVersionedLibraryName(o1Name))) {
                    return o2IsVersioned ? -1 : 1;
                }
                boolean o2StartsWithNeededName = StringsKt.startsWith((String)o2Name, (String)this.$pluginDirName, (boolean)true);
                if (o2StartsWithNeededName != (o1StartsWithNeededName = StringsKt.startsWith((String)o1Name, (String)this.$pluginDirName, (boolean)true))) {
                    return o2StartsWithNeededName ? 1 : -1;
                }
                boolean o2EndsWithIdea = StringsKt.endsWith$default((String)o2Name, (String)"-idea.jar", (boolean)false, (int)2, null);
                if (o2EndsWithIdea != (o1EndsWithIdea = StringsKt.endsWith$default((String)o1Name, (String)"-idea.jar", (boolean)false, (int)2, null))) {
                    return o2EndsWithIdea ? 1 : -1;
                }
                return o1Name.length() - o2Name.length();
            }
            {
                this.$pluginDirName = string;
            }
        });
    }

    private static final boolean fileNameIsLikeVersionedLibraryName(String name) {
        int i = StringsKt.lastIndexOf$default((CharSequence)name, (char)'-', (int)0, (boolean)false, (int)6, null);
        if (i == -1) {
            return false;
        }
        if (i + 1 < name.length()) {
            char c = name.charAt(i + 1);
            return Character.isDigit(c) || (c == 'm' || c == 'M') && i + 2 < name.length() && Character.isDigit(name.charAt(i + 2));
        }
        return false;
    }

    private static final void loadDescriptorsFromProperty(PluginLoadingResult result, DescriptorListLoadingContext context2) {
        String string = System.getProperty("plugin.path");
        if (string == null) {
            return;
        }
        String pathProperty = string;
        boolean useCoreClassLoaderForPluginsFromProperty = Boolean.parseBoolean(System.getProperty("idea.use.core.classloader.for.plugin.path"));
        StringTokenizer t = new StringTokenizer(pathProperty, String.valueOf(File.pathSeparatorChar) + ",");
        while (t.hasMoreTokens()) {
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl;
            String s = t.nextToken();
            Path path = Paths.get(s, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(s)");
            if (PluginDescriptorLoader.loadDescriptor(path, false, context2) == null) continue;
            boolean bl = false;
            boolean bl2 = false;
            IdeaPluginDescriptorImpl it = ideaPluginDescriptorImpl;
            boolean bl3 = false;
            result.add(it, true);
            if (!useCoreClassLoaderForPluginsFromProperty) continue;
            it.setUseCoreClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DescriptorListLoadingContext loadDescriptors(boolean isUnitTestMode, boolean isRunningFromSources) {
        PluginLoadingResult result = PluginDescriptorLoader.createPluginLoadingResult(null);
        Path bundledPluginPath = isUnitTestMode ? null : (Boolean.getBoolean("idea.use.dev.build.server") ? Paths.get(PathManager.getHomePath(), "out/dev-run", PlatformUtils.getPlatformPrefix(), "plugins") : Paths.get(PathManager.getPreInstalledPluginsPath(), new String[0]));
        boolean bl = isUnitTestMode || isRunningFromSources;
        Set<PluginId> set = DisabledPluginsState.disabledPlugins();
        Intrinsics.checkNotNullExpressionValue(set, (String)"DisabledPluginsState.disabledPlugins()");
        boolean bl2 = false;
        PluginLoadingResult pluginLoadingResult = result;
        Set<PluginId> set2 = set;
        boolean bl3 = bl;
        boolean bl4 = isUnitTestMode;
        boolean bl5 = true;
        DescriptorListLoadingContext context2 = new DescriptorListLoadingContext(set2, pluginLoadingResult, bl4, bl5, bl3, bl2, 32, null);
        AutoCloseable autoCloseable = context2;
        boolean bl6 = false;
        boolean bl7 = false;
        Throwable throwable = null;
        try {
            DescriptorListLoadingContext it = (DescriptorListLoadingContext)autoCloseable;
            boolean bl8 = false;
            Path path = Paths.get(PathManager.getPluginsPath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(PathManager.getPluginsPath())");
            PluginDescriptorLoader.loadBundledDescriptorsAndDescriptorsFromDir(context2, path, bundledPluginPath, isUnitTestMode, isRunningFromSources);
            PluginDescriptorLoader.loadDescriptorsFromProperty(result, context2);
            if (isUnitTestMode && result.enabledPluginCount() <= 1) {
                ForkJoinPool forkJoinPool = ForkJoinPool.commonPool();
                Path path2 = Paths.get(PathManager.getPreInstalledPluginsPath(), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Paths.get(PathManager.ge\u2026reInstalledPluginsPath())");
                forkJoinPool.invoke(new LoadDescriptorsFromDirAction(path2, context2, true));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        context2.result.finishLoading();
        return context2;
    }

    private static final void loadBundledDescriptorsAndDescriptorsFromDir(DescriptorListLoadingContext context2, Path customPluginDir, Path bundledPluginDir, boolean isUnitTestMode, boolean isRunningFromSources) {
        ClassLoader classLoader = DescriptorListLoadingContext.class.getClassLoader();
        ForkJoinPool pool = ForkJoinPool.commonPool();
        Activity activity = StartUpMeasurer.startActivity("platform plugin collecting", ActivityCategory.DEFAULT);
        Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"StartUpMeasurer.startAct\u2026ActivityCategory.DEFAULT)");
        Activity activity2 = activity;
        String string = PlatformUtils.getPlatformPrefix();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PlatformUtils.getPlatformPrefix()");
        String platformPrefix = string;
        ClassLoader classLoader2 = classLoader;
        Intrinsics.checkNotNullExpressionValue((Object)classLoader2, (String)"classLoader");
        ClassPathXmlPathResolver pathResolver = new ClassPathXmlPathResolver(classLoader2, isRunningFromSources);
        if ((Intrinsics.areEqual((Object)platformPrefix, (Object)"idea") || Intrinsics.areEqual((Object)platformPrefix, (Object)"WebStorm")) && (Boolean.getBoolean("idea.use.dev.build.server") || !isUnitTestMode && !isRunningFromSources)) {
            DataLoader dataLoader2 = new DataLoader(){

                @NotNull
                public ZipFilePool getPool() {
                    throw (Throwable)new IllegalStateException("must be not called");
                }

                @NotNull
                public Void load(@NotNull String path) {
                    Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                    throw (Throwable)new IllegalStateException("must be not called");
                }

                @NotNull
                public String toString() {
                    return "product classpath";
                }

                public boolean isExcludedFromSubSearch(@NotNull Path jarFile) {
                    Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
                    return DataLoader.DefaultImpls.isExcludedFromSubSearch(this, jarFile);
                }
            };
            InputStream inputStream = classLoader.getResourceAsStream("META-INF/plugin.xml");
            Intrinsics.checkNotNull((Object)inputStream);
            RawPluginDescriptor raw = XmlReader.readModuleDescriptor(inputStream, (ReadModuleContext)context2, (PathResolver)pathResolver, dataLoader2, null, null, null);
            Path path = Paths.get(PathManager.getLibPath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(PathManager.getLibPath())");
            IdeaPluginDescriptorImpl descriptor = new IdeaPluginDescriptorImpl(raw, path, true, null);
            descriptor.readExternal(raw, pathResolver, context2, false, dataLoader2);
            descriptor.setUseCoreClassLoader();
            context2.result.add(descriptor, false);
        } else {
            LinkedHashMap urlsFromClassPath = new LinkedHashMap();
            URL platformPluginURL = PluginDescriptorLoader.computePlatformPluginUrlAndCollectPluginUrls(classLoader, urlsFromClassPath, platformPrefix);
            if (!urlsFromClassPath.isEmpty()) {
                Activity activity3 = activity2.endAndStart("plugin from classpath loading");
                Intrinsics.checkNotNullExpressionValue((Object)activity3, (String)"activity.endAndStart(\"pl\u2026 from classpath loading\")");
                activity2 = activity3;
                pool.invoke(new LoadDescriptorsFromClassPathAction(urlsFromClassPath, context2, platformPluginURL, pathResolver));
            }
        }
        Activity activity4 = activity2.endAndStart("plugin from user dir loading");
        Intrinsics.checkNotNullExpressionValue((Object)activity4, (String)"activity.endAndStart(\"pl\u2026n from user dir loading\")");
        activity2 = activity4;
        pool.invoke(new LoadDescriptorsFromDirAction(customPluginDir, context2, false));
        if (bundledPluginDir != null) {
            Activity activity5 = activity2.endAndStart("plugin from bundled dir loading");
            Intrinsics.checkNotNullExpressionValue((Object)activity5, (String)"activity.endAndStart(\"pl\u2026rom bundled dir loading\")");
            activity2 = activity5;
            pool.invoke(new LoadDescriptorsFromDirAction(bundledPluginDir, context2, true));
        }
        activity2.end();
    }

    private static final URL computePlatformPluginUrlAndCollectPluginUrls(ClassLoader loader, Map<URL, String> urls, String platformPrefix) {
        URL result = null;
        if (platformPrefix != null) {
            String fileName = platformPrefix + "Plugin.xml";
            URL uRL = loader.getResource("META-INF/" + fileName);
            if (uRL != null) {
                URL uRL2 = uRL;
                boolean bl = false;
                boolean bl2 = false;
                URL it = uRL2;
                boolean bl3 = false;
                urls.put(it, fileName);
                result = it;
            }
        }
        PluginDescriptorLoader.collectPluginFilesInClassPath(loader, urls);
        return result;
    }

    private static final void collectPluginFilesInClassPath(ClassLoader loader, Map<URL, String> urls) {
        try {
            Enumeration<URL> enumeration = loader.getResources("META-INF/plugin.xml");
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"enumeration.nextElement()");
                urls.put(uRL, "plugin.xml");
            }
        }
        catch (IOException e) {
            PluginDescriptorLoader.getLOG().warn(e);
        }
    }

    @NotNull
    public static final List<IdeaPluginDescriptorImpl> loadUncachedDescriptors(boolean isUnitTestMode, boolean isRunningFromSources) {
        return PluginDescriptorLoader.loadDescriptors((boolean)isUnitTestMode, (boolean)isRunningFromSources).result.getEnabledPlugins();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final IdeaPluginDescriptorImpl loadDescriptorFromArtifact(@NotNull Path file, @Nullable BuildNumber buildNumber) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Set<PluginId> set = DisabledPluginsState.disabledPlugins();
        Intrinsics.checkNotNullExpressionValue(set, (String)"DisabledPluginsState.disabledPlugins()");
        boolean bl = true;
        boolean bl2 = false;
        PluginLoadingResult pluginLoadingResult = PluginDescriptorLoader.createPluginLoadingResult(buildNumber);
        boolean bl3 = false;
        Set<PluginId> set2 = set;
        boolean bl4 = true;
        DescriptorListLoadingContext context2 = new DescriptorListLoadingContext(set2, pluginLoadingResult, bl3, bl4, bl2, bl, 20, null);
        IdeaPluginDescriptorImpl descriptor = PluginDescriptorLoader.loadDescriptorFromFileOrDir(file, "plugin.xml", context2, PluginXmlPathResolver.DEFAULT_PATH_RESOLVER, false, false, false);
        if (descriptor != null || !StringsKt.endsWith$default((String)((Object)file).toString(), (String)".zip", (boolean)false, (int)2, null)) {
            return descriptor;
        }
        Path path = Files.createTempDirectory("plugin", new FileAttribute[0]);
        Intrinsics.checkNotNull((Object)path);
        Path outputDir = path;
        try {
            new Decompressor.Zip(file).extract(outputDir);
            try {
                List<Path> list = NioFiles.list(outputDir);
                Intrinsics.checkNotNullExpressionValue(list, (String)"NioFiles.list(outputDir)");
                Path rootDir = (Path)CollectionsKt.firstOrNull(list);
                if (rootDir != null) {
                    IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = PluginDescriptorLoader.loadDescriptorFromFileOrDir(rootDir, "plugin.xml", context2, PluginXmlPathResolver.DEFAULT_PATH_RESOLVER, false, false, true);
                    return ideaPluginDescriptorImpl;
                }
            }
            catch (NoSuchFileException noSuchFileException) {
            }
        }
        finally {
            NioFiles.deleteRecursively(outputDir);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final IdeaPluginDescriptorImpl loadDescriptor(@NotNull Path file, @NotNull Set<PluginId> disabledPlugins, boolean isBundled, @NotNull PathResolver pathResolver) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(disabledPlugins, (String)"disabledPlugins");
        Intrinsics.checkNotNullParameter((Object)pathResolver, (String)"pathResolver");
        AutoCloseable autoCloseable = new DescriptorListLoadingContext(disabledPlugins, null, false, false, false, false, 62, null);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            DescriptorListLoadingContext context2 = (DescriptorListLoadingContext)autoCloseable;
            boolean bl3 = false;
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = PluginDescriptorLoader.loadDescriptorFromFileOrDir(file, "plugin.xml", context2, pathResolver, isBundled, false, Files.isDirectory(file, new LinkOption[0]));
            return ideaPluginDescriptorImpl;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public static final void getDescriptorsToMigrate(@NotNull Path dir, @Nullable BuildNumber compatibleBuildNumber, @Nullable Path bundledPluginsPath, @Nullable Map<PluginId, ? extends Set<String>> brokenPluginVersions, @NotNull List<IdeaPluginDescriptorImpl> pluginsToMigrate, @NotNull List<IdeaPluginDescriptorImpl> incompatiblePlugins) throws ExecutionException, InterruptedException {
        IdeaPluginDescriptorImpl descriptor;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter(pluginsToMigrate, (String)"pluginsToMigrate");
        Intrinsics.checkNotNullParameter(incompatiblePlugins, (String)"incompatiblePlugins");
        Map<PluginId, Set<String>> map = brokenPluginVersions;
        if (map == null) {
            Map<PluginId, Set<String>> map2 = PluginManagerCore.getBrokenPluginVersions();
            map = map2;
            Intrinsics.checkNotNullExpressionValue(map2, (String)"PluginManagerCore.getBrokenPluginVersions()");
        }
        PluginLoadingResult loadingResult2 = new PluginLoadingResult(map, new Supplier(compatibleBuildNumber){
            final /* synthetic */ BuildNumber $compatibleBuildNumber;

            @NotNull
            public final BuildNumber get() {
                BuildNumber buildNumber = this.$compatibleBuildNumber;
                if (buildNumber == null) {
                    BuildNumber buildNumber2 = PluginManagerCore.getBuildNumber();
                    buildNumber = buildNumber2;
                    Intrinsics.checkNotNullExpressionValue((Object)buildNumber2, (String)"PluginManagerCore.getBuildNumber()");
                }
                return buildNumber;
            }
            {
                this.$compatibleBuildNumber = buildNumber;
            }
        }, false, 4, null);
        DescriptorListLoadingContext context2 = new DescriptorListLoadingContext(SetsKt.emptySet(), loadingResult2, true, true, false, false, 48, null);
        Path effectiveBundledPluginPath = bundledPluginsPath != null || PluginManagerCore.isUnitTestMode ? bundledPluginsPath : Paths.get(PathManager.getPreInstalledPluginsPath(), new String[0]);
        PluginDescriptorLoader.loadBundledDescriptorsAndDescriptorsFromDir(context2, dir, effectiveBundledPluginPath, PluginManagerCore.isUnitTestMode, PluginManagerCore.isRunningFromSources());
        Iterator<IdeaPluginDescriptorImpl> iterator = loadingResult2.idMap.values().iterator();
        while (iterator.hasNext()) {
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = descriptor = iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptorImpl, (String)"descriptor");
            if (ideaPluginDescriptorImpl.isBundled()) continue;
            if (loadingResult2.isBroken(descriptor.getPluginId())) {
                incompatiblePlugins.add(descriptor);
                continue;
            }
            pluginsToMigrate.add(descriptor);
        }
        iterator = loadingResult2.incompletePlugins.values().iterator();
        while (iterator.hasNext()) {
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = descriptor = iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptorImpl, (String)"descriptor");
            if (ideaPluginDescriptorImpl.isBundled()) continue;
            incompatiblePlugins.add(descriptor);
        }
    }

    @TestOnly
    @NotNull
    public static final List<IdeaPluginDescriptor> testLoadDescriptorsFromClassPath(@NotNull ClassLoader loader) {
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        LinkedHashMap urlsFromClassPath = new LinkedHashMap();
        PluginDescriptorLoader.collectPluginFilesInClassPath(loader, urlsFromClassPath);
        BuildNumber buildNumber = BuildNumber.fromString("2042.42");
        Intrinsics.checkNotNull((Object)buildNumber);
        Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"BuildNumber.fromString(\"2042.42\")!!");
        BuildNumber buildNumber2 = buildNumber;
        DescriptorListLoadingContext context2 = new DescriptorListLoadingContext(SetsKt.emptySet(), new PluginLoadingResult(MapsKt.emptyMap(), new Supplier(buildNumber2){
            final /* synthetic */ BuildNumber $buildNumber;

            @NotNull
            public final BuildNumber get() {
                return this.$buildNumber;
            }
            {
                this.$buildNumber = buildNumber;
            }
        }, false), false, false, false, false, 60, null);
        new LoadDescriptorsFromClassPathAction(urlsFromClassPath, context2, null, new ClassPathXmlPathResolver(loader, false)).compute();
        context2.result.finishLoading();
        return context2.result.getEnabledPlugins();
    }

    public static final /* synthetic */ IdeaPluginDescriptorImpl access$loadFromPluginDir(Path file, String pathName, DescriptorListLoadingContext parentContext, boolean isBundled, boolean isEssential, String descriptorRelativePath, PathResolver pathResolver) {
        return PluginDescriptorLoader.loadFromPluginDir(file, pathName, parentContext, isBundled, isEssential, descriptorRelativePath, pathResolver);
    }

    public static final /* synthetic */ IdeaPluginDescriptorImpl access$loadDescriptorFromJar(Path file, String fileName, PathResolver pathResolver, DescriptorListLoadingContext parentContext, boolean isBundled, boolean isEssential, Path pluginPath) {
        return PluginDescriptorLoader.loadDescriptorFromJar(file, fileName, pathResolver, parentContext, isBundled, isEssential, pluginPath);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return PluginDescriptorLoader.getLOG();
    }

    public static final /* synthetic */ boolean access$fileNameIsLikeVersionedLibraryName(String name) {
        return PluginDescriptorLoader.fileNameIsLikeVersionedLibraryName(name);
    }
}

