/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.DescriptorListLoadingContext;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.LoadDescriptorsFromClassPathAction;
import com.intellij.ide.plugins.PathResolver;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginLoadingResult;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.lang.UrlClassLoader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.RecursiveTask;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ide/plugins/LoadDescriptorsFromClassPathAction;", "Ljava/util/concurrent/RecursiveAction;", "urls", "", "Ljava/net/URL;", "", "context", "Lcom/intellij/ide/plugins/DescriptorListLoadingContext;", "platformPluginURL", "pathResolver", "Lcom/intellij/ide/plugins/PathResolver;", "(Ljava/util/Map;Lcom/intellij/ide/plugins/DescriptorListLoadingContext;Ljava/net/URL;Lcom/intellij/ide/plugins/PathResolver;)V", "compute", "", "loadDescriptorFromResource", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "resource", "pathName", "isEssential", "", "intellij.platform.core.impl"})
final class LoadDescriptorsFromClassPathAction
extends RecursiveAction {
    private final Map<URL, String> urls;
    private final DescriptorListLoadingContext context;
    private final URL platformPluginURL;
    private final PathResolver pathResolver;

    /*
     * WARNING - void declaration
     */
    @Override
    public void compute() {
        boolean bl;
        ArrayList<compute.1> tasks = new ArrayList<compute.1>(this.urls.size());
        Object object = this.urls;
        boolean bl2 = false;
        Iterator<Map.Entry<URL, String>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void url;
            Map.Entry<URL, String> entry;
            Map.Entry<URL, String> entry2 = entry = iterator.next();
            bl = false;
            object = entry2.getKey();
            entry2 = entry;
            bl = false;
            String value = entry2.getValue();
            tasks.add(new RecursiveTask<IdeaPluginDescriptorImpl>(this, (URL)url, value){
                final /* synthetic */ LoadDescriptorsFromClassPathAction this$0;
                final /* synthetic */ URL $url;
                final /* synthetic */ String $value;

                @Nullable
                protected IdeaPluginDescriptorImpl compute() {
                    boolean isEssential = Intrinsics.areEqual((Object)this.$url, (Object)LoadDescriptorsFromClassPathAction.access$getPlatformPluginURL$p(this.this$0));
                    try {
                        return LoadDescriptorsFromClassPathAction.access$loadDescriptorFromResource(this.this$0, this.$url, this.$value, isEssential);
                    }
                    catch (Throwable e) {
                        if (isEssential) {
                            throw e;
                        }
                        PluginDescriptorLoader.access$getLOG$p().info("Cannot load " + this.$url, e);
                        return null;
                    }
                }
                {
                    this.this$0 = this$0;
                    this.$url = $captured_local_variable$1;
                    this.$value = $captured_local_variable$2;
                }
            });
        }
        PluginLoadingResult result = this.context.result;
        ForkJoinTask.invokeAll((Collection)tasks);
        object = tasks.iterator();
        while (object.hasNext()) {
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl;
            RecursiveTask task;
            RecursiveTask recursiveTask = task = (RecursiveTask)object.next();
            Intrinsics.checkNotNullExpressionValue((Object)recursiveTask, (String)"task");
            if ((IdeaPluginDescriptorImpl)recursiveTask.getRawResult() == null) continue;
            boolean bl3 = false;
            bl = false;
            IdeaPluginDescriptorImpl it = ideaPluginDescriptorImpl;
            boolean bl4 = false;
            it.setUseCoreClassLoader();
            result.add(it, false);
        }
    }

    private final IdeaPluginDescriptorImpl loadDescriptorFromResource(URL resource, String pathName, boolean isEssential) {
        if (Intrinsics.areEqual((Object)"file", (Object)resource.getProtocol())) {
            Path file;
            String string = UrlClassLoader.urlToFilePath(resource.getPath());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UrlClassLoader.urlToFilePath(resource.path)");
            Path path = Paths.get(Strings.trimEnd(StringsKt.replace$default((String)string, (char)'\\', (char)'/', (boolean)false, (int)4, null), pathName), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(Strings.trimEn\u2026ce('\\\\', '/'), pathName))");
            Path path2 = file = path.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"file");
            return PluginDescriptorLoader.loadDescriptorFromFileOrDir(path2, pathName, this.context, this.pathResolver, true, isEssential, Files.isDirectory(file, new LinkOption[0]));
        }
        if (Intrinsics.areEqual((Object)"jar", (Object)resource.getProtocol())) {
            Path file;
            Path path = file = Paths.get(UrlClassLoader.urlToFilePath(resource.getPath()), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file");
            Path parentFile = path.getParent();
            if (parentFile == null || !parentFile.endsWith("lib")) {
                return PluginDescriptorLoader.access$loadDescriptorFromJar(file, pathName, this.pathResolver, this.context, true, isEssential, null);
            }
            Path path3 = file.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"file.parent");
            IdeaPluginDescriptorImpl descriptor = PluginDescriptorLoader.access$loadDescriptorFromJar(file, pathName, this.pathResolver, this.context, true, isEssential, path3.getParent());
            if (descriptor != null) {
                descriptor.jarFiles = Collections.singletonList(file);
            }
            return descriptor;
        }
        return null;
    }

    public LoadDescriptorsFromClassPathAction(@NotNull Map<URL, String> urls, @NotNull DescriptorListLoadingContext context2, @Nullable URL platformPluginURL, @NotNull PathResolver pathResolver) {
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pathResolver, (String)"pathResolver");
        this.urls = urls;
        this.context = context2;
        this.platformPluginURL = platformPluginURL;
        this.pathResolver = pathResolver;
    }

    public static final /* synthetic */ URL access$getPlatformPluginURL$p(LoadDescriptorsFromClassPathAction $this) {
        return $this.platformPluginURL;
    }

    public static final /* synthetic */ IdeaPluginDescriptorImpl access$loadDescriptorFromResource(LoadDescriptorsFromClassPathAction $this, URL resource, String pathName, boolean isEssential) {
        return $this.loadDescriptorFromResource(resource, pathName, isEssential);
    }
}

