/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class AttachmentFactory {
    private static final Logger LOG = Logger.getInstance(AttachmentFactory.class);
    private static final long BIG_FILE_THRESHOLD_BYTES = 51200L;

    @NotNull
    public static Attachment createContext(@NotNull @NonNls Object start, Object ... more) {
        if (start == null) {
            AttachmentFactory.$$$reportNull$$$0(0);
        }
        StringBuilder builder = new StringBuilder(String.valueOf(start));
        for (Object o : more) {
            builder.append(",").append(o);
        }
        return new Attachment("current-context.txt", builder.length() > 0 ? builder.toString() : "(unknown)");
    }

    @NotNull
    public static Attachment createAttachment(@NotNull Document document) {
        VirtualFile file;
        if (document == null) {
            AttachmentFactory.$$$reportNull$$$0(1);
        }
        return new Attachment((file = FileDocumentManager.getInstance().getFile(document)) != null ? file.getPath() : "unknown.txt", document.getText());
    }

    @NotNull
    public static Attachment createAttachment(@NotNull VirtualFile file) {
        if (file == null) {
            AttachmentFactory.$$$reportNull$$$0(2);
        }
        return AttachmentFactory.createAttachment(file.getPresentableUrl(), file);
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static Attachment createAttachment(@NotNull String path, @NotNull VirtualFile file) {
        Attachment attachment;
        InputStream inputStream;
        block12: {
            if (path == null) {
                AttachmentFactory.$$$reportNull$$$0(3);
            }
            if (file == null) {
                AttachmentFactory.$$$reportNull$$$0(4);
            }
            inputStream = file.getInputStream();
            attachment = AttachmentFactory.createAttachment(path, inputStream, file.getLength(), file.getFileType().isBinary());
            if (inputStream == null) break block12;
            inputStream.close();
        }
        Attachment attachment2 = attachment;
        if (attachment2 == null) {
            AttachmentFactory.$$$reportNull$$$0(5);
        }
        return attachment2;
        {
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Attachment attachment3 = AttachmentFactory.handleException(e, file.getPath());
                    if (attachment3 == null) {
                        AttachmentFactory.$$$reportNull$$$0(6);
                    }
                    return attachment3;
                }
            }
        }
    }

    @NotNull
    public static Attachment createAttachment(@NotNull File file, boolean isBinary) {
        if (file == null) {
            AttachmentFactory.$$$reportNull$$$0(7);
        }
        return AttachmentFactory.createAttachment(file.toPath(), isBinary);
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static Attachment createAttachment(@NotNull Path file, boolean isBinary) {
        Attachment attachment;
        InputStream inputStream;
        block11: {
            if (file == null) {
                AttachmentFactory.$$$reportNull$$$0(8);
            }
            inputStream = Files.newInputStream(file, new OpenOption[0]);
            attachment = AttachmentFactory.createAttachment(file.toString(), inputStream, Files.size(file), isBinary);
            if (inputStream == null) break block11;
            inputStream.close();
        }
        Attachment attachment2 = attachment;
        if (attachment2 == null) {
            AttachmentFactory.$$$reportNull$$$0(9);
        }
        return attachment2;
        {
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Attachment attachment3 = AttachmentFactory.handleException(e, file.toString());
                    if (attachment3 == null) {
                        AttachmentFactory.$$$reportNull$$$0(10);
                    }
                    return attachment3;
                }
            }
        }
    }

    private static Attachment handleException(Throwable t, String path) {
        LOG.warn("failed to create an attachment from " + path, t);
        return new Attachment(path, t);
    }

    private static Attachment createAttachment(String path, InputStream content, long contentLength, boolean isBinary) throws IOException {
        if (contentLength >= 51200L) {
            File tempFile = FileUtil.createTempFile("ij-attachment-" + PathUtilRt.getFileName(path) + ".", isBinary ? ".bin" : ".txt", true);
            try (FileOutputStream outputStream = new FileOutputStream(tempFile);){
                FileUtil.copy(content, contentLength, (OutputStream)outputStream);
            }
            return new Attachment(path, tempFile, "[File is too big to display]");
        }
        byte[] bytes = FileUtil.loadBytes(content);
        String displayText = isBinary ? "[File is binary]" : new String(bytes, StandardCharsets.UTF_8);
        return new Attachment(path, bytes, displayText);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/AttachmentFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/AttachmentFactory";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttachment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createContext";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createAttachment";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

