/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScopeBuilder;
import com.intellij.psi.search.ProjectScopeImpl;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class CoreProjectScopeBuilder
extends ProjectScopeBuilder {
    private final Project myProject;
    private final FileIndexFacade myFileIndexFacade;
    private final CoreLibrariesScope myLibrariesScope;

    public CoreProjectScopeBuilder(Project project, FileIndexFacade fileIndexFacade) {
        this.myFileIndexFacade = fileIndexFacade;
        this.myProject = project;
        this.myLibrariesScope = new CoreLibrariesScope();
    }

    @Override
    @NotNull
    public GlobalSearchScope buildLibrariesScope() {
        CoreLibrariesScope coreLibrariesScope = this.myLibrariesScope;
        if (coreLibrariesScope == null) {
            CoreProjectScopeBuilder.$$$reportNull$$$0(0);
        }
        return coreLibrariesScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope buildAllScope() {
        return new EverythingGlobalScope();
    }

    @Override
    @NotNull
    public GlobalSearchScope buildProjectScope() {
        return new ProjectScopeImpl(this.myProject, this.myFileIndexFacade);
    }

    @Override
    @NotNull
    public GlobalSearchScope buildContentScope() {
        return new ContentSearchScope(this.myProject, this.myFileIndexFacade);
    }

    @Override
    @NotNull
    public GlobalSearchScope buildEverythingScope() {
        return new EverythingGlobalScope(this.myProject);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreProjectScopeBuilder", "buildLibrariesScope"));
    }

    public static class ContentSearchScope
    extends GlobalSearchScope {
        private final FileIndexFacade myFileIndexFacade;

        public ContentSearchScope(Project project, FileIndexFacade fileIndexFacade) {
            super(project);
            this.myFileIndexFacade = fileIndexFacade;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                ContentSearchScope.$$$reportNull$$$0(0);
            }
            return this.myFileIndexFacade.isInContent(file);
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                ContentSearchScope.$$$reportNull$$$0(1);
            }
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        @Override
        @NotNull
        public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
            Collection<UnloadedModuleDescription> collection = this.myFileIndexFacade.getUnloadedModuleDescriptions();
            if (collection == null) {
                ContentSearchScope.$$$reportNull$$$0(2);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/core/CoreProjectScopeBuilder$ContentSearchScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/core/CoreProjectScopeBuilder$ContentSearchScope";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnloadedModulesBelongingToScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class CoreLibrariesScope
    extends GlobalSearchScope {
        private CoreLibrariesScope() {
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                CoreLibrariesScope.$$$reportNull$$$0(0);
            }
            return CoreProjectScopeBuilder.this.myFileIndexFacade.isInLibraryClasses(file) || CoreProjectScopeBuilder.this.myFileIndexFacade.isInLibrarySource(file);
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                CoreLibrariesScope.$$$reportNull$$$0(1);
            }
            return false;
        }

        @Override
        public boolean isSearchInLibraries() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/core/CoreProjectScopeBuilder$CoreLibrariesScope";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSearchInModuleContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

