/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.scope;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Arrays;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompletionElement {
    private final Object myElement;
    private final PsiSubstitutor mySubstitutor;
    private final Object myEqualityObject;
    private final String myQualifierText;
    @Nullable
    private final PsiType myMethodRefType;

    public CompletionElement(Object element, PsiSubstitutor substitutor) {
        this(element, substitutor, "", null);
    }

    CompletionElement(Object element, PsiSubstitutor substitutor, @NotNull String qualifierText, @Nullable PsiType methodRefType) {
        if (qualifierText == null) {
            CompletionElement.$$$reportNull$$$0(0);
        }
        this.myElement = element;
        this.mySubstitutor = substitutor;
        this.myQualifierText = qualifierText;
        this.myMethodRefType = methodRefType;
        this.myEqualityObject = this.getUniqueId();
    }

    @NotNull
    public String getQualifierText() {
        String string = this.myQualifierText;
        if (string == null) {
            CompletionElement.$$$reportNull$$$0(1);
        }
        return string;
    }

    public PsiSubstitutor getSubstitutor() {
        return this.mySubstitutor;
    }

    public Object getElement() {
        return this.myElement;
    }

    @Nullable
    private Object getUniqueId() {
        if (this.myElement instanceof PsiClass) {
            String qName = ((PsiClass)this.myElement).getQualifiedName();
            return qName == null ? ((PsiClass)this.myElement).getName() : qName;
        }
        if (this.myElement instanceof PsiPackage) {
            return ((PsiPackage)this.myElement).getQualifiedName();
        }
        if (this.myElement instanceof PsiMethod) {
            if (this.myMethodRefType != null) {
                return ((PsiMethod)this.myElement).isConstructor() ? "new" : ((PsiMethod)this.myElement).getName();
            }
            return Trinity.create(((PsiMethod)this.myElement).getName(), Arrays.asList(MethodSignatureUtil.calcErasedParameterTypes(((PsiMethod)this.myElement).getSignature(this.mySubstitutor))), this.myQualifierText);
        }
        if (this.myElement instanceof PsiVariable) {
            return CompletionUtilCoreImpl.getOriginalOrSelf((PsiElement)this.myElement);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CompletionElement)) {
            return false;
        }
        Object thatObj = ((CompletionElement)obj).myEqualityObject;
        if (this.myEqualityObject instanceof MethodSignature) {
            return thatObj instanceof MethodSignature && MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY.equals((MethodSignature)this.myEqualityObject, (MethodSignature)thatObj);
        }
        return Comparing.equal(this.myEqualityObject, thatObj);
    }

    public int hashCode() {
        if (this.myEqualityObject instanceof MethodSignature) {
            return MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY.hashCode((MethodSignature)this.myEqualityObject);
        }
        return this.myEqualityObject != null ? this.myEqualityObject.hashCode() : 0;
    }

    @Nullable
    @ApiStatus.Internal
    public PsiType getMethodRefType() {
        return this.myMethodRefType;
    }

    public boolean isMoreSpecificThan(@NotNull CompletionElement another) {
        Object anotherElement;
        if (another == null) {
            CompletionElement.$$$reportNull$$$0(2);
        }
        if (!((anotherElement = another.getElement()) instanceof PsiMethod) || !(this.myElement instanceof PsiMethod)) {
            return false;
        }
        if (another.myMethodRefType instanceof PsiMethodReferenceType && this.myMethodRefType instanceof PsiClassType) {
            return true;
        }
        if (anotherElement != this.myElement && ((PsiMethod)this.myElement).hasModifierProperty("abstract") && !((PsiMethod)anotherElement).hasModifierProperty("abstract")) {
            return false;
        }
        PsiType prevType = TypeConversionUtil.erasure(another.getSubstitutor().substitute(((PsiMethod)anotherElement).getReturnType()));
        PsiType candidateType = this.mySubstitutor.substitute(((PsiMethod)this.myElement).getReturnType());
        return prevType != null && candidateType != null && !prevType.equals(candidateType) && prevType.isAssignableFrom(candidateType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/scope/CompletionElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "another";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/scope/CompletionElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isMoreSpecificThan";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

