/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CodeInsightUtilCore
extends FileModificationService {
    private static final Logger LOG = Logger.getInstance(CodeInsightUtilCore.class);

    public static <T extends PsiElement> T findElementInRange(@NotNull PsiFile file, int startOffset, int endOffset, @NotNull Class<T> klass, @NotNull Language language) {
        if (file == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(0);
        }
        if (klass == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(1);
        }
        if (language == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(2);
        }
        return CodeInsightUtilCore.findElementInRange(file, startOffset, endOffset, klass, language, null);
    }

    @Nullable
    private static <T extends PsiElement> T findElementInRange(@NotNull PsiFile file, int startOffset, int endOffset, @NotNull Class<T> klass, @NotNull Language language, @Nullable PsiElement initialElement) {
        PsiElement element;
        if (file == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(3);
        }
        if (klass == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(4);
        }
        if (language == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(5);
        }
        PsiElement element1 = file.getViewProvider().findElementAt(startOffset, language);
        PsiElement element2 = file.getViewProvider().findElementAt(endOffset - 1, language);
        if (element1 instanceof PsiWhiteSpace) {
            startOffset = element1.getTextRange().getEndOffset();
            element1 = file.getViewProvider().findElementAt(startOffset, language);
        }
        if (element2 instanceof PsiWhiteSpace) {
            endOffset = element2.getTextRange().getStartOffset();
            element2 = file.getViewProvider().findElementAt(endOffset - 1, language);
        }
        if (element2 == null || element1 == null) {
            return null;
        }
        PsiElement commonParent = PsiTreeUtil.findCommonParent(element1, element2);
        PsiElement psiElement = element = ReflectionUtil.isAssignable(klass, commonParent.getClass()) ? commonParent : PsiTreeUtil.getParentOfType(commonParent, klass);
        if (element == initialElement) {
            return (T)element;
        }
        if (element == null || element.getTextRange().getStartOffset() != startOffset || element.getTextRange().getEndOffset() != endOffset) {
            return null;
        }
        return (T)element;
    }

    @Nullable
    public static <T extends PsiElement> T forcePsiPostprocessAndRestoreElement(@NotNull T element) {
        if (element == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(6);
        }
        return CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(element, false);
    }

    @Nullable
    public static <T extends PsiElement> T forcePsiPostprocessAndRestoreElement(@NotNull T element, boolean useFileLanguage) {
        if (element == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(7);
        }
        PsiFile psiFile = element.getContainingFile();
        Document document = psiFile.getViewProvider().getDocument();
        Language language = useFileLanguage ? psiFile.getLanguage() : PsiUtilCore.getDialect(element);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance(psiFile.getProject());
        RangeMarker rangeMarker = document.createRangeMarker(element.getTextRange());
        documentManager.doPostponedOperationsAndUnblockDocument(document);
        documentManager.commitDocument(document);
        Object elementInRange = CodeInsightUtilCore.findElementInRange(psiFile, rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), element.getClass(), language, element);
        rangeMarker.dispose();
        return (T)elementInRange;
    }

    public static boolean parseStringCharacters(@NotNull String chars, @NotNull StringBuilder outChars, int @Nullable [] sourceOffsets) {
        if (chars == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(8);
        }
        if (outChars == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(9);
        }
        return CodeInsightUtilCore.parseStringCharacters(chars, outChars, sourceOffsets, true, true, '\"', '\'');
    }

    public static boolean parseStringCharacters(@NotNull String chars, @NotNull StringBuilder outChars, int @Nullable [] sourceOffsets, boolean slashMustBeEscaped, boolean exitOnEscapingWrongSymbol, char ... endChars) {
        if (chars == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(10);
        }
        if (outChars == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(11);
        }
        if (endChars == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(12);
        }
        StringParser stringParser = new StringParser(sourceOffsets, slashMustBeEscaped, exitOnEscapingWrongSymbol, endChars);
        return stringParser.parse(chars, outChars);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outChars";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endChars";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/CodeInsightUtilCore";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementInRange";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "forcePsiPostprocessAndRestoreElement";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "parseStringCharacters";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class StringParser {
        private final int @Nullable [] mySourceOffsets;
        private final boolean mySlashMustBeEscaped;
        private final boolean myExitOnEscapingWrongSymbol;
        private final char @NotNull [] myEndChars;

        private StringParser(int @Nullable [] sourceOffsets, boolean slashMustBeEscaped, boolean exitOnEscapingWrongSymbol, char ... endChars) {
            if (endChars == null) {
                StringParser.$$$reportNull$$$0(0);
            }
            this.mySourceOffsets = sourceOffsets;
            this.mySlashMustBeEscaped = slashMustBeEscaped;
            this.myExitOnEscapingWrongSymbol = exitOnEscapingWrongSymbol;
            this.myEndChars = endChars;
        }

        private boolean parse(@NotNull String chars, @NotNull StringBuilder outChars) {
            if (chars == null) {
                StringParser.$$$reportNull$$$0(1);
            }
            if (outChars == null) {
                StringParser.$$$reportNull$$$0(2);
            }
            LOG.assertTrue(this.mySourceOffsets == null || this.mySourceOffsets.length == chars.length() + 1);
            if (chars.indexOf(92) < 0) {
                outChars.append(chars);
                if (this.mySourceOffsets != null) {
                    Arrays.setAll(this.mySourceOffsets, i -> i);
                }
                return true;
            }
            int index = 0;
            int outOffset = outChars.length();
            while (index < chars.length()) {
                char c = chars.charAt(index++);
                if (this.mySourceOffsets != null) {
                    this.mySourceOffsets[outChars.length() - outOffset] = index - 1;
                    this.mySourceOffsets[outChars.length() + 1 - outOffset] = index;
                }
                if (c != '\\') {
                    outChars.append(c);
                    continue;
                }
                if ((index = this.parseEscapedSymbol(chars, outChars, index, outOffset, false)) == -1) {
                    return false;
                }
                if (this.mySourceOffsets == null) continue;
                this.mySourceOffsets[outChars.length() - outOffset] = index;
            }
            return true;
        }

        private int parseEscapedSymbol(@NotNull String chars, @NotNull StringBuilder outChars, int index, int outOffset, boolean isAfterEscapedBackslash) {
            char c;
            if (chars == null) {
                StringParser.$$$reportNull$$$0(3);
            }
            if (outChars == null) {
                StringParser.$$$reportNull$$$0(4);
            }
            if (index == chars.length()) {
                return -1;
            }
            if (StringParser.parseEscapedChar(c = chars.charAt(index++), outChars)) {
                return index;
            }
            switch (c) {
                case '\\': {
                    boolean isUnicodeSequenceStart;
                    boolean bl = isUnicodeSequenceStart = isAfterEscapedBackslash && index < chars.length() && chars.charAt(index) == 'u';
                    if (isUnicodeSequenceStart) {
                        index = this.parseUnicodeEscape(chars, outChars, index, outOffset, true);
                        break;
                    }
                    outChars.append('\\');
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    index = StringParser.parseOctalEscape(chars, outChars, c, index);
                    break;
                }
                case 'u': {
                    if (isAfterEscapedBackslash) {
                        if (this.handleUnexpectedChar(outChars, index - 1, outOffset, c)) break;
                        return -1;
                    }
                    index = this.parseUnicodeEscape(chars, outChars, index - 1, outOffset, false);
                    break;
                }
                default: {
                    if (this.handleUnexpectedChar(outChars, index - 1, outOffset, c)) break;
                    return -1;
                }
            }
            return index;
        }

        private int parseUnicodeEscape(@NotNull String s, @NotNull StringBuilder outChars, int index, int outOffset, boolean isAfterEscapedBackslash) {
            if (s == null) {
                StringParser.$$$reportNull$$$0(5);
            }
            if (outChars == null) {
                StringParser.$$$reportNull$$$0(6);
            }
            int len = s.length();
            int start = index - 1;
            while (++index < len && s.charAt(index) == 'u') {
            }
            if (index + 4 > len) {
                return -1;
            }
            try {
                char c = s.charAt(index);
                if (c == '+' || c == '-') {
                    return -1;
                }
                int code = Integer.parseInt(s.substring(index, index + 4), 16);
                if (code == 10 || code == 13) {
                    return -1;
                }
                char escapedChar = (char)code;
                if (escapedChar == '\\') {
                    if (isAfterEscapedBackslash) {
                        outChars.append('\\');
                        return index + 4;
                    }
                    return this.parseEscapedSymbol(s, outChars, index + 4, outOffset, true);
                }
                if (isAfterEscapedBackslash) {
                    if (StringParser.parseEscapedChar(escapedChar, outChars)) {
                        return index + 4;
                    }
                    if (this.handleUnexpectedChar(outChars, start, outOffset, escapedChar)) {
                        return index + 4;
                    }
                    return -1;
                }
                outChars.append(escapedChar);
                return index + 4;
            }
            catch (NumberFormatException ignored) {
                return -1;
            }
        }

        private boolean handleUnexpectedChar(@NotNull StringBuilder outChars, int start, int outOffset, char c) {
            if (outChars == null) {
                StringParser.$$$reportNull$$$0(7);
            }
            if (CharArrayUtil.indexOf(this.myEndChars, c, 0, this.myEndChars.length) != -1) {
                outChars.append(c);
            } else if (!this.myExitOnEscapingWrongSymbol) {
                if (!this.mySlashMustBeEscaped) {
                    outChars.append('\\');
                    if (this.mySourceOffsets != null) {
                        this.mySourceOffsets[outChars.length() - outOffset] = start;
                    }
                }
                outChars.append(c);
            } else {
                return false;
            }
            return true;
        }

        private static boolean parseEscapedChar(char c, @NotNull StringBuilder outChars) {
            if (outChars == null) {
                StringParser.$$$reportNull$$$0(8);
            }
            switch (c) {
                case 'b': {
                    outChars.append('\b');
                    return true;
                }
                case 't': {
                    outChars.append('\t');
                    return true;
                }
                case 'n': {
                    outChars.append('\n');
                    return true;
                }
                case 'f': {
                    outChars.append('\f');
                    return true;
                }
                case 'r': {
                    outChars.append('\r');
                    return true;
                }
                case 's': {
                    outChars.append(' ');
                    return true;
                }
                case '\n': {
                    return true;
                }
            }
            return false;
        }

        private static int parseOctalEscape(@NotNull String s, @NotNull StringBuilder outChars, char c, int index) {
            if (s == null) {
                StringParser.$$$reportNull$$$0(9);
            }
            if (outChars == null) {
                StringParser.$$$reportNull$$$0(10);
            }
            char startC = c;
            int v = c - 48;
            if (index < s.length()) {
                if ('0' <= (c = s.charAt(index++)) && c <= '7') {
                    v <<= 3;
                    v += c - 48;
                    if (startC <= '3' && index < s.length()) {
                        if ('0' <= (c = s.charAt(index++)) && c <= '7') {
                            v <<= 3;
                            v += c - 48;
                        } else {
                            --index;
                        }
                    }
                } else {
                    --index;
                }
            }
            outChars.append((char)v);
            return index;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endChars";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chars";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outChars";
                    break;
                }
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/CodeInsightUtilCore$StringParser";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parse";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parseEscapedSymbol";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parseUnicodeEscape";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleUnexpectedChar";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parseEscapedChar";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parseOctalEscape";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

