/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.configuration;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ScreenWidthQualifier
extends ResourceQualifier {
    static final int DEFAULT_SIZE = -1;
    private static final Pattern sParsePattern = Pattern.compile("^w(\\d+)dp$");
    private static final String sPrintPattern = "w%1$ddp";
    public static final String NAME = "Screen Width";
    private int mValue = -1;

    public ScreenWidthQualifier() {
    }

    public ScreenWidthQualifier(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return NAME;
    }

    @Override
    public int since() {
        return 13;
    }

    @Override
    public boolean hasFakeValue() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.mValue != -1;
    }

    @Override
    public boolean checkAndSet(String value, FolderConfiguration config) {
        String v;
        ScreenWidthQualifier qualifier;
        Matcher m = sParsePattern.matcher(value);
        if (m.matches() && (qualifier = ScreenWidthQualifier.getQualifier(v = m.group(1))) != null) {
            config.setScreenWidthQualifier(qualifier);
            return true;
        }
        return false;
    }

    public static ScreenWidthQualifier getQualifier(String value) {
        try {
            int dp = Integer.parseInt(value);
            ScreenWidthQualifier qualifier = new ScreenWidthQualifier();
            qualifier.mValue = dp;
            return qualifier;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @Override
    public boolean isMatchFor(ResourceQualifier qualifier) {
        if (qualifier instanceof ScreenWidthQualifier) {
            return this.mValue <= ((ScreenWidthQualifier)qualifier).mValue;
        }
        return false;
    }

    @Override
    public boolean isBetterMatchThan(ResourceQualifier compareTo2, ResourceQualifier reference) {
        if (compareTo2 == null) {
            return true;
        }
        ScreenWidthQualifier compareQ = (ScreenWidthQualifier)compareTo2;
        ScreenWidthQualifier referenceQ = (ScreenWidthQualifier)reference;
        if (compareQ.mValue == referenceQ.mValue) {
            return false;
        }
        if (this.mValue == referenceQ.mValue) {
            return true;
        }
        return this.mValue > compareQ.mValue;
    }

    @Override
    public String getFolderSegment() {
        return String.format(sPrintPattern, this.mValue);
    }

    @Override
    public String getShortDisplayValue() {
        if (this.isValid()) {
            return this.getFolderSegment();
        }
        return "";
    }

    @Override
    public String getLongDisplayValue() {
        if (this.isValid()) {
            return this.getFolderSegment();
        }
        return "";
    }

    @Override
    public int hashCode() {
        return this.mValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScreenWidthQualifier other = (ScreenWidthQualifier)obj;
        return this.mValue == other.mValue;
    }
}

