/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.resources.ResourceType;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.ResourceReference;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.Pair;
import com.intellij.psi.PsiMethod;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u00012\u00020\u0002:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0007\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/tools/lint/checks/MergeRootFrameLayoutDetector;", "Lcom/android/tools/lint/detector/api/LayoutDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "allowedLayouts", "", "", "pending", "", "Lcom/android/utils/Pair;", "Lcom/android/tools/lint/detector/api/Location$Handle;", "afterCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "allowLayout", "layout", "getApplicableElements", "", "getApplicableMethodNames", "", "visitElement", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "visitMethodCall", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "lint-checks"})
public final class MergeRootFrameLayoutDetector
extends LayoutDetector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Set<String> allowedLayouts;
    @Nullable
    private List<Pair<String, Location.Handle>> pending;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String ATTR_FITS_SYSTEM_WINDOWS = "fitsSystemWindows";

    public void afterCheckRootProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List<Pair<String, Location.Handle>> list = this.pending;
        if (list == null) {
            return;
        }
        List<Pair<String, Location.Handle>> pending = list;
        Set<String> set = this.allowedLayouts;
        if (set == null) {
            return;
        }
        Set<String> allowedLayouts = set;
        for (Pair pair : pending) {
            Location.Handle handle;
            Object clientData;
            String layout = (String)pair.getFirst();
            if (!allowedLayouts.contains(layout) || (clientData = (handle = (Location.Handle)pair.getSecond()).getClientData()) instanceof Node && context.getDriver().isSuppressed(null, ISSUE, (Node)clientData)) continue;
            Location location = handle.resolve();
            Context.report$default((Context)context, (Issue)ISSUE, (Location)location, (String)"This `<FrameLayout>` can be replaced with a `<merge>` tag", null, (int)8, null);
        }
    }

    @NotNull
    public Collection<String> getApplicableElements() {
        Object[] objectArray = new String[]{"include", "FrameLayout"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String tag = element.getTagName();
        if (Intrinsics.areEqual((Object)tag, (Object)"include")) {
            String layout2;
            String string = layout2 = element.getAttribute("layout");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"layout");
            if (StringsKt.startsWith$default((String)string, (String)"@layout/", (boolean)false, (int)2, null)) {
                string = layout2;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"layout");
                int n = "@layout/".length();
                boolean bl = false;
                String string2 = string.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                string = layout2 = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"layout");
                this.allowLayout(string);
            }
        } else {
            boolean layout2 = Intrinsics.areEqual((Object)tag, (Object)"FrameLayout");
            boolean bl = false;
            boolean bl2 = false;
            if (_Assertions.ENABLED && !layout2) {
                boolean bl3 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            if (Lint.isRootElement((Element)element) && (MergeRootFrameLayoutDetector.Companion.isWidthFillParent(element) && MergeRootFrameLayoutDetector.Companion.isHeightFillParent(element) || !element.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_gravity")) && !element.hasAttributeNS("http://schemas.android.com/apk/res/android", "background") && !element.hasAttributeNS("http://schemas.android.com/apk/res/android", "foreground") && !Intrinsics.areEqual((Object)element.getAttributeNS("http://schemas.android.com/apk/res/android", ATTR_FITS_SYSTEM_WINDOWS), (Object)"true") && !MergeRootFrameLayoutDetector.Companion.hasPadding(element)) {
                Object object;
                String string;
                if (!context.getProject().getReportIssues()) {
                    return;
                }
                Object layout2 = element.getAttributeNode("style");
                if (layout2 != null && (string = layout2.getValue()) != null) {
                    String string3 = string;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    String url = string3;
                    boolean bl6 = false;
                    List styles = Lint.getStyleAttributes$default((Project)context.getProject(), (LintClient)context.getClient(), (String)url, (String)"http://schemas.android.com/apk/res/android", (String)ATTR_FITS_SYSTEM_WINDOWS, (boolean)false, (int)32, null);
                    if (styles != null) {
                        boolean bl7;
                        block14: {
                            Iterable $this$any$iv = styles;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl7 = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    ResourceValue it = (ResourceValue)element$iv;
                                    boolean bl8 = false;
                                    if (!Intrinsics.areEqual((Object)it.getValue(), (Object)"true")) continue;
                                    bl7 = true;
                                    break block14;
                                }
                                bl7 = false;
                            }
                        }
                        if (bl7) {
                            return;
                        }
                    }
                }
                layout2 = Lint.getLayoutName((File)context.file);
                Location.Handle handle = context.createLocationHandle((Node)element);
                handle.setClientData((Object)element);
                Pair pair = this.pending;
                if (pair == null) {
                    ArrayList arrayList = new ArrayList();
                    boolean bl9 = false;
                    boolean bl10 = false;
                    ArrayList it = arrayList;
                    boolean bl11 = false;
                    this.pending = it;
                    object = arrayList;
                } else {
                    object = pair;
                }
                Pair pending = object;
                pair = Pair.of((Object)layout2, (Object)handle);
                Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"of(layout, handle)");
                pending.add(pair);
            }
        }
    }

    private final void allowLayout(String layout) {
        Set set;
        Set set2 = this.allowedLayouts;
        if (set2 == null) {
            HashSet hashSet = new HashSet();
            boolean bl = false;
            boolean bl2 = false;
            HashSet it = hashSet;
            boolean bl3 = false;
            this.allowedLayouts = it;
            set = hashSet;
        } else {
            set = set2;
        }
        Set allowedLayouts = set;
        allowedLayouts.add((String)layout);
    }

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"setContentView");
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        ResourceReference reference;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        List expressions = node.getValueArguments();
        if (expressions.size() == 1 && (reference = UastLintUtils.Companion.toAndroidReferenceViaResolve((UElement)expressions.get(0))) != null && reference.getType() == ResourceType.LAYOUT) {
            this.allowLayout(reference.getName());
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.PERFORMANCE;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(MergeRootFrameLayoutDetector.class, EnumSet.of((Enum)Scope.ALL_RESOURCE_FILES, (Enum)Scope.JAVA_FILE));
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"MergeRootFrame", (String)"FrameLayout can be replaced with `<merge>` tag", (String)"\n                If a `<FrameLayout>` is the root of a layout and does not provide background or padding \\\n                etc, it can often be replaced with a `<merge>` tag which is slightly more efficient. \\\n                Note that this depends on context, so make sure you understand how the `<merge>` tag \\\n                works before proceeding.\n                ", (Implementation)implementation, (String)"https://android-developers.googleblog.com/2009/03/android-layout-tricks-3-optimize-by.html", (Category)category, (int)4, (Severity)severity, (boolean)false, null, null, null, (int)3840, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nH\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/checks/MergeRootFrameLayoutDetector$Companion;", "", "()V", "ATTR_FITS_SYSTEM_WINDOWS", "", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "hasPadding", "", "root", "Lorg/w3c/dom/Element;", "isFillParent", "element", "dimension", "isHeightFillParent", "isWidthFillParent", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isFillParent(Element element, String dimension) {
            String width = element.getAttributeNS("http://schemas.android.com/apk/res/android", dimension);
            return Intrinsics.areEqual((Object)width, (Object)"match_parent") || Intrinsics.areEqual((Object)width, (Object)"fill_parent");
        }

        private final boolean isWidthFillParent(Element element) {
            return this.isFillParent(element, "layout_width");
        }

        private final boolean isHeightFillParent(Element element) {
            return this.isFillParent(element, "layout_height");
        }

        private final boolean hasPadding(Element root) {
            return root.hasAttributeNS("http://schemas.android.com/apk/res/android", "padding") || root.hasAttributeNS("http://schemas.android.com/apk/res/android", "paddingLeft") || root.hasAttributeNS("http://schemas.android.com/apk/res/android", "paddingRight") || root.hasAttributeNS("http://schemas.android.com/apk/res/android", "paddingTop") || root.hasAttributeNS("http://schemas.android.com/apk/res/android", "paddingBottom");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

