/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.detector.api.AnnotationInfo;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001d0\u001fJ\u001a\u0010 \u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001d0\u001fJ\u001c\u0010!\u001a\u0004\u0018\u00010\u00062\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001d0\u001fJ\u001c\u0010\"\u001a\u0004\u0018\u00010\u00062\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001d0\u001fJ\b\u0010#\u001a\u00020$H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006%"}, d2={"Lcom/android/tools/lint/detector/api/AnnotationUsageInfo;", "", "index", "", "annotations", "", "Lcom/android/tools/lint/detector/api/AnnotationInfo;", "usage", "Lorg/jetbrains/uast/UElement;", "referenced", "Lcom/intellij/psi/PsiElement;", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "(ILjava/util/List;Lorg/jetbrains/uast/UElement;Lcom/intellij/psi/PsiElement;Lcom/android/tools/lint/detector/api/AnnotationUsageType;)V", "getAnnotations", "()Ljava/util/List;", "getIndex", "()I", "setIndex", "(I)V", "getReferenced", "()Lcom/intellij/psi/PsiElement;", "getType", "()Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "setType", "(Lcom/android/tools/lint/detector/api/AnnotationUsageType;)V", "getUsage", "()Lorg/jetbrains/uast/UElement;", "anyCloser", "", "condition", "Lkotlin/Function1;", "anySameScope", "findCloser", "findSameScope", "toString", "", "lint-api"})
public final class AnnotationUsageInfo {
    private int index;
    @NotNull
    private final List<AnnotationInfo> annotations;
    @NotNull
    private final UElement usage;
    @Nullable
    private final PsiElement referenced;
    @NotNull
    private AnnotationUsageType type;

    public AnnotationUsageInfo(int index, @NotNull List<AnnotationInfo> annotations, @NotNull UElement usage, @Nullable PsiElement referenced, @NotNull AnnotationUsageType type) {
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.index = index;
        this.annotations = annotations;
        this.usage = usage;
        this.referenced = referenced;
        this.type = type;
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int n) {
        this.index = n;
    }

    @NotNull
    public final List<AnnotationInfo> getAnnotations() {
        return this.annotations;
    }

    @NotNull
    public final UElement getUsage() {
        return this.usage;
    }

    @Nullable
    public final PsiElement getReferenced() {
        return this.referenced;
    }

    @NotNull
    public final AnnotationUsageType getType() {
        return this.type;
    }

    public final void setType(@NotNull AnnotationUsageType annotationUsageType) {
        Intrinsics.checkNotNullParameter((Object)((Object)annotationUsageType), (String)"<set-?>");
        this.type = annotationUsageType;
    }

    public final boolean anyCloser(@NotNull Function1<? super AnnotationInfo, Boolean> condition) {
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        return this.findCloser(condition) != null;
    }

    @Nullable
    public final AnnotationInfo findCloser(@NotNull Function1<? super AnnotationInfo, Boolean> condition) {
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        int n = 0;
        int n2 = this.index;
        if (n < n2) {
            do {
                int i;
                AnnotationInfo annotationInfo;
                if (!((Boolean)condition.invoke((Object)(annotationInfo = this.annotations.get(i = n++)))).booleanValue()) continue;
                return annotationInfo;
            } while (n < n2);
        }
        return null;
    }

    public final boolean anySameScope(@NotNull Function1<? super AnnotationInfo, Boolean> condition) {
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        return this.findSameScope(condition) != null;
    }

    @Nullable
    public final AnnotationInfo findSameScope(@NotNull Function1<? super AnnotationInfo, Boolean> condition) {
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        PsiElement source = this.annotations.get(this.index).getAnnotated();
        int n = 0;
        int n2 = this.annotations.size() + -1;
        if (n <= n2) {
            do {
                AnnotationInfo annotation;
                int i;
                if ((i = n++) == this.index || (annotation = this.annotations.get(i)).getAnnotated() != source || !((Boolean)condition.invoke((Object)annotation)).booleanValue()) continue;
                return annotation;
            } while (n <= n2);
        }
        return null;
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + '(' + (Object)((Object)this.type) + " for " + this.usage + ", index=" + this.index + " in " + this.annotations + ')';
    }
}

