/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceMergerItem;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.DomExtensions;
import com.google.common.annotations.Beta;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&J\u001a\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH&J:\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0011J\u0018\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J.\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u0019H\u0002J \u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\bH&J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&J(\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000bH&J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\bH&J\u0018\u0010\u001f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J \u0010\u001f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\bH&J\u0018\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&J \u0010 \u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\bH&J\u0018\u0010 \u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&J \u0010!\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\bH&J\u0018\u0010!\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&J\u0018\u0010\"\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J \u0010\"\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020#H&J\u0018\u0010\"\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020#H&J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u0005\u001a\u00020\u0006H&J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u001b\u001a\u00020\u001cH&J\u001a\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001b\u001a\u00020\u001cH&J\f\u0010(\u001a\u0004\u0018\u00010\u001c*\u00020\u0017\u00a8\u0006)"}, d2={"Lcom/android/tools/lint/client/api/XmlParser;", "", "()V", "createLocationHandle", "Lcom/android/tools/lint/detector/api/Location$Handle;", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "node", "Lorg/w3c/dom/Node;", "findNodeAt", "offset", "", "getElementLocation", "Lcom/android/tools/lint/detector/api/Location;", "element", "Lorg/w3c/dom/Element;", "namespace", "", "attribute", "getLocation", "client", "Lcom/android/tools/lint/client/api/LintClient;", "item", "Lcom/android/ide/common/resources/ResourceItem;", "nameOnly", "", "valueOnly", "file", "Ljava/io/File;", "start", "end", "getNameLocation", "getNodeEndOffset", "getNodeStartOffset", "getValueLocation", "Lorg/w3c/dom/Attr;", "parseXml", "Lorg/w3c/dom/Document;", "xml", "", "getFile", "lint-api"})
@Beta
public abstract class XmlParser {
    @Nullable
    public abstract Document parseXml(@NotNull File var1) throws IOException, SAXException, ParserConfigurationException;

    @Nullable
    public abstract Document parseXml(@NotNull CharSequence var1, @NotNull File var2);

    @Nullable
    public abstract Document parseXml(@NotNull XmlContext var1);

    @NotNull
    public abstract Location getLocation(@NotNull XmlContext var1, @NotNull Node var2);

    @NotNull
    public abstract Location getLocation(@NotNull File var1, @NotNull Node var2);

    @NotNull
    public abstract Location getLocation(@NotNull XmlContext var1, @NotNull Node var2, int var3, int var4);

    @NotNull
    public abstract Location getNameLocation(@NotNull XmlContext var1, @NotNull Node var2);

    @NotNull
    public abstract Location getValueLocation(@NotNull XmlContext var1, @NotNull Attr var2);

    @NotNull
    public final Location getElementLocation(@NotNull XmlContext context2, @NotNull Element element, @Nullable Node node, @Nullable String namespace, @Nullable String attribute) {
        Location location2;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (node != null) {
            return this.getLocation(context2, node);
        }
        if (attribute != null) {
            Attr attr;
            Attr attr2 = attr = namespace != null ? element.getAttributeNodeNS(namespace, attribute) : element.getAttributeNode(attribute);
            if (attr != null) {
                return this.getLocation(context2, (Node)attr);
            }
        }
        if ((location2 = this.getLocation(context2, (Node)element)).isSingleLine()) {
            return location2;
        }
        return this.getNameLocation(context2, element);
    }

    public static /* synthetic */ Location getElementLocation$default(XmlParser xmlParser, XmlContext xmlContext, Element element, Node node, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getElementLocation");
        }
        if ((n & 4) != 0) {
            node = null;
        }
        if ((n & 8) != 0) {
            string = null;
        }
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        return xmlParser.getElementLocation(xmlContext, element, node, string, string2);
    }

    @NotNull
    public abstract Location.Handle createLocationHandle(@NotNull XmlContext var1, @NotNull Node var2);

    public abstract int getNodeStartOffset(@NotNull XmlContext var1, @NotNull Node var2);

    public abstract int getNodeEndOffset(@NotNull XmlContext var1, @NotNull Node var2);

    @Nullable
    public abstract Node findNodeAt(@NotNull XmlContext var1, int var2);

    @NotNull
    public abstract Location getLocation(@NotNull LintClient var1, @NotNull File var2, @NotNull Node var3);

    public abstract int getNodeStartOffset(@NotNull LintClient var1, @NotNull File var2, @NotNull Node var3);

    public abstract int getNodeEndOffset(@NotNull LintClient var1, @NotNull File var2, @NotNull Node var3);

    @NotNull
    public abstract Location getNameLocation(@NotNull LintClient var1, @NotNull File var2, @NotNull Node var3);

    @NotNull
    public abstract Location getValueLocation(@NotNull LintClient var1, @NotNull File var2, @NotNull Attr var3);

    @Nullable
    public final Location getLocation(@NotNull LintClient client, @NotNull ResourceItem item) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return this.getLocation(client, item, false, false);
    }

    private final Location getLocation(LintClient client, ResourceItem item, boolean nameOnly, boolean valueOnly) {
        Object object;
        File file = this.getFile(item);
        if (file == null) {
            return null;
        }
        File file2 = file;
        if (item.isFileBased()) {
            return Location.Companion.create(file2);
        }
        CharSequence text = client.readFile(file2);
        String name = item.getName();
        ResourceType type = item.getType();
        if (type == ResourceType.ID && StringsKt.contains$default((CharSequence)text, (CharSequence)"@+id/", (boolean)false, (int)2, null)) {
            return Location.Companion.create(file2, text, -1, Intrinsics.stringPlus((String)"@+id//", (Object)name), null, null);
        }
        Document document = client.getXmlDocument(file2, text);
        Object object2 = object = document == null ? null : document.getDocumentElement();
        if (object == null) {
            return null;
        }
        Element document2 = object;
        object = DomExtensions.iterator((Element)document2);
        while (object.hasNext()) {
            String tag;
            Element element = (Element)object.next();
            if (!Intrinsics.areEqual((Object)element.getAttribute("name"), (Object)name) || !Intrinsics.areEqual((Object)(tag = element.getTagName()), (Object)type.getName()) && !Intrinsics.areEqual((Object)element.getAttribute("type"), (Object)type.getName())) continue;
            if (nameOnly) {
                Attr attr = element.getAttributeNode("name");
                if (attr != null) {
                    Attr attr2 = attr;
                    boolean bl = false;
                    boolean bl2 = false;
                    Attr it = attr2;
                    boolean bl3 = false;
                    return this.getNameLocation(client, file2, it);
                }
            } else if (valueOnly) {
                Node firstChild = element.getFirstChild();
                Node lastChild = element.getLastChild();
                if (firstChild != null) {
                    Location startLocation = this.getLocation(file2, firstChild);
                    if (lastChild == firstChild) {
                        return startLocation;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)lastChild, (String)"lastChild");
                    Location endLocation = this.getLocation(file2, lastChild);
                    if (startLocation.getStart() != null && endLocation.getEnd() != null) {
                        return Location.Companion.create(file2, startLocation.getStart(), endLocation.getEnd());
                    }
                }
            }
            return this.getLocation(client, file2, element);
        }
        return null;
    }

    static /* synthetic */ Location getLocation$default(XmlParser xmlParser, LintClient lintClient, ResourceItem resourceItem, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getLocation");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return xmlParser.getLocation(lintClient, resourceItem, bl, bl2);
    }

    @Nullable
    public final Location getNameLocation(@NotNull LintClient client, @NotNull ResourceItem item) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return XmlParser.getLocation$default(this, client, item, true, false, 8, null);
    }

    @Nullable
    public final Location getValueLocation(@NotNull LintClient client, @NotNull ResourceItem item) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return XmlParser.getLocation$default(this, client, item, false, true, 4, null);
    }

    @Nullable
    public final File getFile(@NotNull ResourceItem $this$getFile) {
        PathString pathString;
        Intrinsics.checkNotNullParameter((Object)$this$getFile, (String)"<this>");
        return $this$getFile instanceof ResourceMergerItem ? ((ResourceMergerItem)$this$getFile).getFile() : ((pathString = $this$getFile.getSource()) == null ? null : pathString.toFile());
    }
}

