/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.ConfigurationHierarchy;
import com.android.tools.lint.client.api.FlagConfiguration;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.model.LintModelLintOptions;
import com.android.tools.lint.model.LintModelSeverity;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0012\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nH\u0016J\u0010\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\nH\u0016J\u0010\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nH\u0016J\u0010\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\nH\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\u0014\u001a\u00020\u0007H\u0016J\b\u0010\u0015\u001a\u00020\u0007H\u0016J\b\u0010\u0016\u001a\u00020\u0007H\u0016J2\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001cH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0\nH\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/android/tools/lint/client/api/LintOptionsConfiguration;", "Lcom/android/tools/lint/client/api/FlagConfiguration;", "configurations", "Lcom/android/tools/lint/client/api/ConfigurationHierarchy;", "lintOptions", "Lcom/android/tools/lint/model/LintModelLintOptions;", "fatalOnly", "", "(Lcom/android/tools/lint/client/api/ConfigurationHierarchy;Lcom/android/tools/lint/model/LintModelLintOptions;Z)V", "disabledCategories", "", "Lcom/android/tools/lint/detector/api/Category;", "disabledIds", "", "enabledCategories", "enabledIds", "exactCategories", "exactIds", "allowSuppress", "exactCheckedIds", "isCheckAllWarnings", "isIgnoreWarnings", "isWarningsAsErrors", "partition", "", "candidates", "", "ids", "", "categories", "severityOverride", "Lcom/android/tools/lint/detector/api/Severity;", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "severityOverrides", "lint-api"})
public class LintOptionsConfiguration
extends FlagConfiguration {
    @NotNull
    private final LintModelLintOptions lintOptions;
    private final boolean fatalOnly;
    @NotNull
    private Set<String> disabledIds;
    @NotNull
    private Set<Category> disabledCategories;
    @NotNull
    private Set<String> enabledIds;
    @NotNull
    private Set<Category> enabledCategories;
    @Nullable
    private Set<String> exactIds;
    @Nullable
    private Set<Category> exactCategories;

    public LintOptionsConfiguration(@NotNull ConfigurationHierarchy configurations, @NotNull LintModelLintOptions lintOptions, boolean fatalOnly) {
        Intrinsics.checkNotNullParameter((Object)configurations, (String)"configurations");
        Intrinsics.checkNotNullParameter((Object)lintOptions, (String)"lintOptions");
        super(configurations);
        this.lintOptions = lintOptions;
        this.fatalOnly = fatalOnly;
        Set disable = this.lintOptions.getDisable();
        if (disable.isEmpty()) {
            this.disabledIds = SetsKt.emptySet();
            this.disabledCategories = SetsKt.emptySet();
        } else {
            boolean bl = false;
            this.disabledIds = new LinkedHashSet();
            bl = false;
            this.disabledCategories = new LinkedHashSet();
            this.partition(disable, TypeIntrinsics.asMutableSet(this.disabledIds), TypeIntrinsics.asMutableSet(this.disabledCategories));
        }
        Set enable = this.lintOptions.getEnable();
        if (enable.isEmpty()) {
            this.enabledIds = SetsKt.emptySet();
            this.enabledCategories = SetsKt.emptySet();
        } else {
            boolean bl = false;
            this.enabledIds = new LinkedHashSet();
            bl = false;
            this.enabledCategories = new LinkedHashSet();
            this.partition(enable, TypeIntrinsics.asMutableSet(this.enabledIds), TypeIntrinsics.asMutableSet(this.enabledCategories));
        }
        Set check = this.lintOptions.getCheck();
        if (check == null || check.isEmpty()) {
            this.exactIds = null;
            this.exactCategories = null;
        } else {
            boolean bl = false;
            this.exactIds = new LinkedHashSet();
            bl = false;
            this.exactCategories = new LinkedHashSet();
            Set<Object> set = this.exactIds;
            if (set == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableSet<kotlin.String>");
            }
            Set set2 = TypeIntrinsics.asMutableSet(set);
            set = this.exactCategories;
            if (set == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableSet<com.android.tools.lint.detector.api.Category>");
            }
            this.partition(check, set2, TypeIntrinsics.asMutableSet(set));
        }
    }

    public /* synthetic */ LintOptionsConfiguration(ConfigurationHierarchy configurationHierarchy, LintModelLintOptions lintModelLintOptions, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(configurationHierarchy, lintModelLintOptions, bl);
    }

    private final void partition(Collection<String> candidates, Set<String> ids, Set<Category> categories) {
        for (String id : candidates) {
            Category category = Category.Companion.getCategory(id);
            if (category != null) {
                categories.add(category);
                continue;
            }
            ids.add(id);
        }
    }

    @Override
    public boolean fatalOnly() {
        return this.fatalOnly;
    }

    @Override
    public boolean isWarningsAsErrors() {
        return this.lintOptions.getWarningsAsErrors();
    }

    @Override
    public boolean isIgnoreWarnings() {
        return this.lintOptions.getIgnoreWarnings();
    }

    @Override
    public boolean isCheckAllWarnings() {
        return this.lintOptions.getCheckAllWarnings();
    }

    @Override
    @NotNull
    public Set<String> disabledIds() {
        return this.disabledIds;
    }

    @Override
    @NotNull
    public Set<String> enabledIds() {
        return this.enabledIds;
    }

    @Override
    @Nullable
    public Set<String> exactCheckedIds() {
        return this.exactIds;
    }

    @Override
    @Nullable
    public Set<Category> disabledCategories() {
        return this.disabledCategories;
    }

    @Override
    @Nullable
    public Set<Category> enabledCategories() {
        return this.enabledCategories;
    }

    @Override
    @Nullable
    public Set<Category> exactCategories() {
        return this.exactCategories;
    }

    @Override
    @Nullable
    public Severity severityOverride(@NotNull Issue issue) {
        Severity severity;
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Map map = this.lintOptions.getSeverityOverrides();
        LintModelSeverity lintModelSeverity = map == null ? null : (LintModelSeverity)map.get(issue.getId());
        int n = lintModelSeverity == null ? -1 : WhenMappings.$EnumSwitchMapping$0[lintModelSeverity.ordinal()];
        switch (n) {
            case 1: {
                severity = Severity.FATAL;
                break;
            }
            case 2: {
                severity = Severity.ERROR;
                break;
            }
            case 3: {
                severity = Severity.WARNING;
                break;
            }
            case 4: {
                severity = Severity.INFORMATIONAL;
                break;
            }
            case 5: {
                severity = Severity.IGNORE;
                break;
            }
            case 6: {
                severity = issue.getDefaultSeverity();
                break;
            }
            default: {
                severity = null;
            }
        }
        return severity;
    }

    @Override
    @NotNull
    public Set<String> severityOverrides() {
        Map map = this.lintOptions.getSeverityOverrides();
        Set<String> set = map == null ? null : map.keySet();
        return set == null ? SetsKt.emptySet() : set;
    }

    @Override
    public boolean allowSuppress() {
        return false;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LintModelSeverity.values().length];
            nArray[LintModelSeverity.FATAL.ordinal()] = 1;
            nArray[LintModelSeverity.ERROR.ordinal()] = 2;
            nArray[LintModelSeverity.WARNING.ordinal()] = 3;
            nArray[LintModelSeverity.INFORMATIONAL.ordinal()] = 4;
            nArray[LintModelSeverity.IGNORE.ordinal()] = 5;
            nArray[LintModelSeverity.DEFAULT_ENABLED.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

