/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profgen;

import com.android.tools.profgen.DexFile;
import com.android.tools.profgen.DexHeader;
import com.android.tools.profgen.DexMethod;
import com.android.tools.profgen.DexPrototype;
import com.android.tools.profgen.EncodingKt;
import com.android.tools.profgen.Endian;
import com.android.tools.profgen.Span;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0004H\u0002\u001a&\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0000\u001a\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a \u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0004H\u0000\u001a\u0018\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u0004H\u0000\u001a\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000fH\u0002\u001a\u0018\u0010\u001e\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0018\u0010\u001f\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u000fH\u0002\u001a\u0018\u0010\"\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0018\u0010#\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"ENDIAN_TAG_OFFSET", "", "HEADER_SIZE", "MAGIC_PREFIX", "", "MAGIC_SUFFIX", "MAGIC_SUPPORTED_VERSIONS", "", "checkMagic", "", "magic", "getTypeList", "dexFile", "Lcom/android/tools/profgen/DexFile;", "buffer", "Ljava/nio/ByteBuffer;", "offset", "", "invalidDexFile", "", "message", "parseClassDefinitionPool", "parseDexFile", "checksum", "name", "bytes", "", "parseHeader", "Lcom/android/tools/profgen/DexHeader;", "src", "parseMethodPool", "parsePrototypePool", "parseSpan", "Lcom/android/tools/profgen/Span;", "parseStringPool", "parseTypePool", "unnamed"})
public final class DexFileParserKt {
    private static final int HEADER_SIZE = 112;
    @NotNull
    private static final String MAGIC_PREFIX = "dex\n";
    @NotNull
    private static final String MAGIC_SUFFIX = "\u0000";
    private static final int ENDIAN_TAG_OFFSET = 40;
    @NotNull
    private static final List<String> MAGIC_SUPPORTED_VERSIONS;

    @NotNull
    public static final DexFile parseDexFile(@NotNull byte[] bytes, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        CRC32 cRC32 = new CRC32();
        boolean bl = false;
        boolean bl2 = false;
        CRC32 $this$parseDexFile_u24lambda_u2d0 = cRC32;
        boolean bl3 = false;
        $this$parseDexFile_u24lambda_u2d0.update(bytes);
        CRC32 crc32 = cRC32;
        long crc32Checksum = crc32.getValue();
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"byteBuffer");
        return DexFileParserKt.parseDexFile(byteBuffer, crc32Checksum, name);
    }

    @NotNull
    public static final DexFile parseDexFile(@NotNull ByteBuffer buffer, long checksum, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        DexHeader dexHeader = DexFileParserKt.parseHeader(buffer);
        DexFile dexFile = new DexFile(dexHeader, checksum, name);
        DexFileParserKt.parseStringPool(buffer, dexFile);
        DexFileParserKt.parseTypePool(buffer, dexFile);
        DexFileParserKt.parsePrototypePool(buffer, dexFile);
        DexFileParserKt.parseMethodPool(buffer, dexFile);
        DexFileParserKt.parseClassDefinitionPool(buffer, dexFile);
        return dexFile;
    }

    private static final DexHeader parseHeader(ByteBuffer src) {
        Endian endian = Endian.Companion.forNumber(src.order(ByteOrder.LITTLE_ENDIAN).getInt(40));
        src.order(endian.getOrder());
        byte[] rawMagic = new byte[8];
        src.get(rawMagic);
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        boolean bl = false;
        String magic = new String(rawMagic, charset);
        DexFileParserKt.checkMagic(magic);
        src.getInt();
        byte[] signature = new byte[20];
        src.get(signature);
        src.getInt();
        int headerSize = src.getInt();
        if (headerSize != 112) {
            DexFileParserKt.invalidDexFile("Header is wrong size. Got " + headerSize + ", Want 112");
            throw new KotlinNothingValueException();
        }
        src.getInt();
        DexFileParserKt.parseSpan(src);
        src.getInt();
        Span stringIds = DexFileParserKt.parseSpan(src);
        Span typeIds = DexFileParserKt.parseSpan(src);
        Span protoIds = DexFileParserKt.parseSpan(src);
        DexFileParserKt.parseSpan(src);
        Span methodIds = DexFileParserKt.parseSpan(src);
        Span classDefs = DexFileParserKt.parseSpan(src);
        Span data = DexFileParserKt.parseSpan(src);
        return new DexHeader(stringIds, typeIds, protoIds, methodIds, classDefs, data);
    }

    private static final void parseStringPool(ByteBuffer buffer, DexFile dexFile) {
        buffer.position(dexFile.getHeader$unnamed().getStringIds().getOffset());
        ByteBuffer data = buffer.asReadOnlyBuffer().order(buffer.order());
        int n = 0;
        int n2 = dexFile.getHeader$unnamed().getStringIds().getSize();
        if (n < n2) {
            do {
                int i = n++;
                int offset = buffer.getInt();
                data.position(offset);
                Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
                int encodedSize = EncodingKt.getLeb128(data);
                String result = EncodingKt.mutf8(data, encodedSize);
                dexFile.getStringPool$unnamed().add(result);
            } while (n < n2);
        }
    }

    private static final void parseTypePool(ByteBuffer buffer, DexFile dexFile) {
        buffer.position(dexFile.getHeader$unnamed().getTypeIds().getOffset());
        int n = 0;
        int n2 = dexFile.getHeader$unnamed().getTypeIds().getSize();
        if (n < n2) {
            do {
                int i = n++;
                int offset = buffer.getInt();
                String string = dexFile.getStringPool$unnamed().get(offset);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dexFile.stringPool[offset]");
                String type = string;
                dexFile.getTypePool$unnamed().add(type);
            } while (n < n2);
        }
    }

    private static final void parsePrototypePool(ByteBuffer buffer, DexFile dexFile) {
        buffer.position(dexFile.getHeader$unnamed().getPrototypeIds().getOffset());
        ByteBuffer data = buffer.asReadOnlyBuffer().order(buffer.order());
        int n = 0;
        int n2 = dexFile.getHeader$unnamed().getPrototypeIds().getSize();
        if (n < n2) {
            do {
                int i = n++;
                buffer.getInt();
                int returnTypeIdx = buffer.getInt();
                int parametersOffset = buffer.getInt();
                ArrayList<DexPrototype> arrayList = dexFile.getProtoPool$unnamed();
                String string = dexFile.getTypePool$unnamed().get(returnTypeIdx);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dexFile.typePool[returnTypeIdx]");
                Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
                arrayList.add(new DexPrototype(string, DexFileParserKt.getTypeList(dexFile, data, parametersOffset)));
            } while (n < n2);
        }
    }

    private static final void parseMethodPool(ByteBuffer buffer, DexFile dexFile) {
        buffer.position(dexFile.getHeader$unnamed().getMethodIds().getOffset());
        int n = 0;
        int n2 = dexFile.getHeader$unnamed().getMethodIds().getSize();
        if (n < n2) {
            do {
                int i = n++;
                int classIdx = EncodingKt.getUshort(buffer);
                int protoIdx = EncodingKt.getUshort(buffer);
                int nameIdx = buffer.getInt();
                String string = dexFile.getTypePool$unnamed().get(classIdx);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dexFile.typePool[classIdx]");
                String clsType = string;
                DexPrototype dexPrototype = dexFile.getProtoPool$unnamed().get(protoIdx);
                Intrinsics.checkNotNullExpressionValue((Object)dexPrototype, (String)"dexFile.protoPool[protoIdx]");
                DexPrototype proto = dexPrototype;
                String string2 = dexFile.getStringPool$unnamed().get(nameIdx);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dexFile.stringPool[nameIdx]");
                String name = string2;
                dexFile.getMethodPool$unnamed().add(new DexMethod(clsType, name, proto));
            } while (n < n2);
        }
    }

    private static final void parseClassDefinitionPool(ByteBuffer buffer, DexFile dexFile) {
        buffer.position(dexFile.getHeader$unnamed().getClassDefs().getOffset());
        int n = 0;
        int n2 = dexFile.getHeader$unnamed().getClassDefs().getSize();
        if (n < n2) {
            do {
                int i = n++;
                int classIdx = buffer.getInt();
                buffer.getInt();
                buffer.getInt();
                buffer.getInt();
                buffer.getInt();
                buffer.getInt();
                buffer.getInt();
                buffer.getInt();
                dexFile.getClassDefPool$unnamed()[i] = classIdx;
            } while (n < n2);
        }
    }

    private static final List<String> getTypeList(DexFile dexFile, ByteBuffer buffer, long offset) {
        if (offset == 0L) {
            return CollectionsKt.emptyList();
        }
        int listOffset = EncodingKt.toIntSaturated(offset);
        if (!dexFile.getHeader$unnamed().getData().includes(listOffset)) {
            DexFileParserKt.invalidDexFile("offset invalid: offset=" + offset + ", data=" + dexFile.getHeader$unnamed().getData());
            throw new KotlinNothingValueException();
        }
        buffer.position(listOffset);
        int size = buffer.getInt();
        int n = 0;
        List result = new ArrayList();
        n = 0;
        if (n < size) {
            do {
                int i = n++;
                int typeId = EncodingKt.getUshort(buffer);
                String string = dexFile.getTypePool$unnamed().get(typeId);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dexFile.typePool[typeId]");
                result.add(string);
            } while (n < size);
        }
        return result;
    }

    private static final void checkMagic(String magic) {
        if (magic == null || !StringsKt.startsWith$default((String)magic, (String)MAGIC_PREFIX, (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)magic, (String)MAGIC_SUFFIX, (boolean)false, (int)2, null)) {
            DexFileParserKt.invalidDexFile(Intrinsics.stringPlus((String)"Unexpected magic number: ", (Object)magic));
            throw new KotlinNothingValueException();
        }
        String string = magic;
        int n = MAGIC_PREFIX.length();
        int n2 = magic.length() - MAGIC_SUFFIX.length();
        boolean bl = false;
        String string2 = string.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String versionTag = string2;
        if (!MAGIC_SUPPORTED_VERSIONS.contains(versionTag)) {
            DexFileParserKt.invalidDexFile(Intrinsics.stringPlus((String)"Unsupported DEX version tag: ", (Object)versionTag));
            throw new KotlinNothingValueException();
        }
    }

    private static final Span parseSpan(ByteBuffer src) {
        int size = src.getInt();
        int offset = src.getInt();
        return new Span(size, offset);
    }

    @NotNull
    public static final Void invalidDexFile(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        boolean bl = false;
        throw (Throwable)new IllegalStateException(message.toString());
    }

    static {
        Object[] objectArray = new String[]{"035", "037", "038", "039"};
        MAGIC_SUPPORTED_VERSIONS = CollectionsKt.listOf((Object[])objectArray);
    }
}

