/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.model.LintModelLintOptions;
import com.android.tools.lint.model.LintModelModule;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"syncTo", "", "project", "Lcom/android/tools/lint/model/LintModelModule;", "flags", "Lcom/android/tools/lint/LintCliFlags;", "lint-cli"})
@JvmName(name="SyncOptions")
public final class SyncOptions {
    public static final void syncTo(@NotNull LintModelModule project, @NotNull LintCliFlags flags) {
        Set check;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
        LintModelLintOptions options = project.getLintOptions();
        Set disabled = options.getDisable();
        Collection collection = disabled;
        boolean bl = false;
        if (!collection.isEmpty()) {
            for (String id : disabled) {
                Category category = Category.Companion.getCategory(id);
                if (category != null) {
                    flags.addDisabledCategory(category);
                    continue;
                }
                flags.getSuppressedIds().add(id);
            }
        }
        Set enabled = options.getEnable();
        Collection id = enabled;
        boolean category = false;
        if (!id.isEmpty()) {
            for (String id2 : enabled) {
                Category category2 = Category.Companion.getCategory(id2);
                if (category2 != null) {
                    flags.addEnabledCategory(category2);
                    continue;
                }
                flags.getEnabledIds().add(id2);
            }
        }
        if ((check = options.getCheck()) != null) {
            Collection id2 = check;
            boolean category2 = false;
            if (!id2.isEmpty()) {
                for (String id3 : check) {
                    Category category3 = Category.Companion.getCategory(id3);
                    if (category3 != null) {
                        flags.addExactCategory(category3);
                        continue;
                    }
                    flags.addExactId(id3);
                }
            }
        }
        flags.setSetExitCode(options.getAbortOnError());
        flags.setFullPath(options.getAbsolutePaths());
        flags.setShowSourceLines(!options.getNoLines());
        flags.setQuiet(options.getQuiet());
        flags.setCheckAllWarnings(options.getCheckAllWarnings());
        flags.setIgnoreWarnings(options.getIgnoreWarnings());
        flags.setWarningsAsErrors(options.getWarningsAsErrors());
        flags.setCheckTestSources(options.getCheckTestSources());
        flags.setIgnoreTestSources(options.getIgnoreTestSources());
        flags.setIgnoreTestFixturesSources(options.getIgnoreTestFixturesSources());
        flags.setCheckGeneratedSources(options.getCheckGeneratedSources());
        flags.setCheckDependencies(options.getCheckDependencies());
        flags.setShowEverything(options.getShowAll());
        flags.setLintConfig(options.getLintConfig());
        flags.setExplainIssues(options.getExplainIssues());
        flags.setBaselineFile(options.getBaselineFile());
        Map severityOverrides = options.getSeverityOverrides();
        if (severityOverrides != null) {
            flags.setSeverityOverrides(severityOverrides);
        } else {
            flags.setSeverityOverrides(MapsKt.emptyMap());
        }
    }
}

