/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00072\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u001a\u0016\u0010\b\u001a\u0004\u0018\u00010\u0001*\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0014\u0010\u000b\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\f\u001a\u00020\nH\u0002\u001a\u0014\u0010\r\u001a\u00020\n*\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000e"}, d2={"getErrorLines", "", "Lcom/android/tools/lint/detector/api/Incident;", "textProvider", "Lkotlin/Function1;", "Ljava/io/File;", "", "Lcom/android/tools/lint/detector/api/Location;", "getLine", "line", "", "getLineOfOffset", "offset", "getLineOffset", "lint-cli"})
public final class ReporterKt {
    @Nullable
    public static final String getErrorLines(@NotNull Incident $this$getErrorLines, @NotNull Function1<? super File, ? extends CharSequence> textProvider) {
        Intrinsics.checkNotNullParameter((Object)$this$getErrorLines, (String)"<this>");
        Intrinsics.checkNotNullParameter(textProvider, (String)"textProvider");
        return ReporterKt.getErrorLines($this$getErrorLines.getLocation(), textProvider);
    }

    @Nullable
    public static final String getErrorLines(@NotNull Location $this$getErrorLines, @NotNull Function1<? super File, ? extends CharSequence> textProvider) {
        CharSequence source;
        Intrinsics.checkNotNullParameter((Object)$this$getErrorLines, (String)"<this>");
        Intrinsics.checkNotNullParameter(textProvider, (String)"textProvider");
        Location location = $this$getErrorLines;
        Position startPosition = location.getStart();
        if (startPosition != null && startPosition.getLine() >= 0 && (source = (CharSequence)textProvider.invoke((Object)$this$getErrorLines.getFile())) != null) {
            Position endPosition = location.getEnd();
            int line2 = startPosition.getLine();
            String errorLine = ReporterKt.getLine(source, line2);
            if (errorLine != null) {
                int n;
                errorLine = StringsKt.replace$default((String)errorLine, (char)'\t', (char)' ', (boolean)false, (int)4, null);
                int column = startPosition.getColumn();
                if (column < 0) {
                    column = 0;
                    int i = 0;
                    while (i < errorLine.length() && Character.isWhitespace(errorLine.charAt(i))) {
                        n = i;
                        i = n + 1;
                        n = column;
                        column = n + 1;
                    }
                }
                StringBuilder sb = new StringBuilder(100);
                sb.append(errorLine);
                sb.append('\n');
                n = 0;
                if (n < column) {
                    do {
                        int i = n++;
                        sb.append(' ');
                    } while (n < column);
                }
                boolean displayCaret = true;
                if (endPosition != null) {
                    int endLine = endPosition.getLine();
                    int endColumn = endPosition.getColumn();
                    if (endLine == line2 && endColumn > column) {
                        int n2 = column;
                        if (n2 < endColumn) {
                            do {
                                int i = n2++;
                                sb.append('~');
                            } while (n2 < endColumn);
                        }
                        displayCaret = false;
                    }
                }
                if (displayCaret) {
                    sb.append('^');
                }
                sb.append('\n');
                return sb.toString();
            }
        }
        return null;
    }

    private static final String getLine(CharSequence $this$getLine, int line2) {
        int index = ReporterKt.getLineOffset($this$getLine, line2);
        return index != -1 ? ReporterKt.getLineOfOffset($this$getLine, index) : (String)null;
    }

    private static final String getLineOfOffset(CharSequence $this$getLineOfOffset, int offset) {
        int end = StringsKt.indexOf$default((CharSequence)$this$getLineOfOffset, (char)'\n', (int)offset, (boolean)false, (int)4, null);
        if (end == -1) {
            end = StringsKt.indexOf$default((CharSequence)$this$getLineOfOffset, (char)'\r', (int)offset, (boolean)false, (int)4, null);
        } else if (end > 0 && $this$getLineOfOffset.charAt(end - 1) == '\r') {
            int n = end;
            end = n + -1;
        }
        return ((Object)$this$getLineOfOffset.subSequence(offset, end != -1 ? end : $this$getLineOfOffset.length())).toString();
    }

    private static final int getLineOffset(CharSequence $this$getLineOffset, int line2) {
        int index = 0;
        int n = 0;
        if (n < line2) {
            do {
                int i = n++;
                if ((index = StringsKt.indexOf$default((CharSequence)$this$getLineOffset, (char)'\n', (int)index, (boolean)false, (int)4, null)) == -1) {
                    return -1;
                }
                int n2 = index;
                index = n2 + 1;
            } while (n < line2);
        }
        return index;
    }
}

