/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.LintStats;
import com.android.tools.lint.MultiProjectHtmlReporter;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.utils.SdkUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/MultiProjectHtmlReporter;", "Lcom/android/tools/lint/Reporter;", "client", "Lcom/android/tools/lint/LintCliClient;", "dir", "Ljava/io/File;", "flags", "Lcom/android/tools/lint/LintCliFlags;", "(Lcom/android/tools/lint/LintCliClient;Ljava/io/File;Lcom/android/tools/lint/LintCliFlags;)V", "write", "", "stats", "Lcom/android/tools/lint/LintStats;", "issues", "", "Lcom/android/tools/lint/detector/api/Incident;", "Companion", "ProjectEntry", "lint-cli"})
public final class MultiProjectHtmlReporter
extends Reporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File dir;
    @NotNull
    private final LintCliFlags flags;
    @NotNull
    private static final String INDEX_NAME = "index.html";

    public MultiProjectHtmlReporter(@NotNull LintCliClient client, @NotNull File dir, @NotNull LintCliFlags flags) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
        super(client, new File(dir, INDEX_NAME));
        this.dir = dir;
        this.flags = flags;
    }

    @Override
    public void write(@NotNull LintStats stats, @NotNull List<Incident> issues) throws IOException {
        Object object;
        Object project;
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        Intrinsics.checkNotNullParameter(issues, (String)"issues");
        Map projectToIncidents = new HashMap();
        for (Incident incident : issues) {
            Project project2 = incident.getProject();
            if (project2 == null) continue;
            project = project2;
            object = projectToIncidents.computeIfAbsent(project, write.list.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue(object, (String)"projectToIncidents.compu\u2026(project) { ArrayList() }");
            List list2 = (List)object;
            list2.add(incident);
        }
        HashSet hashSet = Sets.newHashSet();
        Intrinsics.checkNotNullExpressionValue((Object)hashSet, (String)"newHashSet()");
        Set unique = hashSet;
        String string = INDEX_NAME;
        project = Locale.US;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"US");
        boolean list2 = false;
        object = string;
        boolean bl = false;
        String string2 = ((String)object).toLowerCase((Locale)project);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase(locale)");
        unique.add(string2);
        project = Lists.newArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"newArrayList()");
        List list3 = (List)project;
        for (Project project3 : projectToIncidents.keySet()) {
            String string3;
            String string4;
            boolean deleted22;
            String lowercase;
            Object object2;
            Object object3;
            Object[] objectArray;
            String projectName = project3.getName();
            int number = 1;
            String fileName = null;
            while (true) {
                String numberString = number > 1 ? String.valueOf(number) : "";
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                objectArray = "%1$s%2$s.html";
                object3 = new Object[]{projectName, numberString};
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)String.format((String)objectArray, Arrays.copyOf(object3, ((Object[])object3).length)), (String)"java.lang.String.format(format, *args)");
                objectArray = fileName;
                object3 = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"US");
                bl2 = false;
                object2 = objectArray;
                boolean bl3 = false;
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkNotNullExpressionValue((Object)((String)object2).toLowerCase((Locale)object3), (String)"(this as java.lang.String).toLowerCase(locale)");
                if (!unique.contains(lowercase)) break;
                int n = number;
                number = n + 1;
            }
            unique.add(lowercase);
            File output = new File(this.dir, fileName);
            if (output.exists() && !(deleted22 = output.delete())) {
                objectArray = new Object[]{output};
                this.client.log(null, "Could not delete old file %1$s", objectArray);
                continue;
            }
            if (!output.getParentFile().canWrite()) {
                Object[] deleted22 = new Object[]{output};
                this.client.log(null, "Cannot write output file %1$s", deleted22);
                continue;
            }
            Reporter reporter = Reporter.Companion.createHtmlReporter(this.client, output, this.flags);
            reporter.setUrlMap(this.getUrlMap());
            object3 = (List)projectToIncidents.get(project3);
            if (object3 == null) continue;
            Object projectIssues = object3;
            int projectErrorCount = 0;
            int projectWarningCount = 0;
            object2 = projectIssues.iterator();
            while (object2.hasNext()) {
                int n;
                Incident incident3 = (Incident)object2.next();
                if (incident3.getSeverity().isError()) {
                    n = projectErrorCount;
                    projectErrorCount = n + 1;
                    continue;
                }
                if (incident3.getSeverity() != Severity.WARNING) continue;
                n = projectWarningCount;
                projectWarningCount = n + 1;
            }
            String prefix = project3.getReferenceDir().getPath();
            String path = project3.getDir().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
            Intrinsics.checkNotNullExpressionValue((Object)prefix, (String)"prefix");
            if (StringsKt.startsWith$default((String)path, (String)prefix, (boolean)false, (int)2, null) && path.length() > prefix.length()) {
                int i = prefix.length();
                if (path.charAt(i) == File.separatorChar) {
                    int n = i;
                    i = n + 1;
                }
                string4 = path;
                boolean bl4 = false;
                String string5 = string4.substring(i);
                string3 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                string3 = projectName;
            }
            String relative = string3;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            string4 = "Lint Report for %1$s";
            Object[] objectArray2 = new Object[]{relative};
            boolean bl5 = false;
            Intrinsics.checkNotNullExpressionValue((Object)String.format(string4, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"java.lang.String.format(format, *args)");
            reporter.title = reporter.title;
            reporter.setStripPrefix(relative);
            reporter.write(stats, (List<Incident>)projectIssues);
            Intrinsics.checkNotNullExpressionValue((Object)relative, (String)"relative");
            list3.add(new ProjectEntry(fileName, projectErrorCount, projectWarningCount, relative));
        }
        CollectionsKt.sort((List)list3);
        File file = this.getOutput();
        Intrinsics.checkNotNull((Object)file);
        Reporter reporter = Reporter.Companion.createHtmlReporter(this.client, file, this.flags);
        reporter.writeProjectList(stats, list3);
        if (!(this.client.getFlags().isQuiet() || stats.getErrorCount() <= 0 && stats.getWarningCount() <= 0)) {
            File index = new File(this.dir, INDEX_NAME);
            String url = SdkUtils.fileToUrlString((File)index.getAbsoluteFile());
            Object object4 = StringCompanionObject.INSTANCE;
            String string6 = "Wrote overview index to %1$s";
            Object[] objectArray = new Object[]{url};
            boolean bl6 = false;
            String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"java.lang.String.format(format, *args)");
            object4 = string7;
            boolean bl7 = false;
            System.out.println(object4);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\f\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0000H\u0096\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/lint/MultiProjectHtmlReporter$ProjectEntry;", "", "fileName", "", "errorCount", "", "warningCount", "path", "(Ljava/lang/String;IILjava/lang/String;)V", "getErrorCount", "()I", "getFileName", "()Ljava/lang/String;", "getPath", "getWarningCount", "compareTo", "other", "lint-cli"})
    public static final class ProjectEntry
    implements Comparable<ProjectEntry> {
        @NotNull
        private final String fileName;
        private final int errorCount;
        private final int warningCount;
        @NotNull
        private final String path;

        public ProjectEntry(@NotNull String fileName, int errorCount, int warningCount, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.fileName = fileName;
            this.errorCount = errorCount;
            this.warningCount = warningCount;
            this.path = path;
        }

        @NotNull
        public final String getFileName() {
            return this.fileName;
        }

        public final int getErrorCount() {
            return this.errorCount;
        }

        public final int getWarningCount() {
            return this.warningCount;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @Override
        public int compareTo(@NotNull ProjectEntry other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            int delta = other.errorCount - this.errorCount;
            if (delta != 0) {
                return delta;
            }
            delta = other.warningCount - this.warningCount;
            return delta != 0 ? delta : this.path.compareTo(other.path);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/lint/MultiProjectHtmlReporter$Companion;", "", "()V", "INDEX_NAME", "", "lint-cli"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

